/*
 * Decompiled with CFR 0.152.
 */
package com.foretees.salesforce.sync;

import com.floreantpos.PosLog;
import com.floreantpos.main.Application;
import com.floreantpos.model.Store;
import com.floreantpos.util.AESencrp;
import com.foretees.salesforce.sync.LoginDialog;
import com.foretees.salesforce.sync.SFConnectionException;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.json.JSONObject;
import org.json.JSONTokener;

public class SFAuth {
    private static String instanceURL;
    private static String accessToken;
    static final String GRANTSERVICE = "/services/oauth2/token?grant_type=password";

    public static final HttpClient createHttpClint() throws Exception {
        CloseableHttpClient httpclient = HttpClientBuilder.create().build();
        return httpclient;
    }

    public static HttpResponse getLoginResponse(String USERNAME, String PASSWORD, String securityToken, String LOGINURL, String CLIENTID, String CLIENTSECRET) throws Exception {
        HttpClient httpclient = SFAuth.createHttpClint();
        String loginURL = LOGINURL + GRANTSERVICE + "&client_id=" + CLIENTID + "&client_secret=" + CLIENTSECRET + "&username=" + USERNAME + "&password=" + PASSWORD + securityToken;
        HttpPost httpPost = new HttpPost(loginURL);
        HttpResponse response = httpclient.execute((HttpUriRequest)httpPost);
        httpPost.releaseConnection();
        return response;
    }

    public static boolean login() throws SFConnectionException {
        Integer statusCode = null;
        try {
            String loginURL;
            HttpPost httpPost;
            HttpClient httpclient;
            HttpResponse response;
            Store store = Application.getInstance().getStore();
            String USERNAME = store.getProperty("salesforce.username");
            String PASSWORD = store.getProperty("salesforce.password");
            String securityToken = store.getProperty("salesforce.securityToken");
            String LOGINURL = store.getProperty("salesforce.loginurl");
            String CLIENTID = store.getProperty("salesforce.clientId");
            String CLIENTSECRET = store.getProperty("salesforce.clientSecret");
            if (StringUtils.isNotEmpty((String)PASSWORD)) {
                PASSWORD = AESencrp.decrypt((String)PASSWORD);
            }
            if (StringUtils.isNotEmpty((String)securityToken)) {
                securityToken = AESencrp.decrypt((String)securityToken);
            }
            if (StringUtils.isNotEmpty((String)CLIENTSECRET)) {
                CLIENTSECRET = AESencrp.decrypt((String)CLIENTSECRET);
            }
            if ((statusCode = Integer.valueOf((response = (httpclient = SFAuth.createHttpClint()).execute((HttpUriRequest)(httpPost = new HttpPost(loginURL = LOGINURL + GRANTSERVICE + "&client_id=" + CLIENTID + "&client_secret=" + CLIENTSECRET + "&username=" + USERNAME + "&password=" + PASSWORD + securityToken)))).getStatusLine().getStatusCode())) != 200) {
                String sfdcError = EntityUtils.toString((HttpEntity)response.getEntity());
                PosLog.error(SFAuth.class, "SFDC Login error:" + statusCode + " : " + sfdcError);
                throw new SFConnectionException(sfdcError, statusCode);
            }
            String getResult = null;
            getResult = EntityUtils.toString((HttpEntity)response.getEntity());
            JSONObject jsonObject = null;
            jsonObject = (JSONObject)new JSONTokener(getResult).nextValue();
            accessToken = jsonObject.getString("access_token");
            instanceURL = jsonObject.getString("instance_url");
            httpPost.releaseConnection();
            return true;
        }
        catch (Exception e) {
            return SFAuth.doOpenLoginDialog();
        }
    }

    public static boolean doOpenLoginDialog() throws SFConnectionException {
        LoginDialog loginDialog = new LoginDialog();
        loginDialog.pack();
        loginDialog.open();
        if (loginDialog.isCanceled()) {
            return false;
        }
        return SFAuth.login();
    }

    public static String getAccessToken() throws SFConnectionException {
        if (accessToken == null) {
            SFAuth.login();
        }
        return accessToken;
    }

    public static String getAccessToken(Boolean reLog) throws SFConnectionException {
        if (reLog.booleanValue()) {
            SFAuth.login();
        }
        return SFAuth.getAccessToken();
    }

    public static String getInstanceUrl() throws SFConnectionException {
        if (instanceURL == null) {
            SFAuth.login();
        }
        return instanceURL;
    }

    public static String getInstanceUrlWithoutProtocol() throws SFConnectionException {
        if (instanceURL == null) {
            SFAuth.login();
        }
        return instanceURL.replace("https://", "");
    }

    public static String getInstanceUrl(Boolean reLog) throws SFConnectionException {
        if (reLog.booleanValue()) {
            SFAuth.login();
        }
        return SFAuth.getInstanceUrl();
    }
}

