/*
 * Decompiled with CFR 0.152.
 */
package com.foretees.salesforce.sync;

import com.floreantpos.PosLog;
import com.floreantpos.model.SalesArea;
import com.floreantpos.model.Store;
import com.floreantpos.model.dao.GenericDAO;
import com.floreantpos.model.dao.SalesAreaDAO;
import com.floreantpos.model.dao.StoreDAO;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.util.JsonUtil;
import com.foretees.salesforce.sync.SFDateUtil;
import com.foretees.salesforce.sync.SFUtil;
import com.foretees.salesforce.sync.SalesForceSyncable;
import com.foretees.salesforce.sync.SyncView;
import java.util.Date;
import java.util.Iterator;
import javax.json.JsonArray;
import javax.json.JsonObject;
import javax.json.JsonValue;
import org.hibernate.Session;
import org.hibernate.Transaction;

public class SalesAreaSyncable
implements SalesForceSyncable {
    private SyncView syncView;
    private int count;

    @Override
    public void doSync() throws Exception {
        Session session = null;
        Transaction transaction = null;
        try {
            if (this.syncView == null) {
                return;
            }
            GenericDAO dao = new GenericDAO();
            session = dao.createNewSession();
            transaction = session.beginTransaction();
            JsonArray salesAreas = SFUtil.getSalesAreas();
            Date syncedTime = new Date();
            if (salesAreas == null) {
                this.syncView.setCanceled(false);
                return;
            }
            int maxSize = salesAreas != null ? salesAreas.size() : 0;
            this.syncView.setProgressMaximum(maxSize);
            this.count = 0;
            if (maxSize == 0) {
                return;
            }
            this.doSyncSalesArea(salesAreas, session);
            transaction.commit();
            this.doUpdateSyncedTime(syncedTime);
        }
        catch (Exception e) {
            transaction.rollback();
            throw e;
        }
        finally {
            if (session != null && session.isOpen()) {
                session.close();
            }
        }
    }

    private void doUpdateSyncedTime(Date syncedTime) {
        try {
            DataProvider.get().refreshStore();
            Store store = DataProvider.get().getStore();
            store.addProperty("salesforce.salesAreaSyncTime", SFDateUtil.formatDateAsSFFormat(syncedTime));
            StoreDAO.getInstance().saveOrUpdate(store);
            DataProvider.get().refreshStore();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void doSyncSalesArea(JsonArray salesAreas, Session session) throws Exception {
        Iterator iterator = salesAreas.iterator();
        while (iterator.hasNext()) {
            this.syncView.checkCancelStatus();
            JsonObject itemObject = (JsonObject)iterator.next();
            String label = JsonUtil.getStringValue((JsonValue)itemObject.get((Object)"label"));
            String value = JsonUtil.getStringValue((JsonValue)itemObject.get((Object)"value"));
            String id = label.replaceAll("\\W", "_");
            boolean newItem = false;
            SalesArea salesArea = SalesAreaDAO.getInstance().get(id);
            if (salesArea == null) {
                salesArea = new SalesArea();
                salesArea.setId(id);
                newItem = true;
            }
            salesArea.setName(value);
            if (newItem) {
                SalesAreaDAO.getInstance().save(salesArea, session);
            } else {
                SalesAreaDAO.getInstance().update(salesArea, session);
            }
            PosLog.debug(SalesAreaSyncable.class, "NAME: " + salesArea.getId());
            this.syncView.setProgressValue(++this.count);
        }
    }

    public SyncView getSyncView() {
        return this.syncView;
    }

    public void setSyncView(SyncView syncView) {
        this.syncView = syncView;
    }
}

