/*
 * Decompiled with CFR 0.152.
 */
package com.foretees.salesforce.sync;

import com.floreantpos.Messages;
import com.floreantpos.PosException;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.ui.TitlePanel;
import com.floreantpos.ui.dialog.POSDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.POSUtil;
import com.foretees.salesforce.sync.SalesForceSyncable;
import com.foretees.salesforce.sync.SyncCanceledException;
import com.foretees.salesforce.sync.SyncView;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import net.miginfocom.swing.MigLayout;

public class SyncDialog
extends POSDialog
implements SyncView {
    private JProgressBar progressBar;
    private PosButton btnDone;
    private PosButton btnCancel;
    private TitlePanel titlePanel;
    private SalesForceSyncable salesForceSyncable;
    private JLabel lblTotalItemInfo;

    public SyncDialog(SalesForceSyncable salesForceSyncable) {
        super(POSUtil.getFocusedWindow(), Messages.getString("SyncDialog.0"), true);
        this.salesForceSyncable = salesForceSyncable;
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                SyncDialog.this.setCanceled(true);
            }
        });
        this.setResizable(false);
        this.setPreferredSize(PosUIManager.getSize(500, 180));
        this.initComponents();
    }

    private void initComponents() {
        this.setLayout((LayoutManager)new MigLayout("fill, ins 10 10 0 10"));
        this.titlePanel = new TitlePanel();
        this.titlePanel.setTitle(Messages.getString("SyncDialog.1"));
        this.add((Component)this.titlePanel, "grow, wrap");
        this.lblTotalItemInfo = new JLabel();
        this.add((Component)this.lblTotalItemInfo, "grow, wrap");
        this.progressBar = new JProgressBar();
        this.progressBar.setBounds(40, 40, 160, 50);
        this.progressBar.setStringPainted(true);
        this.progressBar.setValue(0);
        this.add((Component)this.progressBar, "grow,wrap");
        this.btnDone = new PosButton(Messages.getString("SyncDialog.6"));
        this.btnDone.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SyncDialog.this.setCanceled(false);
                SyncDialog.this.dispose();
            }
        });
        this.btnDone.setVisible(false);
        this.btnCancel = new PosButton(Messages.getString("SyncDialog.7"));
        this.btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SyncDialog.this.setCanceled(true);
            }
        });
        this.btnCancel.setVisible(false);
        JPanel bottomPanel = new JPanel((LayoutManager)new MigLayout("hidemode 3,center"));
        bottomPanel.add(this.btnDone);
        this.add((Component)bottomPanel, "grow");
    }

    @Override
    public void checkCancelStatus() {
        if (this.isCanceled()) {
            int option = POSMessageDialog.showYesNoQuestionDialog(POSUtil.getFocusedWindow(), Messages.getString("SyncDialog.2"), Messages.getString("SyncDialog.11"));
            if (option == 0) {
                throw new SyncCanceledException();
            }
            this.setCanceled(false);
        }
    }

    @Override
    public void setVisible(boolean b) {
        if (b) {
            this.startSyncing();
        }
        super.setVisible(b);
    }

    private void startSyncing() {
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    SyncDialog.this.setCanceled(false);
                    SyncDialog.this.salesForceSyncable.doSync();
                    SyncDialog.this.btnCancel.setVisible(false);
                    SyncDialog.this.btnDone.setVisible(true);
                }
                catch (SyncCanceledException e) {
                    SyncDialog.this.setCanceled(true);
                    SyncDialog.this.dispose();
                }
                catch (PosException e) {
                    POSMessageDialog.showError(SyncDialog.this, e.getMessage());
                    SyncDialog.this.setCanceled(true);
                    SyncDialog.this.dispose();
                }
                catch (Exception e) {
                    POSMessageDialog.showError(SyncDialog.this, e.getMessage(), e);
                    SyncDialog.this.setCanceled(true);
                    SyncDialog.this.dispose();
                }
            }
        });
        thread.start();
    }

    @Override
    public void setSyncMessage(String message) {
        this.lblTotalItemInfo.setText(message);
    }

    @Override
    public void setProgressMaximum(int max) {
        this.progressBar.setMaximum(max);
    }

    @Override
    public void setProgressValue(int value) {
        this.progressBar.setValue(value);
    }
}

