/*
 * Decompiled with CFR 0.152.
 */
package com.orocube.orocust;

import com.floreantpos.PosLog;
import com.floreantpos.bo.ui.BackOfficeWindow;
import com.floreantpos.config.TerminalConfig;
import com.floreantpos.customer.CustomerSelector;
import com.floreantpos.customer.CustomerSelectorDialog;
import com.floreantpos.customer.CustomerSelectorFactory;
import com.floreantpos.main.Application;
import com.floreantpos.main.Main;
import com.floreantpos.model.Customer;
import com.floreantpos.model.OrderType;
import com.floreantpos.model.ShopTable;
import com.floreantpos.model.TableStatus;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.User;
import com.floreantpos.model.UserPermission;
import com.floreantpos.model.UserType;
import com.floreantpos.model.dao.TicketDAO;
import com.floreantpos.model.dao.UserDAO;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.orocust.versioning.VersionInfo;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.views.IView;
import com.floreantpos.ui.views.order.DefaultOrderServiceExtension;
import com.floreantpos.ui.views.order.OrderController;
import com.floreantpos.ui.views.order.OrderView;
import com.floreantpos.ui.views.order.RootView;
import com.floreantpos.util.DrawerUtil;
import com.floreantpos.util.POSUtil;
import com.floreantpos.util.PosGuiUtil;
import com.floreantpos.util.TicketAlreadyExistsException;
import com.orocube.common.about.AboutPluginAction;
import com.orocube.common.util.ProductInfo;
import com.orocube.licensemanager.ui.LicenseSelectionListener;
import com.orocube.orocust.OroCustMessages;
import com.orocube.orocust.actions.CustomerExplorerAction;
import com.orocube.orocust.actions.DeliveryDispatchViewAction;
import com.orocube.orocust.actions.OrocustConfigurationViewAction;
import com.orocube.orocust.actions.ShowCustomerGroupBrowseAction;
import com.orocube.orocust.ui.dialog.AssignDriverDialog;
import com.orocube.orocust.ui.dialog.DeliveryDispatchDialog;
import com.orocube.orocust.ui.dialog.DeliverySelectionDialog;
import com.orocube.orocust.ui.view.CustomerListView;
import com.orocube.orocust.ui.view.DeliveryDispatchView;
import com.orocube.orocust.ui.view.DriverView;
import java.awt.Component;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JDialog;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import net.xeoh.plugins.base.annotations.PluginImplementation;
import org.apache.commons.lang.StringUtils;

@PluginImplementation
public class OrderWithCustomerService
extends DefaultOrderServiceExtension
implements ProductInfo {
    @Override
    public String getDescription() {
        return OroCustMessages.getString("OrderWithCustomerService.0");
    }

    @Override
    public void setCustomerToTicket(String ticketId) {
    }

    @Override
    public void setDeliveryDate(String ticketId) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void createNewTicket(OrderType orderType, List<ShopTable> selectedTables, Customer customer) throws TicketAlreadyExistsException {
        if (!this.hasPermission()) {
            POSMessageDialog.showError(OroCustMessages.getString("OrderWithCustomerService.11"));
            return;
        }
        Ticket ticket = new Ticket(true);
        ticket.setOrderType(orderType);
        try {
            String freeTextTableNumber;
            DataProvider.get().setTicketToBeCreated(ticket);
            if (TerminalConfig.isActiveCustomerDisplay()) {
                DrawerUtil.setCustomerDisplayMessage(TerminalConfig.getCustomerDisplayPort(), OroCustMessages.getString("OrderWithCustomerService.1"));
            }
            if (selectedTables != null) {
                for (ShopTable shopTable : selectedTables) {
                    shopTable.setTableStatus(TableStatus.Seat);
                    ticket.addTable(shopTable.getTableNumber());
                }
            }
            Date deliveryDate = null;
            boolean customerWillPickUp = false;
            String shippingAddress = null;
            String extraDeliveryInfo = null;
            String phoneExtension = null;
            String extraManagerInstruction = null;
            Double deliveryChargeAmount = 0.0;
            if (orderType.isRequiredCustomerData().booleanValue() && customer == null) {
                CustomerSelectorDialog dialog = CustomerSelectorFactory.createCustomerSelectorDialog(orderType);
                dialog.setCreateNewTicket(false);
                dialog.updateView(true);
                dialog.openUndecoratedFullScreen();
                if (dialog.isCanceled()) {
                    customer = null;
                    return;
                }
                customer = dialog.getSelectedCustomer();
                if (customer == null) {
                    return;
                }
            }
            if (customer != null) {
                ticket.setCustomer(customer);
            }
            if (orderType.isDelivery().booleanValue() || orderType.isRequiredDeliveryData().booleanValue()) {
                DeliverySelectionDialog deliveryDialog = new DeliverySelectionDialog(Application.getPosWindow(), ticket, orderType, customer);
                deliveryDialog.setLocationRelativeTo(Application.getPosWindow());
                if (customer != null) {
                    deliveryDialog.setRecipientName(customer.getName());
                    deliveryDialog.setDeliveryAddress(customer.getAddress());
                }
                deliveryDialog.openUndecoratedFullScreen();
                if (deliveryDialog.isCanceled()) {
                    return;
                }
                deliveryDate = deliveryDialog.getDeliveryDate();
                shippingAddress = deliveryDialog.getDeliveryAddress();
                extraDeliveryInfo = deliveryDialog.getExtraDeliveryInfo();
                phoneExtension = deliveryDialog.getPhoneExtension();
                extraManagerInstruction = deliveryDialog.getManagerInstruction();
                customerWillPickUp = deliveryDialog.willCustomerPickup();
                deliveryChargeAmount = deliveryDialog.getDeliveryCharge();
            }
            if (customerWillPickUp) {
                ticket.setCustomerWillPickup(true);
            } else {
                ticket.setDeliveryDate(deliveryDate);
                ticket.setDeliveryAddress(shippingAddress);
                ticket.setExtraDeliveryInfo(extraDeliveryInfo);
                ticket.addProperty("PHONE_EXTENSION", phoneExtension);
                ticket.addProperty("MANAGER_INSTRUCTION", extraManagerInstruction);
                ticket.setDeliveryCharge(deliveryChargeAmount);
                ticket.setCustomerWillPickup(false);
            }
            OrderView.getInstance().setCurrentTicket(ticket);
            RootView.getInstance().showView("ORDER_VIEW");
            if (orderType.isPropertyValueTrue("tableSelection.freeTextInput.prompt") && StringUtils.isNotBlank((String)(freeTextTableNumber = PosGuiUtil.captureFreeTextTableNumber()))) {
                ticket.addProperty("freeTextTableName", freeTextTableNumber);
                OrderView.getInstance().updateView();
            }
            if (orderType.isShowGuestSelection().booleanValue()) {
                ticket.setNumberOfGuests(PosGuiUtil.captureGuestNumber());
                OrderView.getInstance().updateView();
            }
        }
        finally {
            DataProvider.get().setTicketToBeCreated(null);
        }
    }

    @Override
    public CustomerSelector createNewCustomerSelector() {
        CustomerListView customerListView = new CustomerListView();
        return customerListView;
    }

    @Override
    public IView getDeliveryDispatchView(OrderType orderType) {
        return DeliveryDispatchView.getInstance(orderType);
    }

    @Override
    public IView getDriverView() {
        return DriverView.getInstance();
    }

    @Override
    public CustomerSelector createCustomerSelectorView() {
        CustomerListView customerListView = new CustomerListView();
        return customerListView;
    }

    @Override
    public void assignDriver(String ticketId) {
        List<User> drivers = UserDAO.getInstance().findDrivers();
        if (drivers == null || drivers.size() == 0) {
            POSMessageDialog.showError(Application.getPosWindow(), OroCustMessages.getString("OrderWithCustomerService.5"));
            return;
        }
        Ticket ticket = TicketDAO.getInstance().get(ticketId);
        AssignDriverDialog dialog = new AssignDriverDialog(Application.getPosWindow());
        dialog.setData(ticket, drivers);
        dialog.setSize(550, 450);
        dialog.setLocationRelativeTo(Application.getPosWindow());
        dialog.setVisible(true);
    }

    @Override
    public boolean finishOrder(String ticketId) {
        Ticket ticket = TicketDAO.getInstance().get(ticketId);
        int due = (int)POSUtil.getDouble(ticket.getDueAmount());
        if (due != 0) {
            POSMessageDialog.showError(Application.getPosWindow(), OroCustMessages.getString("OrderWithCustomerService.6"));
            return false;
        }
        int option = JOptionPane.showOptionDialog(Application.getPosWindow(), OroCustMessages.getString("OrderWithCustomerService.7") + ticket.getId() + OroCustMessages.getString("OrderWithCustomerService.8"), OroCustMessages.getString("OrderWithCustomerService.9"), 2, 1, null, null, null);
        if (option != 0) {
            return false;
        }
        OrderController.closeOrder(ticket);
        return true;
    }

    @Override
    public void createCustomerMenu(JMenu menu) {
        menu.add(new CustomerExplorerAction());
    }

    @Override
    public void initBackoffice(BackOfficeWindow backOfficeWindow) {
        JMenuBar menuBar = backOfficeWindow.getBackOfficeMenuBar();
        JMenu customerExplorerMenu = new JMenu(OroCustMessages.getString("OrderWithCustomerService.10"));
        customerExplorerMenu.add(new JMenuItem(new CustomerExplorerAction()));
        customerExplorerMenu.add(new JMenuItem(new ShowCustomerGroupBrowseAction()));
        customerExplorerMenu.add(new JMenuItem(new OrocustConfigurationViewAction()));
        menuBar.add(customerExplorerMenu);
    }

    public void initAboutMenu(BackOfficeWindow backOfficeWindow) {
        JMenuBar menuBar = backOfficeWindow.getBackOfficeMenuBar();
        JMenu customerExplorerMenu = new JMenu(OroCustMessages.getString("OrderWithCustomerService.10"));
        customerExplorerMenu.add(new JMenuItem((Action)new AboutPluginAction((LicenseSelectionListener)this, this.getLicense(), (Component)POSUtil.getBackOfficeWindow(), (ProductInfo)this)));
        menuBar.add(customerExplorerMenu);
    }

    @Override
    public void initConfigurationView(JDialog dialog) {
    }

    @Override
    public void openDeliveryDispatchDialog(OrderType orderType) {
        DeliveryDispatchDialog dialog = new DeliveryDispatchDialog(orderType);
        dialog.openUndecoratedFullScreen();
    }

    @Override
    public List<AbstractAction> getSpecialFunctionActions() {
        ArrayList<AbstractAction> posActions = new ArrayList<AbstractAction>();
        posActions.add(new DeliveryDispatchViewAction());
        return posActions;
    }

    public void restartPOS(boolean restart) {
        if (restart) {
            try {
                Main.restart();
            }
            catch (Exception e) {
                PosLog.error(((Object)((Object)this)).getClass(), e);
            }
        }
    }

    @Override
    public boolean hasValidLicense() {
        return true;
    }

    @Override
    public boolean requireLicense() {
        return false;
    }

    @Override
    public void showDeliveryInfo(Ticket ticket, OrderType ticketType, Customer customer) {
        DeliverySelectionDialog deliveryDialog = new DeliverySelectionDialog(Application.getPosWindow(), ticket, ticketType, customer);
        deliveryDialog.setLocationRelativeTo(Application.getPosWindow());
        deliveryDialog.openUndecoratedFullScreen();
        if (deliveryDialog.isCanceled()) {
            return;
        }
        if (ticket.getId() != null) {
            OrderController.saveOrder(ticket);
        }
    }

    @Override
    public String getProductName() {
        return VersionInfo.getAppName();
    }

    @Override
    public String getProductVersion() {
        return VersionInfo.getVersion();
    }

    @Override
    public Integer getProductNumericVersion() {
        return VersionInfo.getNumericVersion();
    }

    @Override
    public Component getParent() {
        return POSUtil.getFocusedWindow();
    }

    public URL getChangeLogURL() {
        return ((Object)((Object)this)).getClass().getResource("/cust-change.log.xml");
    }

    @Override
    public String getUpdateServerURL() {
        String updateUrl = TerminalConfig.getPluginUpdateServerURL("orocust");
        if (StringUtils.isEmpty((String)updateUrl)) {
            updateUrl = "https://orodev.net/update/orocust";
        }
        return updateUrl;
    }

    public String getMinParentVersion() {
        return "1.4.147";
    }

    public int getMinParentNumericVersion() {
        return 1192;
    }

    public boolean isEmbedded() {
        return true;
    }

    public boolean isActivated() {
        return true;
    }

    private boolean hasPermission() {
        User user = Application.getCurrentUser();
        UserType userType = user.getType();
        if (userType != null) {
            Set<UserPermission> permissions = userType.getPermissions();
            for (UserPermission permission : permissions) {
                if (!permission.equals(UserPermission.CREATE_TICKET)) continue;
                return true;
            }
        }
        return false;
    }
}

