/*
 * Decompiled with CFR 0.152.
 */
package com.orocube.orocust.callerid.ad101;

import com.floreantpos.PosLog;
import com.orocube.orocust.callerid.CallListener;
import com.orocube.orocust.callerid.CallerIdDeviceFactory;
import com.orocube.orocust.callerid.ad101.AD101Device;
import com.sun.jna.Memory;
import com.sun.jna.Pointer;
import org.apache.commons.lang.StringUtils;

public class AD101DeviceHandler
implements AD101Device.AD101Callback {
    private CallListener callListener;
    private AD101Device ad101Device;

    public AD101DeviceHandler(CallListener callListener) {
        this.callListener = callListener;
        this.ad101Device = CallerIdDeviceFactory.getAD101Device();
        if (this.ad101Device.AD101_InitDevice(0L) == 0) {
            PosLog.info(this.getClass(), "AD101 device could not be initialized or already initialized.");
            return;
        }
        this.ad101Device.AD101_SetEventCallbackFun(this);
    }

    @Override
    public void EVENTCALLBACKPROC(int line, int event, int param) {
        PosLog.info(this.getClass(), "line: " + line + ", event: " + event + ", param: " + param);
        if (event == 9) {
            Memory szCallerID = new Memory(128L);
            Memory szName = new Memory(128L);
            Memory szTime = new Memory(128L);
            String callerId = null;
            String callerName = null;
            String callTime = null;
            this.ad101Device.AD101_GetCallerID(line, (Pointer)szCallerID, (Pointer)szName, (Pointer)szTime);
            callerId = szCallerID.getString(0L);
            callerName = szName.getString(0L);
            callTime = szTime.getString(0L);
            PosLog.info(this.getClass(), "caller id:" + callerId);
            PosLog.info(this.getClass(), "name:" + callerName);
            PosLog.info(this.getClass(), "time:" + callTime);
            if (StringUtils.isEmpty((String)callerId) || callerId.startsWith("BB1")) {
                this.callListener.callEnd(line);
                return;
            }
            this.callListener.callArrived(line, callerId, callerName, callTime);
            return;
        }
        if (event == 170) {
            this.callListener.callMissed(line);
        } else if (event == 187) {
            this.callListener.callReceived(line);
        }
    }
}

