/*
 * Decompiled with CFR 0.152.
 */
package com.orocube.orocust.callerid.whozz;

import com.floreantpos.PosLog;
import com.orocube.orocust.callerid.CallListener;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class WhozzCallReceiver
extends Thread {
    private boolean stopped = false;
    private DatagramSocket socket;
    private final String logEventMsg = "Starting phone call event listening on port 3520";
    private CallListener callListener;

    public WhozzCallReceiver(CallListener callListener) throws Exception {
        this.callListener = callListener;
        this.socket = new DatagramSocket(3520);
    }

    public void halt() {
        this.stopped = true;
    }

    @Override
    public void run() {
        byte[] buffer = new byte[65507];
        while (!this.stopped) {
            DatagramPacket dp = new DatagramPacket(buffer, buffer.length);
            try {
                this.socket.receive(dp);
                String s = new String(dp.getData(), 0, dp.getLength());
                PosLog.info(this.getClass(), "Starting phone call event listening on port 3520");
                PosLog.info(this.getClass(), s);
                this.handleCall(s);
                Thread.yield();
                continue;
            }
            catch (IOException ex) {
                PosLog.error(this.getClass(), ex);
                continue;
            }
            break;
        }
        return;
    }

    public void handleCall(String data) {
        String myData = data;
        Integer myLine = 0;
        String myType = "";
        String myIndicator = "";
        String myDuration = "";
        String myCheckSum = "";
        String ringType = "";
        String myDateTime = "";
        String myNumber = "";
        String myName = "";
        Pattern myPattern = Pattern.compile(".*(\\d\\d) ([IO]) ([ES]) (\\d{4}) ([GB]) (.)(\\d) (\\d\\d/\\d\\d \\d\\d:\\d\\d [AP]M) (.{8,15})(.*)");
        Matcher matcher = myPattern.matcher(myData);
        if (matcher.find()) {
            myLine = Integer.parseInt(matcher.group(1));
            myType = matcher.group(2);
            if (myType.equals("I") || myType.equals("O")) {
                myIndicator = matcher.group(3);
                myDuration = matcher.group(4);
                myCheckSum = matcher.group(5);
                ringType = matcher.group(6);
                myDateTime = matcher.group(8);
                myNumber = matcher.group(9);
                myName = matcher.group(10);
            }
        }
        PosLog.info(this.getClass(), "myIndicator: " + myIndicator);
        PosLog.info(this.getClass(), "myDuration: " + myDuration);
        PosLog.info(this.getClass(), "myCheckSum: " + myCheckSum);
        PosLog.info(this.getClass(), "myRings: " + ringType);
        PosLog.info(this.getClass(), "myName: " + myName);
        Pattern myPatternDetailed = Pattern.compile(".*(\\d\\d) ([NFR]) {13}(\\d\\d/\\d\\d \\d\\d:\\d\\d:\\d\\d)");
        Matcher matcherDetailed = myPatternDetailed.matcher(myData);
        if (matcherDetailed.find()) {
            myLine = Integer.parseInt(matcherDetailed.group(1));
            myType = matcherDetailed.group(2);
            if (myType.equals("N") || myType.equals("F") || myType.equals("R")) {
                myDateTime = matcherDetailed.group(3);
            }
        }
        String command = myType + myIndicator;
        PosLog.info(this.getClass(), "line: " + myLine);
        PosLog.info(this.getClass(), "callerId: " + myNumber);
        PosLog.info(this.getClass(), "callerName: " + myName);
        PosLog.info(this.getClass(), "time: " + myDateTime);
        PosLog.info(this.getClass(), "command: " + command);
        switch (command) {
            case "R": {
                PosLog.info(this.getClass(), "ring on: number: " + myNumber);
                this.callListener.callArrived(myLine, myNumber, myName, myDateTime);
                break;
            }
            case "IS": {
                this.callListener.callArrived(myLine, myNumber, myName, myDateTime);
                if (Integer.parseInt(myDuration) <= 0) break;
                this.callListener.callReceived(myLine);
                break;
            }
            case "F": {
                this.callListener.callReceived(myLine);
                break;
            }
            case "N": {
                this.callListener.callEnd(myLine);
                break;
            }
            case "IE": {
                if (Integer.parseInt(myDuration) > 0) {
                    this.callListener.callReceived(myLine);
                }
                this.callListener.callEnd(myLine);
                break;
            }
            case "OS": {
                break;
            }
        }
    }
}

