/*
 * Decompiled with CFR 0.152.
 */
package com.orocube.orocust.ui.dialog;

import com.floreantpos.ITicketList;
import com.floreantpos.POSConstants;
import com.floreantpos.extension.ExtensionManager;
import com.floreantpos.extension.OrderServiceExtension;
import com.floreantpos.main.Application;
import com.floreantpos.model.OrderType;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.dao.TicketDAO;
import com.floreantpos.swing.CustomerTicketListView;
import com.floreantpos.swing.PosButton;
import com.floreantpos.ui.TicketListUpdateListener;
import com.floreantpos.ui.TitlePanel;
import com.floreantpos.ui.dialog.POSDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.dialog.VoidTicketDialog;
import com.floreantpos.ui.views.OrderInfoDialog;
import com.floreantpos.ui.views.OrderInfoView;
import com.floreantpos.ui.views.order.DefaultOrderServiceExtension;
import com.floreantpos.ui.views.order.OrderController;
import com.floreantpos.util.POSUtil;
import com.orocube.orocust.OroCustMessages;
import com.orocube.orocust.ui.view.CustomerListView;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import net.miginfocom.swing.MigLayout;

public class CustomerHistoryDialog
extends POSDialog
implements ActionListener,
ITicketList,
TicketListUpdateListener {
    private OrderServiceExtension orderServiceExtension;
    private PosButton btnOrderInfo = new PosButton(POSConstants.ORDER_INFO_BUTTON_TEXT);
    private CustomerTicketListView ticketList;
    private TitledBorder ticketsListPanelBorder;
    private String memberId;
    private boolean ticketReordered;

    public CustomerHistoryDialog(String memberId, CustomerListView owner) {
        this.setTitle(OroCustMessages.getString("CustomerHistoryDialog.0"));
        this.setLayout(new BorderLayout());
        this.memberId = memberId;
        this.ticketList = new CustomerTicketListView(memberId);
        this.initComponents();
        this.btnOrderInfo.addActionListener(this);
        this.orderServiceExtension = (OrderServiceExtension)ExtensionManager.getPlugin(OrderServiceExtension.class);
        if (this.orderServiceExtension == null) {
            this.orderServiceExtension = new DefaultOrderServiceExtension();
        }
        this.applyComponentOrientation(ComponentOrientation.getOrientation(Locale.getDefault()));
        this.updateTicketList();
    }

    private void initComponents() {
        this.setLayout(new BorderLayout(10, 10));
        TitlePanel titlePanel = new TitlePanel();
        titlePanel.setTitle(OroCustMessages.getString("CustomerHistoryDialog.1"));
        this.add((Component)titlePanel, "North");
        JPanel centerPanel = new JPanel(new BorderLayout(5, 5));
        JPanel ticketsAndActivityPanel = new JPanel(new BorderLayout(5, 5));
        this.ticketsListPanelBorder = BorderFactory.createTitledBorder(null, "Tickets", 2, 0);
        JPanel activityPanel = this.createActivityPanel();
        ticketsAndActivityPanel.setBorder(new CompoundBorder(this.ticketsListPanelBorder, new EmptyBorder(2, 2, 2, 2)));
        ticketsAndActivityPanel.add((Component)this.ticketList, "Center");
        ticketsAndActivityPanel.add((Component)activityPanel, "South");
        centerPanel.add((Component)ticketsAndActivityPanel, "Center");
        this.add((Component)centerPanel, "Center");
    }

    private JPanel createActivityPanel() {
        JPanel activityPanel = new JPanel(new BorderLayout(5, 5));
        JPanel innerActivityPanel = new JPanel((LayoutManager)new MigLayout("hidemode 3, fill, ins 0", "fill, grow", ""));
        JPanel firstRowButtonPanel = new JPanel();
        firstRowButtonPanel.add(this.btnOrderInfo);
        innerActivityPanel.add(firstRowButtonPanel);
        PosButton btnCancel = new PosButton(POSConstants.CANCEL.toUpperCase());
        btnCancel.setPreferredSize(new Dimension(78, 0));
        btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CustomerHistoryDialog.this.closeDialog(false);
            }
        });
        activityPanel.add(innerActivityPanel);
        activityPanel.add((Component)btnCancel, "East");
        return activityPanel;
    }

    protected void doCloseOrder() {
        Ticket ticket = this.getFirstSelectedTicket();
        if (ticket == null) {
            return;
        }
        ticket = TicketDAO.getInstance().loadFullTicket(ticket.getId());
        int due = (int)POSUtil.getDouble(ticket.getDueAmount());
        if (due != 0) {
            POSMessageDialog.showError(this, OroCustMessages.getString("SwitchboardView.5"));
            return;
        }
        int option = JOptionPane.showOptionDialog(Application.getPosWindow(), OroCustMessages.getString("SwitchboardView.6") + ticket.getId() + OroCustMessages.getString("SwitchboardView.7"), POSConstants.CONFIRM, 2, 1, null, null, null);
        if (option != 0) {
            return;
        }
        OrderController.closeOrder(ticket);
    }

    private void doShowOrderInfo() {
        this.doShowOrderInfo(this.ticketList.getSelectedTickets());
    }

    private void doShowOrderInfo(List<Ticket> tickets) {
        try {
            if (tickets == null || tickets.size() == 0) {
                POSMessageDialog.showMessage(OroCustMessages.getString("CustomerHistoryDialog.3"));
                return;
            }
            ArrayList<Ticket> ticketsToShow = new ArrayList<Ticket>();
            for (int i = 0; i < tickets.size(); ++i) {
                Ticket ticket = tickets.get(i);
                ticketsToShow.add(TicketDAO.getInstance().loadFullTicket(ticket.getId()));
            }
            OrderInfoView view = new OrderInfoView(ticketsToShow);
            OrderInfoDialog dialog = new OrderInfoDialog(view);
            dialog.setSize(400, 600);
            dialog.setDefaultCloseOperation(2);
            dialog.setLocationRelativeTo(Application.getPosWindow());
            dialog.setVisible(true);
            this.ticketReordered = dialog.isReorder();
            if (this.ticketReordered) {
                this.closeDialog(true);
            }
        }
        catch (Exception e) {
            POSMessageDialog.showError(this, POSConstants.ERROR_MESSAGE, e);
        }
    }

    public void doHomeDelivery(OrderType ticketType) {
    }

    public void doVoidTicket() {
        Ticket ticket = this.ticketList.getSelectedTicket();
        if (ticket == null) {
            POSMessageDialog.showMessage(POSConstants.SELECT_ONE_TICKET_TO_VOID);
            return;
        }
        Ticket ticketToVoid = TicketDAO.getInstance().loadFullTicket(ticket.getId());
        VoidTicketDialog voidTicketDialog = new VoidTicketDialog();
        voidTicketDialog.setTicket(ticketToVoid);
        voidTicketDialog.pack();
        voidTicketDialog.open();
        if (!voidTicketDialog.isCanceled()) {
            // empty if block
        }
    }

    public void updateView() {
    }

    private void closeDialog(boolean canceled) {
        this.setCanceled(canceled);
        this.dispose();
        if (canceled) {
            // empty if block
        }
    }

    @Override
    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.updateView();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.btnOrderInfo) {
            this.doShowOrderInfo();
        }
    }

    public Ticket getFirstSelectedTicket() {
        List<Ticket> selectedTickets = this.ticketList.getSelectedTickets();
        if (selectedTickets == null || selectedTickets.size() == 0 || selectedTickets.size() > 1) {
            POSMessageDialog.showMessage(this, OroCustMessages.getString("SwitchboardView.22"));
            return null;
        }
        Ticket ticket = selectedTickets.get(0);
        return ticket;
    }

    @Override
    public Ticket getSelectedTicket() {
        List<Ticket> selectedTickets = this.ticketList.getSelectedTickets();
        if (selectedTickets.size() == 0 || selectedTickets.size() > 1) {
            return null;
        }
        Ticket ticket = selectedTickets.get(0);
        return ticket;
    }

    @Override
    public void ticketListUpdated() {
        String title = POSConstants.OPEN_TICKETS_AND_ACTIVITY;
        this.ticketsListPanelBorder.setTitle(title);
    }

    public String getMemberId() {
        return this.memberId;
    }

    @Override
    public void updateTicketList() {
        this.ticketList.updateTicketList();
    }

    public boolean isTicketReordered() {
        return this.ticketReordered;
    }
}

