/*
 * Decompiled with CFR 0.152.
 */
package com.orocube.orocust.ui.dialog;

import com.floreantpos.PosException;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.util.DateUtil;
import com.floreantpos.swing.POSToggleButton;
import com.floreantpos.swing.PosScrollPane;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.ScrollableFlowPanel;
import com.floreantpos.ui.dialog.OkCancelOptionDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.POSUtil;
import com.orocube.orocust.OroCustMessages;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.BorderFactory;
import org.apache.commons.lang3.StringUtils;

public class DeliveryTicketSelectionDialog
extends OkCancelOptionDialog {
    private ScrollableFlowPanel buttonsPanel;
    private List<Ticket> addedTicketListModel = new ArrayList<Ticket>();
    private List<Ticket> tickets;

    public DeliveryTicketSelectionDialog() {
        super(POSUtil.getFocusedWindow());
        this.initComponent();
        this.setResizable(true);
    }

    public DeliveryTicketSelectionDialog(List<Ticket> tickets) {
        super(POSUtil.getFocusedWindow());
        this.initComponent();
        Collections.sort(tickets, new Comparator<Ticket>(){

            @Override
            public int compare(Ticket o1, Ticket o2) {
                String zipCode1 = o1.getProperty("CUSTOMER_ZIP_CODE");
                String zipCode2 = o2.getProperty("CUSTOMER_ZIP_CODE");
                if (zipCode1 == null) {
                    zipCode1 = "";
                }
                if (zipCode2 == null) {
                    zipCode2 = "";
                }
                return zipCode1.compareTo(zipCode2);
            }
        });
        this.rendererTickets(tickets);
        this.setResizable(true);
    }

    protected void setTickets(List<Ticket> tickets) {
        this.tickets = tickets;
        this.rendererTickets(tickets);
    }

    private void initComponent() {
        this.setOkButtonText(OroCustMessages.getString("DONE"));
        this.buttonsPanel = new ScrollableFlowPanel(3);
        PosScrollPane scrollPane = new PosScrollPane(this.buttonsPanel, 20, 31);
        scrollPane.getVerticalScrollBar().setPreferredSize(new Dimension(80, 0));
        scrollPane.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5), scrollPane.getBorder()));
        this.getContentPanel().add((Component)scrollPane, "Center");
    }

    private void rendererTickets(List<Ticket> tickets) {
        try {
            for (Ticket ticket : tickets) {
                if (ticket.getDueAmount() <= 0.0) continue;
                TicketButton btnTicket = new TicketButton(ticket);
                Color bgColor = ticket.getAssignedDriver() != null ? Color.RED : Color.WHITE;
                btnTicket.setBackground(bgColor);
                btnTicket.setPreferredSize(PosUIManager.getSize(198, 162));
                this.buttonsPanel.add(btnTicket);
            }
        }
        catch (PosException e) {
            POSMessageDialog.showError(this, e.getLocalizedMessage(), e);
        }
    }

    @Override
    public void doOk() {
        if (this.addedTicketListModel.isEmpty()) {
            POSMessageDialog.showMessage(OroCustMessages.getString("TicketSelectionDialog.5"));
            return;
        }
        this.setCanceled(false);
        this.dispose();
    }

    @Override
    public void doCancel() {
        this.addedTicketListModel.clear();
        this.setCanceled(true);
        this.dispose();
    }

    public List<Ticket> getSelectedTickets() {
        return this.addedTicketListModel;
    }

    private class TicketButton
    extends POSToggleButton
    implements ActionListener {
        private Ticket ticket;

        TicketButton(Ticket ticket) {
            String driver;
            String customerAddress;
            String customerZipCode;
            String customerMobile;
            this.ticket = ticket;
            String customerName = ticket.getProperty("CUSTOMER_NAME");
            if (customerName == null) {
                customerName = "";
            }
            if ((customerMobile = ticket.getProperty("CUSTOMER_MOBILE")) == null) {
                customerMobile = "";
            }
            if ((customerZipCode = ticket.getProperty("CUSTOMER_ZIP_CODE")) == null) {
                customerZipCode = "";
            }
            if ((customerAddress = ticket.getDeliveryAddress()) == null || StringUtils.isEmpty((CharSequence)customerAddress) || customerAddress.equals(" ")) {
                customerAddress = "";
            }
            String token = ticket.getNumberToDisplay();
            String customer = StringUtils.isNotEmpty((CharSequence)customerName) ? "<br/><b>" + OroCustMessages.getString("OroCust.DTSD.8") + " </b>" + customerName : "";
            String delivery = StringUtils.isNotEmpty((CharSequence)customerAddress) ? "<br/><b>" + OroCustMessages.getString("OroCust.DTSD.12") + "</b>" + customerAddress : "";
            String deliveryTime = StringUtils.isNotEmpty((CharSequence)customerAddress) ? "<br/><b>" + OroCustMessages.getString("OroCust.DTSD.16") + "</b>" + DateUtil.formatSmall(ticket.getDeliveryDate()) : "";
            driver = ticket.getAssignedDriver() != null ? (driver = "<br/><b>" + OroCustMessages.getString("OroCust.DTSD.20") + "</b>" + ticket.getAssignedDriver().getFullName()) : "";
            this.setText("<html><body><center><h3>" + token + "</h3>" + customer + delivery + deliveryTime + driver + "</center></body></html>");
            this.addActionListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.isSelected()) {
                DeliveryTicketSelectionDialog.this.addedTicketListModel.add(this.ticket);
            } else {
                DeliveryTicketSelectionDialog.this.addedTicketListModel.remove(this.ticket);
            }
        }
    }
}

