/*
 * Decompiled with CFR 0.152.
 */
package com.orocube.orocust.ui.dialog;

import com.floreantpos.POSConstants;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.User;
import com.floreantpos.model.dao.TicketDAO;
import com.floreantpos.report.ReceiptPrintService;
import com.floreantpos.swing.PosButton;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.orocube.orocust.OroCustMessages;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;
import net.miginfocom.swing.MigLayout;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.jdesktop.swingx.JXTable;

public class DriverSelectionDialog
extends JDialog {
    private List<Ticket> tickets;
    private JXTable driverTable;
    private PosButton btnCancel;
    private PosButton btnDone;
    protected boolean canceled = true;
    private User selectedDriver;

    public DriverSelectionDialog(Frame parent) {
        super(parent, OroCustMessages.getString("DriverSelectionDialog.0"), true);
        this.createUI();
        this.setDefaultCloseOperation(2);
    }

    private void createUI() {
        this.setLayout(new BorderLayout());
        JPanel centerPanel = new JPanel((LayoutManager)new MigLayout("fill"));
        this.driverTable = new JXTable();
        JScrollPane scrollPane = new JScrollPane();
        scrollPane.setViewportView((Component)this.driverTable);
        centerPanel.add((Component)scrollPane, "grow");
        this.add((Component)centerPanel, "Center");
        JPanel buttonPanel = new JPanel();
        this.btnCancel = new PosButton();
        this.btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DriverSelectionDialog.this.canceled = true;
                DriverSelectionDialog.this.dispose();
            }
        });
        this.btnCancel.setText(POSConstants.CANCEL.toUpperCase());
        this.btnDone = new PosButton();
        this.btnDone.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DriverSelectionDialog.this.selectedDriver = DriverSelectionDialog.this.doSelectDriver();
                if (DriverSelectionDialog.this.selectedDriver == null) {
                    return;
                }
                if (DriverSelectionDialog.this.tickets == null || DriverSelectionDialog.this.tickets.isEmpty()) {
                    DriverSelectionDialog.this.canceled = false;
                    DriverSelectionDialog.this.dispose();
                } else {
                    DriverSelectionDialog.this.saveTickets();
                }
            }
        });
        this.btnDone.setText(POSConstants.SAVE_BUTTON_TEXT);
        buttonPanel.add(this.btnDone);
        buttonPanel.add(this.btnCancel);
        this.add((Component)buttonPanel, "South");
        this.driverTable.setModel((TableModel)new DriverTableModel());
        this.driverTable.setFocusable(false);
        this.driverTable.setRowHeight(35);
        this.driverTable.getSelectionModel().setSelectionMode(0);
    }

    private User doSelectDriver() {
        int selectedRow = this.driverTable.getSelectedRow();
        if (selectedRow < 0) {
            POSMessageDialog.showError(OroCustMessages.getString("DriverSelectionDialog.3"));
            return null;
        }
        DriverTableModel model = (DriverTableModel)this.driverTable.getModel();
        User driver = model.getDriver(selectedRow);
        return driver;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void saveTickets() {
        Transaction transaction = null;
        try (Session session = TicketDAO.getInstance().createNewSession();){
            transaction = session.beginTransaction();
            for (Ticket ticket : this.tickets) {
                ticket.setAssignedDriver(this.selectedDriver);
                ticket.addProperty("OUT_AT", OroCustMessages.getString("DriverSelectionDialog.4"));
                ticket.setStatus("Driving");
                session.saveOrUpdate((Object)ticket);
            }
            transaction.commit();
            for (Ticket ticket : this.tickets) {
                ReceiptPrintService.printTicket(ticket, "Customer Copy");
                ReceiptPrintService.printTicket(ticket, "Driver Copy");
            }
            this.canceled = false;
            this.dispose();
        }
    }

    public void setData(List<Ticket> tickets, List<User> drivers) {
        this.tickets = tickets;
        this.driverTable.setModel((TableModel)new DriverTableModel(drivers));
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    public User getSelectedDriver() {
        return this.selectedDriver;
    }

    public void setSelectedDriver(User selectedDriver) {
        this.selectedDriver = selectedDriver;
    }

    class DriverTableModel
    extends AbstractTableModel {
        private final String[] columns = new String[]{OroCustMessages.getString("DriverSelectionDialog.5"), OroCustMessages.getString("DriverSelectionDialog.6"), OroCustMessages.getString("DriverSelectionDialog.7")};
        private List<User> drivers;

        public DriverTableModel() {
        }

        public DriverTableModel(List<User> customers) {
            this.drivers = customers;
        }

        @Override
        public int getRowCount() {
            if (this.drivers == null) {
                return 0;
            }
            return this.drivers.size();
        }

        @Override
        public int getColumnCount() {
            return this.columns.length;
        }

        @Override
        public String getColumnName(int column) {
            return this.columns[column];
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            if (this.drivers == null) {
                return null;
            }
            User driver = this.drivers.get(rowIndex);
            switch (columnIndex) {
                case 0: {
                    return driver.getFirstName() + " " + driver.getLastName();
                }
                case 1: {
                    return driver.getPhoneNo();
                }
                case 2: {
                    return driver.getStatus();
                }
            }
            return null;
        }

        public List<User> getDrivers() {
            return this.drivers;
        }

        public User getDriver(int index) {
            if (this.drivers == null) {
                return null;
            }
            if (index < 0 || index >= this.drivers.size()) {
                return null;
            }
            return this.drivers.get(index);
        }
    }
}

