/*
 * Decompiled with CFR 0.152.
 */
package com.orocube.orocust.ui.view;

import com.floreantpos.customer.CustomerSelectorDialog;
import com.floreantpos.customer.CustomerSelectorFactory;
import com.floreantpos.extension.OrderServiceFactory;
import com.floreantpos.main.Application;
import com.floreantpos.model.Customer;
import com.floreantpos.model.OrderType;
import com.floreantpos.model.dao.CustomerDAO;
import com.floreantpos.model.dao.OrderTypeDAO;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.views.order.ViewPanel;
import com.floreantpos.util.TicketAlreadyExistsException;
import com.orocube.orocust.OroCustMessages;
import com.orocube.orocust.callerid.CallButtonClickListener;
import com.orocube.orocust.callerid.CallInformationView;
import com.orocube.orocust.ui.view.DeliveryDispatchTicketActivity;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.util.List;
import java.util.Locale;
import javax.swing.JPanel;

public class DeliveryDispatchView
extends ViewPanel
implements CallButtonClickListener {
    private static final String VIEW_NAME = "DELIVERY_DISPATCH";
    private DeliveryDispatchTicketActivity ticketActivityPanel;
    private static DeliveryDispatchView instance;
    private OrderType orderType;
    private CallInformationView lineView;

    private DeliveryDispatchView(OrderType orderType) {
        this.setOrderType(orderType);
        this.setLayout(new BorderLayout());
        this.initComponents();
        this.applyComponentOrientation(ComponentOrientation.getOrientation(Locale.getDefault()));
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
        JPanel centerPanel = new JPanel(new BorderLayout(5, 5));
        this.ticketActivityPanel = new DeliveryDispatchTicketActivity(this.orderType);
        JPanel ticketsAndActivityPanel = new JPanel(new BorderLayout(5, 5));
        ticketsAndActivityPanel.add((Component)this.ticketActivityPanel, "Center");
        centerPanel.add((Component)ticketsAndActivityPanel, "Center");
        this.add((Component)centerPanel, "Center");
        String enableProperty = Application.getInstance().getStore().getProperty("callerId.CallerIdEnable");
        if (Boolean.valueOf(enableProperty).booleanValue()) {
            this.lineView = new CallInformationView(this);
            this.lineView.setVisible(false);
            this.add((Component)this.lineView, "West");
        }
    }

    public static DeliveryDispatchView getInstance(OrderType orderType) {
        if (instance == null) {
            instance = new DeliveryDispatchView(orderType);
        } else {
            DeliveryDispatchView.instance.ticketActivityPanel.updateTicketList();
        }
        instance.setOrderType(orderType);
        return instance;
    }

    @Override
    public String getViewName() {
        return VIEW_NAME;
    }

    public void setOrderType(OrderType orderType) {
        this.orderType = orderType;
        if (this.ticketActivityPanel != null) {
            this.ticketActivityPanel.setOrderType(orderType);
        }
    }

    public OrderType getOrderType() {
        if (this.orderType == null) {
            this.orderType = OrderTypeDAO.getInstance().getHomeDeliveryOrderType();
        }
        return this.orderType;
    }

    @Override
    public void callButtonClicked(int line, String callerId, String callerName) {
        OrderType orderType2 = this.getOrderType();
        if (orderType2.isRequiredCustomerData().booleanValue()) {
            CustomerSelectorDialog dialog = CustomerSelectorFactory.createCustomerSelectorDialog(orderType2);
            dialog.setCreateNewTicket(true);
            dialog.setCallerId(callerId);
            dialog.updateView(true);
            dialog.openUndecoratedFullScreen();
            if (!dialog.isCanceled()) {
                return;
            }
        } else {
            try {
                List<Customer> customers = CustomerDAO.getInstance().findByMobileNumber(callerId);
                Customer selectedCustomer = null;
                if (customers.size() > 0) {
                    selectedCustomer = customers.get(0);
                } else {
                    selectedCustomer = new Customer();
                    selectedCustomer.setMobileNo(callerId);
                    selectedCustomer.setFirstName(callerName);
                    selectedCustomer.setName(callerName);
                    CustomerDAO.getInstance().save(selectedCustomer);
                }
                OrderServiceFactory.getOrderService().createNewTicket(orderType2, null, selectedCustomer);
            }
            catch (TicketAlreadyExistsException e) {
                POSMessageDialog.showError(this, OroCustMessages.getString("DeliveryDispatchView.2"), e);
            }
        }
    }
}

