/*
 * Decompiled with CFR 0.152.
 */
package com.orostock.inventory.report;

import com.floreantpos.model.InventoryTransaction;
import com.floreantpos.model.InventoryTransactionType;
import com.floreantpos.model.InventoryVendor;
import com.floreantpos.swing.ListTableModel;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class InventoryAverageCostUnitReportModel
extends ListTableModel {
    SimpleDateFormat dateFormat2 = new SimpleDateFormat("MMM-dd-yy HH:mm ");
    DecimalFormat decimalFormat = new DecimalFormat("0.00");
    private double totalAmount;
    private double totalQuantity;
    double totalOnHandValue;
    double amount;
    String type;
    private Double unitCost;

    public InventoryAverageCostUnitReportModel() {
        super(new String[]{"itemgroup", "items", "sku", "date", "vendor", "reasonType", "openingQty", "openingCost", "openingTotalCost", "quantity", "unit", "cost", "total"});
    }

    public void setItems(List<InventoryTransaction> transactions) {
        this.setRows(transactions);
        this.totalAmount = 0.0;
        for (InventoryTransaction item : transactions) {
            this.totalAmount += item.getTotal().doubleValue();
        }
    }

    public void setQuantity(List<InventoryTransaction> transactions) {
        this.setRows(transactions);
        this.totalQuantity = 0.0;
        for (InventoryTransaction item : transactions) {
            if (item.getType().equals((Object)InventoryTransactionType.IN)) {
                this.totalQuantity += item.getQuantity().doubleValue();
                continue;
            }
            if (!item.getType().equals((Object)InventoryTransactionType.OUT)) continue;
            this.totalQuantity -= item.getQuantity().doubleValue();
        }
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        InventoryTransaction transactionData = (InventoryTransaction)this.rows.get(rowIndex);
        switch (columnIndex) {
            case 0: {
                return transactionData.getMenuItem().getMenuGroupName();
            }
            case 1: {
                return transactionData.getMenuItem().getDisplayName();
            }
            case 2: {
                return transactionData.getMenuItem().getSku();
            }
            case 3: {
                return this.dateFormat2.format(transactionData.getTransactionDate());
            }
            case 4: {
                InventoryVendor vendor = transactionData.getVendor();
                if (vendor == null) {
                    return "";
                }
                String vendorName = vendor.getName();
                if (StringUtils.isNotEmpty((String)vendorName)) {
                    return vendorName;
                }
                return "";
            }
            case 5: {
                return transactionData.getReason().toString();
            }
            case 6: {
                return transactionData.getOpeningQty();
            }
            case 7: {
                return transactionData.getOpeningCost();
            }
            case 8: {
                return transactionData.getOpeningTotalCost();
            }
            case 9: {
                this.totalQuantity = transactionData.getBaseUnitQuantity() * transactionData.getQuantity();
                if (transactionData.getReason() == null) {
                    return this.totalQuantity;
                }
                this.type = transactionData.getReason().toString();
                if ("OUT".equals(this.type)) {
                    return -this.totalQuantity;
                }
                return this.totalQuantity;
            }
            case 10: {
                return transactionData.getBaseUnit();
            }
            case 11: {
                this.unitCost = transactionData.getUnitCost() / transactionData.getBaseUnitQuantity();
                return (double)this.unitCost;
            }
            case 12: {
                this.totalOnHandValue = transactionData.getTotal();
                if (transactionData.getReason() == null) {
                    return this.totalOnHandValue;
                }
                this.type = transactionData.getReason().toString();
                if ("OUT".equals(this.type)) {
                    return -this.totalOnHandValue;
                }
                return this.totalQuantity * this.unitCost;
            }
        }
        return null;
    }

    public double getTotalAmount() {
        return this.totalAmount;
    }

    public double getTotalQuantity() {
        return this.totalQuantity;
    }
}

