/*
 * Decompiled with CFR 0.152.
 */
package com.orostock.inventory.report;

import com.floreantpos.model.InventoryLocation;
import com.floreantpos.model.InventoryTransaction;
import com.floreantpos.model.InventoryTransactionType;
import com.floreantpos.model.InventoryVendor;
import com.floreantpos.model.MenuItem;
import com.floreantpos.swing.ListTableModel;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class InventoryTransactionReportModel
extends ListTableModel<InventoryTransaction> {
    SimpleDateFormat dateFormat2 = new SimpleDateFormat("MMM-dd-yy HH:mm ");
    DecimalFormat decimalFormat = new DecimalFormat("0.00");
    private double totalAmount;
    private double totalQuantity;
    double totalOnHandValue;
    double amount;
    String type;
    private Double unitCost;

    public InventoryTransactionReportModel() {
        super(new String[]{"itemgroup", "items", "sku", "vendor", "tranTime", "tranType", "reasonType", "quantity", "unit", "cost", "total", "location"});
    }

    public void setItems(List<InventoryTransaction> transactions) {
        this.setRows(transactions);
        this.totalAmount = 0.0;
        for (InventoryTransaction item : transactions) {
            this.totalAmount += item.getTotal().doubleValue();
        }
    }

    public void setQuantity(List<InventoryTransaction> transactions) {
        this.setRows(transactions);
        this.totalQuantity = 0.0;
        for (InventoryTransaction item : transactions) {
            if (item.getType().equals(InventoryTransactionType.IN.getType())) {
                this.totalQuantity += item.getQuantity().doubleValue();
                continue;
            }
            if (!item.getType().equals(InventoryTransactionType.OUT.getType())) continue;
            this.totalQuantity -= item.getQuantity().doubleValue();
        }
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        InventoryTransaction transactionData = (InventoryTransaction)this.rows.get(rowIndex);
        MenuItem menuItem = transactionData.getMenuItem();
        switch (columnIndex) {
            case 0: {
                String menuGroup = menuItem.getMenuGroupName();
                if (menuGroup == null) {
                    return "";
                }
                return menuGroup;
            }
            case 1: {
                return menuItem.getDisplayName();
            }
            case 2: {
                return menuItem.getSku();
            }
            case 3: {
                InventoryVendor vendor = transactionData.getVendor();
                if (vendor == null) {
                    return transactionData.getTicketId();
                }
                String vendorName = vendor.getName();
                if (StringUtils.isNotEmpty((String)vendorName)) {
                    return vendorName;
                }
                return "";
            }
            case 4: {
                return this.dateFormat2.format(transactionData.getTransactionDate());
            }
            case 5: {
                return transactionData.getTransactionType().name();
            }
            case 6: {
                return transactionData.getReason() == null ? "" : transactionData.getReason().toString();
            }
            case 7: {
                this.totalQuantity = transactionData.getQuantity();
                if (transactionData.getReason() == null) {
                    return this.totalQuantity;
                }
                this.type = transactionData.getTransactionType().toString();
                if ("OUT".equals(this.type)) {
                    return -this.totalQuantity;
                }
                return this.totalQuantity;
            }
            case 8: {
                return transactionData.getUnit();
            }
            case 9: {
                this.unitCost = transactionData.getUnitCost();
                return (double)this.unitCost;
            }
            case 10: {
                this.totalOnHandValue = transactionData.getTotal();
                if (transactionData.getReason() == null) {
                    return this.totalOnHandValue;
                }
                this.type = transactionData.getTransactionType().toString();
                if ("OUT".equals(this.type)) {
                    return -this.totalOnHandValue;
                }
                return this.totalQuantity * this.unitCost;
            }
            case 11: {
                InventoryLocation toInvLoc;
                if (transactionData.getTransactionType() == null) {
                    return "";
                }
                this.type = transactionData.getTransactionType().toString();
                if ("OUT".equals(this.type)) {
                    InventoryLocation fromInventoryLocation = transactionData.getFromInventoryLocation();
                    if (fromInventoryLocation != null) {
                        return fromInventoryLocation.getName();
                    }
                } else if ("IN".equals(this.type) && (toInvLoc = transactionData.getToInventoryLocation()) != null) {
                    return toInvLoc.getName();
                }
                return "";
            }
        }
        return null;
    }

    public double getTotalAmount() {
        return this.totalAmount;
    }

    public double getTotalQuantity() {
        return this.totalQuantity;
    }
}

