/*
 * Decompiled with CFR 0.152.
 */
package com.orostock.inventory.ui;

import com.floreantpos.POSConstants;
import com.floreantpos.PosException;
import com.floreantpos.bo.ui.BOMessageDialog;
import com.floreantpos.bo.ui.explorer.ExplorerButtonPanel;
import com.floreantpos.model.InventoryLocation;
import com.floreantpos.model.dao.InventoryLocationDAO;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.TransparentPanel;
import com.floreantpos.ui.PosTableRenderer;
import com.floreantpos.ui.dialog.BeanEditorDialog;
import com.floreantpos.ui.dialog.DetailsInfoDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.orostock.inventory.InvMessages;
import com.orostock.inventory.ui.InventoryLocationEntryForm;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Enumeration;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.tree.TreePath;
import org.jdesktop.swingx.JXTreeTable;
import org.jdesktop.swingx.treetable.DefaultMutableTreeTableNode;
import org.jdesktop.swingx.treetable.DefaultTreeTableModel;
import org.jdesktop.swingx.treetable.MutableTreeTableNode;
import org.jdesktop.swingx.treetable.TreeTableModel;
import org.jdesktop.swingx.treetable.TreeTableNode;

public class InventoryLocationBrowser
extends TransparentPanel
implements ActionListener,
ListSelectionListener {
    private static final long serialVersionUID = 1L;
    private JXTreeTable treeTable;
    private InvLocationTreeTableModel noRootTreeTableModel;
    private List<InventoryLocation> rootLocationList;

    public InventoryLocationBrowser() {
        this.setLayout(new BorderLayout(5, 5));
        this.treeTable = new JXTreeTable();
        this.treeTable.setRowHeight(PosUIManager.getSize(30));
        this.treeTable.setRootVisible(false);
        this.treeTable.setDefaultRenderer(Object.class, (TableCellRenderer)new PosTableRenderer());
        this.rootLocationList = InventoryLocationDAO.getInstance().getRootLocations();
        this.createTree();
        this.treeTable.expandAll();
        this.treeTable.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent me) {
                int col = InventoryLocationBrowser.this.treeTable.columnAtPoint(me.getPoint());
                if (me.getClickCount() == 2 && col == 0) {
                    InventoryLocationBrowser.this.treeTable.expandPath(InventoryLocationBrowser.this.treeTable.getPathForRow(InventoryLocationBrowser.this.treeTable.getSelectedRow()));
                } else if (me.getClickCount() == 2 && col != 0) {
                    InventoryLocationBrowser.this.editSelectedRow();
                }
            }
        });
        this.add((Component)new JScrollPane((Component)this.treeTable), "Center");
        this.createButtonPanel();
    }

    private void createTree() {
        if (this.rootLocationList != null) {
            InventoryLocation demo = new InventoryLocation();
            demo.setId("0");
            demo.setName(InvMessages.getString("IVLB.1"));
            DefaultMutableTreeTableNode rootNode = new DefaultMutableTreeTableNode((Object)demo);
            rootNode.setUserObject((Object)demo);
            for (InventoryLocation inventoryLocation : this.rootLocationList) {
                DefaultMutableTreeTableNode node = new DefaultMutableTreeTableNode((Object)inventoryLocation);
                rootNode.add((MutableTreeTableNode)node);
                this.buildLocationTree(node);
            }
            this.noRootTreeTableModel = new InvLocationTreeTableModel(rootNode);
            this.treeTable.setTreeTableModel((TreeTableModel)this.noRootTreeTableModel);
        }
    }

    private void buildLocationTree(DefaultMutableTreeTableNode defaultMutableTreeTableNode) {
        InventoryLocation loc = (InventoryLocation)defaultMutableTreeTableNode.getUserObject();
        if (loc == null) {
            return;
        }
        if (loc.getChildren() == null || loc.getChildren().size() == 0) {
            return;
        }
        defaultMutableTreeTableNode.setAllowsChildren(true);
        List<InventoryLocation> children = loc.getChildren();
        for (InventoryLocation inventoryLocation : children) {
            DefaultMutableTreeTableNode node = new DefaultMutableTreeTableNode((Object)inventoryLocation);
            defaultMutableTreeTableNode.add((MutableTreeTableNode)node);
            this.buildLocationTree(node);
        }
    }

    private void createButtonPanel() {
        ExplorerButtonPanel explorerButton = new ExplorerButtonPanel();
        JButton btn_new = new JButton(InvMessages.getString("IVLB.10"));
        JButton editButton = explorerButton.getEditButton();
        JButton deleteButton = explorerButton.getDeleteButton();
        btn_new.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int index = InventoryLocationBrowser.this.treeTable.getSelectedRow();
                InventoryLocation location = null;
                if (index >= 0) {
                    TreePath treePath = InventoryLocationBrowser.this.treeTable.getPathForRow(index);
                    DefaultMutableTreeTableNode lastPathComponent = (DefaultMutableTreeTableNode)treePath.getLastPathComponent();
                    location = (InventoryLocation)lastPathComponent.getUserObject();
                }
                InventoryLocation inventoryLocation = new InventoryLocation();
                if (location != null) {
                    inventoryLocation.setParentLocation(location);
                }
                InventoryLocationEntryForm inventoryLocationEntryForm = new InventoryLocationEntryForm(inventoryLocation);
                BeanEditorDialog dialog = new BeanEditorDialog(inventoryLocationEntryForm);
                dialog.setPreferredSize(PosUIManager.getSize(500, 600));
                dialog.open();
                if (dialog.isCanceled()) {
                    return;
                }
                InventoryLocation newLoc = (InventoryLocation)inventoryLocationEntryForm.getBean();
                InventoryLocation parentOfNewLoc = newLoc.getParentLocation();
                if (newLoc != null) {
                    MutableTreeTableNode root = (MutableTreeTableNode)InventoryLocationBrowser.this.noRootTreeTableModel.getRoot();
                    if (parentOfNewLoc != null) {
                        MutableTreeTableNode parentNode = InventoryLocationBrowser.this.findTreeNodeForLocation(root, parentOfNewLoc.getId());
                        if (parentNode != null) {
                            InventoryLocationBrowser.this.noRootTreeTableModel.insertNodeInto((MutableTreeTableNode)new DefaultMutableTreeTableNode((Object)newLoc), parentNode, parentNode.getChildCount());
                        }
                    } else {
                        MutableTreeTableNode parentNode = InventoryLocationBrowser.this.findTreeNodeForLocation(root, "0");
                        if (parentNode != null) {
                            InventoryLocationBrowser.this.noRootTreeTableModel.insertNodeInto((MutableTreeTableNode)new DefaultMutableTreeTableNode((Object)newLoc), parentNode, parentNode.getChildCount());
                        }
                    }
                }
                InventoryLocationBrowser.this.rootLocationList = InventoryLocationDAO.getInstance().getRootLocations();
                InventoryLocationBrowser.this.createTree();
                InventoryLocationBrowser.this.treeTable.expandAll();
            }
        });
        editButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                InventoryLocationBrowser.this.editSelectedRow();
            }
        });
        deleteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                this.deleteInventoryLocation();
            }

            private void deleteInventoryLocation() {
                try {
                    int index = InventoryLocationBrowser.this.treeTable.getSelectedRow();
                    if (index < 0) {
                        return;
                    }
                    TreePath treePath = InventoryLocationBrowser.this.treeTable.getPathForRow(index);
                    DefaultMutableTreeTableNode lastPathComponent = (DefaultMutableTreeTableNode)treePath.getLastPathComponent();
                    InventoryLocation location = (InventoryLocation)lastPathComponent.getUserObject();
                    if (POSMessageDialog.showYesNoQuestionDialog(InventoryLocationBrowser.this.getRootPane(), POSConstants.CONFIRM_DELETE, POSConstants.DELETE) != 0) {
                        return;
                    }
                    InventoryLocationDAO inventoryLocationdao = InventoryLocationDAO.getInstance();
                    inventoryLocationdao.refresh(location);
                    inventoryLocationdao.delete(location);
                    MutableTreeTableNode tableNode = InventoryLocationBrowser.this.findTreeNodeForLocation((MutableTreeTableNode)InventoryLocationBrowser.this.noRootTreeTableModel.getRoot(), location.getId());
                    if (tableNode.getParent() != null) {
                        InventoryLocationBrowser.this.noRootTreeTableModel.removeNodeFromParent(tableNode);
                    }
                    InventoryLocationBrowser.this.treeTable.repaint();
                    InventoryLocationBrowser.this.treeTable.revalidate();
                }
                catch (PosException x) {
                    DetailsInfoDialog dialog = new DetailsInfoDialog(x.getMessage(), x.getDetails());
                    dialog.open();
                }
                catch (Throwable x) {
                    BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, x);
                }
            }
        });
        TransparentPanel panel = new TransparentPanel();
        panel.add(btn_new);
        panel.add(editButton);
        panel.add(deleteButton);
        this.add((Component)panel, "South");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
    }

    private void editSelectedRow() {
        try {
            int index = this.treeTable.getSelectedRow();
            if (index < 0) {
                return;
            }
            TreePath treePath = this.treeTable.getPathForRow(index);
            DefaultMutableTreeTableNode lastPathComponent = (DefaultMutableTreeTableNode)treePath.getLastPathComponent();
            InventoryLocation location = (InventoryLocation)lastPathComponent.getUserObject();
            InventoryLocationEntryForm inventoryLocationEntryForm = new InventoryLocationEntryForm(location);
            BeanEditorDialog dialog = new BeanEditorDialog(inventoryLocationEntryForm);
            dialog.setPreferredSize(PosUIManager.getSize(500, 600));
            dialog.open();
            if (dialog.isCanceled()) {
                return;
            }
            this.rootLocationList = InventoryLocationDAO.getInstance().getRootLocations();
            this.createTree();
            this.treeTable.expandAll();
        }
        catch (Throwable x) {
            BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, x);
        }
    }

    public MutableTreeTableNode findTreeNodeForLocation(MutableTreeTableNode locationNode, String locationId) {
        InventoryLocation location = (InventoryLocation)locationNode.getUserObject();
        if (locationId.equals(location.getId())) {
            return locationNode;
        }
        Enumeration children = locationNode.children();
        while (children.hasMoreElements()) {
            MutableTreeTableNode treeTableNode = (MutableTreeTableNode)children.nextElement();
            MutableTreeTableNode findLocById = this.findTreeNodeForLocation(treeTableNode, locationId);
            if (findLocById == null) continue;
            return findLocById;
        }
        return null;
    }

    class InvLocationTreeTableModel
    extends DefaultTreeTableModel {
        private final String[] COLUMN_NAMES;

        public InvLocationTreeTableModel(DefaultMutableTreeTableNode rootLocation) {
            super((TreeTableNode)rootLocation);
            this.COLUMN_NAMES = new String[]{"Name", "Translated Name", "Address", "Parent", "Sort", "Default In", "Default Out"};
        }

        public void setRoot(TreeTableNode root) {
            super.setRoot(root);
        }

        public int getColumnCount() {
            return this.COLUMN_NAMES.length;
        }

        public String getColumnName(int column) {
            return this.COLUMN_NAMES[column];
        }

        public boolean isCellEditable(Object node, int column) {
            return false;
        }

        public Object getValueAt(Object node, int column) {
            if (node instanceof DefaultMutableTreeTableNode) {
                InventoryLocation inventoryLocation = (InventoryLocation)((DefaultMutableTreeTableNode)node).getUserObject();
                if (inventoryLocation == null) {
                    return "";
                }
                switch (column) {
                    case 0: {
                        return inventoryLocation.getName();
                    }
                    case 1: {
                        return inventoryLocation.getTranslatedName();
                    }
                    case 2: {
                        return inventoryLocation.getAddress();
                    }
                    case 3: {
                        return inventoryLocation.getParentLocation();
                    }
                    case 4: {
                        return inventoryLocation.getSortOrder();
                    }
                    case 5: {
                        return inventoryLocation.isDefaultInLocation();
                    }
                    case 6: {
                        return inventoryLocation.isDefaultOutLocation();
                    }
                }
            }
            return null;
        }
    }
}

