/*
 * Decompiled with CFR 0.152.
 */
package com.orostock.inventory.ui;

import com.floreantpos.model.InventoryMetaCode;
import com.floreantpos.model.dao.InventoryMetaCodeDAO;
import com.floreantpos.swing.IntegerTextField;
import com.floreantpos.swing.POSTextField;
import com.floreantpos.ui.BeanEditor;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.orostock.inventory.InvMessages;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;

public class InventoryMetacodeEntryForm
extends BeanEditor<InventoryMetaCode> {
    private JLabel lblType;
    private JLabel lblName;
    private JLabel lblNo;
    private JLabel lblDescription;
    private POSTextField tfType;
    private POSTextField tfName;
    private IntegerTextField tfNo;
    private POSTextField tfDescription;

    public InventoryMetacodeEntryForm(InventoryMetaCode ig) {
        this.setLayout(new BorderLayout());
        this.createUI();
        this.setBean(ig);
    }

    private void createUI() {
        JPanel panel = new JPanel();
        this.add((Component)panel, "Center");
        panel.setLayout((LayoutManager)new MigLayout("", "[][grow]", "[][][][]"));
        this.lblType = new JLabel(InvMessages.getString("IVMCEF.3"));
        panel.add((Component)this.lblType, "cell 0 0,alignx trailing");
        this.tfType = new POSTextField();
        panel.add((Component)this.tfType, "cell 1 0,growx");
        this.lblName = new JLabel(InvMessages.getString("IVIS.2"));
        panel.add((Component)this.lblName, "cell 0 1,alignx trailing");
        this.tfName = new POSTextField();
        panel.add((Component)this.tfName, "cell 1 1,growx");
        this.lblNo = new JLabel(InvMessages.getString("IVMCEF.9"));
        panel.add((Component)this.lblNo, "cell 0 2,alignx trailing");
        this.tfNo = new IntegerTextField();
        panel.add((Component)this.tfNo, "cell 1 2,growx");
        this.lblDescription = new JLabel(InvMessages.getString("IVMCEF.12"));
        panel.add((Component)this.lblDescription, "cell 0 3,alignx trailing");
        this.tfDescription = new POSTextField();
        panel.add((Component)this.tfDescription, "cell 1 3,growx");
    }

    @Override
    public void updateView() {
        InventoryMetaCode model = (InventoryMetaCode)this.getBean();
        if (model == null) {
            return;
        }
        this.tfType.setText(model.getType());
        this.tfName.setText(model.getCodeText());
        this.tfNo.setText("" + model.getCodeNo());
        this.tfDescription.setText(model.getDescription());
    }

    @Override
    public boolean updateModel() {
        InventoryMetaCode model = (InventoryMetaCode)this.getBean();
        if (model == null) {
            model = new InventoryMetaCode();
        }
        model.setType(this.tfType.getText());
        model.setCodeText(this.tfName.getText());
        model.setCodeNo(this.tfNo.getInteger());
        model.setDescription(this.tfDescription.getText());
        return true;
    }

    @Override
    public String getDisplayText() {
        return InvMessages.getString("IVMCEF.16");
    }

    @Override
    public boolean save() {
        try {
            if (!this.updateModel()) {
                return false;
            }
            InventoryMetaCode model = (InventoryMetaCode)this.getBean();
            InventoryMetaCodeDAO.getInstance().saveOrUpdate(model);
            return true;
        }
        catch (Exception e) {
            POSMessageDialog.showError(e.getMessage());
            return false;
        }
    }
}

