/*
 * Decompiled with CFR 0.152.
 */
package com.orostock.inventory.ui;

import com.floreantpos.POSConstants;
import com.floreantpos.PosException;
import com.floreantpos.bo.ui.BOMessageDialog;
import com.floreantpos.bo.ui.explorer.ExplorerButtonPanel;
import com.floreantpos.model.InventoryLocation;
import com.floreantpos.model.InventoryTransaction;
import com.floreantpos.model.InventoryTransactionType;
import com.floreantpos.model.dao.InventoryLocationDAO;
import com.floreantpos.model.dao.InventoryTransactionDAO;
import com.floreantpos.model.util.DateUtil;
import com.floreantpos.swing.BeanTableModel;
import com.floreantpos.swing.PosTable;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.TransparentPanel;
import com.floreantpos.ui.dialog.BeanEditorDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.inv.InventoryStockInForm;
import com.floreantpos.ui.inv.InventoryTransactionEntryForm;
import com.floreantpos.ui.util.UiUtil;
import com.floreantpos.util.POSUtil;
import com.orostock.inventory.InvMessages;
import com.orostock.inventory.action.InventoryClosingBalanceAction;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.table.TableColumnModel;
import net.miginfocom.swing.MigLayout;
import org.jdesktop.swingx.JXDatePicker;
import org.jdesktop.swingx.JXTable;

public class InventoryTransactionsBrowser
extends TransparentPanel {
    private static final long serialVersionUID = 1L;
    private JXTable table;
    private BeanTableModel<InventoryTransaction> tableModel;
    private JTextField tfName;
    private JComboBox cbLocation;
    private JButton btnBack;
    private JButton btnForward;
    private JLabel lblNumberOfItem;
    private JXDatePicker fromDatePicker;
    private JXDatePicker toDatePicker;
    private Date fromDate;
    private Date toDate;

    public InventoryTransactionsBrowser() {
        this.init();
        this.searchItem();
    }

    public void init() {
        this.tableModel = new BeanTableModel(InventoryTransaction.class, 20);
        this.tableModel.addColumn(InvMessages.getString("InventoryTransactionsBrowser.0"), InventoryTransaction.PROP_ID);
        this.tableModel.addColumn(InvMessages.getString("InventoryTransactionsBrowser.1"), InventoryTransaction.PROP_MENU_ITEM);
        this.tableModel.addColumn(InvMessages.getString("InventoryTransactionsBrowser.2"), "transactionType");
        this.tableModel.addColumn(InvMessages.getString("InventoryTransactionsBrowser.4"), "fromInventoryLocation");
        this.tableModel.addColumn(InvMessages.getString("InventoryTransactionsBrowser.5"), "toInventoryLocation");
        this.tableModel.addColumn(InvMessages.getString("InventoryTransactionsBrowser.6"), "transactionDateAsString");
        this.tableModel.addColumn(InvMessages.getString("Inventory.TB.3"), InventoryTransaction.PROP_UNIT_PRICE, 11, BeanTableModel.DataType.MONEY);
        this.tableModel.addColumn(InvMessages.getString("Inventory.TB.7"), InventoryTransaction.PROP_UNIT_COST, 11, BeanTableModel.DataType.MONEY);
        this.tableModel.addColumn(InvMessages.getString("Inventory.TB.8"), InventoryTransaction.PROP_QUANTITY, 11, BeanTableModel.DataType.NUMBER);
        this.tableModel.addColumn(InvMessages.getString("Inventory.TB.9"), InventoryTransaction.PROP_UNIT);
        this.tableModel.addColumn(POSConstants.TOTAL.toUpperCase(), InventoryTransaction.PROP_TOTAL, 11, BeanTableModel.DataType.MONEY);
        this.tableModel.addColumn(InvMessages.getString("Inventory.TB.10"), InventoryTransaction.PROP_REASON);
        this.btnBack = new JButton(InvMessages.getString("IVIE.30"));
        this.btnForward = new JButton(InvMessages.getString("IVIE.31"));
        this.lblNumberOfItem = new JLabel();
        this.table = new PosTable(this.tableModel);
        this.setLayout(new BorderLayout(5, 5));
        this.add(new JScrollPane((Component)this.table));
        this.add((Component)this.createButtonPanel(), "South");
        this.add((Component)this.buildSearchForm(), "North");
        this.resizeColumnWidth((JTable)this.table);
        this.btnBack.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                InventoryTransactionsBrowser.this.tableModel.setCurrentRowIndex(InventoryTransactionsBrowser.this.tableModel.getPreviousRowIndex());
                InventoryTransactionsBrowser.this.searchItem();
            }
        });
        this.btnForward.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                InventoryTransactionsBrowser.this.tableModel.setCurrentRowIndex(InventoryTransactionsBrowser.this.tableModel.getNextRowIndex());
                InventoryTransactionsBrowser.this.searchItem();
            }
        });
    }

    public void resizeColumnWidth(JTable table) {
        TableColumnModel columnModel = table.getColumnModel();
        for (int column = 0; column < table.getColumnCount(); ++column) {
            columnModel.getColumn(column).setPreferredWidth((Integer)this.getColumnWidth().get(column));
        }
    }

    private List getColumnWidth() {
        ArrayList<Integer> columnWidth = new ArrayList<Integer>();
        columnWidth.add(100);
        columnWidth.add(200);
        columnWidth.add(60);
        columnWidth.add(70);
        columnWidth.add(70);
        columnWidth.add(100);
        columnWidth.add(100);
        columnWidth.add(100);
        columnWidth.add(100);
        columnWidth.add(70);
        columnWidth.add(70);
        columnWidth.add(100);
        columnWidth.add(100);
        columnWidth.add(200);
        return columnWidth;
    }

    private JPanel createButtonPanel() {
        ExplorerButtonPanel explorerButton = new ExplorerButtonPanel();
        JButton editButton = explorerButton.getEditButton();
        JButton deleteButton = explorerButton.getDeleteButton();
        editButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                InventoryTransactionsBrowser.this.editSelectedRow();
            }
        });
        deleteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    int index = InventoryTransactionsBrowser.this.table.getSelectedRow();
                    if (index < 0) {
                        return;
                    }
                    index = InventoryTransactionsBrowser.this.table.convertRowIndexToModel(index);
                    if (POSMessageDialog.showYesNoQuestionDialog(InventoryTransactionsBrowser.this, POSConstants.CONFIRM_DELETE, POSConstants.DELETE) != 0) {
                        return;
                    }
                    InventoryTransaction item = (InventoryTransaction)InventoryTransactionsBrowser.this.tableModel.getRow(index);
                    InventoryTransactionDAO inventoryTransactionDao = new InventoryTransactionDAO();
                    inventoryTransactionDao.delete(item);
                    InventoryTransactionsBrowser.this.tableModel.removeRow(index);
                }
                catch (Throwable x) {
                    BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, x);
                }
            }
        });
        JPanel bottomPanel = new JPanel((LayoutManager)new MigLayout("fillx", "[33%][33%][33%]"));
        TransparentPanel actionButtonPanel = new TransparentPanel();
        JButton btnGenerateClosingBalance = new JButton(new InventoryClosingBalanceAction());
        bottomPanel.add((Component)btnGenerateClosingBalance, "skip 1,center");
        JPanel navigationPanel = new JPanel(new FlowLayout(4));
        navigationPanel.add((Component)this.lblNumberOfItem, "");
        navigationPanel.add(this.btnBack);
        navigationPanel.add(this.btnForward);
        bottomPanel.add((Component)navigationPanel, "span,right");
        return bottomPanel;
    }

    private void editSelectedRow() {
        try {
            int index = this.table.getSelectedRow();
            if (index < 0) {
                return;
            }
            index = this.table.convertRowIndexToModel(index);
            InventoryTransaction inventoryTransaction = this.tableModel.getRow(index);
            BeanEditorDialog dialog = null;
            if (inventoryTransaction.getTransactionType() == InventoryTransactionType.IN) {
                InventoryStockInForm editor = new InventoryStockInForm(inventoryTransaction);
                dialog = new BeanEditorDialog(editor);
                dialog.openWithScale(830, 630);
            } else {
                InventoryTransactionEntryForm editor = new InventoryTransactionEntryForm(inventoryTransaction);
                dialog = new BeanEditorDialog(editor);
                dialog.setPreferredSize(PosUIManager.getSize(500, 600));
                dialog.open();
            }
            if (dialog.isCanceled()) {
                return;
            }
            this.table.repaint();
        }
        catch (Throwable x) {
            BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, x);
        }
    }

    private JPanel buildSearchForm() {
        JPanel panel = new JPanel();
        panel.setLayout((LayoutManager)new MigLayout("", "[][]15[][]15[][]15[]", "[]5[]"));
        JLabel lblName = new JLabel(InvMessages.getString("IVITB.0"));
        JLabel lblGroup = new JLabel(InvMessages.getString("IVITB.5"));
        JLabel lblFromDate = new JLabel(InvMessages.getString("InventoryTransactionsBrowser.15"));
        JLabel lblToDate = new JLabel(InvMessages.getString("InventoryTransactionsBrowser.16"));
        this.fromDatePicker = UiUtil.getCurrentMonthStart();
        this.toDatePicker = UiUtil.getCurrentMonthEnd();
        this.tfName = new JTextField(15);
        try {
            this.cbLocation = new JComboBox();
            List<InventoryLocation> inventoryLocationList = InventoryLocationDAO.getInstance().findAll();
            this.cbLocation.addItem(InvMessages.getString("IVCRV.21"));
            for (InventoryLocation s : inventoryLocationList) {
                this.cbLocation.addItem(s);
            }
            JButton searchBttn = new JButton(InvMessages.getString("IVIS.22"));
            panel.add((Component)lblName, "align label");
            panel.add(this.tfName);
            panel.add(lblGroup);
            panel.add(this.cbLocation);
            panel.add(lblFromDate);
            panel.add((Component)this.fromDatePicker);
            panel.add(lblToDate);
            panel.add((Component)this.toDatePicker);
            panel.add(searchBttn);
            Border loweredetched = BorderFactory.createEtchedBorder(1);
            TitledBorder title = BorderFactory.createTitledBorder(loweredetched, InvMessages.getString("IVIS.22"));
            title.setTitleJustification(1);
            panel.setBorder(title);
            searchBttn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    InventoryTransactionsBrowser.this.searchItem();
                }
            });
            this.tfName.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    InventoryTransactionsBrowser.this.searchItem();
                }
            });
        }
        catch (Throwable x) {
            BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, x);
        }
        return panel;
    }

    private void searchItem() {
        try {
            String txName = this.tfName.getText();
            Object selectedGroup = this.cbLocation.getSelectedItem();
            this.fromDate = this.fromDatePicker.getDate();
            this.toDate = this.toDatePicker.getDate();
            DateUtil.validateDate(this.fromDate, this.toDate);
            this.fromDate = DateUtil.startOfDay(this.fromDate);
            this.toDate = DateUtil.endOfDay(this.toDate);
            InventoryTransactionDAO.getInstance().getInventoryTransactions(this.tableModel, txName, selectedGroup, this.fromDate, this.toDate);
            int startNumber = this.tableModel.getCurrentRowIndex() + 1;
            int endNumber = this.tableModel.getNextRowIndex();
            int totalNumber = this.tableModel.getNumRows();
            if (endNumber > totalNumber) {
                endNumber = totalNumber;
            }
            this.lblNumberOfItem.setText(String.format(InvMessages.getString("InventoryTransactionsBrowser.17"), startNumber, endNumber, totalNumber));
            this.btnBack.setEnabled(this.tableModel.hasPrevious());
            this.btnForward.setEnabled(this.tableModel.hasNext());
        }
        catch (PosException e) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), e.getMessage());
        }
    }
}

