/*
 * Decompiled with CFR 0.152.
 */
package com.orostock.inventory.ui;

import com.floreantpos.POSConstants;
import com.floreantpos.bo.ui.BOMessageDialog;
import com.floreantpos.bo.ui.CustomCellRenderer;
import com.floreantpos.model.InventoryStockUnit;
import com.floreantpos.model.InventoryUnit;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.dao.InventoryStockUnitDAO;
import com.floreantpos.swing.BeanTableModel;
import com.floreantpos.swing.IUpdatebleView;
import com.floreantpos.swing.PosTable;
import com.floreantpos.swing.TransparentPanel;
import com.floreantpos.ui.dialog.BeanEditorDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.POSUtil;
import com.orostock.inventory.InvMessages;
import com.orostock.inventory.ui.MenuItemPackagingUnitForm;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import net.miginfocom.swing.MigLayout;
import org.jdesktop.swingx.JXTable;

public class MenuItemPackagingUnitBrowser
extends TransparentPanel
implements IUpdatebleView<MenuItem> {
    private JXTable table;
    private BeanTableModel<InventoryStockUnit> tableModel;
    private JXTable tableRecipeUnit;
    private BeanTableModel<InventoryStockUnit> tableModelRecipeUnit;
    private MenuItem menuItem;
    private boolean inited;

    public MenuItemPackagingUnitBrowser(MenuItem menuItem) {
        this.menuItem = menuItem;
        this.tableModel = new BeanTableModel(InventoryStockUnit.class);
        this.tableModel.addColumn(InvMessages.getString("IVSMIPUB.0"), InventoryStockUnit.PROP_PACKAGING_UNIT);
        this.tableModel.addColumn(InvMessages.getString("IVSMIPUB.1"), InventoryStockUnit.PROP_CONVERSION_VALUE);
        this.tableModel.addColumn(InvMessages.getString("IVSMIPUB.2"), InventoryStockUnit.PROP_UNIT);
        this.table = new PosTable(this.tableModel);
        this.tableModelRecipeUnit = new BeanTableModel(InventoryStockUnit.class);
        this.tableModelRecipeUnit.addColumn(InvMessages.getString("IVSMIPUB.3"), InventoryStockUnit.PROP_PACKAGING_UNIT);
        this.tableModelRecipeUnit.addColumn(InvMessages.getString("IVSMIPUB.1"), InventoryStockUnit.PROP_CONVERSION_VALUE);
        this.tableModelRecipeUnit.addColumn(InvMessages.getString("IVSMIPUB.2"), InventoryStockUnit.PROP_UNIT);
        this.tableRecipeUnit = new PosTable(this.tableModelRecipeUnit);
        this.tableRecipeUnit.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    return;
                }
                MenuItemPackagingUnitBrowser.this.table.clearSelection();
            }
        });
        this.table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    return;
                }
                MenuItemPackagingUnitBrowser.this.tableRecipeUnit.clearSelection();
            }
        });
        this.table.getColumnModel().getColumn(1).setCellRenderer(new CustomCellRenderer());
        this.tableRecipeUnit.getColumnModel().getColumn(1).setCellRenderer(new CustomCellRenderer());
        this.setLayout(new BorderLayout(5, 5));
        this.setBorder(new EmptyBorder(20, 20, 20, 20));
        JPanel contentPanel = new JPanel((LayoutManager)new MigLayout("fill,wrap 1", "", "[50%][][50%][]"));
        contentPanel.add((Component)new JScrollPane((Component)this.table), "grow,span");
        contentPanel.add(this.createPackagingUnitButtonPanel());
        contentPanel.add((Component)new JScrollPane((Component)this.tableRecipeUnit), "grow,span");
        contentPanel.add(this.createRecipeUnitButtonPanel());
        this.add(contentPanel);
    }

    private TransparentPanel createPackagingUnitButtonPanel() {
        JButton addButton = new JButton(InvMessages.getString("IVSMIPUB.11"));
        addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    if (MenuItemPackagingUnitBrowser.this.menuItem.getUnit() == null) {
                        POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), InvMessages.getString("IVSMIPUB.12"));
                        return;
                    }
                    MenuItemPackagingUnitForm editor = new MenuItemPackagingUnitForm(new InventoryStockUnit(), MenuItemPackagingUnitBrowser.this.menuItem);
                    BeanEditorDialog dialog = new BeanEditorDialog(editor);
                    dialog.open();
                    if (dialog.isCanceled()) {
                        return;
                    }
                    InventoryStockUnit stockUnit = (InventoryStockUnit)editor.getBean();
                    MenuItemPackagingUnitBrowser.this.tableModel.addRow(stockUnit);
                }
                catch (Exception x) {
                    BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, x);
                }
            }
        });
        JButton editButton = new JButton(POSConstants.EDIT);
        editButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MenuItemPackagingUnitBrowser.this.editPackagingUnitRow();
            }
        });
        JButton deleteButton = new JButton(POSConstants.DELETE);
        deleteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    int index = MenuItemPackagingUnitBrowser.this.table.getSelectedRow();
                    if (index < 0) {
                        return;
                    }
                    index = MenuItemPackagingUnitBrowser.this.table.convertRowIndexToModel(index);
                    InventoryStockUnit stockUnit = (InventoryStockUnit)MenuItemPackagingUnitBrowser.this.tableModel.getRow(index);
                    if (POSMessageDialog.showYesNoQuestionDialog(POSUtil.getFocusedWindow(), POSConstants.CONFIRM_DELETE, POSConstants.DELETE) != 0) {
                        return;
                    }
                    InventoryStockUnitDAO dao = new InventoryStockUnitDAO();
                    dao.delete(stockUnit);
                    MenuItemPackagingUnitBrowser.this.tableModel.removeRow(index);
                }
                catch (Exception x) {
                    BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, x);
                }
            }
        });
        TransparentPanel panel = new TransparentPanel();
        panel.add(addButton);
        panel.add(editButton);
        panel.add(deleteButton);
        return panel;
    }

    private TransparentPanel createRecipeUnitButtonPanel() {
        JButton addButton = new JButton(InvMessages.getString("IVSMIPUB.13"));
        addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    if (MenuItemPackagingUnitBrowser.this.menuItem.getUnit() == null) {
                        POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), InvMessages.getString("IVSMIPUB.12"));
                        return;
                    }
                    MenuItemPackagingUnitForm editor = new MenuItemPackagingUnitForm(new InventoryStockUnit(), MenuItemPackagingUnitBrowser.this.menuItem, true);
                    BeanEditorDialog dialog = new BeanEditorDialog(editor);
                    dialog.open();
                    if (dialog.isCanceled()) {
                        return;
                    }
                    InventoryStockUnit stockUnit = (InventoryStockUnit)editor.getBean();
                    stockUnit.setRecipeUnit(true);
                    MenuItemPackagingUnitBrowser.this.tableModelRecipeUnit.addRow(stockUnit);
                }
                catch (Exception x) {
                    BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, x);
                }
            }
        });
        JButton editButton = new JButton(POSConstants.EDIT);
        editButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MenuItemPackagingUnitBrowser.this.editRecipeUnitRow();
            }
        });
        JButton deleteButton = new JButton(POSConstants.DELETE);
        deleteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    int index = MenuItemPackagingUnitBrowser.this.tableRecipeUnit.getSelectedRow();
                    if (index < 0) {
                        return;
                    }
                    index = MenuItemPackagingUnitBrowser.this.tableRecipeUnit.convertRowIndexToModel(index);
                    InventoryStockUnit stockUnit = (InventoryStockUnit)MenuItemPackagingUnitBrowser.this.tableModelRecipeUnit.getRow(index);
                    if (POSMessageDialog.showYesNoQuestionDialog(POSUtil.getFocusedWindow(), POSConstants.CONFIRM_DELETE, POSConstants.DELETE) != 0) {
                        return;
                    }
                    InventoryStockUnitDAO dao = new InventoryStockUnitDAO();
                    dao.delete(stockUnit);
                    MenuItemPackagingUnitBrowser.this.tableModelRecipeUnit.removeRow(index);
                }
                catch (Exception x) {
                    BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, x);
                }
            }
        });
        TransparentPanel panel = new TransparentPanel();
        panel.add(addButton);
        panel.add(editButton);
        panel.add(deleteButton);
        return panel;
    }

    public void editPackagingUnitRow() {
        try {
            int index = this.table.getSelectedRow();
            if (index < 0) {
                return;
            }
            index = this.table.convertRowIndexToModel(index);
            InventoryStockUnit stockUnit = this.tableModel.getRow(index);
            MenuItemPackagingUnitForm editor = new MenuItemPackagingUnitForm(stockUnit, this.menuItem);
            BeanEditorDialog dialog = new BeanEditorDialog(editor);
            dialog.open();
            if (dialog.isCanceled()) {
                return;
            }
            this.table.repaint();
        }
        catch (Throwable x) {
            BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, x);
        }
    }

    public void editRecipeUnitRow() {
        try {
            int index = this.tableRecipeUnit.getSelectedRow();
            if (index < 0) {
                return;
            }
            index = this.tableRecipeUnit.convertRowIndexToModel(index);
            InventoryStockUnit stockUnit = this.tableModelRecipeUnit.getRow(index);
            MenuItemPackagingUnitForm editor = new MenuItemPackagingUnitForm(stockUnit, this.menuItem, true);
            BeanEditorDialog dialog = new BeanEditorDialog(editor);
            dialog.open();
            if (dialog.isCanceled()) {
                return;
            }
            this.tableRecipeUnit.repaint();
        }
        catch (Throwable x) {
            BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, x);
        }
    }

    public void refreshTable() {
        if (this.menuItem == null) {
            return;
        }
        ArrayList<InventoryStockUnit> packagingUnits = new ArrayList<InventoryStockUnit>();
        ArrayList<InventoryStockUnit> recipeUnits = new ArrayList<InventoryStockUnit>();
        List<InventoryStockUnit> units = this.menuItem.getStockUnits();
        if (units != null) {
            for (InventoryStockUnit inventoryStockUnit : units) {
                if (inventoryStockUnit.isRecipeUnit().booleanValue()) {
                    recipeUnits.add(inventoryStockUnit);
                    continue;
                }
                packagingUnits.add(inventoryStockUnit);
            }
            this.tableModel.addRows(packagingUnits);
            this.tableModelRecipeUnit.addRows(recipeUnits);
        }
    }

    @Override
    public void initView(MenuItem e) {
        if (this.inited) {
            return;
        }
        this.menuItem = e;
        this.refreshTable();
        this.inited = true;
    }

    @Override
    public boolean updateModel(MenuItem e) {
        InventoryUnit unit;
        ArrayList<InventoryStockUnit> rows = new ArrayList<InventoryStockUnit>();
        List<InventoryStockUnit> rowsPackagingUnits = this.tableModel.getRows();
        List<InventoryStockUnit> rowsRecipeUnits = this.tableModelRecipeUnit.getRows();
        if (rowsPackagingUnits != null) {
            rows.addAll(rowsPackagingUnits);
        }
        if (rowsRecipeUnits != null) {
            rows.addAll(rowsRecipeUnits);
        }
        if ((unit = e.getUnit()) != null && unit.getUnitGroup() != null) {
            List<InventoryUnit> groupUnits = unit.getUnitGroup().getUnits();
            for (InventoryStockUnit stockUnit : rows) {
                if (!groupUnits.contains(stockUnit.getUnit())) {
                    stockUnit.setUnit(unit);
                    stockUnit.calculateBaseUnitValue();
                }
                stockUnit.setMenuItemId(e.getId());
            }
        }
        e.setStockUnits(rows);
        return true;
    }
}

