/*
 * Decompiled with CFR 0.152.
 */
package com.orostock.inventory.ui;

import com.floreantpos.POSConstants;
import com.floreantpos.PosLog;
import com.floreantpos.bo.ui.BOMessageDialog;
import com.floreantpos.model.InventoryVendor;
import com.floreantpos.model.LabelItem;
import com.floreantpos.model.Printer;
import com.floreantpos.model.PurchaseOrder;
import com.floreantpos.model.PurchaseOrderItem;
import com.floreantpos.model.dao.InventoryVendorDAO;
import com.floreantpos.model.dao.PurchaseOrderDAO;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.model.util.DateUtil;
import com.floreantpos.report.ReceiptPrintService;
import com.floreantpos.swing.BeanTableModel;
import com.floreantpos.swing.ButtonColumn;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.PosSmallButton;
import com.floreantpos.swing.PosTable;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.TransparentPanel;
import com.floreantpos.ui.BeanEditor;
import com.floreantpos.ui.dialog.BeanEditorDialog;
import com.floreantpos.ui.dialog.ConfirmDeleteDialog;
import com.floreantpos.ui.dialog.DateSelectionDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.util.UiUtil;
import com.floreantpos.util.CurrencyUtil;
import com.floreantpos.util.POSUtil;
import com.floreantpos.versioning.VersionInfo;
import com.orostock.inventory.InvMessages;
import com.orostock.inventory.ui.PrintLabelDialog;
import com.orostock.inventory.ui.PurchaseOrderForm;
import com.orostock.inventory.ui.PurchaseOrderInfoDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.MatteBorder;
import javax.swing.border.TitledBorder;
import javax.swing.table.TableColumn;
import net.miginfocom.swing.MigLayout;
import net.sf.jasperreports.engine.JasperPrint;
import org.jdesktop.swingx.JXDatePicker;
import org.jdesktop.swingx.JXTable;

public class PurchaseOrderExplorer
extends TransparentPanel {
    private static final long serialVersionUID = 1L;
    private JXTable table;
    private BeanTableModel<PurchaseOrder> tableModel = new BeanTableModel<PurchaseOrder>(PurchaseOrder.class){
        private static final long serialVersionUID = 1L;

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == 8;
        }
    };
    private JButton editButton;
    private JButton deleteButton;
    private JComboBox<Object> cbVendors;
    private JTextField tfPONumber;
    private JCheckBox chkShowClosed;
    private JXDatePicker dpFromDate;
    private JXDatePicker dpEndDate;
    private JButton btnNewPurchaseOrder;

    public PurchaseOrderExplorer() {
        this.tableModel.addColumn(InvMessages.getString("PurchaseOrderExplorer.0"), PurchaseOrder.PROP_ORDER_ID);
        this.tableModel.addColumn(InvMessages.getString("PurchaseOrderExplorer.1"), PurchaseOrder.PROP_CREATED_DATE);
        this.tableModel.addColumn(InvMessages.getString("PurchaseOrderExplorer.2"), PurchaseOrder.PROP_VENDOR);
        this.tableModel.addColumn(InvMessages.getString("PurchaseOrderExplorer.3"), PurchaseOrder.PROP_INVENTORY_LOCATION);
        this.tableModel.addColumn(InvMessages.getString("PurchaseOrderExplorer.4") + " (" + CurrencyUtil.getCurrencySymbol() + ")", PurchaseOrder.PROP_TOTAL_AMOUNT, 11, BeanTableModel.DataType.MONEY);
        this.tableModel.addColumn(InvMessages.getString("PurchaseOrderExplorer.7"), "orderStatusDisplay");
        this.tableModel.addColumn(InvMessages.getString("PurchaseOrderExplorer.9"), PurchaseOrder.PROP_VARIFICATION_DATE);
        this.tableModel.addColumn(InvMessages.getString("PurchaseOrderExplorer.10"), PurchaseOrder.PROP_RECEIVING_DATE);
        this.tableModel.addColumn("--", "statusDisplay");
        this.table = new PosTable(this.tableModel);
        this.table.setSortable(false);
        AbstractAction action = new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    int row = Integer.parseInt(e.getActionCommand());
                    if (row < 0) {
                        return;
                    }
                    PurchaseOrder purchaseOrder = (PurchaseOrder)PurchaseOrderExplorer.this.tableModel.getRow(row);
                    if (purchaseOrder.getStatus() == 0) {
                        DateSelectionDialog dialog = new DateSelectionDialog();
                        dialog.setTitle(VersionInfo.getAppName());
                        dialog.setCaption(InvMessages.getString("PurchaseOrderExplorer.13"));
                        dialog.setSize(PosUIManager.getSize(350, 250));
                        dialog.open();
                        if (dialog.isCanceled()) {
                            return;
                        }
                        purchaseOrder.setVarificationDate(dialog.getSelectedDate());
                        purchaseOrder.setStatus(1);
                        PurchaseOrderDAO.getInstance().saveOrUpdate(purchaseOrder);
                        PurchaseOrderExplorer.this.table.repaint();
                    } else if (purchaseOrder.getStatus() == 1 || purchaseOrder.getStatus() == 5) {
                        PurchaseOrderForm purchaseOrderForm = new PurchaseOrderForm(purchaseOrder, true);
                        BeanEditorDialog dialog = new BeanEditorDialog((Frame)POSUtil.getBackOfficeWindow(), (BeanEditor)purchaseOrderForm);
                        dialog.openWithScale(830, 630);
                        if (dialog.isCanceled()) {
                            return;
                        }
                    }
                }
                catch (Exception x) {
                    BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, x);
                }
            }
        };
        ButtonColumn buttonColumn = new ButtonColumn((JTable)this.table, action, 8){
            private static final long serialVersionUID = 1L;

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                PurchaseOrder order = (PurchaseOrder)PurchaseOrderExplorer.this.tableModel.getRow(row);
                if (column == 8 && order.getStatus() != 0 && order.getStatus() != 1 && order.getStatus() != 5) {
                    return new JLabel(InvMessages.getString("PurchaseOrderExplorer.14"), 0);
                }
                return super.getTableCellRendererComponent(table, value, false, hasFocus, row, column);
            }

            @Override
            public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
                return super.getTableCellEditorComponent(table, value, false, row, column);
            }
        };
        this.setLayout(new BorderLayout(5, 5));
        this.add(new JScrollPane((Component)this.table));
        JButton btnPrint = new JButton(InvMessages.getString("PurchaseOrderExplorer.15"));
        btnPrint.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PurchaseOrderExplorer.this.doPrintBarcode();
            }
        });
        this.btnNewPurchaseOrder = new JButton(InvMessages.getString("PurchaseOrderExplorer.16"));
        this.btnNewPurchaseOrder.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PurchaseOrderExplorer.this.doCreatePurchaseOrder();
            }
        });
        this.editButton = new JButton(POSConstants.EDIT);
        this.editButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PurchaseOrderExplorer.this.doEditPurchaseOrder();
            }
        });
        this.deleteButton = new JButton(POSConstants.DELETE);
        this.deleteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PurchaseOrderExplorer.this.doDeletePurchaseOrder();
            }
        });
        MatteBorder selectedBorder = BorderFactory.createMatteBorder(2, 10, 2, 10, this.table.getBackground());
        MatteBorder unselectedBorder = BorderFactory.createMatteBorder(2, 10, 2, 10, this.table.getBackground());
        CompoundBorder border1 = new CompoundBorder(selectedBorder, this.editButton.getBorder());
        CompoundBorder border2 = new CompoundBorder(unselectedBorder, this.editButton.getBorder());
        buttonColumn.setUnselectedBorder(border1);
        buttonColumn.setFocusBorder(border2);
        JButton btnPurchaseOrderInfo = new JButton(InvMessages.getString("PurchaseOrderExplorer.17"));
        btnPurchaseOrderInfo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PurchaseOrderExplorer.this.showPurchaseOrderInfo();
            }
        });
        TransparentPanel panel = new TransparentPanel();
        panel.add(btnPrint);
        panel.add(this.btnNewPurchaseOrder);
        panel.add(this.editButton);
        panel.add(this.deleteButton);
        panel.add(btnPurchaseOrderInfo);
        this.add((Component)this.buildSearchForm(), "North");
        this.add((Component)panel, "South");
        this.resizeTableColumns();
    }

    public void print(List<LabelItem> items) throws Exception {
        try {
            List<Printer> labelPrinters = DataProvider.get().getPrinters().getLabelPrinters();
            if (labelPrinters.size() == 0) {
                POSMessageDialog.showError(POSUtil.getFocusedWindow(), InvMessages.getString("PurchaseOrderExplorer.18"));
                return;
            }
            for (Printer printer : labelPrinters) {
                JasperPrint jasperPrint = ReceiptPrintService.createPurchaseOrderItemsBarcodePrint(items);
                jasperPrint.setName("BARCODE_REPORT");
                jasperPrint.setProperty("printerName", printer.getDeviceName());
                ReceiptPrintService.printQuitely(jasperPrint);
            }
        }
        catch (Exception e) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), e.getMessage(), e);
        }
    }

    private void resizeTableColumns() {
        this.table.setAutoResizeMode(4);
        this.setColumnWidth(0, PosUIManager.getSize(100));
        this.setColumnWidth(1, PosUIManager.getSize(100));
        this.setColumnWidth(3, PosUIManager.getSize(100));
        this.setColumnWidth(4, PosUIManager.getSize(100));
        this.setColumnWidth(5, PosUIManager.getSize(120));
        this.setColumnWidth(6, PosUIManager.getSize(120));
        this.setColumnWidth(7, PosUIManager.getSize(120));
        this.setColumnWidth(8, PosUIManager.getSize(100));
    }

    private void setColumnWidth(int columnNumber, int width) {
        TableColumn column = this.table.getColumnModel().getColumn(columnNumber);
        column.setPreferredWidth(width);
        column.setMaxWidth(width);
        column.setMinWidth(width);
    }

    private JPanel buildSearchForm() {
        JPanel panel = new JPanel((LayoutManager)new MigLayout("fillx", "", ""));
        JLabel lblOrderType = new JLabel(InvMessages.getString("PurchaseOrderExplorer.5"));
        this.cbVendors = new JComboBox();
        this.cbVendors.addItem(InvMessages.getString("PurchaseOrderExplorer.6"));
        List<InventoryVendor> vendors = InventoryVendorDAO.getInstance().findAll();
        for (InventoryVendor vendor : vendors) {
            this.cbVendors.addItem(vendor);
        }
        JLabel lblName = new JLabel(InvMessages.getString("PurchaseOrderExplorer.8"));
        this.tfPONumber = new JTextField(15);
        this.dpFromDate = UiUtil.getCurrentMonthStart();
        this.dpEndDate = UiUtil.getCurrentMonthEnd();
        this.chkShowClosed = new JCheckBox(InvMessages.getString("PurchaseOrderExplorer.23"));
        this.chkShowClosed.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PurchaseOrderExplorer.this.showPurchaseOrders();
            }
        });
        try {
            JButton searchBttn = new JButton(InvMessages.getString("PurchaseOrderExplorer.11"));
            panel.add((Component)lblName, "align label,split 9");
            panel.add(this.tfPONumber);
            panel.add(lblOrderType);
            panel.add(this.cbVendors);
            panel.add(new JLabel(InvMessages.getString("PurchaseOrderExplorer.24")));
            panel.add((Component)this.dpFromDate);
            panel.add(new JLabel(InvMessages.getString("PurchaseOrderExplorer.25")));
            panel.add((Component)this.dpEndDate);
            panel.add(searchBttn);
            panel.add((Component)this.chkShowClosed, "right");
            Border loweredetched = BorderFactory.createEtchedBorder(1);
            TitledBorder title = BorderFactory.createTitledBorder(loweredetched, "");
            title.setTitleJustification(1);
            panel.setBorder(title);
            searchBttn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PurchaseOrderExplorer.this.showPurchaseOrders();
                }
            });
            this.tfPONumber.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PurchaseOrderExplorer.this.showPurchaseOrders();
                }
            });
        }
        catch (Throwable x) {
            BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, x);
        }
        return panel;
    }

    private void showPurchaseOrders() {
        String txName = this.tfPONumber.getText();
        Boolean showClosed = this.chkShowClosed.isSelected();
        InventoryVendor vendor = null;
        Object selecteditem = this.cbVendors.getSelectedItem();
        Date from = DateUtil.startOfDay(this.dpFromDate.getDate());
        Date to = DateUtil.endOfDay(this.dpEndDate.getDate());
        if (selecteditem instanceof InventoryVendor) {
            vendor = (InventoryVendor)selecteditem;
        }
        List<PurchaseOrder> purchaseOrderList = PurchaseOrderDAO.getInstance().findBy(txName, vendor, from, to, showClosed);
        this.tableModel.setRows(purchaseOrderList);
    }

    private void showPurchaseOrderInfo() {
        ArrayList<PurchaseOrder> orderList = new ArrayList<PurchaseOrder>();
        int index = this.table.getSelectedRow();
        if (index < 0) {
            return;
        }
        index = this.table.convertRowIndexToModel(index);
        PurchaseOrder purchaseOrder = this.tableModel.getRow(index);
        orderList.add(purchaseOrder);
        PurchaseOrderInfoDialog dialog = new PurchaseOrderInfoDialog(orderList);
        dialog.setSize(PosUIManager.getSize(900, 650));
        dialog.setModal(true);
        dialog.open();
        if (dialog.isCanceled()) {
            return;
        }
        this.table.repaint();
    }

    private void doCreatePurchaseOrder() {
        try {
            final PurchaseOrderForm editor = new PurchaseOrderForm();
            final BeanEditorDialog dialog = new BeanEditorDialog((Frame)POSUtil.getBackOfficeWindow(), (BeanEditor)editor);
            PosSmallButton btnSaveAndReceiveOrder = new PosSmallButton("<html><center>" + InvMessages.getString("PurchaseOrderExplorer.12") + " & " + InvMessages.getString("PurchaseOrderExplorer.20") + "</center></html>");
            btnSaveAndReceiveOrder.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (!editor.updateModel()) {
                        return;
                    }
                    DateSelectionDialog dateSelectionDialog = new DateSelectionDialog();
                    dateSelectionDialog.setTitle(VersionInfo.getAppName());
                    dateSelectionDialog.setCaption(InvMessages.getString("PurchaseOrderExplorer.19"));
                    dateSelectionDialog.setSize(PosUIManager.getSize(350, 250));
                    dateSelectionDialog.open();
                    if (dateSelectionDialog.isCanceled()) {
                        return;
                    }
                    Date receivingDate = dateSelectionDialog.getSelectedDate();
                    if (receivingDate == null) {
                        return;
                    }
                    PurchaseOrder purchaseOrder = (PurchaseOrder)editor.getBean();
                    for (PurchaseOrderItem item : purchaseOrder.getOrderItems()) {
                        item.setQuantityToReceive(item.getItemQuantity() - item.getQuantityReceived());
                    }
                    Date purchaseOrderDate = purchaseOrder.getCreatedDate() == null ? new Date() : purchaseOrder.getCreatedDate();
                    purchaseOrder.setVarificationDate(purchaseOrderDate);
                    purchaseOrder.setCreatedDate(purchaseOrderDate);
                    purchaseOrder.setReceivingDate(receivingDate);
                    purchaseOrder.setClosingDate(purchaseOrderDate);
                    editor.setReceive(true, true);
                    if (!editor.save()) {
                        return;
                    }
                    dialog.disposeWithNotCancelled();
                }
            });
            PosButton btnOk = (PosButton)dialog.getButtonPanel().getComponent(0);
            btnOk.setText(InvMessages.getString("PurchaseOrderExplorer.28"));
            dialog.getButtonPanel().add((Component)btnSaveAndReceiveOrder, 0);
            dialog.openWithScale(1124, 630);
            if (dialog.isCanceled()) {
                return;
            }
            PurchaseOrder purchaseOrder = (PurchaseOrder)editor.getBean();
            this.tableModel.addRow(purchaseOrder);
            this.doPrintPurchaseOrder(purchaseOrder);
        }
        catch (Exception x) {
            BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, x);
        }
    }

    private void doPrintPurchaseOrder(PurchaseOrder purchaseOrder) throws Exception {
        if (POSMessageDialog.showMessageAndPromtToPrint(POSUtil.getBackOfficeWindow(), InvMessages.getString("PurchaseOrderExplorer.29") + purchaseOrder.getOrderId() + InvMessages.getString("PurchaseOrderExplorer.30"))) {
            JasperPrint jasperPrint = ReceiptPrintService.createPurchaseOrderPrint(purchaseOrder);
            jasperPrint.setName("PURCHASE_ORDER_" + purchaseOrder.getOrderId());
            jasperPrint.setProperty("printerName", DataProvider.get().getPrinters().getReceiptPrinter());
            ReceiptPrintService.printQuitely(jasperPrint);
        }
    }

    public void updateView() {
        this.showPurchaseOrders();
    }

    private void doPrintBarcode() {
        try {
            int index = this.table.getSelectedRow();
            if (index < 0) {
                POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), InvMessages.getString("PurchaseOrderExplorer.32"));
                return;
            }
            index = this.table.convertRowIndexToModel(index);
            PurchaseOrder purchaseOrder = this.tableModel.getRow(index);
            List<PurchaseOrderItem> orderItems = purchaseOrder.getOrderItems();
            ArrayList<LabelItem> labelItems = new ArrayList<LabelItem>();
            for (PurchaseOrderItem purchaseOrderItem : orderItems) {
                LabelItem labelItem = new LabelItem();
                labelItem.setMenuItem(purchaseOrderItem.getMenuItem());
                if (purchaseOrder.getStatus() == 5) {
                    double quantity = purchaseOrderItem.getQuantityReceived();
                    labelItem.setPrintQuantity((int)quantity);
                } else {
                    double itemQuantity = purchaseOrderItem.getItemQuantity();
                    labelItem.setPrintQuantity((int)itemQuantity);
                }
                labelItems.add(labelItem);
            }
            PrintLabelDialog dialog = new PrintLabelDialog();
            dialog.setButtonVisibility(false);
            dialog.doAddLabelItems(labelItems);
            dialog.setSize(PosUIManager.getSize(650, 600));
            dialog.open();
        }
        catch (Exception e) {
            PosLog.error(PurchaseOrderExplorer.class, e.getMessage(), e);
        }
    }

    private void doEditPurchaseOrder() {
        try {
            int index = this.table.getSelectedRow();
            if (index < 0) {
                return;
            }
            index = this.table.convertRowIndexToModel(index);
            PurchaseOrder purchaseOrder = this.tableModel.getRow(index);
            PurchaseOrderForm purchaseOrderForm = new PurchaseOrderForm(purchaseOrder);
            BeanEditorDialog dialog = new BeanEditorDialog((Frame)POSUtil.getBackOfficeWindow(), (BeanEditor)purchaseOrderForm);
            dialog.openWithScale(1124, 630);
            if (dialog.isCanceled()) {
                return;
            }
            this.table.repaint();
        }
        catch (Throwable x) {
            BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, x);
        }
    }

    private void doDeletePurchaseOrder() {
        try {
            int index = this.table.getSelectedRow();
            if (index < 0) {
                return;
            }
            index = this.table.convertRowIndexToModel(index);
            PurchaseOrder purchaseOrder = this.tableModel.getRow(index);
            if (ConfirmDeleteDialog.showMessage(this, POSConstants.CONFIRM_DELETE, POSConstants.DELETE) == 0) {
                PurchaseOrderDAO.getInstance().delete(purchaseOrder);
                this.tableModel.removeRow(index);
            }
        }
        catch (Exception x) {
            BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, x);
        }
    }
}

