/*
 * Decompiled with CFR 0.152.
 */
package com.orostock.inventory.ui;

import com.floreantpos.POSConstants;
import com.floreantpos.PosLog;
import com.floreantpos.bo.ui.BOMessageDialog;
import com.floreantpos.mailservices.MailService;
import com.floreantpos.main.Application;
import com.floreantpos.model.PurchaseOrder;
import com.floreantpos.model.PurchaseOrderItem;
import com.floreantpos.model.dao.PurchaseOrderDAO;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.report.ReceiptPrintService;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.PosOptionPane;
import com.floreantpos.swing.PosScrollPane;
import com.floreantpos.ui.BeanEditor;
import com.floreantpos.ui.dialog.BeanEditorDialog;
import com.floreantpos.ui.dialog.POSDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.views.TicketReceiptView;
import com.floreantpos.util.POSUtil;
import com.orostock.inventory.InvMessages;
import com.orostock.inventory.ui.PurchaseOrderForm;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.export.JRPdfExporter;
import net.sf.jasperreports.engine.export.JRPdfExporterParameter;

public class PurchaseOrderInfoDialog
extends POSDialog {
    private List<PurchaseOrder> purchaseOrders;
    private JPanel reportPanel;
    private boolean reorder = false;
    private PosButton btnReOrder;
    private PosButton btnPrint;
    private JPanel reportView;
    private PosButton btnEmail;

    public PurchaseOrderInfoDialog(List<PurchaseOrder> purchaseOrders) {
        super(POSUtil.getBackOfficeWindow());
        this.setTitle(InvMessages.getString("Inventory.POD.20"));
        this.purchaseOrders = purchaseOrders;
        this.createReportView();
    }

    public void createReportView() {
        this.reportView = new JPanel(new BorderLayout());
        this.reportPanel = new JPanel((LayoutManager)new MigLayout("wrap 1, ax 50%", "", ""));
        PosScrollPane scrollPane = new PosScrollPane(this.reportPanel);
        scrollPane.getVerticalScrollBar().setUnitIncrement(20);
        try {
            this.createReport();
        }
        catch (Exception e1) {
            PosLog.error(PurchaseOrderInfoDialog.class, e1.getMessage(), e1);
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), InvMessages.getString("Inventory.POD.0"));
        }
        this.setLayout(new BorderLayout());
        this.reportView.add(scrollPane);
        this.add(this.reportView);
        JPanel panel = new JPanel();
        this.getContentPane().add((Component)panel, "South");
        this.btnReOrder = new PosButton(InvMessages.getString("Inventory.POD.1"));
        this.btnReOrder.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                block0: {
                    PurchaseOrderInfoDialog.this.setCanceled(true);
                    PurchaseOrderInfoDialog.this.dispose();
                    Iterator iter = PurchaseOrderInfoDialog.this.purchaseOrders.iterator();
                    if (!iter.hasNext()) break block0;
                    PurchaseOrder purchaseOrder = (PurchaseOrder)iter.next();
                    PurchaseOrderInfoDialog.this.createReOrder(purchaseOrder);
                }
            }
        });
        panel.add(this.btnReOrder);
        this.btnEmail = new PosButton(InvMessages.getString("Inventory.POD.2"));
        this.btnEmail.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    PurchaseOrderInfoDialog.this.sendOrders();
                }
                catch (Exception e1) {
                    POSMessageDialog.showError(POSUtil.getFocusedWindow(), InvMessages.getString("Inventory.POD.3"));
                }
            }
        });
        panel.add(this.btnEmail);
        this.btnPrint = new PosButton(InvMessages.getString("Inventory.POD.4"));
        this.btnPrint.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    PurchaseOrderInfoDialog.this.print();
                }
                catch (Exception e1) {
                    BOMessageDialog.showError(e1);
                }
            }
        });
        panel.add(this.btnPrint);
        PosButton btnClose = new PosButton();
        btnClose.setText(InvMessages.getString("PurchaseOrderInfoDialog.0"));
        btnClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PurchaseOrderInfoDialog.this.dispose();
            }
        });
        panel.add(btnClose);
    }

    private void sendOrders() throws Exception {
        for (PurchaseOrder purchaseOrder : this.purchaseOrders) {
            JasperPrint jasperPrint = ReceiptPrintService.createPurchaseOrderPrint(purchaseOrder);
            jasperPrint.setName("PURCHASE_ORDER_" + purchaseOrder.getOrderId());
            jasperPrint.setProperty("printerName", DataProvider.get().getPrinters().getReceiptPrinter());
            this.doEmail(jasperPrint, purchaseOrder);
        }
    }

    public void doEmail(JasperPrint report, PurchaseOrder purchaseOrder) {
        String EMAIL_PATTERN = "^[_A-Za-z0-9-\\+]+(\\.[_A-Za-z0-9-]+)*@[A-Za-z0-9-]+(\\.[A-Za-z0-9]+)*(\\.[A-Za-z]{2,})$";
        String email = PosOptionPane.showInputDialog(InvMessages.getString("Inventory.POD.33"), purchaseOrder.getVendor().getEmail());
        if (email == null) {
            return;
        }
        Pattern pattern = Pattern.compile(EMAIL_PATTERN);
        Matcher matcher = pattern.matcher(email);
        if (matcher.matches()) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            JRPdfExporter exporter = new JRPdfExporter();
            exporter.setParameter(JRPdfExporterParameter.JASPER_PRINT, (Object)report);
            exporter.setParameter(JRPdfExporterParameter.OUTPUT_STREAM, (Object)byteArrayOutputStream);
            try {
                exporter.exportReport();
            }
            catch (JRException e) {
                PosLog.error(this.getClass(), (Exception)((Object)e));
            }
            byte[] bytes = byteArrayOutputStream.toByteArray();
            String fileName = "PurchaseOrder_" + purchaseOrder.getOrderId() + ".pdf";
            MailService.sendMail(email, InvMessages.getString("Inventory.POD.34"), InvMessages.getString("Inventory.POD.34"), fileName, fileName, bytes);
            POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), InvMessages.getString("Inventory.POD.36"));
        } else {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), InvMessages.getString("Inventory.POD.37"));
            this.doEmail(report, purchaseOrder);
        }
    }

    public void createReport() throws Exception {
        for (int i = 0; i < this.purchaseOrders.size(); ++i) {
            PurchaseOrder purchaseOrder = this.purchaseOrders.get(i);
            JasperPrint jasperPrint = ReceiptPrintService.createPurchaseOrderPrint(purchaseOrder);
            TicketReceiptView receiptView = new TicketReceiptView(jasperPrint);
            this.reportPanel.add(receiptView.getReportPanel());
        }
    }

    public void print() throws Exception {
        for (PurchaseOrder purchaseOrder : this.purchaseOrders) {
            JasperPrint jasperPrint = ReceiptPrintService.createPurchaseOrderPrint(purchaseOrder);
            jasperPrint.setName("PURCHASE_ORDER_" + purchaseOrder.getOrderId());
            jasperPrint.setProperty("printerName", DataProvider.get().getPrinters().getReceiptPrinter());
            ReceiptPrintService.printQuitely(jasperPrint);
        }
    }

    public List<PurchaseOrder> getPurchaseOrders() {
        return this.purchaseOrders;
    }

    public JPanel getReportPanel() {
        return this.reportPanel;
    }

    private void createReOrder(PurchaseOrder purchaseOrder) {
        PurchaseOrder pOrder = new PurchaseOrder();
        pOrder.setProperties(purchaseOrder.getProperties());
        pOrder.setTerminal(Application.getInstance().getTerminal());
        Calendar currentTime = Calendar.getInstance();
        pOrder.setCreatedDate(currentTime.getTime());
        ArrayList newPurchaseOrderItems = new ArrayList();
        for (PurchaseOrderItem oldPurchaseOrderItem : purchaseOrder.getOrderItems()) {
            PurchaseOrderItem newPurchaseOrderItem = new PurchaseOrderItem();
            newPurchaseOrderItem.setItemQuantity(oldPurchaseOrderItem.getItemQuantity());
            newPurchaseOrderItem.setMenuItemId(oldPurchaseOrderItem.getMenuItemId());
            newPurchaseOrderItem.setName(oldPurchaseOrderItem.getName());
            newPurchaseOrderItem.setGroupName(oldPurchaseOrderItem.getGroupName());
            newPurchaseOrderItem.setCategoryName(oldPurchaseOrderItem.getCategoryName());
            newPurchaseOrderItem.setUnitPrice(oldPurchaseOrderItem.getUnitPrice());
            newPurchaseOrderItem.setItemUnitName(oldPurchaseOrderItem.getItemUnitName());
            newPurchaseOrderItem.setTaxRate(oldPurchaseOrderItem.getTaxRate());
            newPurchaseOrderItem.setBeverage(oldPurchaseOrderItem.isBeverage());
            newPurchaseOrderItem.setPurchaseOrder(pOrder);
            pOrder.addToorderItems(newPurchaseOrderItem);
        }
        this.doCreatePurchaseOrder(pOrder);
        this.reorder = true;
    }

    private void doCreatePurchaseOrder(PurchaseOrder pOrder) {
        try {
            final PurchaseOrderForm editor = new PurchaseOrderForm(pOrder);
            final BeanEditorDialog dialog = new BeanEditorDialog((Frame)POSUtil.getBackOfficeWindow(), (BeanEditor)editor);
            PosButton btnSaveAndReceiveOrder = new PosButton("<html><center>" + InvMessages.getString("Inventory.POD.5") + "&<br>" + InvMessages.getString("Inventory.POD.8") + "</center></html>");
            btnSaveAndReceiveOrder.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (!editor.updateModel()) {
                        return;
                    }
                    PurchaseOrder purchaseOrder = (PurchaseOrder)editor.getBean();
                    for (PurchaseOrderItem item : purchaseOrder.getOrderItems()) {
                        item.setQuantityToReceive(item.getItemQuantity() - item.getQuantityReceived());
                    }
                    PurchaseOrderDAO.getInstance().saveOrUpdate(purchaseOrder, true);
                    dialog.dispose();
                }
            });
            PosButton btnOk = (PosButton)dialog.getButtonPanel().getComponent(0);
            btnOk.setText(InvMessages.getString("Inventory.POD.9"));
            dialog.getButtonPanel().add((Component)btnSaveAndReceiveOrder, 0);
            dialog.openWithScale(830, 630);
            if (dialog.isCanceled()) {
                return;
            }
            PurchaseOrder purchaseOrder = (PurchaseOrder)editor.getBean();
            this.purchaseOrders.add(purchaseOrder);
            this.showMessage(purchaseOrder);
        }
        catch (Exception x) {
            BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, x);
        }
    }

    private void showMessage(PurchaseOrder purchaseOrder) throws Exception {
        if (POSMessageDialog.showMessageAndPromtToPrint(POSUtil.getBackOfficeWindow(), InvMessages.getString("Inventory.POD.10") + purchaseOrder.getOrderId() + InvMessages.getString("Inventory.POD.11"))) {
            JasperPrint jasperPrint = ReceiptPrintService.createPurchaseOrderPrint(purchaseOrder);
            jasperPrint.setName("PURCHASE_ORDER_" + purchaseOrder.getOrderId());
            jasperPrint.setProperty("printerName", DataProvider.get().getPrinters().getReceiptPrinter());
            ReceiptPrintService.printQuitely(jasperPrint);
        }
    }

    public boolean isReorder() {
        return this.reorder;
    }
}

