/*
 * Decompiled with CFR 0.152.
 */
package com.orostock.inventory.ui;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.bo.ui.BOMessageDialog;
import com.floreantpos.config.AppProperties;
import com.floreantpos.main.Application;
import com.floreantpos.model.StockCount;
import com.floreantpos.model.dao.StockCountDAO;
import com.floreantpos.model.util.DateUtil;
import com.floreantpos.swing.BeanTableModel;
import com.floreantpos.swing.ButtonColumn;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.PosTable;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.TransparentPanel;
import com.floreantpos.ui.BeanEditor;
import com.floreantpos.ui.dialog.BeanEditorDialog;
import com.floreantpos.ui.dialog.ConfirmDeleteDialog;
import com.floreantpos.ui.dialog.DateSelectionDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.util.UiUtil;
import com.floreantpos.util.POSUtil;
import com.orostock.inventory.InvMessages;
import com.orostock.inventory.ui.StockCountForm;
import com.orostock.inventory.ui.StockCountReport;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Date;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.MatteBorder;
import javax.swing.border.TitledBorder;
import javax.swing.table.TableColumn;
import net.miginfocom.swing.MigLayout;
import org.jdesktop.swingx.JXDatePicker;
import org.jdesktop.swingx.JXTable;

public class StockCountExplorer
extends TransparentPanel {
    private JXTable table;
    private BeanTableModel<StockCount> tableModel = new BeanTableModel<StockCount>(StockCount.class){

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == 7;
        }
    };
    private JButton editButton;
    private JButton deleteButton;
    private JTextField tfRefNumber;
    private JCheckBox chkShowClosed;
    private JXDatePicker dpFromDate;
    private JXDatePicker dpEndDate;

    public StockCountExplorer() {
        this.tableModel.addColumn("SL NO", StockCount.PROP_REF_NUMBER);
        this.tableModel.addColumn("Count Date", StockCount.PROP_CREATED_DATE);
        this.tableModel.addColumn("Count By", StockCount.PROP_USER);
        this.tableModel.addColumn("Post Date", StockCount.PROP_POST_DATE);
        this.tableModel.addColumn("Verify Date", StockCount.PROP_VARIFICATION_DATE);
        this.tableModel.addColumn("Verified By", StockCount.PROP_VERIFIED_BY);
        this.tableModel.addColumn("Last Modified Date", StockCount.PROP_LAST_MODIFIED_DATE);
        this.tableModel.addColumn("--", "checkVerification");
        this.table = new PosTable(this.tableModel);
        this.table.setSortable(false);
        AbstractAction action = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    int row = Integer.parseInt(e.getActionCommand());
                    if (row < 0) {
                        return;
                    }
                    StockCount stockCount = (StockCount)StockCountExplorer.this.tableModel.getRow(row);
                    DateSelectionDialog dialog = new DateSelectionDialog(new Date(), stockCount.getCreatedDate(), (boolean)Boolean.TRUE);
                    dialog.setTitle(AppProperties.getAppName());
                    dialog.setCaption(InvMessages.getString("IVSCE.8"));
                    dialog.setPostDateVisible(true);
                    dialog.setLblSelectDateCaption(Messages.getString("StockCountExplorer.3"));
                    dialog.setSize(PosUIManager.getSize(350, 300));
                    dialog.open();
                    if (dialog.isCanceled()) {
                        return;
                    }
                    stockCount.setVarificationDate(dialog.getSelectedDate());
                    stockCount.setVerifiedBy(Application.getCurrentUser());
                    stockCount.setLastModifiedDate(new Date());
                    stockCount.setPostDate(dialog.getPostDate());
                    StockCountDAO.getInstance().saveOrUpdate(stockCount, true);
                }
                catch (Exception x) {
                    BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, x);
                }
            }
        };
        ButtonColumn buttonColumn = new ButtonColumn((JTable)this.table, action, 7){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                StockCount order = (StockCount)StockCountExplorer.this.tableModel.getRow(row);
                if (order.getVerifiedBy() != null) {
                    return new JLabel(InvMessages.getString("IVSCE.9"));
                }
                return super.getTableCellRendererComponent(table, value, false, hasFocus, row, column);
            }

            @Override
            public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
                return super.getTableCellEditorComponent(table, value, false, row, column);
            }
        };
        this.setLayout(new BorderLayout(5, 5));
        this.add(new JScrollPane((Component)this.table));
        JButton addButton = new JButton(InvMessages.getString("IVSCE.10"));
        this.editButton = new JButton(POSConstants.EDIT);
        this.deleteButton = new JButton(POSConstants.DELETE);
        addButton.addActionListener(e -> this.doCreateStockCount());
        this.editButton.addActionListener(e -> this.doEditStockCount());
        this.deleteButton.addActionListener(e -> this.doDeleteStockCount());
        MatteBorder selectedBorder = BorderFactory.createMatteBorder(2, 10, 2, 10, this.table.getBackground());
        MatteBorder unselectedBorder = BorderFactory.createMatteBorder(2, 10, 2, 10, this.table.getBackground());
        CompoundBorder border1 = new CompoundBorder(selectedBorder, this.editButton.getBorder());
        CompoundBorder border2 = new CompoundBorder(unselectedBorder, this.editButton.getBorder());
        buttonColumn.setUnselectedBorder(border1);
        buttonColumn.setFocusBorder(border2);
        JButton btnStockCountInfo = new JButton(InvMessages.getString("IVSCE.12"));
        btnStockCountInfo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StockCountExplorer.this.showStockCountInfo();
            }
        });
        TransparentPanel panel = new TransparentPanel();
        panel.add(addButton);
        panel.add(this.editButton);
        panel.add(this.deleteButton);
        panel.add(btnStockCountInfo);
        this.add((Component)this.buildSearchForm(), "North");
        this.add((Component)panel, "South");
        this.resizeTableColumns();
    }

    private void resizeTableColumns() {
        this.table.setAutoResizeMode(4);
        this.setColumnWidth(0, PosUIManager.getSize(100));
        this.setColumnWidth(1, PosUIManager.getSize(100));
        this.setColumnWidth(3, PosUIManager.getSize(100));
        this.setColumnWidth(4, PosUIManager.getSize(100));
        this.setColumnWidth(5, PosUIManager.getSize(120));
        this.setColumnWidth(6, PosUIManager.getSize(120));
        this.setColumnWidth(7, PosUIManager.getSize(120));
    }

    private void setColumnWidth(int columnNumber, int width) {
        TableColumn column = this.table.getColumnModel().getColumn(columnNumber);
        column.setPreferredWidth(width);
        column.setMaxWidth(width);
        column.setMinWidth(width);
    }

    private JPanel buildSearchForm() {
        JPanel panel = new JPanel((LayoutManager)new MigLayout("fillx", "", ""));
        JLabel lblName = new JLabel(InvMessages.getString("IVSCE.16"));
        this.tfRefNumber = new JTextField(15);
        this.dpFromDate = UiUtil.getCurrentMonthStart();
        this.dpEndDate = UiUtil.getCurrentMonthEnd();
        this.chkShowClosed = new JCheckBox(InvMessages.getString("IVSCE.17"));
        this.chkShowClosed.addActionListener(e -> this.showStockCounts());
        try {
            JButton searchBttn = new JButton(InvMessages.getString("IVIS.22"));
            panel.add((Component)lblName, "align label,split 7");
            panel.add(this.tfRefNumber);
            panel.add(new JLabel(InvMessages.getString("IVSCE.20")));
            panel.add((Component)this.dpFromDate);
            panel.add(new JLabel(InvMessages.getString("IVSCE.21")));
            panel.add((Component)this.dpEndDate);
            panel.add(searchBttn);
            panel.add((Component)this.chkShowClosed, "right");
            Border loweredetched = BorderFactory.createEtchedBorder(1);
            TitledBorder title = BorderFactory.createTitledBorder(loweredetched, InvMessages.getString("IVIS.22"));
            title.setTitleJustification(1);
            panel.setBorder(title);
            searchBttn.addActionListener(e -> this.showStockCounts());
            this.tfRefNumber.addActionListener(e -> this.showStockCounts());
        }
        catch (Throwable x) {
            BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, x);
        }
        return panel;
    }

    private void showStockCounts() {
        String txtRefId = this.tfRefNumber.getText();
        Boolean showVerified = this.chkShowClosed.isSelected();
        Object vendor = null;
        Date from = DateUtil.startOfDay(this.dpFromDate.getDate());
        Date to = DateUtil.endOfDay(this.dpEndDate.getDate());
        List stockCountList = StockCountDAO.getInstance().findBy(txtRefId, from, to, showVerified);
        this.tableModel.setRows(stockCountList);
    }

    private void showStockCountInfo() {
        if (this.table.getRowCount() == 0) {
            String message = InvMessages.getString("StockCountExplorer.4");
            POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), message);
            return;
        }
        int index = this.table.getSelectedRow();
        if (index < 0) {
            String message = InvMessages.getString("StockCountExplorer.1");
            POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), message);
            return;
        }
        StockCount stockCount = this.tableModel.getRow(index);
        StockCountReport report = new StockCountReport(stockCount);
        try {
            report.showReport();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.table.repaint();
    }

    private void doCreateStockCount() {
        try {
            StockCountForm editor = new StockCountForm();
            BeanEditorDialog dialog = new BeanEditorDialog((Frame)POSUtil.getBackOfficeWindow(), (BeanEditor)editor);
            PosButton btnOk = (PosButton)dialog.getButtonPanel().getComponent(0);
            btnOk.setText(InvMessages.getString("IVSCE.24"));
            dialog.openFullScreen();
            if (dialog.isCanceled()) {
                return;
            }
            StockCount stockCount = (StockCount)editor.getBean();
            this.tableModel.addRow(stockCount);
            this.doPrintStockCount(stockCount);
        }
        catch (Exception x) {
            BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, x);
        }
    }

    private void doEditStockCount() {
        try {
            if (this.table.getRowCount() == 0) {
                String message = InvMessages.getString("StockCountExplorer.0");
                POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), message);
                return;
            }
            int index = this.table.getSelectedRow();
            if (index < 0) {
                String message = InvMessages.getString("StockCountExplorer.1");
                POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), message);
                return;
            }
            StockCount stockCount = this.tableModel.getRow(index = this.table.convertRowIndexToModel(index));
            if (stockCount.getVerifiedBy() != null) {
                POSMessageDialog.showError(POSUtil.getBackOfficeWindow(), InvMessages.getString("IVSCE.11"));
                return;
            }
            StockCountForm stockCountForm = new StockCountForm(stockCount);
            BeanEditorDialog dialog = new BeanEditorDialog((Frame)POSUtil.getBackOfficeWindow(), (BeanEditor)stockCountForm);
            dialog.openFullScreen();
            if (dialog.isCanceled()) {
                return;
            }
            this.table.repaint();
        }
        catch (Throwable x) {
            BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, x);
        }
    }

    private void doDeleteStockCount() {
        try {
            if (this.table.getRowCount() == 0) {
                String message = InvMessages.getString("StockCountExplorer.2");
                POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), message);
                return;
            }
            int index = this.table.getSelectedRow();
            if (index < 0) {
                String message = InvMessages.getString("StockCountExplorer.1");
                POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), message);
                return;
            }
            index = this.table.convertRowIndexToModel(index);
            StockCount stockCount = this.tableModel.getRow(index);
            if (ConfirmDeleteDialog.showMessage(this, POSConstants.CONFIRM_DELETE, POSConstants.DELETE) == 0) {
                StockCountDAO.getInstance().delete(stockCount);
                this.tableModel.removeRow(index);
            }
        }
        catch (Exception x) {
            BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, x);
        }
    }

    private void doPrintStockCount(StockCount stockCount) throws Exception {
    }

    public void updateView() {
        this.showStockCounts();
    }
}

