/*
 * Decompiled with CFR 0.152.
 */
package com.orostock.inventory.ui;

import com.floreantpos.PosLog;
import com.floreantpos.main.Application;
import com.floreantpos.model.IUnit;
import com.floreantpos.model.InventoryLocation;
import com.floreantpos.model.InventoryUnit;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.StockCount;
import com.floreantpos.model.StockCountItem;
import com.floreantpos.model.dao.InventoryUnitDAO;
import com.floreantpos.model.dao.StockCountDAO;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.swing.BeanTableModel;
import com.floreantpos.swing.DoubleTextField;
import com.floreantpos.swing.POSTextField;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.ui.BeanEditor;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.DateTimePicker;
import com.floreantpos.util.POSUtil;
import com.orostock.inventory.InvMessages;
import com.orostock.inventory.report.InventoryStockData;
import com.orostock.inventory.report.dao.ReportDAO;
import com.orostock.inventory.ui.StockCountItemEntryDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang3.StringUtils;
import org.jdesktop.swingx.JXTable;

public class StockCountForm
extends BeanEditor<StockCount> {
    private POSTextField tfOrderId;
    private JLabel lblOrderId;
    private TitledBorder titleBorder;
    private DateTimePicker dpStockCountDate;
    private JXTable table;
    private BeanTableModel<StockCountItem> tableModel;
    private List<StockCountItem> items = new ArrayList<StockCountItem>();
    private JButton btnAddItem;
    private JButton btnDeleteItem;
    private JButton btnAddMultipleItem;

    public StockCountForm() {
        this(new StockCount());
    }

    public StockCountForm(StockCount stockCount) {
        this(stockCount, false);
    }

    public StockCountForm(StockCount stockCount, boolean receive) {
        if (stockCount.getCountItems() != null) {
            this.items.addAll(stockCount.getCountItems());
        }
        this.initComponents();
        this.setBean(stockCount);
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
        this.setBorder(new EmptyBorder(10, 10, 10, 10));
        JPanel itemInfoPanel = new JPanel((LayoutManager)new MigLayout("hidemode 3,wrap 2", "[][grow][]", ""));
        this.titleBorder = new TitledBorder("");
        itemInfoPanel.setBorder(this.titleBorder);
        this.add((Component)itemInfoPanel, "North");
        this.lblOrderId = new JLabel(InvMessages.getString("IVSCF.4"));
        itemInfoPanel.add((Component)this.lblOrderId, "alignx trailing");
        this.tfOrderId = new POSTextField();
        itemInfoPanel.add((Component)this.tfOrderId, "growx");
        this.dpStockCountDate = new DateTimePicker();
        this.dpStockCountDate.setDate(new Date());
        this.dpStockCountDate.addActionListener(e -> this.updateStockCount());
        itemInfoPanel.add((Component)new JLabel(InvMessages.getString("IVSCF.7")), "alignx trailing");
        itemInfoPanel.add((Component)((Object)this.dpStockCountDate));
        this.tableModel = new BeanTableModel(StockCountItem.class);
        this.tableModel.addColumn(InvMessages.getString("IVSCF.9"), StockCountItem.PROP_SKU);
        this.tableModel.addColumn(InvMessages.getString("IVSCF.11"), StockCountItem.PROP_NAME);
        this.tableModel.addColumn(InvMessages.getString("IVSCF.13"), StockCountItem.PROP_INVENTORY_LOCATION);
        this.tableModel.addColumn(InvMessages.getString("IVSCF.15"), StockCountItem.PROP_UNIT);
        this.tableModel.addColumn(InvMessages.getString("IVSCF.17"), StockCountItem.PROP_UNIT_ON_HAND, 11, BeanTableModel.DataType.NUMBER);
        this.tableModel.addColumn(InvMessages.getString("IVSCF.19"), StockCountItem.PROP_ACTUAL_UNIT, BeanTableModel.EditMode.EDITABLE, 11, BeanTableModel.DataType.NUMBER);
        this.tableModel.addColumn(InvMessages.getString("IVSCF.21"), "countVariance", 11, BeanTableModel.DataType.NUMBER);
        this.tableModel.addColumn(InvMessages.getString("IVSCF.23"), StockCountItem.PROP_COST, 11, BeanTableModel.DataType.MONEY);
        this.tableModel.addColumn(InvMessages.getString("IVSCF.25"), "costVariance", 11, BeanTableModel.DataType.MONEY);
        this.tableModel.setRows(this.items);
        this.table = new JXTable(this.tableModel){

            public void changeSelection(int row, int column, boolean toggle, boolean extend) {
                super.changeSelection(row, column, toggle, extend);
                StockCountForm.this.table.editCellAt(row, column);
                DefaultCellEditor editor = (DefaultCellEditor)StockCountForm.this.table.getCellEditor(row, column);
                if (editor != null && editor.getComponent() instanceof DoubleTextField) {
                    DoubleTextField textField = (DoubleTextField)editor.getComponent();
                    textField.requestFocus();
                    textField.selectAll();
                }
            }

            public void setValueAt(Object value, int rowIndex, int columnIndex) {
                StockCountItem stockCountItem = (StockCountItem)StockCountForm.this.tableModel.getRow(rowIndex);
                double quantity = 0.0;
                if (value instanceof Double) {
                    quantity = (Double)value;
                } else if (value instanceof String) {
                    String receiveStr = (String)value;
                    if (receiveStr.isEmpty()) {
                        return;
                    }
                    quantity = Double.parseDouble(receiveStr);
                }
                if (columnIndex == 5) {
                    stockCountItem.setActualUnit(quantity);
                }
                StockCountForm.this.table.repaint();
            }
        };
        DoubleTextField tfEditField = new DoubleTextField();
        tfEditField.setHorizontalAlignment(4);
        DefaultCellEditor editor = new DefaultCellEditor(tfEditField);
        editor.setClickCountToStart(1);
        this.table.setDefaultEditor(this.table.getColumnClass(5), (TableCellEditor)editor);
        BeanTableModel.BeanTableCellRenderer tableCellRenderer = new BeanTableModel.BeanTableCellRenderer();
        this.table.setDefaultRenderer(Object.class, (TableCellRenderer)tableCellRenderer);
        this.table.setDefaultRenderer(Number.class, (TableCellRenderer)tableCellRenderer);
        this.table.setRowHeight(30);
        this.table.setSelectionMode(0);
        this.add(new JScrollPane((Component)this.table));
        this.resizeTableColumns();
        this.add((Component)this.createSouthActionButtonPanel(), "South");
    }

    private void updateStockCount() {
        List<StockCountItem> stockCountItemList = this.tableModel.getRows();
        for (StockCountItem stockCountItem : stockCountItemList) {
            ReportDAO dao;
            List<InventoryStockData> inventoryTransactions;
            IUnit unit = DataProvider.get().getUnitByCode(stockCountItem.getUnit());
            MenuItem menuItem = stockCountItem.getMenuItem();
            InventoryLocation location = stockCountItem.getInventoryLocation();
            String inventoryUnitId = "";
            if (unit != null) {
                InventoryUnit inventoryUnit = InventoryUnitDAO.getInstance().findByName(unit.getName());
                inventoryUnitId = inventoryUnit.getId();
            }
            if ((inventoryTransactions = (dao = new ReportDAO()).getInventoryOnHandReportData(menuItem.getSku(), location, null, inventoryUnitId, null, this.dpStockCountDate.getDate(), true)) == null) continue;
            for (InventoryStockData inventoryStockData : inventoryTransactions) {
                if (!inventoryStockData.getMenuItemId().equals(menuItem.getId())) continue;
                double quantity = inventoryStockData.getQuantityInHand();
                stockCountItem.setUnitOnHand(quantity > 0.0 ? quantity : 0.0);
                stockCountItem.setActualUnit(quantity > 0.0 ? quantity : 0.0);
            }
        }
        this.table.repaint();
    }

    private JPanel createSouthActionButtonPanel() {
        JPanel southActionPanel = new JPanel((LayoutManager)new MigLayout("fillx,hidemode 3"));
        this.btnAddMultipleItem = new JButton(InvMessages.getString("IVSCF.28"));
        this.btnAddItem = new JButton(InvMessages.getString("IVSCF.29"));
        JButton btnEditItem = new JButton(InvMessages.getString("IVSCF.30"));
        this.btnDeleteItem = new JButton(InvMessages.getString("IVSCF.31"));
        this.btnAddMultipleItem.addActionListener(e -> this.doAddMultipleStockItem());
        this.btnAddItem.addActionListener(e -> this.doAddStockItem());
        btnEditItem.addActionListener(e -> this.doEditStockItem());
        this.btnDeleteItem.addActionListener(e -> this.doDeleteStockItem());
        southActionPanel.add((Component)this.btnAddMultipleItem, "split 4,left");
        southActionPanel.add(this.btnAddItem);
        southActionPanel.add(btnEditItem);
        southActionPanel.add(this.btnDeleteItem);
        return southActionPanel;
    }

    private void resizeTableColumns() {
        this.table.setAutoResizeMode(4);
        this.setColumnWidth(0, PosUIManager.getSize(150));
        this.setColumnWidth(1, PosUIManager.getSize(350));
    }

    private void setColumnWidth(int columnNumber, int width) {
        TableColumn column = this.table.getColumnModel().getColumn(columnNumber);
        column.setPreferredWidth(width);
        column.setMaxWidth(width);
        column.setMinWidth(width);
    }

    @Override
    public boolean save() {
        try {
            if (!this.updateModel()) {
                return false;
            }
            StockCount stockCount = (StockCount)this.getBean();
            StockCountDAO.getInstance().saveOrUpdate(stockCount);
            return true;
        }
        catch (Exception e) {
            PosLog.error(this.getClass(), e);
            POSMessageDialog.showError(e.getMessage());
            return false;
        }
    }

    @Override
    public void updateView() {
        StockCount stockCount = (StockCount)this.getBean();
        if (stockCount.getRefNumber() == null) {
            this.tfOrderId.setText(String.valueOf(StockCountDAO.getInstance().getNextStockCountSequenceNumber()));
            return;
        }
        this.dpStockCountDate.setDate(stockCount.getCreatedDate());
        this.tfOrderId.setText(String.valueOf(stockCount.getRefNumber()));
    }

    @Override
    public boolean updateModel() {
        StockCount stockCount = (StockCount)this.getBean();
        String refId = this.tfOrderId.getText();
        if (StringUtils.isEmpty((CharSequence)refId)) {
            POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), InvMessages.getString("IVSCF.33"));
            return false;
        }
        if (this.items == null || this.items.isEmpty()) {
            POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), InvMessages.getString("IVSCF.34"));
            return false;
        }
        stockCount.setRefNumber(refId);
        stockCount.setCreatedDate(this.dpStockCountDate.getDate());
        stockCount.setUser(Application.getCurrentUser());
        stockCount.setLastModifiedDate(new Date());
        if (stockCount.getCountItems() != null) {
            stockCount.getCountItems().clear();
        }
        boolean isEmptyLoc = false;
        for (StockCountItem item : this.items) {
            if (item.getInventoryLocation() == null) {
                isEmptyLoc = true;
                break;
            }
            item.setStockCount(stockCount);
            stockCount.addTocountItems(item);
        }
        if (isEmptyLoc) {
            POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), InvMessages.getString("IVSCF.35"));
            return false;
        }
        return true;
    }

    @Override
    public String getDisplayText() {
        return InvMessages.getString("IVSCF.36");
    }

    private void doAddStockItem() {
        StockCountItemEntryDialog dialog = new StockCountItemEntryDialog(this.tableModel, false, this.dpStockCountDate.getDate());
        dialog.setSize(PosUIManager.getSize(400, 450));
        dialog.open();
        if (dialog.isCanceled()) {
            return;
        }
    }

    private void doAddMultipleStockItem() {
        StockCountItemEntryDialog dialog = new StockCountItemEntryDialog(this.tableModel, true, this.dpStockCountDate.getDate());
        dialog.setSize(PosUIManager.getSize(350, 300));
        dialog.open();
        if (dialog.isCanceled()) {
            return;
        }
    }

    private void doEditStockItem() {
        try {
            if (this.table.getRowCount() == 0) {
                String message = InvMessages.getString("StockCountForm.0");
                POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), message);
                return;
            }
            int row = this.table.getSelectedRow();
            if (row == -1) {
                String message = InvMessages.getString("StockCountForm.1");
                POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), message);
                return;
            }
            int index = this.table.convertRowIndexToModel(row);
            StockCountItem item = this.tableModel.getRow(index);
            if (item == null) {
                return;
            }
            StockCountItemEntryDialog dialog = new StockCountItemEntryDialog(item, this.dpStockCountDate.getDate());
            dialog.setSize(PosUIManager.getSize(350, 350));
            dialog.open();
            if (dialog.isCanceled()) {
                return;
            }
            this.table.repaint();
        }
        catch (Exception e) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), e.getMessage(), e);
        }
    }

    private void doDeleteStockItem() {
        try {
            if (this.table.getRowCount() == 0) {
                String message = InvMessages.getString("StockCountForm.2");
                POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), message);
                return;
            }
            int row = this.table.getSelectedRow();
            if (row == -1) {
                String message = InvMessages.getString("StockCountForm.1");
                POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), message);
                return;
            }
            int index = this.table.convertRowIndexToModel(row);
            StockCountItem item = this.items.get(index);
            if (item == null) {
                return;
            }
            this.tableModel.removeRow(item);
        }
        catch (Exception e) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), e.getMessage(), e);
        }
    }
}

