/*
 * Decompiled with CFR 0.152.
 */
package com.orostock.inventory.ui;

import com.floreantpos.Messages;
import com.floreantpos.config.AppProperties;
import com.floreantpos.model.IUnit;
import com.floreantpos.model.InventoryLocation;
import com.floreantpos.model.InventoryUnit;
import com.floreantpos.model.InventoryVendor;
import com.floreantpos.model.MenuGroup;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.StockCountItem;
import com.floreantpos.model.dao.InventoryLocationDAO;
import com.floreantpos.model.dao.InventoryUnitDAO;
import com.floreantpos.model.dao.InventoryVendorDAO;
import com.floreantpos.model.dao.MenuGroupDAO;
import com.floreantpos.model.dao.MenuItemDAO;
import com.floreantpos.model.util.DateUtil;
import com.floreantpos.swing.BeanTableModel;
import com.floreantpos.swing.ComboBoxModel;
import com.floreantpos.swing.DoubleTextField;
import com.floreantpos.swing.POSTextField;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.ui.dialog.OkCancelOptionDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.POSUtil;
import com.orostock.inventory.InvMessages;
import com.orostock.inventory.report.InventoryStockData;
import com.orostock.inventory.report.dao.ReportDAO;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;

public class StockCountItemEntryDialog
extends OkCancelOptionDialog {
    private static final long serialVersionUID = 1L;
    private Component lblQuantity;
    private StockCountItem orderItem;
    private JLabel lblStockCountItemType;
    private JLabel lblUnitPrice;
    private DoubleTextField tfUnitOnHand;
    private DoubleTextField tfActualUnit;
    private JButton btnSearchItem;
    private POSTextField tfSearchString;
    private JComboBox<IUnit> cbUnits;
    private JLabel lblOrderId;
    private JComboBox cbItems;
    private JComboBox<InventoryLocation> cbLocations;
    private BeanTableModel<StockCountItem> tableModel;
    private boolean isEditMode = false;
    private JComboBox cbGroups;
    private JComboBox cbVendors;
    private boolean isForMultipleItem;
    private JLabel lblItem;
    private JLabel lblUnit;
    private Date stockCountDate;

    public StockCountItemEntryDialog(BeanTableModel<StockCountItem> tableModel, boolean isForMultipleItem, Date stockCountDate) {
        this.tableModel = tableModel;
        this.isForMultipleItem = isForMultipleItem;
        this.stockCountDate = stockCountDate;
        this.setCaption(InvMessages.getString("IVSCIED.0"));
        this.initComponents();
        this.initData();
        this.updateVisibility();
        this.setOkButtonText(InvMessages.getString("IVSCIED.1"));
        this.setCancelButtonText(InvMessages.getString("IVSCIED.2"));
    }

    private void updateVisibility() {
        this.lblOrderId.setVisible(!this.isForMultipleItem);
        this.tfSearchString.setVisible(!this.isForMultipleItem);
        this.btnSearchItem.setVisible(!this.isForMultipleItem);
        this.lblItem.setVisible(!this.isForMultipleItem);
        this.cbItems.setVisible(!this.isForMultipleItem);
        this.lblUnit.setVisible(!this.isForMultipleItem);
        this.cbUnits.setVisible(!this.isForMultipleItem);
        this.lblUnitPrice.setVisible(!this.isForMultipleItem);
        this.tfUnitOnHand.setVisible(!this.isForMultipleItem);
        this.lblQuantity.setVisible(!this.isForMultipleItem);
        this.tfActualUnit.setVisible(!this.isForMultipleItem);
    }

    public StockCountItemEntryDialog(StockCountItem orderItem, Date stockCountDate) {
        this.orderItem = orderItem;
        this.isEditMode = true;
        this.stockCountDate = stockCountDate;
        this.setCaption(InvMessages.getString("IVSCIED.3"));
        this.initComponents();
        this.initData();
        this.updateView();
    }

    private void initData() {
        this.cbItems.setModel(new ComboBoxModel());
        this.cbItems.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                MenuItem menuItem = (MenuItem)StockCountItemEntryDialog.this.cbItems.getSelectedItem();
                ComboBoxModel aModel = (ComboBoxModel)StockCountItemEntryDialog.this.cbUnits.getModel();
                if (menuItem != null) {
                    MenuItemDAO.getInstance().initialize(menuItem);
                    aModel.setDataList(menuItem.getUnits());
                    if (aModel.getSize() > 0) {
                        StockCountItemEntryDialog.this.cbUnits.setSelectedIndex(0);
                    }
                    StockCountItemEntryDialog.this.loadStockQuantity();
                }
            }
        });
        ComboBoxModel aModel = new ComboBoxModel();
        this.cbUnits.setModel(aModel);
        this.cbUnits.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                StockCountItemEntryDialog.this.loadStockQuantity();
            }
        });
        ComboBoxModel locationModel = new ComboBoxModel();
        locationModel.addElement((Object)null);
        List<InventoryLocation> locations = InventoryLocationDAO.getInstance().findAll();
        for (InventoryLocation inventoryLocation : locations) {
            locationModel.addElement(inventoryLocation);
        }
        this.cbLocations.setModel(locationModel);
        this.cbLocations.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                StockCountItemEntryDialog.this.loadStockQuantity();
            }
        });
        ComboBoxModel groupsModel = new ComboBoxModel();
        groupsModel.addElement((Object)null);
        List<MenuGroup> menuGroups = MenuGroupDAO.getInstance().findGroupsWithInventoryItems();
        for (MenuGroup menuGroup : menuGroups) {
            groupsModel.addElement(menuGroup);
        }
        this.cbGroups.setModel(groupsModel);
        this.cbGroups.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
            }
        });
        ComboBoxModel vendorsModel = new ComboBoxModel();
        vendorsModel.addElement((Object)null);
        List<InventoryVendor> vendors = InventoryVendorDAO.getInstance().findAll();
        for (InventoryVendor vendor : vendors) {
            vendorsModel.addElement(vendor);
        }
        this.cbVendors.setModel(vendorsModel);
        this.cbVendors.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
            }
        });
        this.loadUnits();
    }

    private void loadUnits() {
        ComboBoxModel model = (ComboBoxModel)this.cbUnits.getModel();
        model.removeAllElements();
        MenuItem menuItem = (MenuItem)this.cbItems.getSelectedItem();
        if (menuItem == null) {
            return;
        }
        model.setDataList(menuItem.getUnits());
    }

    private void initComponents() {
        this.setTitle(AppProperties.getAppName());
        JPanel itemInfoPanel = new JPanel((LayoutManager)new MigLayout("hidemode 3", "[][grow]", ""));
        JLabel lblCountDate = new JLabel(Messages.getString("StockCountItemEntryDialog.0"));
        JLabel countDate = new JLabel(DateUtil.formatAsGiftCardDateFormat(this.stockCountDate));
        itemInfoPanel.add((Component)lblCountDate, "alignx trailing");
        itemInfoPanel.add((Component)countDate, "growx, wrap");
        JLabel lblLocation = new JLabel(InvMessages.getString("IVSCIED.4"));
        this.cbLocations = new JComboBox();
        if (this.isEditMode) {
            this.cbLocations.setEnabled(false);
        }
        itemInfoPanel.add((Component)lblLocation, "alignx trailing");
        itemInfoPanel.add(this.cbLocations, "growx, wrap");
        JLabel lblGroup = new JLabel(InvMessages.getString("IVSCIED.10"));
        this.cbGroups = new JComboBox();
        if (!this.isEditMode) {
            itemInfoPanel.add((Component)lblGroup, "alignx trailing");
            itemInfoPanel.add((Component)this.cbGroups, "growx, wrap");
        }
        JLabel lblVendor = new JLabel(InvMessages.getString("IVSCIED.13"));
        this.cbVendors = new JComboBox();
        if (!this.isEditMode) {
            itemInfoPanel.add((Component)lblVendor, "alignx trailing");
            itemInfoPanel.add((Component)this.cbVendors, "growx, wrap");
        }
        this.lblOrderId = new JLabel(InvMessages.getString("IVSCIED.16"));
        if (!this.isEditMode) {
            itemInfoPanel.add((Component)this.lblOrderId, "alignx trailing");
        }
        this.tfSearchString = new POSTextField();
        if (!this.isEditMode) {
            itemInfoPanel.add((Component)this.tfSearchString, "growx, split 2,");
        }
        this.tfSearchString.addActionListener(e -> this.doSearchItem());
        this.btnSearchItem = new JButton(InvMessages.getString("IVSCIED.19"));
        if (!this.isEditMode) {
            itemInfoPanel.add((Component)this.btnSearchItem, " wrap");
        }
        this.btnSearchItem.addActionListener(e -> this.doSearchItem());
        this.lblItem = new JLabel(InvMessages.getString("IVSCIED.21"));
        itemInfoPanel.add((Component)this.lblItem, "alignx trailing");
        this.cbItems = new JComboBox();
        this.cbItems.setMinimumSize(PosUIManager.getSize(90, 0));
        itemInfoPanel.add((Component)this.cbItems, "grow, wrap");
        if (this.isEditMode) {
            this.cbItems.setEnabled(false);
        }
        this.lblStockCountItemType = new JLabel(InvMessages.getString("IVSCIED.24"));
        itemInfoPanel.add((Component)this.lblStockCountItemType, " alignx trailing");
        this.lblStockCountItemType.setVisible(false);
        this.lblUnit = new JLabel(InvMessages.getString("IVSCIED.26"));
        itemInfoPanel.add((Component)this.lblUnit, "alignx trailing");
        this.cbUnits = new JComboBox();
        this.cbUnits.setPreferredSize(PosUIManager.getSize(120, 0));
        itemInfoPanel.add(this.cbUnits, "grow, wrap");
        this.lblUnitPrice = new JLabel(InvMessages.getString("IVSCIED.29"));
        itemInfoPanel.add((Component)this.lblUnitPrice, "alignx trailing");
        this.tfUnitOnHand = new DoubleTextField();
        this.tfUnitOnHand.setEditable(false);
        itemInfoPanel.add((Component)this.tfUnitOnHand, "growx, wrap");
        this.lblQuantity = new JLabel(InvMessages.getString("IVSCIED.32"));
        itemInfoPanel.add(this.lblQuantity, "alignx trailing");
        this.tfActualUnit = new DoubleTextField();
        itemInfoPanel.add((Component)this.tfActualUnit, "growx");
        this.getContentPanel().add(itemInfoPanel);
    }

    private void doSearchItem() {
        List<MenuItem> menuItems = this.getItems();
        ComboBoxModel model = (ComboBoxModel)this.cbItems.getModel();
        model.removeAllElements();
        model.setDataList(menuItems);
        if (model.getSize() > 0) {
            this.cbItems.setSelectedIndex(0);
        }
        this.loadUnits();
        ComboBoxModel unitModel = (ComboBoxModel)this.cbUnits.getModel();
        if (unitModel.getSize() > 0) {
            this.cbUnits.setSelectedIndex(0);
        }
        this.loadStockQuantity();
    }

    private List<MenuItem> getItems() {
        String searchText = this.tfSearchString.getText();
        MenuGroup menuGroup = (MenuGroup)this.cbGroups.getSelectedItem();
        InventoryVendor vendor = (InventoryVendor)this.cbVendors.getSelectedItem();
        InventoryLocation location = (InventoryLocation)this.cbLocations.getSelectedItem();
        List<MenuItem> menuItems = MenuItemDAO.getInstance().findMenuItemsForStockCount(searchText, menuGroup, vendor, location);
        return menuItems;
    }

    public void updateView() {
        if (this.orderItem == null) {
            return;
        }
        MenuItem menuItem = this.orderItem.getMenuItem();
        if (menuItem != null) {
            ComboBoxModel model = (ComboBoxModel)this.cbItems.getModel();
            model.addElement(menuItem);
            this.cbItems.setSelectedItem(menuItem);
            this.loadUnits();
            ComboBoxModel unitModel = (ComboBoxModel)this.cbUnits.getModel();
            if (unitModel.getSize() > 0) {
                List units = unitModel.getDataList();
                for (IUnit unit : units) {
                    if (!this.orderItem.getUnit().equals(unit.getUniqueCode())) continue;
                    this.cbUnits.setSelectedItem(unit);
                    break;
                }
            }
        }
        InventoryLocation location = null;
        if (this.orderItem.getInventoryLocation() == null) {
            location = InventoryLocationDAO.getInstance().getDefaultInInventoryLocation();
            this.cbLocations.setSelectedItem(location);
        } else {
            location = this.orderItem.getInventoryLocation();
            this.cbLocations.setSelectedItem(location);
        }
        this.tfActualUnit.setText(String.valueOf(POSUtil.getRoundedDouble(this.orderItem.getActualUnit())));
        this.tfUnitOnHand.setText(String.valueOf(POSUtil.getRoundedDouble(this.orderItem.getUnitOnHand())));
    }

    @Override
    public void doOk() {
        try {
            if (this.isForMultipleItem) {
                this.doAddMultipleItems();
                return;
            }
            if (this.isEditMode) {
                if (this.orderItem == null) {
                    this.orderItem = new StockCountItem();
                }
            } else {
                this.orderItem = new StockCountItem();
            }
            double unitOnHand = this.tfUnitOnHand.getDoubleOrZero();
            MenuItem menuItem = (MenuItem)this.cbItems.getSelectedItem();
            if (menuItem == null) {
                POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), InvMessages.getString("IVSCIED.35"));
                return;
            }
            IUnit unit = (IUnit)this.cbUnits.getSelectedItem();
            if (unit == null) {
                POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), InvMessages.getString("IVSCIED.36"));
                return;
            }
            InventoryLocation location = (InventoryLocation)this.cbLocations.getSelectedItem();
            if (location == null) {
                POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), InvMessages.getString("IVSCIED.37"));
                return;
            }
            double quantity = this.tfActualUnit.getDoubleOrZero();
            this.orderItem.setSku(menuItem.getSku());
            this.orderItem.setMenuItem(menuItem);
            this.orderItem.setItemId(menuItem.getId());
            this.orderItem.setUnit(unit.getUniqueCode());
            this.orderItem.setInventoryLocation(location);
            this.orderItem.setActualUnit(quantity);
            this.orderItem.setCost(menuItem.getCost());
            this.orderItem.setUnitOnHand(unitOnHand);
            this.orderItem.setName(menuItem.getDisplayName());
            if (this.isEditMode) {
                this.setCanceled(false);
                this.dispose();
                return;
            }
            List<StockCountItem> items = this.tableModel.getRows();
            StockCountItem existedItem = null;
            for (StockCountItem stockCountItem : items) {
                if (!this.isItemExists(stockCountItem, this.orderItem)) continue;
                existedItem = stockCountItem;
                break;
            }
            if (existedItem == null) {
                this.tableModel.addRow(this.orderItem);
                return;
            }
            int option = POSMessageDialog.showYesNoQuestionDialog(POSUtil.getFocusedWindow(), InvMessages.getString("IVSCIED.38"), InvMessages.getString("IVSCIED.39"));
            if (option != 0) {
                return;
            }
            for (StockCountItem stockCountItem : items) {
                if (!this.isItemExists(stockCountItem, existedItem)) continue;
                stockCountItem.setActualUnit(quantity);
            }
            this.tableModel.fireTableDataChanged();
            this.tfSearchString.requestFocus();
            this.tfSearchString.selectAll();
        }
        catch (Exception e) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), e.getMessage(), e);
        }
    }

    private boolean isItemExists(StockCountItem stockCountItem, StockCountItem orderItem) {
        return stockCountItem.getItemId().equals(orderItem.getItemId()) && stockCountItem.getUnit().equals(orderItem.getUnit()) && stockCountItem.getInventoryLocation().equals(orderItem.getInventoryLocation());
    }

    private void doAddMultipleItems() throws Exception {
        MenuGroup menuGroup = (MenuGroup)this.cbGroups.getSelectedItem();
        InventoryVendor vendor = (InventoryVendor)this.cbVendors.getSelectedItem();
        InventoryLocation location = (InventoryLocation)this.cbLocations.getSelectedItem();
        if (location == null) {
            POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), InvMessages.getString("IVSCIED.40"));
            return;
        }
        ReportDAO dao = new ReportDAO();
        List<InventoryStockData> inventoryTransactions = dao.getInventoryOnHandReportData(null, location, menuGroup, null, vendor, this.stockCountDate, true, false);
        if (inventoryTransactions == null || inventoryTransactions.isEmpty()) {
            POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), InvMessages.getString("IVSCIED.41"));
            return;
        }
        ArrayList<StockCountItem> stockCountItemList = new ArrayList<StockCountItem>();
        for (InventoryStockData inventoryStock : inventoryTransactions) {
            StockCountItem orderItem = new StockCountItem();
            orderItem.setSku(inventoryStock.getSku());
            orderItem.setMenuItem(inventoryStock.getMenuItem());
            orderItem.setCost(inventoryStock.getMenuItemCost());
            orderItem.setItemId(inventoryStock.getMenuItemId());
            orderItem.setUnit(inventoryStock.getUnit());
            orderItem.setInventoryLocation(location);
            orderItem.setActualUnit(0.0);
            orderItem.setUnitOnHand(inventoryStock.getQuantityInHand());
            orderItem.setName(inventoryStock.getMenuItemName());
            stockCountItemList.add(orderItem);
        }
        List<StockCountItem> items = this.tableModel.getRows();
        for (StockCountItem stockCountItem : items) {
            Iterator iterator = stockCountItemList.iterator();
            while (iterator.hasNext()) {
                StockCountItem item = (StockCountItem)iterator.next();
                if (!stockCountItem.getItemId().equals(item.getItemId()) || !stockCountItem.getInventoryLocation().getId().equals(item.getInventoryLocation().getId())) continue;
                iterator.remove();
            }
        }
        this.tableModel.getRows().addAll(stockCountItemList);
        this.tableModel.fireTableDataChanged();
        this.setCanceled(false);
        this.dispose();
    }

    private void loadStockQuantity() {
        MenuItem menuItem = (MenuItem)this.cbItems.getSelectedItem();
        IUnit unit = (IUnit)this.cbUnits.getSelectedItem();
        InventoryLocation location = (InventoryLocation)this.cbLocations.getSelectedItem();
        double quantity = 0.0;
        if (menuItem != null && location != null) {
            ReportDAO dao;
            List<InventoryStockData> inventoryTransactions;
            String inventoryUnitId = "";
            if (unit != null) {
                InventoryUnit inventoryUnit = InventoryUnitDAO.getInstance().findByName(unit.getName());
                inventoryUnitId = inventoryUnit.getId();
            }
            if ((inventoryTransactions = (dao = new ReportDAO()).getInventoryOnHandReportData(menuItem.getSku(), location, null, inventoryUnitId, null, this.stockCountDate, true)) != null) {
                for (InventoryStockData inventoryStockData : inventoryTransactions) {
                    if (!inventoryStockData.getMenuItemId().equals(menuItem.getId())) continue;
                    quantity = inventoryStockData.getQuantityInHand();
                }
            }
        }
        this.tfActualUnit.setText(String.valueOf(quantity > 0.0 ? quantity : 0.0));
        this.tfUnitOnHand.setText(String.valueOf(quantity > 0.0 ? quantity : 0.0));
    }
}

