/*
 * Decompiled with CFR 0.152.
 */
package com.orostock.inventory.ui;

import com.floreantpos.config.AppProperties;
import com.floreantpos.model.StockCount;
import com.floreantpos.model.StockCountItem;
import com.floreantpos.report.ReportUtil;
import com.floreantpos.services.report.ReportService;
import com.floreantpos.swing.ListTableModel;
import com.floreantpos.ui.dialog.OkCancelOptionDialog;
import com.floreantpos.util.NumberUtil;
import com.orostock.inventory.InvMessages;
import java.awt.Component;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import javax.swing.table.TableModel;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.data.JRTableModelDataSource;
import net.sf.jasperreports.view.JRViewer;

public class StockCountReport {
    private StockCountReportModel itemReportModel;
    private StockCount stockCount;

    public StockCountReport(StockCount stockCount) {
        this.stockCount = stockCount;
    }

    public void showReport() throws Exception {
        this.createModels();
        HashMap<String, String> map = new HashMap<String, String>();
        ReportUtil.populateRestaurantProperties(map);
        map.put("reportTitle", InvMessages.getString("StockCountReport.0"));
        map.put("reportDate", ReportService.formatFullDate(new Date()));
        map.put("line1", InvMessages.getString("StockCountReport.1") + ReportService.formatFullDate(this.stockCount.getCreatedDate()));
        map.put("line2", InvMessages.getString("StockCountReport.3") + this.stockCount.getUser());
        map.put("txt1", InvMessages.getString("StockCountReport.5"));
        map.put("txt2", InvMessages.getString("StockCountReport.7"));
        map.put("txt3", InvMessages.getString("StockCountReport.9"));
        map.put("txt4", InvMessages.getString("StockCountReport.11"));
        map.put("txt5", InvMessages.getString("StockCountReport.13"));
        map.put("txt6", InvMessages.getString("StockCountReport.15"));
        map.put("txt7", InvMessages.getString("StockCountReport.17"));
        map.put("txt8", InvMessages.getString("StockCountReport.19"));
        map.put("txt9", InvMessages.getString("StockCountReport.21"));
        map.put("grandTotal", InvMessages.getString("StockCountReport.23"));
        map.put("signature1", InvMessages.getString("StockCountReport.25"));
        map.put("signature2", InvMessages.getString("StockCountReport.27"));
        JasperReport masterReport = ReportUtil.getReport("item_count_report");
        JasperPrint print = JasperFillManager.fillReport((JasperReport)masterReport, map, (JRDataSource)new JRTableModelDataSource((TableModel)this.itemReportModel));
        JRViewer viewer = ReportUtil.getCustomJRViewer(print);
        OkCancelOptionDialog dialog = new OkCancelOptionDialog(){

            @Override
            public void doOk() {
            }
        };
        dialog.setDefaultCloseOperation(2);
        dialog.setTitle(AppProperties.getAppName());
        dialog.setCaption(InvMessages.getString("StockCountReport.28"));
        dialog.getContentPanel().add((Component)viewer);
        dialog.setOkButtonVisible(false);
        dialog.openFullScreen();
    }

    public void createModels() {
        this.itemReportModel = new StockCountReportModel();
        this.itemReportModel.setRows(this.stockCount.getCountItems());
    }

    public class StockCountReportModel
    extends ListTableModel<StockCountItem> {
        SimpleDateFormat dateFormat2;
        DecimalFormat decimalFormat;

        public StockCountReportModel() {
            super(new String[]{"col1", "col2", "col3", "col4", "col5", "col6", "col7", "col8", "col9"});
            this.dateFormat2 = new SimpleDateFormat("MMM-dd-yyyy hh:mm a");
            this.decimalFormat = new DecimalFormat("0.00");
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            StockCountItem data = (StockCountItem)this.rows.get(rowIndex);
            switch (columnIndex) {
                case 0: {
                    return data.getSku();
                }
                case 1: {
                    return data.getName();
                }
                case 2: {
                    return data.getInventoryLocation().getName();
                }
                case 3: {
                    return data.getUnit();
                }
                case 4: {
                    return NumberUtil.formatNumber(data.getUnitOnHand(), true);
                }
                case 5: {
                    return NumberUtil.formatNumber(data.getActualUnit(), true);
                }
                case 6: {
                    return NumberUtil.formatNumber(data.getCountVariance(), true);
                }
                case 7: {
                    return NumberUtil.formatNumber(data.getCost(), true);
                }
                case 8: {
                    return data.getCostVariance();
                }
            }
            return null;
        }
    }
}

