/*
 * Decompiled with CFR 0.152.
 */
package com.orostock.inventory.ui.recepie;

import com.floreantpos.POSConstants;
import com.floreantpos.PosException;
import com.floreantpos.bo.ui.BOMessageDialog;
import com.floreantpos.bo.ui.CustomCellRenderer;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.Recepie;
import com.floreantpos.model.RecipeTable;
import com.floreantpos.model.dao.RecepieDAO;
import com.floreantpos.model.dao.RecipeTableDAO;
import com.floreantpos.swing.BeanTableModel;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.TransparentPanel;
import com.floreantpos.ui.BeanEditor;
import com.floreantpos.ui.dialog.BeanEditorDialog;
import com.floreantpos.ui.dialog.DetailsInfoDialog;
import com.floreantpos.ui.dialog.MenuItemSelectionDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.POSUtil;
import com.orostock.inventory.InvMessages;
import com.orostock.inventory.ui.recepie.RecipeEntryForm;
import com.orostock.inventory.ui.recepie.template.RecipePreparationEntryForm;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.table.TableCellRenderer;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.collections.CollectionUtils;
import org.jdesktop.swingx.JXTable;

public class RecipeExplorer
extends TransparentPanel {
    private JXTable table;
    private BeanTableModel<Recepie> tableModel;
    private JTextField tfRecipeName = new JTextField(20);
    private JButton btnBack;
    private JButton btnForward;
    private JLabel lblNumberOfItem;

    public RecipeExplorer() {
        this.initComponent();
        this.showRecipeItems();
    }

    private void initComponent() {
        this.tableModel = new BeanTableModel(Recepie.class);
        this.tableModel.addColumn("ITEM NAME", "menuItemName");
        this.tableModel.addColumn("RECIPE " + POSConstants.NAME.toUpperCase(), Recepie.PROP_NAME);
        this.tableModel.addColumn("YIELD", Recepie.PROP_YIELD);
        this.tableModel.addColumn("YIELD UNIT", Recepie.PROP_YIELD_UNIT);
        this.tableModel.addColumn("PORTION", Recepie.PROP_PORTION);
        this.tableModel.addColumn("PORTION UNIT", Recepie.PROP_PORTION_UNIT);
        this.tableModel.addRows(RecepieDAO.getInstance().findAll());
        this.table = new JXTable(this.tableModel);
        this.table.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent me) {
                if (me.getClickCount() == 2) {
                    RecipeExplorer.this.editSelectedRow();
                }
            }
        });
        this.table.setRowHeight(PosUIManager.getSize(35));
        this.table.setDefaultRenderer(Object.class, (TableCellRenderer)new CustomCellRenderer());
        this.btnBack = new JButton(InvMessages.getString("IVIE.30"));
        this.btnForward = new JButton(InvMessages.getString("IVIE.31"));
        this.lblNumberOfItem = new JLabel();
        this.btnBack.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RecipeExplorer.this.showRecipeItems(RecipeExplorer.this.tableModel.getPreviousRowIndex());
            }
        });
        this.btnForward.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RecipeExplorer.this.showRecipeItems(RecipeExplorer.this.tableModel.getNextRowIndex());
            }
        });
        this.setLayout(new BorderLayout(5, 5));
        this.add(new JScrollPane((Component)this.table));
        JPanel topSearchPanel = new JPanel((LayoutManager)new MigLayout());
        topSearchPanel.add(new JLabel(InvMessages.getString("IVRE.1")));
        topSearchPanel.add(this.tfRecipeName);
        this.tfRecipeName.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RecipeExplorer.this.showRecipeItems();
            }
        });
        JButton btnSearch = new JButton(POSConstants.SEARCH_ITEM_BUTTON_TEXT);
        btnSearch.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RecipeExplorer.this.showRecipeItems();
            }
        });
        topSearchPanel.add(btnSearch);
        this.add((Component)topSearchPanel, "North");
        this.addButtonPanel();
    }

    protected void showRecipeItems() {
        this.showRecipeItems(0);
    }

    protected void showRecipeItems(int rowIndex) {
        this.tableModel.setCurrentRowIndex(rowIndex);
        this.tableModel.setPageSize(10);
        RecepieDAO.getInstance().loadRecepies(this.tableModel, this.tfRecipeName.getText(), false);
        int startNumber = this.tableModel.getCurrentRowIndex() + 1;
        int endNumber = this.tableModel.getNextRowIndex();
        int totalNumber = this.tableModel.getNumRows();
        if (endNumber > totalNumber) {
            endNumber = totalNumber;
        }
        this.lblNumberOfItem.setText(String.format(InvMessages.getString("Inventory.IE.12"), startNumber, endNumber, totalNumber));
        this.btnBack.setEnabled(this.tableModel.hasPrevious());
        this.btnForward.setEnabled(this.tableModel.hasNext());
        this.table.repaint();
    }

    private void addButtonPanel() {
        JButton btnSelectMenuItem = new JButton(InvMessages.getString("IVRE.2"));
        btnSelectMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RecipeExplorer.this.applyRecipeToMenuItem();
            }
        });
        JButton addButton = new JButton(POSConstants.ADD);
        addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RecipeExplorer.this.doAddNewRecipe();
            }
        });
        JButton editButton = new JButton(POSConstants.EDIT);
        editButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RecipeExplorer.this.editSelectedRow();
            }
        });
        JButton deleteButton = new JButton(POSConstants.DELETE);
        deleteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    int index = RecipeExplorer.this.table.getSelectedRow();
                    if (index < 0) {
                        return;
                    }
                    index = RecipeExplorer.this.table.convertRowIndexToModel(index);
                    Recepie orderType = (Recepie)RecipeExplorer.this.tableModel.getRow(index);
                    if (POSMessageDialog.showYesNoQuestionDialog(POSUtil.getBackOfficeWindow(), POSConstants.CONFIRM_DELETE, POSConstants.DELETE) != 0) {
                        return;
                    }
                    RecepieDAO dao = new RecepieDAO();
                    dao.delete(orderType);
                    RecipeExplorer.this.tableModel.removeRow(index);
                }
                catch (PosException x) {
                    DetailsInfoDialog dialog = new DetailsInfoDialog(x.getMessage(), x.getDetails());
                    dialog.open();
                }
                catch (Exception x) {
                    BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, x);
                }
            }
        });
        JButton btnPreparation = new JButton(InvMessages.getString("IVRE.3"));
        btnPreparation.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RecipeExplorer.this.doPreparationRecipe();
            }
        });
        JPanel mainPanel = new JPanel(new BorderLayout());
        JPanel centerPanel = new JPanel();
        JPanel rightPanel = new JPanel();
        centerPanel.add(btnPreparation);
        centerPanel.add(addButton);
        centerPanel.add(editButton);
        centerPanel.add(deleteButton);
        rightPanel.add(this.lblNumberOfItem);
        rightPanel.add(this.btnBack);
        rightPanel.add(this.btnForward);
        mainPanel.add((Component)centerPanel, "Center");
        mainPanel.add((Component)rightPanel, "East");
        this.add((Component)mainPanel, "South");
    }

    private void doPreparationRecipe() {
        RecipePreparationEntryForm form = new RecipePreparationEntryForm();
        form.setSize(650, 550);
        form.open();
    }

    private void doAddNewRecipe() {
        try {
            RecipeEntryForm editor = new RecipeEntryForm(new Recepie());
            BeanEditorDialog dialog = new BeanEditorDialog((Frame)POSUtil.getBackOfficeWindow(), (BeanEditor)editor);
            dialog.openWithScale(700, 650);
            if (dialog.isCanceled()) {
                return;
            }
            Recepie recipe = (Recepie)editor.getBean();
            this.tableModel.addRow(recipe);
        }
        catch (Exception x) {
            BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, x);
        }
    }

    private void applyRecipeToMenuItem() {
        try {
            int index = this.table.getSelectedRow();
            if (index < 0) {
                return;
            }
            index = this.table.convertRowIndexToModel(index);
            Recepie recipe = this.tableModel.getRow(index);
            List<MenuItem> items = RecipeTableDAO.getInstance().findMenuItems(recipe);
            MenuItemSelectionDialog dialog = new MenuItemSelectionDialog(items);
            dialog.setSize(700, 600);
            dialog.open();
            if (dialog.isCanceled()) {
                return;
            }
            List<MenuItem> menuItems = dialog.getSelectedItems();
            if (CollectionUtils.isEqualCollection(items, menuItems)) {
                return;
            }
            ArrayList<RecipeTable> recipeTables = new ArrayList<RecipeTable>();
            ArrayList<MenuItem> deletedRecipeMenuItems = new ArrayList<MenuItem>();
            if (menuItems != null) {
                for (MenuItem menuItem : menuItems) {
                    RecipeTable bean = new RecipeTable();
                    bean.setMenuItem(menuItem);
                    recipeTables.add(bean);
                }
            }
            if (items != null) {
                for (MenuItem menuItem : items) {
                    if (menuItems.contains(menuItem)) continue;
                    deletedRecipeMenuItems.add(menuItem);
                }
            }
            RecipeTableDAO.getInstance().saveRecipeTables(deletedRecipeMenuItems, recipeTables.toArray());
            this.table.repaint();
        }
        catch (Throwable x) {
            BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, x);
        }
    }

    private void editSelectedRow() {
        try {
            int index = this.table.getSelectedRow();
            if (index < 0) {
                return;
            }
            index = this.table.convertRowIndexToModel(index);
            Recepie recipe = this.tableModel.getRow(index);
            RecipeEntryForm editor = new RecipeEntryForm(recipe);
            BeanEditorDialog dialog = new BeanEditorDialog((Frame)POSUtil.getBackOfficeWindow(), (BeanEditor)editor);
            dialog.openWithScale(700, 650);
            if (dialog.isCanceled()) {
                return;
            }
            this.table.repaint();
        }
        catch (Throwable x) {
            BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, x);
        }
    }
}

