/*
 * Decompiled with CFR 0.152.
 */
package com.orostock.inventory.ui.recepie;

import com.floreantpos.POSConstants;
import com.floreantpos.bo.ui.BOMessageDialog;
import com.floreantpos.model.Recepie;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.ui.BeanEditor;
import com.floreantpos.ui.TitlePanel;
import com.floreantpos.ui.dialog.BeanEditorDialog;
import com.floreantpos.ui.dialog.POSDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.POSUtil;
import com.orostock.inventory.InvMessages;
import com.orostock.inventory.ui.recepie.RecipeEntryForm;
import com.orostock.inventory.ui.recepie.RecipeSelectionView;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;

public class RecipeSelectionDialog
extends POSDialog
implements ActionListener {
    private RecipeSelectionView itemSelectorPanel;
    private List<Recepie> recipeList;
    private int selectionMode;
    private TitlePanel titelpanel;
    private boolean subRecipeOnly;
    private static RecipeSelectionDialog instance;

    public RecipeSelectionDialog(List<Recepie> recipelist) {
        super(POSUtil.getFocusedWindow(), "");
        this.recipeList = recipelist;
        this.initComponents();
    }

    public RecipeSelectionDialog(List<Recepie> recipeList, boolean subRecipeOnly) {
        super(POSUtil.getFocusedWindow(), "");
        this.recipeList = recipeList;
        this.subRecipeOnly = subRecipeOnly;
        this.initComponents();
    }

    public RecipeSelectionDialog() {
        super(POSUtil.getFocusedWindow(), "");
        this.setTitle(InvMessages.getString("IVRSD.3"));
        this.initComponents();
    }

    private void initComponents() {
        this.setLayout(new BorderLayout(5, 5));
        this.setTitle(InvMessages.getString("IVRSD.4"));
        this.titelpanel = new TitlePanel();
        this.titelpanel.setTitle(InvMessages.getString("IVRSD.3"));
        this.add((Component)this.titelpanel, "North");
        JPanel contentPane = new JPanel((LayoutManager)new MigLayout("fill,hidemode 3,inset 0 10 0 10"));
        this.itemSelectorPanel = new RecipeSelectionView(this.recipeList, this.subRecipeOnly);
        contentPane.add((Component)this.itemSelectorPanel, "grow,span,wrap");
        PosButton btnOk = new PosButton(InvMessages.getString("IVRSD.8"));
        btnOk.setActionCommand(POSConstants.OK);
        btnOk.setBackground(Color.GREEN);
        btnOk.setFocusable(false);
        btnOk.addActionListener(this);
        PosButton btnCancel = new PosButton(POSConstants.CANCEL);
        btnCancel.setFocusable(false);
        btnCancel.addActionListener(this);
        JPanel footerPanel = new JPanel((LayoutManager)new MigLayout("center,ins 0 5 5 5", "", ""));
        PosButton btnEdit = new PosButton();
        PosButton btnAdd = new PosButton();
        btnAdd.setText(POSConstants.ADD);
        btnEdit.setText(POSConstants.EDIT);
        btnEdit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RecipeSelectionDialog.this.editSelectedRow();
            }
        });
        btnAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    Recepie menuRecepie = new Recepie();
                    RecipeEntryForm editor = new RecipeEntryForm(menuRecepie);
                    BeanEditorDialog dialog = new BeanEditorDialog((Frame)POSUtil.getBackOfficeWindow(), (BeanEditor)editor);
                    dialog.setPreferredSize(PosUIManager.getSize(900, 650));
                    dialog.open();
                    if (dialog.isCanceled()) {
                        return;
                    }
                    Recepie recipeItem = (Recepie)editor.getBean();
                    RecipeSelectionDialog.this.itemSelectorPanel.getModel().addRow(recipeItem);
                }
                catch (Throwable x) {
                    BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, x);
                }
            }
        });
        footerPanel.add(btnAdd);
        footerPanel.add(btnEdit);
        footerPanel.add(btnOk);
        footerPanel.add(btnCancel);
        this.add((Component)footerPanel, "South");
        this.add(contentPane);
    }

    public void setParentRecepie(Recepie selectedRecepie, boolean editMode) {
        this.itemSelectorPanel.setParentRecepie(selectedRecepie, editMode);
    }

    public void setSelectionMode(int selectionMode) {
        this.selectionMode = selectionMode;
        if (selectionMode == 0) {
            this.titelpanel.setTitle(InvMessages.getString("IVRSD.12"));
        } else {
            this.titelpanel.setTitle(InvMessages.getString("IVRSD.13"));
        }
        this.itemSelectorPanel.setSelectionMode(selectionMode);
    }

    private void doOk() {
        if (this.selectionMode == 0) {
            Recepie recipe = this.getSelectedRowData();
            if (recipe == null) {
                POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), InvMessages.getString("IVRSD.14"));
                return;
            }
        } else {
            List<Recepie> menuRecepies = this.itemSelectorPanel.getSelectedRecepieList();
            if (menuRecepies == null || menuRecepies.isEmpty()) {
                POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), InvMessages.getString("IVRSD.14"));
                return;
            }
        }
        this.setCanceled(false);
        this.dispose();
    }

    private void doCancel() {
        this.setCanceled(true);
        this.dispose();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String actionCommand = e.getActionCommand();
        if (POSConstants.CANCEL.equalsIgnoreCase(actionCommand)) {
            this.doCancel();
        } else if (POSConstants.OK.equalsIgnoreCase(actionCommand)) {
            this.doOk();
        }
    }

    private void editSelectedRow() {
        try {
            int index = this.itemSelectorPanel.getSelectedRow();
            if (index < 0) {
                return;
            }
            Recepie recipe = this.itemSelectorPanel.getModel().getRow(index);
            this.itemSelectorPanel.getModel().setRow(index, recipe);
            RecipeEntryForm editor = new RecipeEntryForm(recipe);
            BeanEditorDialog dialog = new BeanEditorDialog((Frame)POSUtil.getBackOfficeWindow(), (BeanEditor)editor);
            dialog.openWithScale(800, 700);
            if (dialog.isCanceled()) {
                return;
            }
            this.itemSelectorPanel.repaintTable();
        }
        catch (Throwable x) {
            BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, x);
        }
    }

    public List<Recepie> getSelectedItems() {
        return this.itemSelectorPanel.getSelectedRecepieList();
    }

    public Recepie getSelectedRowData() {
        int index = this.itemSelectorPanel.getSelectedRow();
        if (index < 0) {
            return null;
        }
        return this.itemSelectorPanel.getModel().getRow(index);
    }

    public static RecipeSelectionDialog getInstance() {
        if (instance == null) {
            instance = new RecipeSelectionDialog();
        }
        return instance;
    }
}

