/*
 * Decompiled with CFR 0.152.
 */
package com.orostock.inventory.ui.recepie;

import com.floreantpos.POSConstants;
import com.floreantpos.bo.ui.BOMessageDialog;
import com.floreantpos.bo.ui.CustomCellRenderer;
import com.floreantpos.model.RecipeTable;
import com.floreantpos.model.dao.RecipeTableDAO;
import com.floreantpos.swing.BeanTableModel;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.TransparentPanel;
import com.floreantpos.ui.BeanEditor;
import com.floreantpos.ui.dialog.BeanEditorDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.POSUtil;
import com.orostock.inventory.InvMessages;
import com.orostock.inventory.ui.recepie.RecipeTableEntryForm;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.table.TableCellRenderer;
import net.miginfocom.swing.MigLayout;
import org.jdesktop.swingx.JXTable;

public class RecipeTableExplorer
extends TransparentPanel {
    private JXTable table;
    private BeanTableModel<RecipeTable> tableModel;
    private JTextField tfRecipeName = new JTextField(20);

    public RecipeTableExplorer() {
        this.tableModel = new BeanTableModel(RecipeTable.class);
        this.tableModel.addColumn("ITEM NAME", RecipeTable.PROP_MENU_ITEM);
        this.tableModel.addColumn("RECEPIE", "recipeList");
        this.tableModel.addRows(RecipeTableDAO.getInstance().findAll());
        this.table = new JXTable(this.tableModel);
        this.table.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent me) {
                if (me.getClickCount() == 2) {
                    RecipeTableExplorer.this.editSelectedRow();
                }
            }
        });
        this.table.setRowHeight(PosUIManager.getSize(30));
        this.table.setDefaultRenderer(Object.class, (TableCellRenderer)new CustomCellRenderer());
        this.setLayout(new BorderLayout(5, 5));
        this.add(new JScrollPane((Component)this.table));
        JPanel topSearchPanel = new JPanel((LayoutManager)new MigLayout());
        topSearchPanel.add(new JLabel(InvMessages.getString("IVRTE.0")));
        topSearchPanel.add(this.tfRecipeName);
        this.tfRecipeName.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RecipeTableExplorer.this.doSearchItems();
            }
        });
        JButton btnSearch = new JButton(POSConstants.SEARCH_ITEM_BUTTON_TEXT);
        btnSearch.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RecipeTableExplorer.this.doSearchItems();
            }
        });
        topSearchPanel.add(btnSearch);
        this.add((Component)topSearchPanel, "North");
        this.addButtonPanel();
    }

    private void doSearchItems() {
        List<RecipeTable> items = RecipeTableDAO.getInstance().findRecipeTables(this.tfRecipeName.getText());
        this.tableModel.setRows(items);
    }

    private void addButtonPanel() {
        JButton addButton = new JButton(POSConstants.ADD);
        addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    RecipeTableEntryForm editor = new RecipeTableEntryForm(new RecipeTable());
                    BeanEditorDialog dialog = new BeanEditorDialog((Frame)POSUtil.getBackOfficeWindow(), (BeanEditor)editor);
                    dialog.openWithScale(600, 550);
                    if (dialog.isCanceled()) {
                        return;
                    }
                    RecipeTable recipe = (RecipeTable)editor.getBean();
                    RecipeTableExplorer.this.tableModel.addRow(recipe);
                }
                catch (Exception x) {
                    BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, x);
                }
            }
        });
        JButton editButton = new JButton(POSConstants.EDIT);
        editButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RecipeTableExplorer.this.editSelectedRow();
            }
        });
        JButton deleteButton = new JButton(POSConstants.DELETE);
        deleteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    int index = RecipeTableExplorer.this.table.getSelectedRow();
                    if (index < 0) {
                        return;
                    }
                    index = RecipeTableExplorer.this.table.convertRowIndexToModel(index);
                    RecipeTable orderType = (RecipeTable)RecipeTableExplorer.this.tableModel.getRow(index);
                    if (POSMessageDialog.showYesNoQuestionDialog(POSUtil.getBackOfficeWindow(), POSConstants.CONFIRM_DELETE, POSConstants.DELETE) != 0) {
                        return;
                    }
                    RecipeTableDAO dao = new RecipeTableDAO();
                    dao.delete(orderType);
                    RecipeTableExplorer.this.tableModel.removeRow(index);
                }
                catch (Exception x) {
                    BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, x);
                }
            }
        });
        TransparentPanel panel = new TransparentPanel();
        panel.add(addButton);
        panel.add(editButton);
        panel.add(deleteButton);
        this.add((Component)panel, "South");
    }

    private void editSelectedRow() {
        try {
            int index = this.table.getSelectedRow();
            if (index < 0) {
                return;
            }
            index = this.table.convertRowIndexToModel(index);
            RecipeTable recipeTable = this.tableModel.getRow(index);
            RecipeTableEntryForm editor = new RecipeTableEntryForm(recipeTable);
            BeanEditorDialog dialog = new BeanEditorDialog((Frame)POSUtil.getBackOfficeWindow(), (BeanEditor)editor);
            dialog.openWithScale(600, 550);
            if (dialog.isCanceled()) {
                return;
            }
            this.table.repaint();
        }
        catch (Throwable x) {
            BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, x);
        }
    }
}

