/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.actions;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.actions.PosAction;
import com.floreantpos.customer.CustomerSelectorDialog;
import com.floreantpos.customer.CustomerSelectorFactory;
import com.floreantpos.main.Application;
import com.floreantpos.model.Customer;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.dao.ActionHistoryDAO;
import com.floreantpos.model.dao.TicketDAO;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.views.order.actions.DataChangeListener;
import org.hibernate.StaleStateException;

public class CustomerSelectionAction
extends PosAction {
    private Ticket ticket;

    public CustomerSelectionAction() {
        super(POSConstants.ORDER_INFO);
    }

    public CustomerSelectionAction(Ticket ticket) {
        super(POSConstants.ORDER_INFO);
        this.ticket = ticket;
    }

    public CustomerSelectionAction(DataChangeListener listener) {
        super(POSConstants.ORDER_INFO_BUTTON_TEXT, listener);
    }

    public void setTicket(Ticket ticket) {
        this.ticket = ticket;
    }

    public Ticket getTicket() {
        return this.ticket;
    }

    @Override
    public void execute() {
        try {
            if (this.listener != null) {
                Object selectedObject = this.getSelectedObject();
                if (selectedObject == null) {
                    return;
                }
                if (selectedObject instanceof Ticket) {
                    this.ticket = (Ticket)selectedObject;
                }
            }
            if (this.ticket == null) {
                return;
            }
            if (this.ticket.isPaid().booleanValue()) {
                POSMessageDialog.showMessage(Application.getPosWindow(), Messages.getString("CustomerSelectionAction.0"));
                return;
            }
            if (this.ticket.isVoided().booleanValue()) {
                POSMessageDialog.showMessage(Application.getPosWindow(), POSConstants.TICKET_IS_VOIDED);
                return;
            }
            CustomerSelectorDialog dialog = CustomerSelectorFactory.createCustomerSelectorDialog(this.ticket.getOrderType());
            dialog.setCreateNewTicket(false);
            if (this.ticket != null) {
                dialog.setTicket(this.ticket);
            }
            dialog.openUndecoratedFullScreen();
            if (dialog.isCanceled()) {
                return;
            }
            TicketDAO.getInstance().loadFullTicket(this.ticket);
            Customer selectedCustomer = dialog.getSelectedCustomer();
            this.ticket.setCustomer(selectedCustomer);
            TicketDAO.getInstance().saveOrUpdate(this.ticket);
            CustomerSelectionAction.logJournal(this.ticket, selectedCustomer);
            if (this.listener != null) {
                this.listener.dataChanged(this.ticket);
            }
        }
        catch (StaleStateException x) {
            POSMessageDialog.showError(Application.getPosWindow(), Messages.getString("OrderView.0"));
            return;
        }
        catch (Exception e) {
            POSMessageDialog.showError(Application.getPosWindow(), Messages.getString("CustomerSelectionAction.1"), e);
            return;
        }
    }

    public static void logJournal(Ticket ticket, Customer selectedCustomer) {
        ActionHistoryDAO.saveHistory(ticket, "Customer set", "Customer id: " + (selectedCustomer == null ? null : selectedCustomer.getId()));
    }
}

