/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.actions;

import com.floreantpos.Messages;
import com.floreantpos.PrinterIsNotConfiguredException;
import com.floreantpos.actions.PosAction;
import com.floreantpos.config.TerminalConfig;
import com.floreantpos.main.Application;
import com.floreantpos.model.CashDrawer;
import com.floreantpos.model.Currency;
import com.floreantpos.model.DrawerType;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.User;
import com.floreantpos.model.UserPermission;
import com.floreantpos.model.dao.CashDrawerDAO;
import com.floreantpos.model.dao.TerminalDAO;
import com.floreantpos.model.ext.DeviceType;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.print.PosPrintService;
import com.floreantpos.services.report.CashDrawerReportService;
import com.floreantpos.ui.dialog.CashReconciliationDialog;
import com.floreantpos.ui.dialog.MultiCurrencyAmountSelectionDialog;
import com.floreantpos.ui.dialog.NumberSelectionDialog2;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.dialog.UserListDialog;
import com.floreantpos.util.CurrencyUtil;
import com.floreantpos.util.DrawerUtil;
import com.floreantpos.util.NumberUtil;
import com.floreantpos.util.POSUtil;
import java.util.Date;
import java.util.List;

public class DrawerAssignmentAction
extends PosAction {
    private Terminal terminal;
    private User responsibleUser;

    public DrawerAssignmentAction(Terminal terminal, User responsibleUser) {
        super(Messages.getString("DrawerAssignmentAction.0"), UserPermission.DRAWER_ASSIGNMENT);
        this.terminal = terminal;
        this.responsibleUser = responsibleUser;
        this.updateActionText();
    }

    public void updateActionText() {
        if (this.terminal.isCashDrawerAssigned()) {
            this.putValue("Name", Messages.getString("DrawerAssignmentAction.12"));
        } else {
            this.putValue("Name", Messages.getString("DrawerAssignmentAction.2"));
        }
    }

    @Override
    public void execute() throws Exception {
        boolean thisDrawerTerminal;
        TerminalDAO.getInstance().refresh(this.terminal);
        if (this.terminal.isCashDrawerAssigned()) {
            int option = POSMessageDialog.showYesNoQuestionDialog(POSUtil.getFocusedWindow(), Messages.getString("DrawerAssignmentAction.13"), Messages.getString("CONFIRM"));
            if (option != 0) {
                return;
            }
            this.performDrawerClose();
        } else {
            if (this.terminal.getDeviceType().intValue() == DeviceType.ANDROID.getDeviceType()) {
                POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("DrawerAssignmentAction.15"));
                return;
            }
            this.performAssignment();
        }
        boolean bl = thisDrawerTerminal = Application.getInstance().getTerminal().getId().intValue() == this.terminal.getId().intValue();
        if (thisDrawerTerminal) {
            Application.getInstance().refreshAndGetTerminal();
        }
    }

    public void performAssignment() throws Exception {
        DrawerUtil.kickDrawer();
        UserListDialog dialog = new UserListDialog();
        dialog.pack();
        dialog.open();
        if (dialog.isCanceled()) {
            return;
        }
        User assignToUser = dialog.getSelectedUser();
        if (!assignToUser.isClockedIn().booleanValue()) {
            POSMessageDialog.showError(Messages.getString("DrawerAssignmentAction.16"));
            return;
        }
        CashDrawer cashDrawer = new CashDrawer();
        double drawerBalance = TerminalConfig.getDeafultDrawerAmount();
        List<Currency> currencyList = CurrencyUtil.getAllCurrency();
        if (this.terminal.isEnableMultiCurrency().booleanValue() && currencyList.size() > 1) {
            MultiCurrencyAmountSelectionDialog multiCurrencyDialog = new MultiCurrencyAmountSelectionDialog(cashDrawer, drawerBalance, currencyList);
            multiCurrencyDialog.pack();
            multiCurrencyDialog.open();
            if (multiCurrencyDialog.isCanceled()) {
                POSMessageDialog.showError(Messages.getString("DrawerAssignmentAction.17"));
                return;
            }
            drawerBalance = multiCurrencyDialog.getTotalAmount();
        } else {
            String dialogTitle;
            String message = Messages.getString("DrawerAssignmentAction.6");
            drawerBalance = NumberSelectionDialog2.takeDoubleInput(message, dialogTitle = Messages.getString("DrawerAssignmentAction.7"), drawerBalance);
            if (Double.isNaN(drawerBalance)) {
                POSMessageDialog.showError(Messages.getString("DrawerAssignmentAction.18"));
                return;
            }
        }
        this.terminal.setAssignedUser(assignToUser);
        cashDrawer.setStartTime(new Date());
        cashDrawer.setAssignedUser(assignToUser);
        cashDrawer.setTerminal(this.terminal);
        cashDrawer.setStoreSession(DataProvider.get().getStoreSession());
        cashDrawer.setDrawerType(DrawerType.DRAWER);
        cashDrawer.setBeginCash(drawerBalance);
        cashDrawer.setAssignedBy(this.responsibleUser);
        this.terminal.setCurrentCashDrawer(cashDrawer);
        CashDrawerDAO.getInstance().saveDrawerAssignment(cashDrawer, this.terminal);
        POSMessageDialog.showMessage(Messages.getString("DrawerAssignmentAction.8") + " " + assignToUser.getFullName());
        this.updateActionText();
    }

    public void performDrawerClose() throws Exception {
        DrawerUtil.kickDrawer();
        CashDrawer cashDrawer = this.terminal.getCurrentCashDrawer();
        CashDrawerReportService reportService = new CashDrawerReportService(cashDrawer);
        reportService.populateReport();
        Double cashToDeposit = 0.0;
        Application application = Application.getInstance();
        if (application.getStore().isUseDetailedReconciliation().booleanValue()) {
            CashReconciliationDialog dialog = new CashReconciliationDialog(cashDrawer);
            dialog.pack();
            dialog.open();
            if (dialog.isCanceled()) {
                return;
            }
            cashToDeposit = dialog.getTotalReconcilieAmount();
        } else if (application.getTerminal().isEnableMultiCurrency().booleanValue()) {
            MultiCurrencyAmountSelectionDialog multiCurrencyDialog = new MultiCurrencyAmountSelectionDialog(cashDrawer, cashDrawer.getDrawerAccountable(), CurrencyUtil.getAllCurrency());
            multiCurrencyDialog.setTitle(Messages.getString("DrawerAssignmentAction.20"));
            multiCurrencyDialog.setCaption(Messages.getString("DrawerAssignmentAction.20"));
            multiCurrencyDialog.setReconcile(true);
            multiCurrencyDialog.pack();
            multiCurrencyDialog.open();
            if (multiCurrencyDialog.isCanceled()) {
                return;
            }
            cashToDeposit = multiCurrencyDialog.getTotalAmount();
        } else {
            cashToDeposit = this.getReconcileAmount(cashDrawer);
            if (cashToDeposit.isNaN()) {
                return;
            }
        }
        cashDrawer.setCashToDeposit(cashToDeposit);
        TerminalDAO dao = new TerminalDAO();
        dao.resetCashDrawer(cashDrawer, this.terminal, this.responsibleUser, 0.0);
        if (this.terminal.isEnableMultiCurrency().booleanValue()) {
            // empty if block
        }
        try {
            PosPrintService.printDrawerPullReport(cashDrawer);
        }
        catch (PrinterIsNotConfiguredException printerIsNotConfiguredException) {
            // empty catch block
        }
        POSMessageDialog.showMessage(Messages.getString("DrawerAssignmentAction.10"));
        this.updateActionText();
    }

    private Double getReconcileAmount(CashDrawer report) {
        Double reconcileAmount = NumberSelectionDialog2.takeDoubleInput(Messages.getString("DrawerAssignmentAction.22"), Messages.getString("DrawerAssignmentAction.22"), NumberUtil.roundToTwoDigit(report.getDrawerAccountable()));
        if (Double.isNaN(reconcileAmount)) {
            return Double.NaN;
        }
        if (reconcileAmount < report.getDrawerAccountable()) {
            if (POSMessageDialog.showYesNoQuestionDialog(POSUtil.getFocusedWindow(), Messages.getString("DrawerAssignmentAction.24"), Messages.getString("CONFIRM")) == 0) {
                return reconcileAmount;
            }
            return this.getReconcileAmount(report);
        }
        return reconcileAmount;
    }
}

