/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.actions;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosLog;
import com.floreantpos.actions.PosAction;
import com.floreantpos.main.Application;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.TicketItem;
import com.floreantpos.model.dao.TicketDAO;
import com.floreantpos.report.ReceiptPrintService;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.dialog.ReorderDialog;
import com.floreantpos.ui.views.order.OrderController;
import com.floreantpos.ui.views.order.actions.DataChangeListener;
import com.floreantpos.util.POSUtil;
import java.util.List;

public class ItemReorderAction
extends PosAction {
    private Ticket ticket;

    public ItemReorderAction(Ticket ticket) {
        this.ticket = ticket;
    }

    public ItemReorderAction(DataChangeListener listener) {
        super(Messages.getString("ItemReorderAction.0"), listener);
    }

    @Override
    public void execute() {
        try {
            if (this.listener != null) {
                Object selectedObject = this.getSelectedObject();
                if (selectedObject == null) {
                    return;
                }
                if (selectedObject instanceof Ticket) {
                    this.ticket = (Ticket)selectedObject;
                }
            }
            this.ticket = TicketDAO.getInstance().loadFullTicket(this.ticket.getId());
            Ticket cloneTicket = Ticket.clone(this.ticket);
            if (cloneTicket.getTicketItems().size() == 0) {
                POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("ItemReorderAction.1"));
                return;
            }
            ReorderDialog dialog = new ReorderDialog(cloneTicket);
            dialog.setTitle(Messages.getString("ItemReorderAction.2"));
            dialog.setDefaultCloseOperation(2);
            dialog.setSize(PosUIManager.getSize(1024, 650));
            dialog.open();
            if (dialog.isCanceled()) {
                return;
            }
            List<TicketItem> ticketItemList = dialog.getTicketItems();
            if (ticketItemList == null) {
                return;
            }
            for (TicketItem ticketItem : ticketItemList) {
                ticketItem.setTicket(this.ticket);
                this.ticket.addToticketItems(ticketItem);
            }
            this.ticket.calculatePrice();
            OrderController.saveOrder(this.ticket);
            if (this.ticket.getOrderType().isShouldPrintToKitchen().booleanValue() && this.ticket.needsKitchenPrint()) {
                ReceiptPrintService.printToKitchen(this.ticket);
                POSMessageDialog.showMessage(Messages.getString("ItemReorderAction.3"));
            }
        }
        catch (Exception e) {
            PosLog.error(this.getClass(), e);
            POSMessageDialog.showError(Application.getPosWindow(), POSConstants.ERROR_MESSAGE, e);
        }
    }
}

