/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.actions;

import com.floreantpos.Messages;
import com.floreantpos.actions.PosAction;
import com.floreantpos.model.Customer;
import com.floreantpos.model.ShopSeat;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.TicketItem;
import com.floreantpos.model.TicketItemSeat;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.ui.floorplan.SeatSelectionDialog;
import com.floreantpos.ui.views.order.OrderView;
import com.floreantpos.ui.views.order.TicketView;
import java.util.ArrayList;
import java.util.List;

public class SeatSelectionAction
extends PosAction {
    public SeatSelectionAction() {
        super(Messages.getString("OrderView.3"));
    }

    public void setSource(PosButton btnSeat) {
    }

    @Override
    public void execute() {
        this.doAddSeatNumber();
    }

    protected void doAddSeatNumber() {
        Ticket currentTicket = OrderView.getInstance().getCurrentTicket();
        SeatSelectionDialog seatDialog = new SeatSelectionDialog(currentTicket);
        seatDialog.setTitle(Messages.getString("SeatSelectionAction.2"));
        seatDialog.setSize(PosUIManager.getSize(900, 650));
        seatDialog.open();
        if (seatDialog.isCanceled()) {
            return;
        }
        ShopSeat seat = seatDialog.getSeat();
        this.doAddSeatTreatTicketItem(seat, currentTicket, true);
    }

    private void doAddSeatTreatTicketItem(ShopSeat seat, Ticket currentTicket, boolean createNewSeat) {
        TicketItem ticketItem = this.getLastSeatTicketItem(currentTicket);
        boolean itemFound = true;
        if (ticketItem == null) {
            itemFound = false;
            ticketItem = new TicketItem();
        }
        if (seat == null) {
            ticketItem.setName(Messages.getString("SeatSelectionAction.3"));
            ticketItem.setSeat(null);
        } else {
            ticketItem.setName(seat.getSeatNumberWithTableName(currentTicket));
            TicketItemSeat ticketItemSeat = this.getTicketItemSeat(seat.getId(), currentTicket);
            if (ticketItemSeat == null) {
                ticketItemSeat = seat.convertTicketItemSeat();
            }
            Customer member = seat.getMember();
            if (ticketItemSeat.getMemberId() == null && member != null) {
                ticketItemSeat.setMember(member);
            }
            ticketItem.setSeat(ticketItemSeat);
        }
        ticketItem.setShouldPrintToKitchen(true);
        ticketItem.setTreatAsSeat(true);
        ticketItem.setTicket(currentTicket);
        TicketView ticketView = OrderView.getInstance().getTicketView();
        if (!itemFound) {
            ticketView.addTicketItem(ticketItem);
        } else {
            ticketView.updateView();
        }
    }

    private TicketItemSeat getTicketItemSeat(String seatId, Ticket currentTicket) {
        TicketItemSeat lastSeat = (TicketItemSeat)this.getLastSeat(currentTicket);
        if (lastSeat != null && lastSeat.getId() != null && lastSeat.getId().equals(seatId)) {
            return lastSeat;
        }
        return null;
    }

    private TicketItem getLastSeatTicketItem(Ticket currentTicket) {
        TicketItem lastTicketItem;
        List<TicketItem> ticketItems = currentTicket.getTicketItems();
        if (ticketItems != null && !ticketItems.isEmpty() && (lastTicketItem = ticketItems.get(ticketItems.size() - 1)).isTreatAsSeat().booleanValue()) {
            return lastTicketItem;
        }
        return null;
    }

    public Object getLastSeat(Ticket currentTicket) {
        TicketItem lastTicketItem;
        TicketItemSeat lastSeat = null;
        List<TicketItem> ticketItems = currentTicket.getTicketItems();
        if (ticketItems != null && !ticketItems.isEmpty() && (lastTicketItem = ticketItems.get(ticketItems.size() - 1)).getSeat() != null) {
            lastSeat = lastTicketItem.getSeat();
        }
        return lastSeat;
    }

    public boolean updateSeatNumber(TicketItem ticketItem) {
        SeatSelectionDialog seatDialog = new SeatSelectionDialog(ticketItem.getTicket(), ticketItem.getSeat());
        seatDialog.setTitle(Messages.getString("SeatSelectionAction.5"));
        seatDialog.setSize(PosUIManager.getSize(900, 650));
        seatDialog.open();
        if (seatDialog.isCanceled()) {
            return false;
        }
        ShopSeat seat = seatDialog.getSeat();
        if (seat == null) {
            ticketItem.setName(Messages.getString("SeatSelectionAction.6"));
            ticketItem.setSeat(null);
        } else {
            ticketItem.setName(seat.getSeatNumberWithTableName(ticketItem.getTicket()));
            TicketItemSeat ticketItemSeat = this.getTicketItemSeat(seat.getId(), ticketItem.getTicket());
            if (ticketItemSeat == null) {
                ticketItemSeat = seat.convertTicketItemSeat();
            }
            ticketItemSeat.setMember(seat.getMember());
            ticketItem.setSeat(ticketItemSeat);
        }
        this.updateTicketItemsSeatNumber(ticketItem);
        return true;
    }

    protected List<TicketItemSeat> getSeatNumbers(Ticket ticket) {
        ArrayList<TicketItemSeat> ticketItemSeats = new ArrayList<TicketItemSeat>();
        for (TicketItem ticketItem : ticket.getTicketItems()) {
            if (!ticketItem.isTreatAsSeat().booleanValue() || ticketItemSeats.contains(ticketItem.getSeat())) continue;
            ticketItemSeats.add(ticketItem.getSeat());
        }
        return ticketItemSeats;
    }

    private void updateTicketItemsSeatNumber(TicketItem ticketItem) {
        boolean updateSeatNumber = false;
        for (TicketItem item : ticketItem.getTicket().getTicketItems()) {
            if (item == ticketItem) {
                updateSeatNumber = true;
                continue;
            }
            if (!updateSeatNumber) continue;
            if (item.isTreatAsSeat().booleanValue()) break;
            item.setSeat(ticketItem.getSeat());
        }
    }

    public Object getSelectedSeatNumber() {
        Ticket currentTicket = OrderView.getInstance().getCurrentTicket();
        List<TicketItem> ticketItems = currentTicket.getTicketItems();
        if (ticketItems != null && !ticketItems.isEmpty()) {
            TicketItem lastTicketItem = ticketItems.get(ticketItems.size() - 1);
            return lastTicketItem.getSeat();
        }
        return null;
    }
}

