/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.actions;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosException;
import com.floreantpos.actions.PosAction;
import com.floreantpos.main.Application;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.TicketItem;
import com.floreantpos.model.dao.ActionHistoryDAO;
import com.floreantpos.model.dao.TicketDAO;
import com.floreantpos.services.SplitTicketService;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.ui.RefreshableView;
import com.floreantpos.ui.dialog.NumberSelectionDialog2;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.views.ManuallySplitTicketDialog;
import com.floreantpos.ui.views.SplitTypeSelectionDialog;
import com.floreantpos.ui.views.order.actions.DataChangeListener;
import com.floreantpos.ui.views.payment.SplitedTicketSelectionDialog;
import com.floreantpos.util.CopyUtil;
import com.floreantpos.util.POSUtil;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.hibernate.Hibernate;

public class SplitTicketAction
extends PosAction {
    private Ticket ticket;
    private boolean allowCustomerSelection = true;
    private RefreshableView refreshableView;

    public SplitTicketAction() {
        super(POSConstants.SPLIT_TICKET);
    }

    public SplitTicketAction(boolean allowCustomerSelection) {
        super(POSConstants.SPLIT_TICKET);
        this.allowCustomerSelection = allowCustomerSelection;
    }

    public SplitTicketAction(DataChangeListener listener) {
        super(POSConstants.SPLIT_TICKET_BUTTON_TEXT, listener);
    }

    public SplitTicketAction(DataChangeListener listener, boolean allowCustomerSelection) {
        super(POSConstants.SPLIT_TICKET_BUTTON_TEXT, listener);
        this.allowCustomerSelection = allowCustomerSelection;
    }

    public SplitTicketAction(Ticket ticket) {
        super(POSConstants.SPLIT_TICKET);
        this.ticket = ticket;
    }

    public void setTicket(Ticket ticket) {
        this.ticket = ticket;
    }

    public Ticket getTicket() {
        return this.ticket;
    }

    @Override
    public void execute() {
        try {
            int option;
            if (this.listener != null) {
                Object selectedObject = this.getSelectedObject();
                if (selectedObject == null) {
                    return;
                }
                if (selectedObject instanceof Ticket) {
                    this.ticket = (Ticket)selectedObject;
                }
            }
            if (this.ticket == null) {
                return;
            }
            if (this.ticket.isVoided().booleanValue()) {
                POSMessageDialog.showMessage(Application.getPosWindow(), POSConstants.TICKET_IS_VOIDED);
                return;
            }
            if (!this.hasPermissionToAccessTicket(this.ticket)) {
                return;
            }
            if (this.ticket.hasGratuity() && (option = POSMessageDialog.showYesNoQuestionDialog("The ticket contains gratuity which will be applied to original ticket only.\nDo you wish to continue?")) != 0) {
                return;
            }
            if (!(!StringUtils.isNotEmpty((String)this.ticket.getId()) || Hibernate.isInitialized(this.ticket.getTicketItems()) && Hibernate.isInitialized(this.ticket.getTransactions()))) {
                this.ticket = TicketDAO.getInstance().loadFullTicket(this.ticket.getId());
            }
            Ticket cloneTicket = (Ticket)CopyUtil.deepCopy(this.ticket);
            cloneTicket.setExtraProperties(this.ticket.getExtraProperties());
            if (cloneTicket.getPaidAmount() > 0.0) {
                POSMessageDialog.showMessage(Application.getPosWindow(), Messages.getString("SplitTicketAction.2"));
                return;
            }
            if (this.hasTicketItemDiscount(cloneTicket) && POSMessageDialog.showYesNoQuestionDialog(POSUtil.getFocusedWindow(), Messages.getString("SplitTicketAction.8"), POSConstants.CONFIRM) != 0) {
                return;
            }
            SplitTypeSelectionDialog dialog = new SplitTypeSelectionDialog(cloneTicket);
            dialog.pack();
            dialog.open();
            if (dialog.isCanceled()) {
                return;
            }
            int splitType = dialog.getSelectedSplitType();
            List<Ticket> splitTickets = this.doSplitTicket(splitType, cloneTicket);
            if (splitTickets == null) {
                return;
            }
            boolean ticketSplited = false;
            for (Ticket ticket : splitTickets) {
                if (!StringUtils.isNotEmpty((String)ticket.getId())) continue;
                ticketSplited = true;
            }
            if (!ticketSplited) {
                cloneTicket = this.ticket;
            }
            if (this.listener != null) {
                this.listener.dataChanged(cloneTicket);
            }
        }
        catch (PosException e) {
            POSMessageDialog.showError(Application.getPosWindow(), e.getMessage());
        }
        catch (Exception e) {
            POSMessageDialog.showError(Application.getPosWindow(), POSConstants.ERROR_MESSAGE, e);
        }
    }

    private boolean hasTicketItemDiscount(Ticket newTicket) {
        for (TicketItem ticketItem : newTicket.getTicketItems()) {
            if (ticketItem.getDiscounts() == null || ticketItem.getDiscounts().size() <= 0) continue;
            return true;
        }
        return false;
    }

    private List<Ticket> doSplitTicket(int splitType, Ticket ticket) throws Exception {
        if (!this.hasTicketItems(ticket)) {
            POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("SplitTicketAction.9"));
            return null;
        }
        List<Ticket> splitTickets = null;
        if (splitType == 0) {
            NumberSelectionDialog2 numberDialog = new NumberSelectionDialog2();
            numberDialog.setTitle(Messages.getString("SplitTicketAction.3"));
            numberDialog.pack();
            numberDialog.open();
            if (numberDialog.isCanceled()) {
                return null;
            }
            int splitQuantity = (int)numberDialog.getValue();
            if (splitQuantity > 0) {
                this.removeSeat(ticket);
                splitTickets = SplitTicketService.doEquallySplit(ticket, splitQuantity);
            }
        } else if (splitType == 1) {
            splitTickets = SplitTicketService.doSplitBySeatNumber(ticket);
        } else {
            this.removeSeat(ticket);
            NumberSelectionDialog2 numberDialog = new NumberSelectionDialog2();
            numberDialog.setTitle(Messages.getString("SplitTicketAction.3"));
            numberDialog.pack();
            numberDialog.open();
            if (numberDialog.isCanceled()) {
                return null;
            }
            int splitQuantity = (int)numberDialog.getValue();
            if (splitQuantity <= 1) {
                POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("SplitTicketAction.10"));
                return null;
            }
            ManuallySplitTicketDialog dialog = new ManuallySplitTicketDialog();
            dialog.allowCustomerSelection(this.allowCustomerSelection);
            dialog.setTicket(ticket, splitQuantity);
            dialog.open();
            if (dialog.isCanceled()) {
                if (StringUtils.isNotEmpty((String)ticket.getId())) {
                    ticket = TicketDAO.getInstance().loadFullTicket(ticket.getId());
                }
                return null;
            }
            splitTickets = dialog.getSplitTickets();
        }
        if (splitTickets == null || splitTickets.isEmpty() || splitTickets.size() == 1) {
            POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("SplitTicketAction.11"));
            return null;
        }
        if (!this.showSplitActionDialog(splitTickets)) {
            return null;
        }
        this.performSplitActionHistory(ticket, splitTickets);
        return splitTickets;
    }

    private void removeSeat(Ticket ticket) {
        List<TicketItem> ticketItems = ticket.getTicketItems();
        if (ticketItems != null) {
            Iterator<TicketItem> iterator = ticketItems.iterator();
            while (iterator.hasNext()) {
                TicketItem item = iterator.next();
                if (item.isTreatAsSeat().booleanValue()) {
                    iterator.remove();
                    item.setSeat(null);
                    continue;
                }
                item.setSeat(null);
                item.setSeatNumber(null);
            }
        }
    }

    private boolean showSplitActionDialog(List<Ticket> splitTickets) {
        SplitedTicketSelectionDialog posDialog = new SplitedTicketSelectionDialog(splitTickets);
        posDialog.setDefaultCloseOperation(2);
        posDialog.allowCustomerSelection(this.allowCustomerSelection);
        posDialog.setSize(PosUIManager.getSize(800, 600));
        posDialog.setRefreshableView(this.refreshableView);
        posDialog.setListener(this.listener);
        posDialog.open();
        return !posDialog.isCanceled();
    }

    private boolean hasTicketItems(Ticket ticket) {
        if (ticket.getTicketItems() == null || ticket.getTicketItems().isEmpty()) {
            return Boolean.FALSE;
        }
        for (TicketItem item : ticket.getTicketItems()) {
            if (item.isTreatAsSeat().booleanValue()) continue;
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    private void performSplitActionHistory(Ticket mainTicket, List<Ticket> splitTickets) {
        ActionHistoryDAO.addSplitTicketActionHistory(mainTicket, splitTickets);
    }

    public void setRefreshableView(RefreshableView refreshableView) {
        this.refreshableView = refreshableView;
    }

    public static void displayMaximumSplitQuantityEceeded() {
        POSMessageDialog.showError(POSUtil.getFocusedWindow(), String.format(Messages.getString("SplitTicketAction.1"), 100));
    }
}

