/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.actions;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosException;
import com.floreantpos.actions.PosAction;
import com.floreantpos.main.Application;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.dao.TicketDAO;
import com.floreantpos.services.TicketService;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.views.order.OrderView;
import com.floreantpos.ui.views.order.RootView;
import com.floreantpos.ui.views.order.actions.DataChangeListener;

public class TicketEditAction
extends PosAction {
    private Ticket ticket;

    public TicketEditAction() {
        super(POSConstants.EDIT_TICKET_BUTTON_TEXT);
    }

    public TicketEditAction(Ticket ticket) {
        super(POSConstants.EDIT_TICKET_BUTTON_TEXT);
        this.ticket = ticket;
    }

    public TicketEditAction(DataChangeListener listener) {
        super(POSConstants.EDIT_TICKET_BUTTON_TEXT, listener);
    }

    @Override
    public void execute() {
        try {
            Ticket ticket = this.geTicket();
            if (ticket == null) {
                return;
            }
            if (ticket.isVoided().booleanValue()) {
                POSMessageDialog.showMessage(Application.getPosWindow(), POSConstants.TICKET_IS_VOIDED);
                return;
            }
            if (!this.hasPermissionToAccessTicket(ticket)) {
                return;
            }
            Ticket ticketToEdit = TicketDAO.getInstance().loadFullTicket(ticket.getId());
            if (!OrderView.getInstance().isReturnMode() && ticketToEdit.isAnyItemCloudSynced()) {
                POSMessageDialog.showError(Application.getPosWindow(), Messages.getString("TicketEditAction.0"));
                return;
            }
            ticketToEdit.recalculatePaidAmount();
            if (ticketToEdit.isClosed().booleanValue()) {
                ticketToEdit.setClosed(false);
                ticketToEdit.setReOpened(true);
            }
            OrderView.getInstance().setCurrentTicket(ticketToEdit);
            RootView.getInstance().showView("ORDER_VIEW");
        }
        catch (PosException e) {
            POSMessageDialog.showError(Application.getPosWindow(), e.getMessage());
        }
        catch (Exception e) {
            POSMessageDialog.showError(Application.getPosWindow(), e.getMessage(), e);
        }
    }

    private Ticket geTicket() {
        if (this.ticket != null) {
            return this.ticket;
        }
        Object selectedObject = this.getSelectedObject();
        if (selectedObject == null) {
            return null;
        }
        if (selectedObject instanceof Ticket) {
            return (Ticket)selectedObject;
        }
        return TicketService.getTicket((String)selectedObject);
    }
}

