/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.actions;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosException;
import com.floreantpos.actions.PosAction;
import com.floreantpos.main.Application;
import com.floreantpos.model.PosTransaction;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.User;
import com.floreantpos.model.UserPermission;
import com.floreantpos.model.dao.ActionHistoryDAO;
import com.floreantpos.model.dao.TicketDAO;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.dialog.UserListDialog;
import com.floreantpos.ui.views.order.actions.DataChangeListener;
import com.floreantpos.util.POSUtil;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.hibernate.Session;
import org.hibernate.Transaction;

public class TicketTransferAction
extends PosAction {
    private Ticket ticket;
    private boolean isTransfered = false;
    private User currentUser;

    public TicketTransferAction() {
        super(Messages.getString("TicketTransferAction.0"));
    }

    public TicketTransferAction(Ticket ticket, User currentUser) {
        super(Messages.getString("TicketTransferAction.0"));
        this.ticket = ticket;
        this.currentUser = currentUser;
    }

    public TicketTransferAction(DataChangeListener listener) {
        super(Messages.getString("TicketTransferAction.0"), listener);
    }

    public void setTicket(Ticket ticket) {
        this.ticket = ticket;
    }

    public Ticket getTicket() {
        return this.ticket;
    }

    @Override
    public void execute() {
        try {
            User owner;
            if (this.listener != null) {
                Object selectedObject = this.getSelectedObject();
                if (selectedObject == null) {
                    return;
                }
                if (selectedObject instanceof Ticket) {
                    this.ticket = (Ticket)selectedObject;
                }
            }
            if (this.ticket == null) {
                return;
            }
            if (this.ticket.isClosed().booleanValue()) {
                POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), "Closed ticket cannot be transferred.");
                return;
            }
            if (this.ticket.isVoided().booleanValue()) {
                POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), POSConstants.TICKET_IS_VOIDED);
                return;
            }
            int option = POSMessageDialog.showYesNoQuestionDialog(POSUtil.getFocusedWindow(), Messages.getString("TicketTransferAction.3"), Messages.getString("TicketTransferAction.4"));
            if (option != 0) {
                return;
            }
            this.ticket = TicketDAO.getInstance().loadFullTicket(this.ticket.getId());
            User user = this.currentUser;
            if (user == null) {
                user = Application.getCurrentUser();
            }
            if (!user.equals(owner = this.ticket.getOwner()) && !user.hasPermission(UserPermission.TRANSFER_TICKET)) {
                POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("OrderInfoDialog.4") + this.ticket.getId());
                return;
            }
            User selectedUser = this.selectUserToTransfer(owner);
            if (selectedUser == null) {
                return;
            }
            TicketTransferAction.doTransferTickets(Application.getCurrentUser(), selectedUser, Arrays.asList(this.ticket));
            this.isTransfered = true;
            POSMessageDialog.showMessage(Messages.getString("TicketTransferAction.5"));
            if (this.listener != null) {
                this.listener.dataChanged(this.ticket);
            }
        }
        catch (PosException e) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), e.getMessage());
        }
        catch (Exception e) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), POSConstants.ERROR_MESSAGE, e);
        }
    }

    private User selectUserToTransfer(User owner) {
        UserListDialog dialog = new UserListDialog();
        dialog.hideUser(owner);
        dialog.setTitle(Messages.getString("UserTransferDialog.0"));
        dialog.setCaption(Messages.getString("UserTransferDialog.1"));
        dialog.setSize(PosUIManager.getSize(400, 600));
        dialog.open();
        if (dialog.isCanceled()) {
            return null;
        }
        User selectedUser = dialog.getSelectedUser();
        return selectedUser;
    }

    public static void doTransferTickets(User performer, User selectedUser, List<Ticket> tickets) {
        if (selectedUser == null || tickets == null) {
            return;
        }
        Transaction transaction = null;
        try (Session session = TicketDAO.getInstance().createNewSession();){
            transaction = session.beginTransaction();
            for (Ticket ticket : tickets) {
                User prevOwner = ticket.getOwner();
                ticket.setOwner(selectedUser);
                ticket.setShouldUpdateTableStatus(true);
                String currentCashDrawerId = null;
                if (selectedUser.isStaffBank().booleanValue() && selectedUser.isStaffBankStarted().booleanValue()) {
                    currentCashDrawerId = selectedUser.getCurrentCashDrawerId();
                } else {
                    Terminal terminal = Application.getInstance().getTerminal();
                    if (terminal != null) {
                        currentCashDrawerId = terminal.getCurrentCashDrawer().getId();
                    }
                }
                Set<PosTransaction> transactions = ticket.getTransactions();
                if (transactions != null) {
                    for (PosTransaction posTransaction : transactions) {
                        posTransaction.setCashDrawerId(currentCashDrawerId);
                        posTransaction.setUser(selectedUser);
                    }
                }
                TicketDAO.getInstance().saveOrUpdate(ticket, session);
                TicketTransferAction.saveJournal(performer, prevOwner, selectedUser, session, ticket);
            }
            transaction.commit();
        }
        catch (Exception e) {
            if (transaction != null) {
                transaction.rollback();
            }
            throw e;
        }
    }

    private static void saveJournal(User performer, User prevOwner, User newOwner, Session session, Ticket ticket) {
        StringBuilder sb = new StringBuilder();
        sb.append("Ticket: " + ticket.getId());
        sb.append(". From staff: " + prevOwner.getId() + "/" + prevOwner.getFirstName());
        sb.append(". To staff: " + newOwner.getId() + "/" + newOwner.getFirstName());
        ActionHistoryDAO.saveHistory(performer, ticket, null, "Transfer ticket", sb.toString(), session);
    }

    public boolean isTransfered() {
        return this.isTransfered;
    }
}

