/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.bo.actions;

import com.floreantpos.Messages;
import com.floreantpos.bo.ui.BackOfficeWindow;
import com.floreantpos.report.DiscountReportView;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.POSUtil;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JTabbedPane;

public class DiscountReportAction
extends AbstractAction {
    private static final String DISCOUNT_REPORT = Messages.getString("DiscountReportAction.0");

    public DiscountReportAction() {
        super(DISCOUNT_REPORT);
    }

    public DiscountReportAction(String name) {
        super(name);
    }

    public DiscountReportAction(String name, Icon icon) {
        super(name, icon);
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
        BackOfficeWindow backOfficeWindow = POSUtil.getBackOfficeWindow();
        try {
            JTabbedPane tabbedPane = backOfficeWindow.getTabbedPane();
            DiscountReportView reportView = null;
            int index = tabbedPane.indexOfTab(DISCOUNT_REPORT);
            if (index == -1) {
                reportView = new DiscountReportView();
                tabbedPane.addTab(DISCOUNT_REPORT, reportView);
            } else {
                reportView = (DiscountReportView)tabbedPane.getComponentAt(index);
            }
            tabbedPane.setSelectedComponent(reportView);
        }
        catch (Exception e) {
            POSMessageDialog.showError(backOfficeWindow, e.getMessage(), e);
        }
    }
}

