/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.bo.ui.explorer;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.bo.ui.BOMessageDialog;
import com.floreantpos.model.DayPart;
import com.floreantpos.model.Shift;
import com.floreantpos.model.dao.DayPartDAO;
import com.floreantpos.model.dao.ShiftDAO;
import com.floreantpos.swing.ListTableModel;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.TransparentPanel;
import com.floreantpos.ui.PosTableRenderer;
import com.floreantpos.ui.dialog.ConfirmDeleteDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.model.ShiftEntryDialog;
import com.floreantpos.util.POSUtil;
import com.floreantpos.util.ShiftUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import org.hibernate.exception.ConstraintViolationException;

public class BusinessHourExplorer
extends TransparentPanel {
    private JTable table;
    private ShiftTableModel tableModel;

    public BusinessHourExplorer() {
        List<DayPart> shifts = new DayPartDAO().findAll();
        this.tableModel = new ShiftTableModel(shifts);
        this.table = new JTable(this.tableModel);
        this.table.setRowHeight(PosUIManager.getSize(30));
        this.table.setDefaultRenderer(Object.class, new PosTableRenderer());
        this.setLayout(new BorderLayout(5, 5));
        this.add(new JScrollPane(this.table));
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent me) {
                if (me.getClickCount() == 2) {
                    this.editSelectedRow();
                }
            }

            private void editSelectedRow() {
                try {
                    int index = BusinessHourExplorer.this.table.getSelectedRow();
                    if (index < 0) {
                        return;
                    }
                    DayPart dayPart = (DayPart)BusinessHourExplorer.this.tableModel.getRowData(index);
                    ShiftEntryDialog dialog = new ShiftEntryDialog();
                    dialog.setShift(dayPart);
                    dialog.open();
                    if (dialog.isCanceled()) {
                        return;
                    }
                    BusinessHourExplorer.this.tableModel.updateItem(index);
                }
                catch (Throwable x) {
                    BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, x);
                }
            }
        });
        JButton addButton = new JButton(POSConstants.ADD);
        addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    ShiftEntryDialog dialog = new ShiftEntryDialog();
                    dialog.open();
                    if (dialog.isCanceled()) {
                        return;
                    }
                    DayPart shift = dialog.getShift();
                    BusinessHourExplorer.this.tableModel.addItem(shift);
                }
                catch (Exception x) {
                    BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, x);
                }
            }
        });
        JButton editButton = new JButton(POSConstants.EDIT);
        editButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    int index = BusinessHourExplorer.this.table.getSelectedRow();
                    if (index < 0) {
                        POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("BusinessHourExplorer.0"));
                        return;
                    }
                    DayPart shift = (DayPart)BusinessHourExplorer.this.tableModel.getRowData(index);
                    ShiftEntryDialog dialog = new ShiftEntryDialog();
                    dialog.setShift(shift);
                    dialog.open();
                    if (dialog.isCanceled()) {
                        return;
                    }
                    BusinessHourExplorer.this.tableModel.updateItem(index);
                }
                catch (Throwable x) {
                    BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, x);
                }
            }
        });
        JButton deleteButton = new JButton(POSConstants.DELETE);
        deleteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    int index = BusinessHourExplorer.this.table.getSelectedRow();
                    if (index < 0) {
                        POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("BusinessHourExplorer.1"));
                        return;
                    }
                    if (ConfirmDeleteDialog.showMessage(BusinessHourExplorer.this, POSConstants.CONFIRM_DELETE, POSConstants.DELETE) == 0) {
                        Shift shift = (Shift)BusinessHourExplorer.this.tableModel.getRowData(index);
                        ShiftDAO.getInstance().delete(shift);
                        BusinessHourExplorer.this.tableModel.deleteItem(index);
                    }
                }
                catch (ConstraintViolationException ex) {
                    BOMessageDialog.showError(POSConstants.SHIFT_ERROR, ex);
                }
                catch (Exception e2) {
                    BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, e2);
                }
            }
        });
        TransparentPanel panel = new TransparentPanel();
        panel.add(addButton);
        panel.add(editButton);
        panel.add(deleteButton);
        this.add((Component)panel, "South");
    }

    class ShiftTableModel
    extends ListTableModel {
        ShiftTableModel(List list) {
            super(new String[]{POSConstants.ID, POSConstants.NAME, POSConstants.START_TIME, POSConstants.END_TIME}, list);
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            DayPart shift = (DayPart)this.rows.get(rowIndex);
            switch (columnIndex) {
                case 0: {
                    return String.valueOf(shift.getId());
                }
                case 1: {
                    return shift.getName();
                }
                case 2: {
                    return ShiftUtil.buildShiftTimeRepresentation(shift.getStartTime());
                }
                case 3: {
                    return ShiftUtil.buildShiftTimeRepresentation(shift.getEndTime());
                }
            }
            return null;
        }
    }
}

