/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.bo.ui.explorer;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.model.CookingInstruction;
import com.floreantpos.model.dao.CookingInstructionDAO;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.TransparentPanel;
import com.floreantpos.ui.PosTableRenderer;
import com.floreantpos.ui.dialog.ConfirmDeleteDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;

public class CookingInstructionExplorer
extends TransparentPanel {
    private List<CookingInstruction> categoryList;
    private JTable table;
    private CookingInstructionTableModel tableModel;
    CookingInstructionDAO dao = new CookingInstructionDAO();

    public CookingInstructionExplorer() {
        this.categoryList = this.dao.findAll();
        this.tableModel = new CookingInstructionTableModel();
        this.table = new JTable(this.tableModel);
        this.table.setRowHeight(PosUIManager.getSize(30));
        this.table.setDefaultRenderer(Object.class, new PosTableRenderer());
        this.setLayout(new BorderLayout(5, 5));
        this.add(new JScrollPane(this.table));
        JButton addButton = new JButton(POSConstants.ADD);
        addButton.addActionListener(e -> this.doAddCookingInstraction());
        JButton editButton = new JButton(POSConstants.EDIT);
        editButton.addActionListener(e -> this.doEditCookingInstraction());
        JButton deleteButton = new JButton(POSConstants.DELETE);
        deleteButton.addActionListener(e -> this.doDeleteCookingInstraction());
        TransparentPanel panel = new TransparentPanel();
        panel.add(addButton);
        panel.add(editButton);
        panel.add(deleteButton);
        this.add((Component)panel, "South");
    }

    private void doAddCookingInstraction() {
        try {
            String instruction = JOptionPane.showInputDialog(POSUtil.getBackOfficeWindow(), (Object)POSConstants.ENTER_INSTRUCTION_DESCRIPTION);
            if (instruction == null) {
                return;
            }
            if ((instruction = instruction.trim()).isEmpty()) {
                POSMessageDialog.showError(POSUtil.getBackOfficeWindow(), POSConstants.INSTRUCTION_CANNOT_BE_EMPTY);
                return;
            }
            if (instruction.length() > 60) {
                POSMessageDialog.showError(POSUtil.getBackOfficeWindow(), POSConstants.LONG_INSTRUCTION_ERROR);
                return;
            }
            CookingInstruction cookingInstruction = new CookingInstruction();
            cookingInstruction.setDescription(instruction);
            this.dao.save(cookingInstruction);
            this.tableModel.add(cookingInstruction);
        }
        catch (Exception x) {
            POSMessageDialog.showError(POSUtil.getBackOfficeWindow(), POSConstants.ERROR_MESSAGE, x);
        }
    }

    private void doEditCookingInstraction() {
        try {
            int index = this.table.getSelectedRow();
            if (index < 0) {
                POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("SelectToEdit"));
                return;
            }
            CookingInstruction cookingInstruction = this.categoryList.get(index);
            String instruction = JOptionPane.showInputDialog(POSUtil.getBackOfficeWindow(), POSConstants.ENTER_INSTRUCTION_DESCRIPTION, cookingInstruction.getDescription());
            if (instruction == null) {
                return;
            }
            if ((instruction = instruction.trim()).isEmpty()) {
                POSMessageDialog.showError(POSUtil.getBackOfficeWindow(), POSConstants.INSTRUCTION_CANNOT_BE_EMPTY);
                return;
            }
            if (instruction.length() > 60) {
                POSMessageDialog.showError(POSUtil.getBackOfficeWindow(), POSConstants.LONG_INSTRUCTION_ERROR);
                return;
            }
            cookingInstruction.setDescription(instruction);
            this.dao.saveOrUpdate(cookingInstruction);
            this.table.repaint();
        }
        catch (Throwable x) {
            POSMessageDialog.showError(POSUtil.getBackOfficeWindow(), POSConstants.ERROR_MESSAGE, x);
        }
    }

    private void doDeleteCookingInstraction() {
        try {
            int index = this.table.getSelectedRow();
            if (index < 0) {
                POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("SelectToDelete"));
                return;
            }
            if (ConfirmDeleteDialog.showMessage(POSUtil.getBackOfficeWindow(), POSConstants.CONFIRM_DELETE, POSConstants.DELETE) == 0) {
                CookingInstruction cookingInstruction = this.categoryList.get(index);
                this.dao.delete(cookingInstruction);
                this.tableModel.delete(cookingInstruction, index);
            }
        }
        catch (Exception x) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), POSConstants.ERROR_MESSAGE, x);
        }
    }

    class CookingInstructionTableModel
    extends AbstractTableModel {
        String[] columnNames = new String[]{POSConstants.DESCRIPTION};

        CookingInstructionTableModel() {
        }

        @Override
        public int getRowCount() {
            if (CookingInstructionExplorer.this.categoryList == null) {
                return 0;
            }
            return CookingInstructionExplorer.this.categoryList.size();
        }

        @Override
        public int getColumnCount() {
            return 1;
        }

        @Override
        public String getColumnName(int column) {
            return this.columnNames[column];
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            if (CookingInstructionExplorer.this.categoryList == null) {
                return "";
            }
            CookingInstruction cookingInstruction = (CookingInstruction)CookingInstructionExplorer.this.categoryList.get(rowIndex);
            switch (columnIndex) {
                case 0: {
                    return cookingInstruction.getDescription();
                }
            }
            return null;
        }

        public void add(CookingInstruction instruction) {
            int size = CookingInstructionExplorer.this.categoryList.size();
            CookingInstructionExplorer.this.categoryList.add(instruction);
            this.fireTableRowsInserted(size, size);
        }

        public void delete(CookingInstruction instruction, int index) {
            CookingInstructionExplorer.this.categoryList.remove(instruction);
            this.fireTableRowsDeleted(index, index);
        }
    }
}

