/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.bo.ui.explorer;

import com.floreantpos.POSConstants;
import com.floreantpos.PosException;
import com.floreantpos.bo.ui.BOMessageDialog;
import com.floreantpos.model.Discount;
import com.floreantpos.model.dao.DiscountDAO;
import com.floreantpos.report.DiscountReport;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.TransparentPanel;
import com.floreantpos.ui.PosTableRenderer;
import com.floreantpos.ui.dialog.ConfirmDeleteDialog;
import com.floreantpos.ui.dialog.DetailsInfoDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.model.CouponForm;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import org.apache.commons.lang3.StringUtils;

public class CouponExplorer
extends TransparentPanel
implements ActionListener {
    private JTable explorerView = new JTable();
    private CouponExplorerTableModel explorerModel;

    public CouponExplorer() {
        this.explorerView.setDefaultRenderer(Object.class, new PosTableRenderer());
        this.explorerView.setRowHeight(30);
        this.setLayout(new BorderLayout(5, 5));
        this.add(new JScrollPane(this.explorerView));
        JButton btnAddItemCoupon = new JButton("Add Item Discount");
        btnAddItemCoupon.setActionCommand("ITEM");
        btnAddItemCoupon.addActionListener(this);
        JButton btnAddOrderCoupon = new JButton("Add Order Discount");
        btnAddOrderCoupon.setActionCommand("ORDER");
        btnAddOrderCoupon.addActionListener(this);
        JButton editButton = new JButton(POSConstants.EDIT);
        editButton.setActionCommand(POSConstants.EDIT);
        editButton.addActionListener(this);
        JButton deleteButton = new JButton(POSConstants.DELETE);
        deleteButton.setActionCommand(POSConstants.DELETE);
        deleteButton.addActionListener(this);
        JButton btnPrint = new JButton(POSConstants.PRINT);
        btnPrint.setActionCommand(POSConstants.PRINT);
        btnPrint.addActionListener(this);
        TransparentPanel panel = new TransparentPanel();
        panel.add(btnAddItemCoupon);
        panel.add(btnAddOrderCoupon);
        panel.add(editButton);
        panel.add(deleteButton);
        panel.add(btnPrint);
        this.add((Component)panel, "South");
    }

    public void initData() throws Exception {
        DiscountDAO dao = new DiscountDAO();
        List<Discount> couponList = dao.findAll();
        this.explorerModel = new CouponExplorerTableModel(couponList);
        this.explorerView.setModel(this.explorerModel);
        this.explorerView.getColumnModel().getColumn(1).setCellRenderer(new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                if (value instanceof String) {
                    this.setHorizontalAlignment(4);
                }
                return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            }
        });
    }

    private void addNewItemCoupon() {
        try {
            CouponForm dialog = new CouponForm(new Discount(), true);
            dialog.setTitle("Add Coupon");
            dialog.setSize(PosUIManager.getSize(800, 600));
            dialog.open();
            if (dialog.isCanceled()) {
                return;
            }
            Discount coupon = dialog.getBean();
            this.explorerModel.addCoupon(coupon);
        }
        catch (Exception x) {
            BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, x);
        }
    }

    private void addNewOrderCoupon() {
        try {
            CouponForm dialog = new CouponForm(new Discount(), false);
            dialog.setTitle("Add Coupon");
            dialog.setSize(PosUIManager.getSize(800, 600));
            dialog.open();
            if (dialog.isCanceled()) {
                return;
            }
            Discount coupon = dialog.getBean();
            this.explorerModel.addCoupon(coupon);
        }
        catch (Exception x) {
            BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, x);
        }
    }

    private void editCoupon(Discount coupon) {
        try {
            boolean isItemBasedCoupon = coupon.getQualificationType() == 0;
            CouponForm dialog = new CouponForm(coupon, isItemBasedCoupon);
            dialog.setTitle("Edit Coupon");
            dialog.setSize(PosUIManager.getSize(800, 600));
            dialog.open();
            if (dialog.isCanceled()) {
                return;
            }
            this.explorerView.repaint();
        }
        catch (Throwable x) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), POSConstants.ERROR_MESSAGE, x);
        }
    }

    private void deleteCoupon(int index, Discount coupon) {
        try {
            if (ConfirmDeleteDialog.showMessage(this, POSConstants.CONFIRM_DELETE, POSConstants.DELETE) == 0) {
                if (StringUtils.isNotBlank((CharSequence)coupon.getId())) {
                    DiscountDAO.getInstance().delete(coupon.getId());
                }
                this.explorerModel.deleteCoupon(coupon, index);
            }
        }
        catch (PosException x) {
            DetailsInfoDialog dialog = new DetailsInfoDialog(x.getMessage(), x.getDetails());
            dialog.open();
        }
        catch (Exception x) {
            BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, x);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String actionCommand = e.getActionCommand();
        if ("ITEM".equals(actionCommand)) {
            this.addNewItemCoupon();
        } else if ("ORDER".equals(actionCommand)) {
            this.addNewOrderCoupon();
        } else if (POSConstants.EDIT.equals(actionCommand)) {
            int index = this.explorerView.getSelectedRow();
            if (index < 0) {
                BOMessageDialog.showError(POSConstants.SELECT_COUPON_TO_EDIT);
                return;
            }
            Discount coupon = this.explorerModel.getCoupon(index);
            DiscountDAO.getInstance().refresh(coupon);
            this.editCoupon(coupon);
        } else if (POSConstants.DELETE.equals(actionCommand)) {
            int index = this.explorerView.getSelectedRow();
            if (index < 0) {
                BOMessageDialog.showError(POSConstants.SELECT_COUPON_TO_DELETE);
                return;
            }
            Discount coupon = this.explorerModel.getCoupon(index);
            this.deleteCoupon(index, coupon);
        } else if (POSConstants.PRINT.equals(actionCommand)) {
            DiscountReport.print();
        }
    }

    private class CouponExplorerTableModel
    extends AbstractTableModel {
        String[] columnNames = new String[]{POSConstants.NAME, POSConstants.COUPON_VALUE, POSConstants.START_DATE, POSConstants.EXPIRY_DATE, POSConstants.ENABLED, POSConstants.NEVER_EXPIRE};
        List<Discount> couponList;

        CouponExplorerTableModel(List<Discount> list) {
            this.couponList = list;
        }

        @Override
        public int getRowCount() {
            if (this.couponList == null) {
                return 0;
            }
            return this.couponList.size();
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        @Override
        public String getColumnName(int index) {
            return this.columnNames[index];
        }

        @Override
        public Object getValueAt(int row, int column) {
            if (this.couponList == null) {
                return "";
            }
            Discount coupon = this.couponList.get(row);
            switch (column) {
                case 0: {
                    return coupon.getName();
                }
                case 1: {
                    double value = coupon.getValue();
                    if (coupon.getType() == 0) {
                        return value;
                    }
                    if (coupon.getType() == 1) {
                        return String.valueOf((int)value + "%");
                    }
                    return value;
                }
                case 2: {
                    return coupon.getStartDate();
                }
                case 3: {
                    return coupon.getExpiryDate();
                }
                case 4: {
                    return (boolean)coupon.isEnabled();
                }
                case 5: {
                    return (boolean)coupon.isNeverExpire();
                }
            }
            return null;
        }

        public void addCoupon(Discount coupon) {
            int size = this.couponList.size();
            this.couponList.add(coupon);
            this.fireTableRowsInserted(size, size);
        }

        public void deleteCoupon(Discount coupon, int index) {
            this.couponList.remove(coupon);
            this.fireTableRowsDeleted(index, index);
        }

        public Discount getCoupon(int index) {
            return this.couponList.get(index);
        }
    }
}

