/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.bo.ui.explorer;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosException;
import com.floreantpos.PosLog;
import com.floreantpos.bo.ui.BOMessageDialog;
import com.floreantpos.bo.ui.CustomCellRenderer;
import com.floreantpos.main.Application;
import com.floreantpos.model.GiftCard;
import com.floreantpos.model.User;
import com.floreantpos.model.UserPermission;
import com.floreantpos.model.UserType;
import com.floreantpos.model.dao.GiftCardDAO;
import com.floreantpos.model.util.DateUtil;
import com.floreantpos.swing.BeanTableModel;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.TransparentPanel;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.views.GiftCardBatchNumberEntryDialog;
import com.floreantpos.ui.views.GiftCardGeneratorView;
import com.floreantpos.ui.views.GiftCardHolderNameEntryView;
import com.floreantpos.ui.views.GiftCardImportCheckingDialog;
import com.floreantpos.ui.views.GiftCardStausSelectionDialog;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;
import org.apache.commons.io.IOUtils;
import org.jdesktop.swingx.JXDatePicker;
import org.jdesktop.swingx.JXTable;

public class GiftCardExplorer
extends TransparentPanel {
    private JXTable table;
    private BeanTableModel<GiftCard> tableModel;
    private JTextField tfNumber;
    private Date fromDate;
    private Date toDate;
    private JXDatePicker fromDatePicker;
    private JXDatePicker toDatePicker;
    private Set<UserPermission> permissions;
    private Clipboard cb;
    private JButton copyButton;
    private JButton btnActive;
    private JButton btnDeactive;
    private JButton btnDisable;
    private JTextField tfBatchNumber;
    private JButton btnCopyBatch;
    private JButton btnDelete;
    private JButton btnExport;
    private JButton btnImport;
    private JButton btnBack;
    private JButton btnForward;
    private JLabel lblNumberOfItem;
    private JComboBox<GiftCardStatus> giftCardStatusCombo;

    public GiftCardExplorer() {
        this.initComponents();
        this.searchItem();
    }

    private void initComponents() {
        this.setLayout(new BorderLayout(5, 5));
        this.tableModel = new BeanTableModel(GiftCard.class);
        this.tableModel.addColumn(Messages.getString("GiftCardExplorer.42"), "customCardNumber");
        this.tableModel.addColumn(Messages.getString("GiftCardExplorer.44"), "ownerName");
        this.tableModel.addColumn(Messages.getString("GiftCardExplorer.46"), "pinNumber");
        this.tableModel.addColumn(Messages.getString("GiftCardExplorer.48"), "batchNo");
        this.tableModel.addColumn(Messages.getString("GiftCardExplorer.50"), "balance", 11, BeanTableModel.DataType.MONEY);
        this.tableModel.addColumn(Messages.getString("GiftCardExplorer.52"), "issueDate");
        this.tableModel.addColumn(Messages.getString("GiftCardExplorer.54"), "activationDate");
        this.tableModel.addColumn(Messages.getString("GiftCardExplorer.56"), "deActivationDate");
        this.tableModel.addColumn(Messages.getString("GiftCardExplorer.58"), "expiryDate");
        this.tableModel.addColumn(Messages.getString("GiftCardExplorer.60"), "active");
        this.tableModel.addColumn(Messages.getString("GiftCardExplorer.62"), "disable");
        this.tableModel.addColumn(Messages.getString("GiftCardExplorer.64"), "duration", 11, BeanTableModel.DataType.NUMBER);
        this.tableModel.addColumn(Messages.getString("GiftCardExplorer.66"), "durationType");
        this.tableModel.addColumn(Messages.getString("GiftCardExplorer.68"), "point", 11, BeanTableModel.DataType.NUMBER);
        this.table = new JXTable(this.tableModel);
        this.tableModel.initTableRenderer((JTable)this.table);
        this.table.setDefaultRenderer(Object.class, (TableCellRenderer)new CustomCellRenderer());
        this.table.setRowHeight(PosUIManager.getSize(30));
        this.btnBack = new JButton(Messages.getString("GiftCardExplorer.51"));
        this.btnForward = new JButton(Messages.getString("GiftCardExplorer.53"));
        this.lblNumberOfItem = new JLabel();
        this.btnBack.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GiftCardExplorer.this.tableModel.setCurrentRowIndex(GiftCardExplorer.this.tableModel.getPreviousRowIndex());
                GiftCardExplorer.this.searchItem();
            }
        });
        this.btnForward.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GiftCardExplorer.this.tableModel.setCurrentRowIndex(GiftCardExplorer.this.tableModel.getNextRowIndex());
                GiftCardExplorer.this.searchItem();
            }
        });
        JPanel bottomPanel = new JPanel((LayoutManager)new MigLayout("fillx"));
        bottomPanel.add((Component)this.createButtonPanel(), "center");
        bottomPanel.add((Component)this.lblNumberOfItem, "right, split 3");
        bottomPanel.add(this.btnBack);
        bottomPanel.add(this.btnForward);
        this.add(new JScrollPane((Component)this.table));
        this.add((Component)bottomPanel, "South");
        this.add((Component)this.buildSearchForm(), "North");
        this.resizeColumnWidth((JTable)this.table);
        this.disableButtonList();
        this.table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (GiftCardExplorer.this.table.getSelectedRow() < 0) {
                    GiftCardExplorer.this.disableButtonList();
                } else {
                    GiftCardExplorer.this.enableButtonList();
                }
            }
        });
    }

    private void copyCardNo() {
        try {
            int index = this.table.getSelectedRow();
            if (index < 0) {
                return;
            }
            this.cb = Toolkit.getDefaultToolkit().getSystemClipboard();
            StringBuilder cardNumber = new StringBuilder(this.table.getStringAt(index, 0));
            for (int i = 0; i < cardNumber.length(); ++i) {
                if (i != 4 && i != 8 && i != 12) continue;
                cardNumber.deleteCharAt(i);
            }
            StringSelection tr = new StringSelection(cardNumber.toString());
            this.cb.setContents(tr, null);
            POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), "Card no. copied to clipboard.");
        }
        catch (Throwable x) {
            BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, x);
        }
    }

    private void copyBatchNumber() {
        try {
            int index = this.table.getSelectedRow();
            if (index < 0) {
                return;
            }
            this.cb = Toolkit.getDefaultToolkit().getSystemClipboard();
            StringBuilder batchNumber = new StringBuilder(this.table.getStringAt(index, 3));
            StringSelection tr = new StringSelection(batchNumber.toString());
            this.cb.setContents(tr, null);
            POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("GiftCardExplorer.0"));
        }
        catch (Throwable x) {
            BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, x);
        }
    }

    private void doImportCSVFile() {
        try {
            JFileChooser fileChooser = new JFileChooser();
            fileChooser.setFileSelectionMode(0);
            fileChooser.setAcceptAllFileFilterUsed(false);
            fileChooser.addChoosableFileFilter(new FileNameExtensionFilter("*.csv", "csv"));
            int result = fileChooser.showOpenDialog(this);
            if (result == 1) {
                return;
            }
            File selectedFile = fileChooser.getSelectedFile();
            if (selectedFile == null) {
                return;
            }
            GiftCardImportCheckingDialog dialog = new GiftCardImportCheckingDialog(selectedFile);
            dialog.openFullScreen();
            if (dialog.isCanceled()) {
                return;
            }
            List<GiftCard> giftCards = dialog.getGiftCards();
            boolean giftCardExistWithEmptyCardNumber = dialog.isGiftCardExistWithEmptyCardNumber();
            GiftCardDAO.getInstance().saveAsList(giftCards);
            POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), giftCardExistWithEmptyCardNumber ? Messages.getString("GiftCardExplorer.70") : Messages.getString("GiftCardExplorer.65"));
            this.searchItem();
        }
        catch (PosException e) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), e.getMessage());
        }
        catch (Exception e) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("GiftCardExplorer.67"), e);
        }
    }

    public static String getSysClipboardText() {
        String ret = "";
        Clipboard sysClip = Toolkit.getDefaultToolkit().getSystemClipboard();
        Transferable clipTf = sysClip.getContents(null);
        if (clipTf != null && clipTf.isDataFlavorSupported(DataFlavor.stringFlavor)) {
            try {
                ret = (String)clipTf.getTransferData(DataFlavor.stringFlavor);
            }
            catch (Exception e) {
                PosLog.error(GiftCardExplorer.class, e);
            }
        }
        return ret;
    }

    private JPanel buildSearchForm() {
        JPanel panel = new JPanel();
        panel.setLayout((LayoutManager)new MigLayout("", "[][]15[][]15[][][]15[][]15[][]15[][]5[]", "[]5[]"));
        this.fromDatePicker = new JXDatePicker();
        this.toDatePicker = new JXDatePicker();
        JLabel lblNumber = new JLabel(Messages.getString("CardNumber"));
        this.tfNumber = new JTextField(15);
        JLabel lblBatchNumber = new JLabel(Messages.getString("BatchNumber"));
        this.tfBatchNumber = new JTextField(15);
        JLabel lblStatus = new JLabel("Status");
        this.giftCardStatusCombo = new JComboBox();
        this.giftCardStatusCombo.setModel(new DefaultComboBoxModel<GiftCardStatus>(GiftCardStatus.values()));
        try {
            JButton searchBttn = new JButton(Messages.getString("Search"));
            JButton btnRefresh = new JButton(Messages.getString("Refresh"));
            JButton btnClear = new JButton(Messages.getString("GiftCardExplorer.2"));
            panel.add((Component)lblNumber, "align label");
            panel.add(this.tfNumber);
            panel.add((Component)lblBatchNumber, "align label");
            panel.add(this.tfBatchNumber);
            panel.add(new JLabel(Messages.getString("IssueDate")));
            panel.add(new JLabel(Messages.getString("GiftCardExplorer.4")));
            panel.add((Component)this.fromDatePicker);
            panel.add(new JLabel(Messages.getString("GiftCardExplorer.5")));
            panel.add((Component)this.toDatePicker);
            panel.add(lblStatus);
            panel.add(this.giftCardStatusCombo);
            panel.add(searchBttn);
            panel.add(btnRefresh);
            panel.add(btnClear);
            Border loweredetched = BorderFactory.createEtchedBorder(1);
            TitledBorder title = BorderFactory.createTitledBorder(loweredetched, Messages.getString("Search"));
            title.setTitleJustification(1);
            panel.setBorder(title);
            this.tfNumber.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    GiftCardExplorer.this.searchItem();
                }
            });
            this.tfBatchNumber.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    GiftCardExplorer.this.searchItem();
                }
            });
            btnClear.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    GiftCardExplorer.this.fromDatePicker.getEditor().setText(null);
                    GiftCardExplorer.this.toDatePicker.getEditor().setText(null);
                    GiftCardExplorer.this.fromDatePicker.setDate(null);
                    GiftCardExplorer.this.toDatePicker.setDate(null);
                    GiftCardExplorer.this.tfNumber.setText("");
                    GiftCardExplorer.this.tfBatchNumber.setText("");
                    GiftCardExplorer.this.fromDate = null;
                    GiftCardExplorer.this.toDate = null;
                    GiftCardExplorer.this.giftCardStatusCombo.setSelectedItem((Object)GiftCardStatus.ALL);
                }
            });
            searchBttn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    GiftCardExplorer.this.searchItem();
                }
            });
            btnRefresh.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    GiftCardExplorer.this.searchItem();
                }
            });
            this.tfNumber.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    GiftCardExplorer.this.searchItem();
                }
            });
        }
        catch (Throwable x) {
            BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, x);
        }
        return panel;
    }

    private void searchItem() {
        String txNumber = this.tfNumber.getText();
        String batchNumber = this.tfBatchNumber.getText();
        this.fromDate = this.fromDatePicker.getDate();
        this.toDate = this.toDatePicker.getDate();
        if (this.fromDate != null && this.toDate != null && this.fromDate.after(this.toDate)) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), POSConstants.FROM_DATE_CANNOT_BE_GREATER_THAN_TO_DATE_);
            return;
        }
        if (this.fromDate != null) {
            this.fromDate = DateUtil.startOfDay(this.fromDate);
        }
        if (this.toDate != null) {
            this.toDate = DateUtil.endOfDay(this.toDate);
        }
        if (this.fromDate == null && this.toDate != null) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("GiftCardExplorer.6"));
            return;
        }
        if (this.fromDate != null && this.toDate == null) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("GiftCardExplorer.7"));
            return;
        }
        GiftCardStatus selectedItem = (GiftCardStatus)((Object)this.giftCardStatusCombo.getSelectedItem());
        GiftCardDAO.getInstance().searchByCardAndIssueDate(txNumber, batchNumber, this.fromDate, this.toDate, selectedItem.name(), this.tableModel);
        int startNumber = this.tableModel.getCurrentRowIndex() + 1;
        int endNumber = this.tableModel.getNextRowIndex();
        int totalNumber = this.tableModel.getNumRows();
        if (endNumber > totalNumber) {
            endNumber = totalNumber;
        }
        this.lblNumberOfItem.setText(String.format(Messages.getString("GiftCardExplorer.69"), startNumber, endNumber, totalNumber));
        this.btnBack.setEnabled(this.tableModel.hasPrevious());
        this.btnForward.setEnabled(this.tableModel.hasNext());
    }

    private TransparentPanel createButtonPanel() {
        this.copyButton = new JButton(Messages.getString("GiftCardExplorer.9"));
        JButton btnAddGiftCard = new JButton(Messages.getString("GiftCardExplorer.70"));
        JButton generateButton = new JButton(Messages.getString("Generate"));
        this.btnActive = new JButton(Messages.getString("Activate"));
        this.btnDeactive = new JButton(Messages.getString("GiftCardExplorer.12"));
        this.btnDisable = new JButton(Messages.getString("Disable"));
        this.btnCopyBatch = new JButton(Messages.getString("GiftCardExplorer.15"));
        this.btnDelete = new JButton(Messages.getString("GiftCardExplorer.16"));
        this.btnImport = new JButton(Messages.getString("GiftCardExplorer.71"));
        this.btnExport = new JButton(Messages.getString("GiftCardExplorer.17"));
        User user = Application.getCurrentUser();
        UserType newUserType = user.getType();
        if (newUserType != null) {
            this.permissions = newUserType.getPermissions();
        }
        this.btnImport.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GiftCardExplorer.this.doImportCSVFile();
            }
        });
        this.btnExport.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    GiftCardExplorer.this.doExportToCSV();
                }
                catch (Exception e1) {
                    POSMessageDialog.showError(GiftCardExplorer.this, e1.getMessage(), e1);
                }
            }
        });
        this.copyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GiftCardExplorer.this.copyCardNo();
            }
        });
        this.btnCopyBatch.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GiftCardExplorer.this.copyBatchNumber();
            }
        });
        this.btnDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GiftCardExplorer.this.doDeleteCards();
            }
        });
        btnAddGiftCard.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GiftCardExplorer.this.doAddGiftCard();
            }
        });
        generateButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GiftCardExplorer.this.doGenerateCard();
            }
        });
        this.btnActive.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GiftCardExplorer.this.doActiveCard();
            }
        });
        this.btnDeactive.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GiftCardExplorer.this.doDeactiveCard();
            }
        });
        this.btnDisable.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GiftCardExplorer.this.doDisableCard();
            }
        });
        TransparentPanel panel = new TransparentPanel();
        if (this.permissions != null && this.permissions.contains(UserPermission.GENERATE_GIFT_CARD)) {
            panel.add(btnAddGiftCard);
            panel.add(generateButton);
            panel.add(this.copyButton);
            panel.add(this.btnCopyBatch);
            panel.add(this.btnActive);
            panel.add(this.btnDeactive);
            panel.add(this.btnDisable);
            panel.add(this.btnDelete);
            panel.add(this.btnImport);
            panel.add(this.btnExport);
        }
        return panel;
    }

    public void resizeColumnWidth(JTable table) {
        TableColumnModel columnModel = table.getColumnModel();
        for (int column = 0; column < table.getColumnCount(); ++column) {
            columnModel.getColumn(column).setPreferredWidth((Integer)this.getColumnWidth().get(column));
        }
    }

    private List getColumnWidth() {
        ArrayList<Integer> columnWidth = new ArrayList<Integer>();
        columnWidth.add(120);
        columnWidth.add(150);
        columnWidth.add(70);
        columnWidth.add(100);
        columnWidth.add(70);
        columnWidth.add(70);
        columnWidth.add(85);
        columnWidth.add(90);
        columnWidth.add(70);
        columnWidth.add(50);
        columnWidth.add(50);
        columnWidth.add(50);
        columnWidth.add(70);
        columnWidth.add(50);
        return columnWidth;
    }

    private void disableButtonList() {
        this.copyButton.setEnabled(false);
        this.btnActive.setEnabled(false);
        this.btnDeactive.setEnabled(false);
        this.btnDisable.setEnabled(false);
        this.btnCopyBatch.setEnabled(false);
    }

    private void enableButtonList() {
        this.copyButton.setEnabled(true);
        this.btnActive.setEnabled(true);
        this.btnDeactive.setEnabled(true);
        this.btnDisable.setEnabled(true);
        this.btnCopyBatch.setEnabled(true);
        this.btnExport.setEnabled(true);
    }

    private void doDeleteCards() {
        try {
            GiftCardBatchNumberEntryDialog dialog = new GiftCardBatchNumberEntryDialog();
            dialog.setTitle(Messages.getString("BatchNumberEntry"));
            dialog.setDefaultCloseOperation(2);
            dialog.setSize(PosUIManager.getSize(400, 300));
            dialog.setLocationRelativeTo(POSUtil.getFocusedWindow());
            dialog.setVisible(true);
            if (dialog.isCanceled()) {
                return;
            }
            if (dialog.isActive()) {
                POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("GiftCardExplorer.24"));
                return;
            }
            String batchNumber = dialog.getBatchNumber();
            if (!GiftCardDAO.getInstance().hasBatchNo(batchNumber)) {
                POSMessageDialog.showError(this, Messages.getString("GiftCardExplorer.22") + batchNumber);
                return;
            }
            if (POSMessageDialog.showYesNoQuestionDialog(POSUtil.getBackOfficeWindow(), POSConstants.CONFIRM_DELETE, POSConstants.DELETE) != 0) {
                return;
            }
            GiftCardDAO.getInstance().deleteCardListByBatchNumber(batchNumber);
            POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("GiftCardExplorer.25"));
            this.searchItem();
        }
        catch (Throwable x) {
            BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, x);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doExportToCSV() throws Exception {
        FileWriter writer;
        CSVPrinter csvFilePrinter;
        JFileChooser fileChooser;
        List<GiftCard> giftCardList;
        block10: {
            GiftCardDAO cardDAO = new GiftCardDAO();
            GiftCardStausSelectionDialog dialog = new GiftCardStausSelectionDialog();
            dialog.setTitle(Messages.getString("GiftCardExplorer.55"));
            dialog.setDefaultCloseOperation(2);
            dialog.setSize(PosUIManager.getSize(400, 300));
            dialog.setLocationRelativeTo(POSUtil.getFocusedWindow());
            dialog.setVisible(true);
            if (dialog.isCanceled()) {
                return;
            }
            giftCardList = cardDAO.findGiftCardsToExportIntoCsvFile(dialog.getSelectedStaus());
            if (giftCardList == null) {
                POSMessageDialog.showMessage(this, Messages.getString("GiftCardExplorer.57"));
                return;
            }
            fileChooser = this.createGiftCardExportFileChooser();
            Integer option = fileChooser.showSaveDialog(this);
            if (option != 0) {
                return;
            }
            csvFilePrinter = null;
            writer = null;
            if (this.isReplaceFile(fileChooser)) break block10;
            IOUtils.closeQuietly(writer);
            if (csvFilePrinter != null) {
                csvFilePrinter.close();
            }
            return;
        }
        try {
            File file = fileChooser.getSelectedFile();
            writer = new FileWriter(file);
            CSVFormat csvFileFormat = CSVFormat.DEFAULT.withRecordSeparator("\n");
            csvFilePrinter = new CSVPrinter((Appendable)writer, csvFileFormat);
            Object[] headers = new Object[]{"Card Number", "Owner Name", "Balance", "Issue Date", "Activation Date", "Deactivation Date", "Expiration Date", "Active", "Disable", "Duration Type", "Duration", "Pin Number", "Point", "Batch Number", "Email", "Type"};
            csvFilePrinter.printRecord(headers);
            for (GiftCard giftCard : giftCardList) {
                Object[] arry = new Object[16];
                String s = giftCard.getCardNumber();
                arry[0] = "\"" + s + "\"";
                arry[1] = giftCard.getOwnerName();
                arry[2] = giftCard.getBalance();
                arry[3] = giftCard.getIssueDate() != null ? DateUtil.formatAsGiftCardDateFormat(giftCard.getIssueDate()) : "";
                arry[4] = giftCard.getActivationDate() != null ? DateUtil.formatAsGiftCardDateFormat(giftCard.getActivationDate()) : "";
                arry[5] = giftCard.getDeActivationDate() != null ? DateUtil.formatAsGiftCardDateFormat(giftCard.getDeActivationDate()) : "";
                arry[6] = giftCard.getExpiryDate() != null ? DateUtil.formatAsGiftCardDateFormat(giftCard.getExpiryDate()) : "";
                arry[7] = giftCard.isActive();
                arry[8] = giftCard.isDisable();
                arry[9] = giftCard.getDurationType();
                arry[10] = giftCard.getDuration();
                arry[11] = giftCard.getPinNumber();
                arry[12] = giftCard.getPoint();
                arry[13] = giftCard.getBatchNo();
                arry[14] = giftCard.getEmail();
                arry[15] = giftCard.getType();
                csvFilePrinter.printRecord(arry);
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(writer);
            if (csvFilePrinter != null) {
                csvFilePrinter.close();
            }
            throw throwable;
        }
        IOUtils.closeQuietly((Writer)writer);
        if (csvFilePrinter != null) {
            csvFilePrinter.close();
        }
    }

    private boolean isReplaceFile(JFileChooser fileChooser) {
        if (fileChooser.getSelectedFile().exists() && POSMessageDialog.showYesNoQuestionDialog(POSUtil.getFocusedWindow(), Messages.getString("GiftCardExplorer.59"), Messages.getString("CONFIRM")) != 0) {
            Integer option = fileChooser.showSaveDialog(this);
            if (option != 0) {
                return false;
            }
            return this.isReplaceFile(fileChooser);
        }
        return true;
    }

    private JFileChooser createGiftCardExportFileChooser() {
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setFileSelectionMode(0);
        fileChooser.setMultiSelectionEnabled(false);
        fileChooser.setAcceptAllFileFilterUsed(false);
        fileChooser.addChoosableFileFilter(new FileNameExtensionFilter("*.csv", "csv"));
        fileChooser.setSelectedFile(new File(Messages.getString("GiftCardExplorer.20") + ".csv"));
        fileChooser.setFileFilter(new FileFilter(){

            @Override
            public String getDescription() {
                return Messages.getString("GiftCardExplorer.21");
            }

            @Override
            public boolean accept(File f) {
                return f.getName().endsWith(".csv");
            }
        });
        return fileChooser;
    }

    private void doActiveCard() {
        try {
            int index = this.table.getSelectedRow();
            if (index < 0) {
                return;
            }
            index = this.table.convertRowIndexToModel(index);
            GiftCard giftCard = this.tableModel.getRow(index);
            giftCard = GiftCardDAO.getInstance().initialize(giftCard);
            if (giftCard.isActive().booleanValue()) {
                POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("GiftCardExplorer.32"));
                return;
            }
            int value = POSMessageDialog.showYesNoQuestionDialog(POSUtil.getFocusedWindow(), Messages.getString("GiftCardExplorer.30"), Messages.getString("GiftCardExplorer.31"));
            if (value == 0) {
                if (giftCard.getOwnerName() == null) {
                    GiftCardHolderNameEntryView dialog = new GiftCardHolderNameEntryView();
                    dialog.setTitle(Messages.getString("GiftCardExplorer.33"));
                    dialog.setDefaultCloseOperation(2);
                    dialog.setSize(PosUIManager.getSize(400, 300));
                    dialog.setLocationRelativeTo(POSUtil.getFocusedWindow());
                    dialog.setVisible(true);
                    if (dialog.isCanceled()) {
                        return;
                    }
                    giftCard.setOwnerName(dialog.getCardHolderName());
                }
                Calendar c = Calendar.getInstance();
                Date activationDate = c.getTime();
                giftCard.setActive(true);
                giftCard.setActivationDate(activationDate);
                giftCard.setDeActivationDate(null);
                giftCard.setExpiryDate(giftCard.prepareExpireDate(activationDate));
                giftCard.setActive(true);
                giftCard.setDisable(false);
                GiftCardDAO.getInstance().saveOrUpdate(giftCard);
                POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("GiftCardExplorer.34"));
                this.searchItem();
            }
        }
        catch (Exception e2) {
            POSMessageDialog.showError(this, e2.getMessage(), e2);
        }
    }

    private void doDeactiveCard() {
        try {
            int index = this.table.getSelectedRow();
            if (index < 0) {
                return;
            }
            index = this.table.convertRowIndexToModel(index);
            GiftCard giftCard = this.tableModel.getRow(index);
            giftCard = GiftCardDAO.getInstance().initialize(giftCard);
            if (!giftCard.isActive().booleanValue()) {
                POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("GiftCardExplorer.37"));
                return;
            }
            int value = POSMessageDialog.showYesNoQuestionDialog(POSUtil.getFocusedWindow(), Messages.getString("DeactivateCard"), Messages.getString("Deactivation"));
            if (value == 0) {
                giftCard.setActive(false);
                giftCard.setDeActivationDate(new Date());
                GiftCardDAO.getInstance().saveOrUpdate(giftCard);
                POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("CardDeactivatedSuccessfully"));
                this.searchItem();
            }
        }
        catch (Exception e2) {
            POSMessageDialog.showError(this, e2.getMessage(), e2);
        }
    }

    private void doDisableCard() {
        try {
            int index = this.table.getSelectedRow();
            if (index < 0) {
                return;
            }
            index = this.table.convertRowIndexToModel(index);
            GiftCard giftCard = this.tableModel.getRow(index);
            giftCard = GiftCardDAO.getInstance().initialize(giftCard);
            if (giftCard.isDisable().booleanValue()) {
                POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("GiftCardExplorer.1"));
                return;
            }
            int value = POSMessageDialog.showYesNoQuestionDialog(POSUtil.getFocusedWindow(), Messages.getString("DisableCard"), Messages.getString("Disable"));
            if (value == 0) {
                giftCard.setDisable(true);
                giftCard.setActive(false);
                giftCard.setDeActivationDate(new Date());
                GiftCardDAO.getInstance().saveOrUpdate(giftCard);
                POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("DisabledSuccessfully"));
                this.searchItem();
            }
        }
        catch (Exception e2) {
            POSMessageDialog.showError(this, e2.getMessage(), e2);
        }
    }

    private void doGenerateCard() {
        try {
            GiftCardGeneratorView dialog = new GiftCardGeneratorView();
            dialog.setTitle(Messages.getString("GiftCardGeneration"));
            dialog.setDefaultCloseOperation(2);
            dialog.setSize(PosUIManager.getSize(600, 400));
            dialog.setLocationRelativeTo(POSUtil.getFocusedWindow());
            dialog.setVisible(true);
            this.searchItem();
        }
        catch (Exception e2) {
            POSMessageDialog.showError(this, e2.getMessage(), e2);
        }
    }

    private void doAddGiftCard() {
        try {
            GiftCardGeneratorView dialog = new GiftCardGeneratorView(true);
            dialog.setTitle(Messages.getString("GiftCardGeneration"));
            dialog.setDefaultCloseOperation(2);
            dialog.setSize(PosUIManager.getSize(600, 400));
            dialog.setLocationRelativeTo(POSUtil.getFocusedWindow());
            dialog.setVisible(true);
            this.searchItem();
        }
        catch (Exception e2) {
            POSMessageDialog.showError(this, e2.getMessage(), e2);
        }
    }

    public static class CellTransferable
    implements Transferable {
        public static final DataFlavor CELL_DATA_FLAVOR = new DataFlavor(Object.class, "application/x-cell-value");
        private Object cellValue;

        public CellTransferable(Object cellValue) {
            this.cellValue = cellValue;
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            return new DataFlavor[]{CELL_DATA_FLAVOR};
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor flavor) {
            return CELL_DATA_FLAVOR.equals(flavor);
        }

        @Override
        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
            if (!this.isDataFlavorSupported(flavor)) {
                throw new UnsupportedFlavorException(flavor);
            }
            return this.cellValue;
        }
    }

    public static enum GiftCardStatus {
        ALL,
        ACTIVE,
        DEACTIVE,
        DISABLED;

    }
}

