/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.bo.ui.explorer;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.bo.ui.BOMessageDialog;
import com.floreantpos.bo.ui.CustomCellRenderer;
import com.floreantpos.bo.ui.explorer.ExplorerView;
import com.floreantpos.model.MenuCategory;
import com.floreantpos.model.dao.MenuCategoryDAO;
import com.floreantpos.model.dao.MenuGroupDAO;
import com.floreantpos.swing.BeanTableModel;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.TransparentPanel;
import com.floreantpos.ui.BeanEditor;
import com.floreantpos.ui.dialog.BeanEditorDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.model.MenuCategoryForm;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.table.TableCellRenderer;
import jiconfont.IconCode;
import jiconfont.icons.GoogleMaterialDesignIcons;
import jiconfont.swing.IconFontSwing;
import net.miginfocom.swing.MigLayout;
import org.jdesktop.swingx.JXTable;

public class MenuCategoryExplorer
extends TransparentPanel
implements ExplorerView {
    private JXTable table;
    private BeanTableModel<MenuCategory> tableModel;
    private JTextField tfNameField;
    private JButton btnBack;
    private JButton btnForward;
    private JLabel lblNumberOfItem;

    public MenuCategoryExplorer() {
        this.setLayout(new BorderLayout(5, 5));
        this.tableModel = new BeanTableModel(MenuCategory.class);
        this.tableModel.addColumn(POSConstants.NAME, "name");
        this.tableModel.addColumn(POSConstants.TRANSLATED_NAME, "translatedName");
        this.tableModel.addColumn(POSConstants.BEVERAGE, "beverage");
        this.tableModel.addColumn(POSConstants.VISIBLE, "visible");
        this.tableModel.addColumn(POSConstants.SORT_ORDER, "sortOrder");
        this.tableModel.addColumn(POSConstants.BUTTON_COLOR, "buttonColor");
        this.tableModel.addColumn(POSConstants.TEXT_COLOR, "textColor");
        this.table = new JXTable(this.tableModel);
        this.table.setRowHeight(PosUIManager.getSize(30));
        this.table.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent me) {
                if (me.getClickCount() == 2) {
                    MenuCategoryExplorer.this.editSelectedRow();
                }
            }
        });
        this.table.setDefaultRenderer(Object.class, (TableCellRenderer)new CustomCellRenderer());
        this.add((Component)this.createSearchPanel(), "North");
        this.add(new JScrollPane((Component)this.table));
        this.addButtonPanel();
    }

    private JPanel createSearchPanel() {
        JPanel northPanel = new JPanel((LayoutManager)new MigLayout("", "[][]10[][]10[]", "[]10[]"));
        northPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("Search")));
        JLabel nameLabel = new JLabel(Messages.getString("NAME"));
        this.tfNameField = new JTextField(20);
        this.tfNameField.addKeyListener(this.doSearchByKeyListener());
        JButton btnSearch = new JButton(Messages.getString("Search"));
        btnSearch.addActionListener(this.doSearch());
        JButton btnRefresh = new JButton(POSConstants.REFRESH);
        btnRefresh.addActionListener(this.doRefresh());
        northPanel.add((Component)nameLabel, "align label");
        northPanel.add(this.tfNameField);
        northPanel.add(btnSearch);
        northPanel.add(btnRefresh);
        return northPanel;
    }

    private KeyListener doSearchByKeyListener() {
        return new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
                if (MenuCategoryExplorer.this.tfNameField.getText().length() > 2) {
                    MenuCategoryExplorer.this.showMenuCategories();
                }
            }

            @Override
            public void keyPressed(KeyEvent e) {
                int key = e.getKeyCode();
                if (key == 10) {
                    MenuCategoryExplorer.this.showMenuCategories();
                }
            }
        };
    }

    private ActionListener doSearch() {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    MenuCategoryExplorer.this.showMenuCategories();
                }
                catch (Exception e2) {
                    POSMessageDialog.showError(POSUtil.getFocusedWindow(), e2.getMessage(), e2);
                }
            }
        };
    }

    private ActionListener doRefresh() {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    MenuCategoryExplorer.this.initData();
                }
                catch (Exception e2) {
                    POSMessageDialog.showError(POSUtil.getFocusedWindow(), e2.getMessage(), e2);
                }
            }
        };
    }

    private void showMenuCategories() {
        this.showMenuCategories(0);
    }

    private void showMenuCategories(Integer index) {
        try {
            this.setCursor(Cursor.getPredefinedCursor(3));
            String txName = this.tfNameField.getText();
            if (index != null) {
                this.tableModel.setCurrentRowIndex(index);
            }
            MenuCategoryDAO.getInstance().findCategories(this.tableModel, txName);
            this.lblNumberOfItem.setText(this.tableModel.getDisplayText());
            this.btnBack.setEnabled(this.tableModel.hasPrevious());
            this.btnForward.setEnabled(this.tableModel.hasNext());
        }
        catch (Exception e) {
            POSMessageDialog.showError(this, e.getMessage(), e);
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    private void addButtonPanel() {
        int iconSize = PosUIManager.getSize(16);
        this.btnBack = new JButton();
        this.btnBack.setIcon(IconFontSwing.buildIcon((IconCode)GoogleMaterialDesignIcons.NAVIGATE_BEFORE, (float)iconSize));
        this.btnBack.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MenuCategoryExplorer.this.showMenuCategories(MenuCategoryExplorer.this.tableModel.getPreviousRowIndex());
            }
        });
        this.btnForward = new JButton();
        this.btnForward.setIcon(IconFontSwing.buildIcon((IconCode)GoogleMaterialDesignIcons.NAVIGATE_NEXT, (float)iconSize));
        this.btnForward.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MenuCategoryExplorer.this.showMenuCategories(MenuCategoryExplorer.this.tableModel.getNextRowIndex());
            }
        });
        this.lblNumberOfItem = new JLabel();
        JButton addButton = new JButton(POSConstants.ADD);
        addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    MenuCategoryForm editor = new MenuCategoryForm();
                    BeanEditorDialog dialog = new BeanEditorDialog((Frame)POSUtil.getBackOfficeWindow(), (BeanEditor)editor);
                    dialog.setPreferredSize(PosUIManager.getSize(600, 600));
                    dialog.open();
                    if (dialog.isCanceled()) {
                        return;
                    }
                    MenuCategory foodCategory = (MenuCategory)editor.getBean();
                    MenuCategoryExplorer.this.tableModel.addRow(foodCategory);
                }
                catch (Exception x) {
                    BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, x);
                }
            }
        });
        JButton editButton = new JButton(POSConstants.EDIT);
        editButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MenuCategoryExplorer.this.editSelectedRow();
            }
        });
        JButton deleteButton = new JButton(POSConstants.DELETE);
        deleteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MenuCategoryExplorer.this.doDeleteCategory();
            }
        });
        JPanel bottomPanel = new JPanel(new BorderLayout());
        JPanel btnPanel = new JPanel();
        JPanel paginationPanel = new JPanel();
        btnPanel.add(addButton);
        btnPanel.add(editButton);
        btnPanel.add(deleteButton);
        paginationPanel.add(this.lblNumberOfItem);
        paginationPanel.add(this.btnBack);
        paginationPanel.add(this.btnForward);
        bottomPanel.add(btnPanel);
        bottomPanel.add((Component)paginationPanel, "East");
        this.add((Component)bottomPanel, "South");
    }

    public void editSelectedRow() {
        try {
            int index = this.table.getSelectedRow();
            if (index < 0) {
                POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("SelectToEdit"));
                return;
            }
            index = this.table.convertRowIndexToModel(index);
            MenuCategory category = this.tableModel.getRow(index);
            MenuCategoryForm editor = new MenuCategoryForm(category);
            BeanEditorDialog dialog = new BeanEditorDialog((Frame)POSUtil.getBackOfficeWindow(), (BeanEditor)editor);
            dialog.setPreferredSize(PosUIManager.getSize(600, 600));
            dialog.open();
            if (dialog.isCanceled()) {
                return;
            }
            this.table.repaint();
        }
        catch (Throwable x) {
            BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, x);
        }
    }

    @Override
    public void initData() {
        this.showMenuCategories();
    }

    private void doDeleteCategory() {
        try {
            int index = this.table.getSelectedRow();
            if (index < 0) {
                POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("SelectToDelete"));
                return;
            }
            index = this.table.convertRowIndexToModel(index);
            MenuCategory category = this.tableModel.getRow(index);
            if (POSMessageDialog.showYesNoQuestionDialog(POSUtil.getBackOfficeWindow(), POSConstants.CONFIRM_DELETE, POSConstants.DELETE) != 0) {
                return;
            }
            MenuGroupDAO menuGroupDao = new MenuGroupDAO();
            boolean hasMenuGroups = menuGroupDao.existsMenuGroups(category);
            if (hasMenuGroups && POSMessageDialog.showYesNoQuestionDialog(POSUtil.getBackOfficeWindow(), Messages.getString("MenuCategoryExplorer.0"), POSConstants.DELETE) != 0) {
                return;
            }
            MenuCategoryDAO dao = new MenuCategoryDAO();
            dao.delete(category);
            this.tableModel.removeRow(category);
        }
        catch (Exception x) {
            BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, x);
        }
    }
}

