/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.bo.ui.explorer;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosException;
import com.floreantpos.bo.ui.BOMessageDialog;
import com.floreantpos.model.MenuShift;
import com.floreantpos.model.dao.MenuShiftDAO;
import com.floreantpos.model.dao.ShiftDAO;
import com.floreantpos.swing.ListTableModel;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.TransparentPanel;
import com.floreantpos.ui.PosTableRenderer;
import com.floreantpos.ui.dialog.ConfirmDeleteDialog;
import com.floreantpos.ui.dialog.DetailsInfoDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.model.MenuShiftEntryDialog;
import com.floreantpos.util.POSUtil;
import com.floreantpos.util.ShiftUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;

public class MenuShiftExplorer
extends TransparentPanel {
    private JTable table;
    private MenuShiftTableModel tableModel;

    public MenuShiftExplorer() {
        List<MenuShift> shifts = MenuShiftDAO.getInstance().findAll();
        this.tableModel = new MenuShiftTableModel(shifts);
        this.table = new JTable(this.tableModel);
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent me) {
                if (me.getClickCount() == 2) {
                    MenuShiftExplorer.this.editSelectedRow();
                }
            }
        });
        this.table.setDefaultRenderer(Object.class, new PosTableRenderer());
        this.table.setRowHeight(PosUIManager.getSize(30));
        this.setLayout(new BorderLayout(5, 5));
        this.add(new JScrollPane(this.table));
        JButton addButton = new JButton(POSConstants.ADD);
        addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    MenuShiftEntryDialog dialog = new MenuShiftEntryDialog();
                    dialog.open();
                    if (dialog.isCanceled()) {
                        return;
                    }
                    MenuShift shift = dialog.getCategoryShift();
                    MenuShiftExplorer.this.tableModel.addItem(shift);
                }
                catch (Exception x) {
                    BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, x);
                }
            }
        });
        JButton editButton = new JButton(POSConstants.EDIT);
        editButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MenuShiftExplorer.this.editSelectedRow();
            }
        });
        JButton deleteButton = new JButton(POSConstants.DELETE);
        deleteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    int index = MenuShiftExplorer.this.table.getSelectedRow();
                    if (index < 0) {
                        POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("MenuShiftExplorer.0"));
                        return;
                    }
                    MenuShift menuShift = (MenuShift)MenuShiftExplorer.this.tableModel.getRowData(index);
                    if (ConfirmDeleteDialog.showMessage(MenuShiftExplorer.this, POSConstants.CONFIRM_DELETE, POSConstants.DELETE) == 0) {
                        ShiftDAO.getInstance().delete(menuShift);
                        MenuShiftExplorer.this.tableModel.deleteItem(index);
                    }
                }
                catch (PosException x) {
                    DetailsInfoDialog dialog = new DetailsInfoDialog(x.getMessage(), x.getDetails());
                    dialog.open();
                }
                catch (Exception x) {
                    POSMessageDialog.showError(POSConstants.ERROR_MESSAGE, x);
                }
            }
        });
        TransparentPanel panel = new TransparentPanel();
        panel.add(addButton);
        panel.add(editButton);
        panel.add(deleteButton);
        this.add((Component)panel, "South");
    }

    private void editSelectedRow() {
        try {
            int index = this.table.getSelectedRow();
            if (index < 0) {
                POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("MenuShiftExplorer.1"));
                return;
            }
            MenuShift shift = (MenuShift)this.tableModel.getRowData(index);
            MenuShiftEntryDialog dialog = new MenuShiftEntryDialog();
            dialog.setMenuShift(shift);
            dialog.open();
            if (dialog.isCanceled()) {
                return;
            }
            this.tableModel.updateItem(index);
        }
        catch (Throwable x) {
            BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, x);
        }
    }

    class MenuShiftTableModel
    extends ListTableModel {
        MenuShiftTableModel(List list) {
            super(new String[]{POSConstants.NAME, POSConstants.DESCRIPTION, Messages.getString("MenuShiftExplorer.2"), POSConstants.START_TIME, POSConstants.END_TIME, Messages.getString("MenuShiftExplorer.3"), Messages.getString("MenuShiftExplorer.4"), Messages.getString("ACTIVE")}, list);
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            MenuShift shift = (MenuShift)this.rows.get(rowIndex);
            if (shift == null) {
                return null;
            }
            switch (columnIndex) {
                case 0: {
                    return shift.getName();
                }
                case 1: {
                    return shift.getDescription();
                }
                case 2: {
                    return shift.getDayOfWeekAsString();
                }
                case 3: {
                    return ShiftUtil.buildShiftTimeRepresentation(shift.getStartTime());
                }
                case 4: {
                    return ShiftUtil.buildShiftTimeRepresentation(shift.getEndTime());
                }
                case 5: {
                    return shift.getPriority();
                }
                case 6: {
                    return shift.isAnyDay();
                }
                case 7: {
                    return shift.isEnable();
                }
            }
            return null;
        }
    }
}

