/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.bo.ui.explorer;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosException;
import com.floreantpos.bo.ui.BOMessageDialog;
import com.floreantpos.bo.ui.CustomCellRenderer;
import com.floreantpos.bo.ui.explorer.ExplorerButtonPanel;
import com.floreantpos.bo.ui.explorer.ExplorerView;
import com.floreantpos.model.ModifierGroup;
import com.floreantpos.model.dao.ModifierGroupDAO;
import com.floreantpos.swing.BeanTableModel;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.TransparentPanel;
import com.floreantpos.ui.BeanEditor;
import com.floreantpos.ui.dialog.BeanEditorDialog;
import com.floreantpos.ui.dialog.ConfirmDeleteDialog;
import com.floreantpos.ui.dialog.DetailsInfoDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.model.ModifierGroupForm;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.table.TableCellRenderer;
import jiconfont.IconCode;
import jiconfont.icons.GoogleMaterialDesignIcons;
import jiconfont.swing.IconFontSwing;
import net.miginfocom.swing.MigLayout;
import org.jdesktop.swingx.JXTable;

public class ModifierGroupExplorer
extends TransparentPanel
implements ExplorerView {
    private JXTable table;
    private BeanTableModel<ModifierGroup> tableModel;
    private JTextField tfNameField;
    private JButton btnBack;
    private JButton btnForward;
    private JLabel lblNumberOfItem;

    public ModifierGroupExplorer() {
        this.setLayout(new BorderLayout(5, 5));
        this.tableModel = new BeanTableModel(ModifierGroup.class);
        this.tableModel.addColumn(POSConstants.NAME, ModifierGroup.PROP_NAME);
        this.tableModel.addColumn(POSConstants.TRANSLATED_NAME, ModifierGroup.PROP_TRANSLATED_NAME);
        this.tableModel.addColumn(POSConstants.MODIFIERS, "modifiers");
        this.table = new JXTable(this.tableModel);
        this.table.addMouseListener((MouseListener)this.doEditByDoubleClick());
        this.table.setDefaultRenderer(Object.class, (TableCellRenderer)new CustomCellRenderer());
        this.table.setRowHeight(PosUIManager.getSize(30));
        this.add((Component)this.createSearchPanel(), "North");
        this.add(new JScrollPane((Component)this.table));
        this.createButtonPanel();
    }

    private void createButtonPanel() {
        ExplorerButtonPanel explorerButton = new ExplorerButtonPanel();
        JButton editButton = explorerButton.getEditButton();
        JButton addButton = explorerButton.getAddButton();
        JButton deleteButton = explorerButton.getDeleteButton();
        editButton.addActionListener(this.doEdit());
        addButton.addActionListener(this.doAdd());
        deleteButton.addActionListener(this.doDelete());
        int iconSize = PosUIManager.getSize(16);
        this.btnBack = new JButton();
        this.btnBack.setIcon(IconFontSwing.buildIcon((IconCode)GoogleMaterialDesignIcons.NAVIGATE_BEFORE, (float)iconSize));
        this.btnBack.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ModifierGroupExplorer.this.showMenuGrpups(ModifierGroupExplorer.this.tableModel.getPreviousRowIndex());
            }
        });
        this.btnForward = new JButton();
        this.btnForward.setIcon(IconFontSwing.buildIcon((IconCode)GoogleMaterialDesignIcons.NAVIGATE_NEXT, (float)iconSize));
        this.btnForward.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ModifierGroupExplorer.this.showMenuGrpups(ModifierGroupExplorer.this.tableModel.getNextRowIndex());
            }
        });
        this.lblNumberOfItem = new JLabel();
        JPanel bottomPanel = new JPanel(new BorderLayout());
        JPanel btnPanel = new JPanel();
        JPanel paginationPanel = new JPanel();
        btnPanel.add(addButton);
        btnPanel.add(editButton);
        btnPanel.add(deleteButton);
        paginationPanel.add(this.lblNumberOfItem);
        paginationPanel.add(this.btnBack);
        paginationPanel.add(this.btnForward);
        bottomPanel.add(btnPanel);
        bottomPanel.add((Component)paginationPanel, "East");
        this.add((Component)bottomPanel, "South");
    }

    @Override
    public void initData() {
        this.showMenuGrpups();
    }

    private MouseAdapter doEditByDoubleClick() {
        return new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent me) {
                if (me.getClickCount() == 2) {
                    ModifierGroupExplorer.this.editModifierGroups();
                }
            }
        };
    }

    private ActionListener doDelete() {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    int index = ModifierGroupExplorer.this.table.getSelectedRow();
                    if (index < 0) {
                        POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("SelectToDelete"));
                        return;
                    }
                    index = ModifierGroupExplorer.this.table.convertRowIndexToModel(index);
                    if (ConfirmDeleteDialog.showMessage(ModifierGroupExplorer.this, POSConstants.CONFIRM_DELETE, POSConstants.DELETE) != 1) {
                        ModifierGroup category = (ModifierGroup)ModifierGroupExplorer.this.tableModel.getRow(index);
                        ModifierGroupDAO modifierCategoryDAO = new ModifierGroupDAO();
                        modifierCategoryDAO.delete(category);
                        ModifierGroupExplorer.this.tableModel.removeRow(index);
                    }
                }
                catch (PosException x) {
                    DetailsInfoDialog dialog = new DetailsInfoDialog(x.getMessage(), x.getDetails());
                    dialog.open();
                }
                catch (Throwable x) {
                    BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, x);
                }
            }
        };
    }

    private ActionListener doAdd() {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    ModifierGroupForm editor = new ModifierGroupForm();
                    BeanEditorDialog dialog = new BeanEditorDialog((Frame)POSUtil.getBackOfficeWindow(), (BeanEditor)editor);
                    dialog.setPreferredSize(PosUIManager.getSize(700, 720));
                    dialog.open();
                    if (dialog.isCanceled()) {
                        return;
                    }
                    ModifierGroup modifierGroup = (ModifierGroup)editor.getBean();
                    ModifierGroupExplorer.this.tableModel.addRow(modifierGroup);
                }
                catch (Throwable x) {
                    BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, x);
                }
            }
        };
    }

    private ActionListener doEdit() {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ModifierGroupExplorer.this.editModifierGroups();
            }
        };
    }

    private JPanel createSearchPanel() {
        JPanel northPanel = new JPanel((LayoutManager)new MigLayout("", "[][]10[][]10[]", "[]10[]"));
        northPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("Search")));
        JLabel nameLabel = new JLabel(Messages.getString("NAME"));
        this.tfNameField = new JTextField(20);
        this.tfNameField.addKeyListener(this.doSearchByKeyListener());
        JButton btnSearch = new JButton(Messages.getString("Search"));
        btnSearch.addActionListener(this.doSearch());
        JButton btnRefresh = new JButton(POSConstants.REFRESH);
        btnRefresh.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    ModifierGroupExplorer.this.initData();
                }
                catch (Exception e2) {
                    POSMessageDialog.showError(POSUtil.getFocusedWindow(), e2.getMessage(), e2);
                }
            }
        });
        northPanel.add((Component)nameLabel, "align label");
        northPanel.add(this.tfNameField);
        northPanel.add(btnSearch);
        northPanel.add(btnRefresh);
        return northPanel;
    }

    private KeyListener doSearchByKeyListener() {
        return new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
                if (ModifierGroupExplorer.this.tfNameField.getText().length() > 2) {
                    ModifierGroupExplorer.this.showMenuGrpups();
                }
            }

            @Override
            public void keyPressed(KeyEvent e) {
                int key = e.getKeyCode();
                if (key == 10) {
                    ModifierGroupExplorer.this.showMenuGrpups();
                }
            }
        };
    }

    private ActionListener doSearch() {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    ModifierGroupExplorer.this.showMenuGrpups();
                }
                catch (Exception e2) {
                    POSMessageDialog.showError(POSUtil.getFocusedWindow(), e2.getMessage(), e2);
                }
            }
        };
    }

    private void showMenuGrpups() {
        this.showMenuGrpups(0);
    }

    private void showMenuGrpups(Integer index) {
        try {
            this.setCursor(Cursor.getPredefinedCursor(3));
            String txName = this.tfNameField.getText();
            if (index != null) {
                this.tableModel.setCurrentRowIndex(index);
            }
            ModifierGroupDAO.getInstance().findModifierGroups(this.tableModel, txName);
            this.lblNumberOfItem.setText(this.tableModel.getDisplayText());
            this.btnBack.setEnabled(this.tableModel.hasPrevious());
            this.btnForward.setEnabled(this.tableModel.hasNext());
        }
        catch (Exception e) {
            POSMessageDialog.showError(this, e.getMessage(), e);
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    private void editModifierGroups() {
        try {
            int index = this.table.getSelectedRow();
            if (index < 0) {
                POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("SelectToEdit"));
                return;
            }
            index = this.table.convertRowIndexToModel(index);
            ModifierGroup category = this.tableModel.getRow(index);
            ModifierGroupForm editor = new ModifierGroupForm(category);
            BeanEditorDialog dialog = new BeanEditorDialog((Frame)POSUtil.getBackOfficeWindow(), (BeanEditor)editor);
            dialog.setPreferredSize(PosUIManager.getSize(700, 720));
            dialog.open();
            if (dialog.isCanceled()) {
                return;
            }
            this.table.repaint();
        }
        catch (Throwable x) {
            BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, x);
        }
    }
}

