/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.bo.ui.explorer;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.config.TerminalConfig;
import com.floreantpos.config.ui.ConfigurationView;
import com.floreantpos.model.Department;
import com.floreantpos.model.SalesArea;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.TerminalType;
import com.floreantpos.model.dao.DepartmentDAO;
import com.floreantpos.model.dao.SalesAreaDAO;
import com.floreantpos.model.dao.TerminalDAO;
import com.floreantpos.model.dao.TerminalTypeDAO;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.model.util.DateUtil;
import com.floreantpos.swing.ComboBoxModel;
import com.floreantpos.swing.DoubleTextField;
import com.floreantpos.swing.IntegerTextField;
import com.floreantpos.swing.POSTextField;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.util.UiUtil;
import com.floreantpos.util.POSUtil;
import com.floreantpos.util.PosGuiUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Random;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang.StringUtils;
import org.jdesktop.swingx.JXDatePicker;

public class TerminalForm
extends ConfigurationView {
    private JLabel lblTerminalId;
    private POSTextField tfTerminalId;
    private JButton btnTerminalGen;
    private JLabel lblTerminalName;
    private POSTextField tfTerminalName;
    private JLabel lblLocation;
    private POSTextField tfLocation;
    private JLabel lblDeptName;
    private JComboBox cbDeptList;
    private JCheckBox cbTicketSettlement;
    private JCheckBox cbDbConfig;
    private JCheckBox cbEnableAutoLogOff;
    private JCheckBox cbTranslatedName;
    private JCheckBox chbKioskMode;
    private JCheckBox cbBarcode;
    private JCheckBox cbKitchenReceipt;
    private JCheckBox cbMultiCurrency;
    private JLabel lblAutoLogOffSec;
    private IntegerTextField tfAutoLogOffSec;
    private JLabel lblDefaultPassLen;
    private int terminalId;
    private IntegerTextField tfDefaultPassLen;
    private JLabel lblDefaultDrawerBalance;
    private DoubleTextField tfDefaultDrawerAmount;
    private JCheckBox chkHasCashDrawer;
    private JCheckBox chkActive;
    private JLabel lblSalesArea;
    private JComboBox cbSalesArea;
    private JCheckBox cbFixedSalesArea;
    private JSpinner spinner;
    private JComboBox cbTerminalType = new JComboBox();
    private Department department;
    private List selection;
    private Terminal terminal;
    private JLabel lblOrderViewPageSize;
    private IntegerTextField tfOrderViewPageSize;
    private boolean thisTerminal = true;
    private JCheckBox chkShowPrintBtn;
    private JCheckBox chkMasterTerminal;
    private JXDatePicker dpTicketCreationDate;
    private static final SimpleDateFormat usDateFormat = new SimpleDateFormat("MM/dd/yy");

    public TerminalForm(Terminal terminal) {
        this.terminal = terminal;
        this.setLayout(new BorderLayout());
        this.thisTerminal = this.terminal.equals(DataProvider.get().getCurrentTerminal());
        this.createUI();
        this.initData();
    }

    public void initData() {
        DepartmentDAO deptDAO = new DepartmentDAO();
        ArrayList<Department> deptList = new ArrayList<Department>();
        deptList.add(null);
        deptList.addAll(deptDAO.findAll());
        this.cbDeptList.setModel(new ComboBoxModel(deptList));
        SalesAreaDAO salesAreaDAO = new SalesAreaDAO();
        ArrayList<SalesArea> salesareaList = new ArrayList<SalesArea>();
        salesareaList.add(null);
        salesareaList.addAll(salesAreaDAO.findAll());
        this.cbSalesArea.setModel(new ComboBoxModel(salesareaList));
    }

    private void createTerminal() {
        Random random = new Random();
        this.terminalId = random.nextInt(10000) + 1;
        this.tfTerminalId.setText(String.valueOf(this.terminalId));
    }

    private void createUI() {
        JPanel itemInfoPanel = new JPanel();
        JScrollPane scrollPane = new JScrollPane(itemInfoPanel, 20, 31);
        scrollPane.setBorder(null);
        this.add((Component)scrollPane, "Center");
        itemInfoPanel.setLayout((LayoutManager)new MigLayout("hidemode 3", "[][grow][]", ""));
        this.lblTerminalId = new JLabel(Messages.getString("TerminalEntryForm.3"));
        itemInfoPanel.add((Component)this.lblTerminalId, "alignx trailing");
        this.tfTerminalId = new POSTextField();
        this.tfTerminalId.setEditable(false);
        itemInfoPanel.add((Component)this.tfTerminalId, "growx,split 3");
        ComboBoxModel model = new ComboBoxModel();
        model.addElement((Object)null);
        TerminalTypeDAO.getInstance().findAll().forEach(terminalType -> model.addElement(terminalType));
        this.cbTerminalType.setModel(model);
        itemInfoPanel.add(new JLabel(Messages.getString("TerminalForm.16")));
        itemInfoPanel.add((Component)this.cbTerminalType, "growx, wrap");
        this.btnTerminalGen = new JButton(Messages.getString("Generate"));
        this.lblTerminalName = new JLabel(Messages.getString("NAME"));
        itemInfoPanel.add((Component)this.lblTerminalName, "alignx trailing");
        this.tfTerminalName = new POSTextField();
        itemInfoPanel.add((Component)this.tfTerminalName, "growx, wrap");
        this.lblLocation = new JLabel(Messages.getString("TerminalEntryForm.11"));
        itemInfoPanel.add((Component)this.lblLocation, "alignx trailing");
        this.tfLocation = new POSTextField();
        itemInfoPanel.add((Component)this.tfLocation, "growx, wrap");
        this.lblDeptName = new JLabel(Messages.getString("TerminalEntryForm.20"));
        itemInfoPanel.add((Component)this.lblDeptName, "alignx trailing");
        this.cbDeptList = new JComboBox();
        itemInfoPanel.add((Component)this.cbDeptList, "growx, wrap");
        this.lblSalesArea = new JLabel(Messages.getString("TerminalForm.6"));
        itemInfoPanel.add((Component)this.lblSalesArea, "alignx trailing");
        this.cbSalesArea = new JComboBox();
        itemInfoPanel.add((Component)this.cbSalesArea, "growx,split 2");
        this.cbFixedSalesArea = new JCheckBox(Messages.getString("TerminalForm.7"));
        itemInfoPanel.add((Component)this.cbFixedSalesArea, "wrap");
        this.lblOrderViewPageSize = new JLabel(Messages.getString("TerminalForm.8"));
        itemInfoPanel.add((Component)this.lblOrderViewPageSize, "newline, alignx trailing");
        this.tfOrderViewPageSize = new IntegerTextField();
        itemInfoPanel.add((Component)this.tfOrderViewPageSize, " growx");
        this.lblDefaultPassLen = new JLabel(Messages.getString("TerminalEntryForm.29"));
        itemInfoPanel.add((Component)this.lblDefaultPassLen, "newline, alignx trailing");
        this.tfDefaultPassLen = new IntegerTextField();
        itemInfoPanel.add((Component)this.tfDefaultPassLen, "growx");
        this.lblDefaultDrawerBalance = new JLabel(Messages.getString("TerminalForm.9"));
        itemInfoPanel.add((Component)this.lblDefaultDrawerBalance, "newline, alignx trailing");
        this.tfDefaultDrawerAmount = new DoubleTextField();
        itemInfoPanel.add((Component)this.tfDefaultDrawerAmount, "growx");
        JLabel lblDefaultDate = new JLabel(Messages.getString("TerminalForm.10"));
        itemInfoPanel.add((Component)lblDefaultDate, "newline, alignx trailing");
        this.dpTicketCreationDate = UiUtil.getDeafultDate();
        this.dpTicketCreationDate.setFormats(new DateFormat[]{usDateFormat});
        this.dpTicketCreationDate.getEditor().setEditable(false);
        itemInfoPanel.add((Component)this.dpTicketCreationDate, "width 250! ,split 4");
        JButton clearDate = new JButton(Messages.getString("TerminalForm.15"));
        clearDate.addActionListener(e -> this.doClearTicketCreationDate());
        itemInfoPanel.add((Component)clearDate, "wrap");
        JPanel bottomPanel = new JPanel((LayoutManager)new MigLayout("fillx, insets 0 0 0 0", "[]20px[grow]", ""));
        this.cbEnableAutoLogOff = new JCheckBox(Messages.getString("TerminalEntryForm.36"));
        bottomPanel.add((Component)this.cbEnableAutoLogOff, "split 2,span 2");
        JPanel newPanel = new JPanel(new BorderLayout(10, 0));
        newPanel.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 0));
        this.lblAutoLogOffSec = new JLabel(Messages.getString("TerminalEntryForm.26"));
        newPanel.add((Component)this.lblAutoLogOffSec, "West");
        this.tfAutoLogOffSec = new IntegerTextField(8);
        newPanel.add((Component)this.tfAutoLogOffSec, "Center");
        this.tfAutoLogOffSec.setEnabled(false);
        bottomPanel.add((Component)newPanel, "");
        this.cbTicketSettlement = new JCheckBox(Messages.getString("TerminalEntryForm.32"));
        bottomPanel.add((Component)this.cbTicketSettlement, "newline, growx, wrap");
        this.cbDbConfig = new JCheckBox(Messages.getString("TerminalEntryForm.34"));
        bottomPanel.add((Component)this.cbDbConfig, "growx, wrap");
        this.cbTranslatedName = new JCheckBox(Messages.getString("TerminalEntryForm.38"));
        bottomPanel.add((Component)this.cbTranslatedName, "growx, wrap");
        this.chbKioskMode = new JCheckBox(Messages.getString("TerminalEntryForm.40"));
        bottomPanel.add((Component)this.chbKioskMode, "growx, wrap");
        this.cbBarcode = new JCheckBox(Messages.getString("TerminalEntryForm.42"));
        bottomPanel.add((Component)this.cbBarcode, "growx, wrap");
        this.cbKitchenReceipt = new JCheckBox(Messages.getString("TerminalEntryForm.44"));
        bottomPanel.add((Component)this.cbKitchenReceipt, "growx, wrap");
        this.cbMultiCurrency = new JCheckBox(Messages.getString("TerminalEntryForm.46"));
        bottomPanel.add((Component)this.cbMultiCurrency, "growx, wrap");
        this.chkHasCashDrawer = new JCheckBox(Messages.getString("TerminalForm.11"));
        this.chkActive = new JCheckBox(Messages.getString("ACTIVE"));
        this.chkShowPrintBtn = new JCheckBox(Messages.getString("TerminalForm.13"));
        this.chkMasterTerminal = new JCheckBox(Messages.getString("TerminalForm.14"));
        bottomPanel.add((Component)this.chkHasCashDrawer, "cell 0 10,growx, wrap");
        bottomPanel.add((Component)this.chkActive, "cell 0 11,growx, wrap");
        bottomPanel.add((Component)this.chkShowPrintBtn, "cell 0 12,growx, wrap");
        bottomPanel.add((Component)this.chkMasterTerminal, "cell 0 13,growx, wrap");
        bottomPanel.add((Component)new JLabel(Messages.getString("TerminalForm.19")), "cell 0 15, growx");
        SpinnerNumberModel spinnerModel = new SpinnerNumberModel(1.0, 0.5, 2.5, 0.1);
        this.spinner = new JSpinner(spinnerModel);
        bottomPanel.add((Component)this.spinner, "cell 1 15, width " + PosUIManager.getSize(50));
        itemInfoPanel.add((Component)bottomPanel, "cell 1 17, span 1, growx");
        this.installActions();
    }

    private void doClearTicketCreationDate() {
        this.dpTicketCreationDate.setDate(null);
    }

    private void installActions() {
        this.btnTerminalGen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TerminalForm.this.createTerminal();
            }
        });
        this.cbDeptList.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TerminalForm.this.cbDeptList = (JComboBox)e.getSource();
                TerminalForm.this.department = (Department)TerminalForm.this.cbDeptList.getSelectedItem();
                if (TerminalForm.this.department != null) {
                    TerminalForm.this.selection = new ArrayList();
                    TerminalForm.this.selection.add(null);
                    List<SalesArea> salesAreaByDept = SalesAreaDAO.getInstance().findSalesAreaByDept(TerminalForm.this.department);
                    if (salesAreaByDept != null) {
                        TerminalForm.this.selection.addAll(salesAreaByDept);
                    }
                    TerminalForm.this.cbSalesArea.setModel(new ComboBoxModel(TerminalForm.this.selection));
                } else {
                    TerminalForm.this.selection = new ArrayList();
                    TerminalForm.this.selection.add(null);
                    List<SalesArea> list = SalesAreaDAO.getInstance().findAll();
                    if (list != null) {
                        TerminalForm.this.selection.addAll(list);
                    }
                    TerminalForm.this.cbSalesArea.setModel(new ComboBoxModel(TerminalForm.this.selection));
                }
            }
        });
        this.cbEnableAutoLogOff.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    TerminalForm.this.tfAutoLogOffSec.setEnabled(true);
                } else {
                    TerminalForm.this.tfAutoLogOffSec.setEnabled(false);
                }
            }
        });
    }

    @Override
    public boolean save() {
        try {
            if (!this.updateModel()) {
                return false;
            }
            TerminalDAO termDAO = new TerminalDAO();
            termDAO.saveOrUpdate(this.terminal);
            return true;
        }
        catch (Exception e) {
            POSMessageDialog.showError(e.getMessage());
            return false;
        }
    }

    public void updateView() {
        try {
            if (this.terminal == null) {
                return;
            }
            this.thisTerminal = this.terminal.equals(DataProvider.get().getCurrentTerminal());
            if (this.terminal.getId() != null) {
                this.tfTerminalId.setText(String.valueOf(this.terminal.getId()));
            }
            this.tfTerminalName.setText(this.terminal.getName());
            this.tfLocation.setText(this.terminal.getLocation());
            if (StringUtils.isNotEmpty((String)this.terminal.getDepartmentId())) {
                PosGuiUtil.selectComboItemById(this.cbDeptList, this.terminal.getDepartmentId());
            }
            if (StringUtils.isNotEmpty((String)this.terminal.getSalesAreaId())) {
                PosGuiUtil.selectComboItemById(this.cbSalesArea, this.terminal.getSalesAreaId());
            }
            this.tfAutoLogOffSec.setText(String.valueOf(this.terminal.getAutoLogOffSec()));
            this.tfDefaultPassLen.setText(String.valueOf(this.terminal.getDefaultPassLength()));
            this.cbTicketSettlement.setSelected(this.terminal.isConfirmTicketSettlement());
            this.cbDbConfig.setSelected(this.terminal.isShowDbConfig());
            this.cbEnableAutoLogOff.setSelected(this.terminal.isIsAutoLogOffEnabled());
            this.cbTranslatedName.setSelected(this.terminal.isShowTranslatedName());
            this.cbBarcode.setSelected(this.terminal.isShowBarcodeOnReceipt());
            this.cbKitchenReceipt.setSelected(this.terminal.isGroupByCatagoryKitReceipt());
            this.cbMultiCurrency.setSelected(this.terminal.isEnableMultiCurrency());
            this.chkHasCashDrawer.setSelected(this.terminal.isHasCashDrawer());
            this.chkActive.setSelected(this.terminal.isActive());
            this.chkShowPrintBtn.setSelected(this.terminal.isShowPrntBtn());
            this.chkMasterTerminal.setSelected(this.terminal.isMasterTerminal());
            PosGuiUtil.selectComboItemById(this.cbTerminalType, this.terminal.getTerminalTypeId());
            this.cbFixedSalesArea.setSelected(this.terminal.isFixedSalesArea());
            Date parseDate = TerminalConfig.getTicketCreationDate() == null ? null : DateUtil.parseDate(TerminalConfig.getTicketCreationDate());
            this.dpTicketCreationDate.setDate(parseDate);
            if (this.thisTerminal) {
                this.chbKioskMode.setSelected(TerminalConfig.isKioskMode());
                this.tfOrderViewPageSize.setText(String.valueOf(TerminalConfig.getOrderViewPageSize()));
                this.spinner.setValue(TerminalConfig.getScreenScaleFactor());
                this.tfDefaultDrawerAmount.setText(String.valueOf(TerminalConfig.getDeafultDrawerAmount()));
            } else {
                this.chbKioskMode.setEnabled(false);
                this.tfOrderViewPageSize.setEnabled(false);
                this.tfDefaultDrawerAmount.setEnabled(false);
                this.spinner.setEnabled(false);
            }
            this.setInitialized(true);
        }
        catch (Exception e) {
            POSMessageDialog.showError(this, POSConstants.ERROR_MESSAGE, e);
        }
    }

    public boolean updateModel() {
        int option;
        TerminalDAO.getInstance().refresh(this.terminal);
        int defaultPassLen = this.tfDefaultPassLen.getInteger();
        int pageSize = this.tfOrderViewPageSize.getInteger();
        if (this.thisTerminal && (pageSize <= 0 || pageSize > 500)) {
            POSMessageDialog.showMessage(Messages.getString("TerminalForm.24"));
            return false;
        }
        if (this.tfAutoLogOffSec.getInteger() < 10 && this.cbEnableAutoLogOff.isSelected()) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("AutoLogOffTime"));
            return false;
        }
        this.terminal.setName(this.tfTerminalName.getText());
        this.terminal.setLocation(this.tfLocation.getText());
        this.terminal.setSalesArea((SalesArea)this.cbSalesArea.getSelectedItem());
        this.terminal.setDepartment((Department)this.cbDeptList.getSelectedItem());
        this.terminal.setAutoLogOffSec(this.tfAutoLogOffSec.getInteger());
        this.terminal.setFixedSalesArea(this.cbFixedSalesArea.isSelected());
        this.terminal.setDefaultPassLength(defaultPassLen);
        this.terminal.setConfirmTicketSettlement(this.cbTicketSettlement.isSelected());
        this.terminal.setShowDbConfig(this.cbDbConfig.isSelected());
        this.terminal.setIsAutoLogOffEnabled(this.cbEnableAutoLogOff.isSelected());
        this.terminal.setShowTranslatedName(this.cbTranslatedName.isSelected());
        this.terminal.setShowBarcodeOnReceipt(this.cbBarcode.isSelected());
        this.terminal.setGroupByCatagoryKitReceipt(this.cbKitchenReceipt.isSelected());
        this.terminal.setEnableMultiCurrency(this.cbMultiCurrency.isSelected());
        this.terminal.setTerminalType((TerminalType)this.cbTerminalType.getSelectedItem());
        this.terminal.setHasCashDrawer(this.chkHasCashDrawer.isSelected());
        this.terminal.setActive(this.chkActive.isSelected());
        this.terminal.setShowPrntBtn(this.chkShowPrintBtn.isSelected());
        TerminalConfig.setTicketCreationDate(this.formatTicketCreationDateAsString());
        List<Terminal> masterTerminals = TerminalDAO.getInstance().findMasterTerminal(this.terminal);
        if (masterTerminals != null && !masterTerminals.isEmpty() && this.chkMasterTerminal.isSelected()) {
            option = POSMessageDialog.showYesNoQuestionDialog(POSUtil.getFocusedWindow(), Messages.getString("TerminalForm.25"), Messages.getString("TerminalForm.26"));
            if (option == 0) {
                TerminalDAO.getInstance().resetMasterTerminal(masterTerminals);
                this.terminal.setMasterTerminal(this.chkMasterTerminal.isSelected());
            }
        } else {
            this.terminal.setMasterTerminal(this.chkMasterTerminal.isSelected());
        }
        if (this.thisTerminal) {
            TerminalConfig.setScreenScaleFactor((Double)this.spinner.getValue());
            TerminalConfig.setKioskMode(this.chbKioskMode.isSelected());
            TerminalConfig.setOrderViewPageSize(pageSize);
            TerminalConfig.setDefultDrawerAmount(this.tfDefaultDrawerAmount.getDoubleOrZero());
            TerminalConfig.setShowDbConfigureButton(this.cbDbConfig.isSelected());
        }
        if (this.chkMasterTerminal.isSelected()) {
            POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("TerminalConfigurationView.40"));
        } else if ((masterTerminals == null || masterTerminals.size() < 1) && (option = POSMessageDialog.showYesNoQuestionDialog(this, Messages.getString("TerminalConfigurationView.100"), Messages.getString("CONFIRM"))) != 0) {
            return false;
        }
        return true;
    }

    private String formatTicketCreationDateAsString() {
        Date date = this.dpTicketCreationDate.getDate();
        if (date == null) {
            return null;
        }
        return DateUtil.formatDate(date);
    }

    @Override
    public void initialize() throws Exception {
        this.updateView();
    }

    @Override
    public String getName() {
        return POSConstants.CONFIG_TAB_STORE;
    }
}

