/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.bo.ui.explorer;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosLog;
import com.floreantpos.bo.ui.BOMessageDialog;
import com.floreantpos.bo.ui.CustomCellRenderer;
import com.floreantpos.main.Application;
import com.floreantpos.model.OrderType;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.User;
import com.floreantpos.model.dao.OrderTypeDAO;
import com.floreantpos.model.dao.TicketDAO;
import com.floreantpos.model.dao.UserDAO;
import com.floreantpos.model.util.DateUtil;
import com.floreantpos.swing.BeanTableModel;
import com.floreantpos.swing.ListComboBoxModel;
import com.floreantpos.swing.MultiSelectComboBox;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.TransparentPanel;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.util.UiUtil;
import com.floreantpos.ui.views.OrderInfoDialog;
import com.floreantpos.ui.views.OrderInfoView;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.RowSorter;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.event.RowSorterEvent;
import javax.swing.event.RowSorterListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableRowSorter;
import jiconfont.IconCode;
import jiconfont.icons.GoogleMaterialDesignIcons;
import jiconfont.swing.IconFontSwing;
import net.miginfocom.swing.MigLayout;
import org.jdesktop.swingx.JXDatePicker;
import org.jdesktop.swingx.JXTable;

public class TicketExplorer
extends TransparentPanel {
    private boolean stopSorting = false;
    private JXDatePicker fromDatePicker = UiUtil.getCurrentMonthStart();
    private JXDatePicker toDatePicker = UiUtil.getCurrentMonthEnd();
    private JButton btnGo = new JButton(POSConstants.GO);
    private JXTable table;
    private BeanTableModel<Ticket> tableModel;
    private JButton btnDelete;
    private JButton btnDeleteAll;
    private JButton btnOrderInfo;
    private JPanel buildSearchForm;
    private JTextField tfTicketId;
    private JTextField tfMemberName;
    private JButton btnBack;
    private JButton btnForward;
    private JLabel lblNumberOfItem;
    private JComboBox userCombo;
    private MultiSelectComboBox<OrderType> cbMultiOrderType;

    public TicketExplorer() {
        this.initCompponents();
        this.showClosedTickets();
    }

    private void initCompponents() {
        this.setLayout(new BorderLayout());
        this.tableModel = new BeanTableModel(Ticket.class);
        this.tableModel.addColumn(POSConstants.ID, Ticket.PROP_ID);
        this.tableModel.addColumn(POSConstants.ORDER_TYPE, "orderTypeName");
        this.tableModel.addColumn(POSConstants.CUSTOMER, "customerName");
        this.tableModel.addColumn(POSConstants.CREATED_BY, "ownerName");
        this.tableModel.addColumn(POSConstants.CREATE_TIME, Ticket.PROP_CREATE_DATE);
        this.tableModel.addColumn(POSConstants.SETTLE_TIME, Ticket.PROP_CLOSING_DATE);
        this.tableModel.addColumn(Messages.getString("TicketExplorer.3"), "returnDate");
        this.tableModel.addColumn(POSConstants.VOID, Ticket.PROP_VOIDED);
        this.tableModel.addColumn(POSConstants.SUBTOTAL, Ticket.PROP_SUBTOTAL_AMOUNT);
        this.tableModel.addColumn(POSConstants.DISCOUNT, Ticket.PROP_DISCOUNT_AMOUNT);
        this.tableModel.addColumn(POSConstants.TAX, Ticket.PROP_TAX_AMOUNT);
        this.tableModel.addColumn(POSConstants.TOTAL, Ticket.PROP_TOTAL_AMOUNT);
        this.tableModel.addColumn(POSConstants.PAID, Ticket.PROP_PAID);
        this.table = new JXTable(this.tableModel);
        this.table.setAutoResizeMode(4);
        this.table.setDefaultRenderer(Object.class, (TableCellRenderer)new CustomCellRenderer());
        this.table.setDefaultRenderer(Date.class, (TableCellRenderer)new CustomCellRenderer());
        this.table.setRowHeight(PosUIManager.getSize(45));
        this.table.setRowSorter((RowSorter)new TableRowSorter(this.table.getModel()){

            @Override
            public boolean isSortable(int column) {
                if (column == 0 || column == 1 || column == 3 || column == 6) {
                    return Boolean.FALSE;
                }
                return Boolean.TRUE;
            }
        });
        this.table.getRowSorter().addRowSorterListener(new RowSorterListener(){

            @Override
            public void sorterChanged(RowSorterEvent e) {
                if (TicketExplorer.this.stopSorting) {
                    return;
                }
                TicketExplorer.this.showClosedTickets(0);
            }
        });
        int iconSize = PosUIManager.getSize(16);
        this.lblNumberOfItem = new JLabel();
        this.btnBack = new JButton();
        this.btnBack.setIcon(IconFontSwing.buildIcon((IconCode)GoogleMaterialDesignIcons.NAVIGATE_BEFORE, (float)iconSize));
        this.btnForward = new JButton();
        this.btnForward.setIcon(IconFontSwing.buildIcon((IconCode)GoogleMaterialDesignIcons.NAVIGATE_NEXT, (float)iconSize));
        this.btnBack.addActionListener(e -> this.showClosedTickets(this.tableModel.getPreviousRowIndex()));
        this.btnForward.addActionListener(e -> this.showClosedTickets(this.tableModel.getNextRowIndex()));
        this.buildSearchForm = this.buildSearchForm();
        this.add((Component)this.buildSearchForm, "North");
        this.add((Component)new JScrollPane((Component)this.table), "Center");
        this.addButtonPanel();
    }

    private JPanel buildSearchForm() {
        JPanel mainPanel = new JPanel(new BorderLayout());
        Border loweredetched = BorderFactory.createEtchedBorder(1);
        TitledBorder title = BorderFactory.createTitledBorder(loweredetched, Messages.getString("Search"));
        title.setTitleJustification(1);
        mainPanel.setBorder(title);
        JPanel leftPanel = new JPanel();
        try {
            leftPanel.setLayout((LayoutManager)new MigLayout());
            JLabel lblTicketId = new JLabel(Messages.getString("TicketExplorer.0"));
            this.tfTicketId = new JTextField(15);
            leftPanel.add(lblTicketId);
            leftPanel.add(this.tfTicketId);
            JLabel lblcustomerName = new JLabel(Messages.getString("TicketExplorer.4"));
            this.tfMemberName = new JTextField(15);
            leftPanel.add(lblcustomerName);
            leftPanel.add(this.tfMemberName);
            KeyListener keyListener = new KeyListener(){

                @Override
                public void keyTyped(KeyEvent e) {
                }

                @Override
                public void keyReleased(KeyEvent e) {
                    if (((JTextField)e.getComponent()).getText().length() > 3) {
                        TicketExplorer.this.showClosedTickets();
                    }
                    TicketExplorer.this.doRenderSearchFields(TicketExplorer.this.tfTicketId.getText().length() == 0);
                }

                @Override
                public void keyPressed(KeyEvent e) {
                    int key = e.getKeyCode();
                    if (key == 10) {
                        TicketExplorer.this.showClosedTickets();
                    }
                    TicketExplorer.this.doRenderSearchFields(TicketExplorer.this.tfTicketId.getText().length() == 0);
                }
            };
            this.tfTicketId.addKeyListener(keyListener);
            this.tfMemberName.addKeyListener(keyListener);
        }
        catch (Throwable x) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), POSConstants.ERROR_MESSAGE, x);
        }
        mainPanel.add((Component)leftPanel, "West");
        mainPanel.add((Component)this.rightPanel(), "Center");
        return mainPanel;
    }

    private JPanel rightPanel() {
        JPanel topPanel = new JPanel((LayoutManager)new MigLayout());
        this.btnGo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    TicketExplorer.this.showClosedTickets();
                }
                catch (Exception e1) {
                    POSMessageDialog.showError(POSUtil.getBackOfficeWindow(), POSConstants.ERROR_MESSAGE, e1);
                }
            }
        });
        List<User> users = UserDAO.getInstance().findAll();
        Vector<Object> list = new Vector<Object>();
        list.add(POSConstants.ALL);
        list.addAll(users);
        JLabel userLabel = new JLabel(POSConstants.USER + " :");
        this.userCombo = new JComboBox(new ListComboBoxModel(list));
        JLabel lblOrderType = new JLabel(Messages.getString("ReportViewer.1"));
        this.cbMultiOrderType = new MultiSelectComboBox();
        this.cbMultiOrderType.setItems(OrderTypeDAO.getInstance().findAllForReport(false));
        this.cbMultiOrderType.setPreferredSize(PosUIManager.getSize(130, 20));
        topPanel.add((Component)new JLabel(POSConstants.FROM), "grow");
        topPanel.add((Component)this.fromDatePicker, "gapright 10");
        topPanel.add((Component)new JLabel(POSConstants.TO), "grow");
        topPanel.add((Component)this.toDatePicker);
        topPanel.add(lblOrderType);
        topPanel.add(this.cbMultiOrderType);
        topPanel.add(userLabel);
        topPanel.add(this.userCombo);
        topPanel.add((Component)this.btnGo, "width 60!");
        return topPanel;
    }

    private void addButtonPanel() {
        this.btnOrderInfo = new JButton(Messages.getString("TicketExplorer.1"));
        this.btnOrderInfo.addActionListener(e -> this.showOrderInfo());
        this.btnDelete = new JButton(POSConstants.DELETE);
        this.btnDelete.addActionListener(e -> this.doDelete());
        this.btnDeleteAll = new JButton(POSConstants.DELETE_ALL);
        this.btnDeleteAll.addActionListener(e -> this.doDeleteAll());
        JPanel mainPanel = new JPanel(new BorderLayout());
        TransparentPanel panel = new TransparentPanel();
        panel.add(this.btnOrderInfo);
        panel.add(this.btnDelete);
        User currentUser = Application.getCurrentUser();
        this.btnDelete.setVisible((currentUser.isAdministrator() || currentUser.isManager()) && Application.getInstance().isDevelopmentMode());
        JPanel navigationPanel = new JPanel();
        navigationPanel.add(this.lblNumberOfItem);
        navigationPanel.add(this.btnBack);
        navigationPanel.add(this.btnForward);
        mainPanel.add((Component)panel, "Center");
        mainPanel.add((Component)navigationPanel, "East");
        this.add((Component)mainPanel, "South");
    }

    private void showClosedTickets() {
        this.showClosedTickets(0);
    }

    private void doRenderSearchFields(boolean enabled) {
        if (!enabled) {
            this.tfMemberName.setText("");
        }
        this.tfMemberName.setEnabled(enabled);
        this.cbMultiOrderType.setEnabled(enabled);
        this.fromDatePicker.setEnabled(enabled);
        this.toDatePicker.setEnabled(enabled);
        this.userCombo.setEnabled(enabled);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void showClosedTickets(int rowIndex) {
        try {
            this.stopSorting = true;
            this.tableModel.setCurrentRowIndex(rowIndex);
            Date fromDate = this.fromDatePicker.getDate();
            Date toDate = this.toDatePicker.getDate();
            if (fromDate != null && toDate != null && fromDate.after(toDate)) {
                POSMessageDialog.showError(POSUtil.getFocusedWindow(), POSConstants.FROM_DATE_CANNOT_BE_GREATER_THAN_TO_DATE_);
                return;
            }
            if (fromDate != null) {
                fromDate = DateUtil.startOfDay(fromDate);
            }
            if (toDate != null) {
                toDate = DateUtil.endOfDay(toDate);
            }
            fromDate = DateUtil.startOfDay(fromDate);
            toDate = DateUtil.endOfDay(toDate);
            String txTicketId = this.tfTicketId.getText();
            String txMemberName = this.tfMemberName.getText();
            User user = null;
            if (!this.userCombo.getSelectedItem().equals(POSConstants.ALL)) {
                user = (User)this.userCombo.getSelectedItem();
            }
            TicketDAO.getInstance().loadClosedTicket(this.tableModel, txTicketId, txMemberName, fromDate, toDate, user, this.cbMultiOrderType.getSelectedItems(), this.getRowSortingFieldsName());
            int startNumber = this.tableModel.getCurrentRowIndex() + 1;
            int endNumber = this.tableModel.getNextRowIndex();
            int totalNumber = this.tableModel.getNumRows();
            if (endNumber > totalNumber) {
                endNumber = totalNumber;
            }
            this.lblNumberOfItem.setText(String.format(Messages.getString("TicketExplorer.2"), startNumber, endNumber, totalNumber));
            this.btnBack.setEnabled(this.tableModel.hasPrevious());
            this.btnForward.setEnabled(this.tableModel.hasNext());
        }
        catch (Exception e) {
            POSMessageDialog.showError(e.getMessage(), e);
        }
        finally {
            this.stopSorting = false;
        }
    }

    private List<SortData> getRowSortingFieldsName() {
        List<RowSorter.SortKey> sortKeys = this.table.getRowSorter().getSortKeys();
        if (sortKeys.isEmpty()) {
            return null;
        }
        ArrayList<SortData> sortFields = new ArrayList<SortData>();
        RowSorter.SortKey sortKey = sortKeys.get(0);
        String column = this.tableModel.getColumnBeanAttributeName(sortKey.getColumn());
        SortData sortDatas = new SortData(column, sortKey.getSortOrder().name());
        sortFields.add(sortDatas);
        return sortFields;
    }

    private void doDeleteAll() {
        try {
            List<Ticket> tickets = this.tableModel.getRows();
            if (tickets.isEmpty()) {
                return;
            }
            if (POSMessageDialog.showYesNoQuestionDialog(POSUtil.getBackOfficeWindow(), POSConstants.CONFIRM_DELETE, POSConstants.DELETE_ALL) != 0) {
                return;
            }
            TicketDAO.getInstance().deleteTickets(tickets);
            this.tableModel.removeAll();
            this.table.revalidate();
            this.table.repaint();
            this.showClosedTickets();
        }
        catch (Exception x) {
            BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, x);
        }
    }

    private void doDelete() {
        try {
            int index = this.table.getSelectedRow();
            if (index < 0) {
                POSMessageDialog.showMessage(POSUtil.getBackOfficeWindow(), POSConstants.SELECT_ONE_TICKET_TO_VOID);
                return;
            }
            index = this.table.convertRowIndexToModel(index);
            ArrayList<Ticket> tickets = new ArrayList<Ticket>();
            Ticket ticket = this.tableModel.getRows().get(index);
            TicketDAO.getInstance().refresh(ticket);
            tickets.add(ticket);
            if (POSMessageDialog.showYesNoQuestionDialog(POSUtil.getBackOfficeWindow(), POSConstants.CONFIRM_DELETE, POSConstants.DELETE) != 0) {
                return;
            }
            TicketDAO.getInstance().deleteTickets(tickets);
            this.tableModel.removeRow(index);
            this.table.revalidate();
            this.table.repaint();
            this.showClosedTickets();
        }
        catch (Exception x) {
            BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, x);
        }
    }

    private void showOrderInfo() {
        try {
            int index = this.table.getSelectedRow();
            if (index < 0) {
                POSMessageDialog.showError(POSUtil.getBackOfficeWindow(), POSConstants.SELECT_TICKET);
                return;
            }
            index = this.table.convertRowIndexToModel(index);
            Ticket ticket = this.tableModel.getRows().get(index);
            Ticket ticketFull = TicketDAO.getInstance().loadFullTicket(ticket.getId());
            ArrayList<Ticket> ticketsToShow = new ArrayList<Ticket>();
            ticketsToShow.add(ticketFull);
            try {
                OrderInfoView view = new OrderInfoView(ticketsToShow);
                OrderInfoDialog dialog = new OrderInfoDialog(view);
                dialog.setSize(600, 700);
                dialog.setDefaultCloseOperation(2);
                dialog.open();
            }
            catch (Exception e) {
                PosLog.error(this.getClass(), e);
            }
        }
        catch (Exception e) {
            POSMessageDialog.showError(Application.getPosWindow(), POSConstants.ERROR_MESSAGE, e);
        }
    }

    public class SortData {
        private String columnName;
        private String sortOrder;

        public SortData(String columnName, String sortOrder) {
            this.columnName = columnName;
            this.sortOrder = sortOrder;
        }

        public String getColumnName() {
            return this.columnName;
        }

        public void setColumnName(String columnName) {
            this.columnName = columnName;
        }

        public String getSortOrder() {
            return this.sortOrder;
        }

        public void setSortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
        }
    }
}

