/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.bo.ui.menudesigner;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.bo.ui.menudesigner.PageItemActionSelectorDialog;
import com.floreantpos.config.TerminalConfig;
import com.floreantpos.main.Application;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.MenuPage;
import com.floreantpos.model.MenuPageItem;
import com.floreantpos.model.OrderType;
import com.floreantpos.model.dao.MenuItemDAO;
import com.floreantpos.model.dao.MenuPageDAO;
import com.floreantpos.model.dao.MenuPageItemDAO;
import com.floreantpos.model.dao.OrderTypeDAO;
import com.floreantpos.swing.MultiSelectComboBox;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.TransparentPanel;
import com.floreantpos.ui.BeanEditor;
import com.floreantpos.ui.RefreshableView;
import com.floreantpos.ui.dialog.BeanEditorDialog;
import com.floreantpos.ui.dialog.MenuItemSelectionDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.model.MenuItemForm;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ItemEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.TransferHandler;
import net.miginfocom.swing.MigLayout;
import org.hibernate.StaleStateException;

public class MenuPageDesignView
extends TransparentPanel
implements RefreshableView {
    public static final String VIEW_NAME = "ITEM_VIEW";
    private static final int HORIZONTAL_GAP = 5;
    private static final int VERTICAL_GAP = 5;
    private Dimension buttonSize;
    private MenuPage menuPage;
    private JPanel buttonPanelContainer = new JPanel((LayoutManager)new MigLayout("center,wrap 4"));
    private Integer cols = 0;
    private Integer rows = 0;
    private MenuPageItem dropItem = null;
    private JPanel topPanel = new JPanel((LayoutManager)new MigLayout("ins 5 5"));
    private MultiSelectComboBox<OrderType> cbMultiSelectOrderType = new MultiSelectComboBox();
    private JButton btnSave;
    private JButton btnCancel;
    private JButton btnDetachedAll;

    public MenuPageDesignView() {
        this.initComponent();
    }

    private void initComponent() {
        this.buttonSize = new Dimension(TerminalConfig.getMenuItemButtonWidth(), TerminalConfig.getMenuItemButtonHeight());
        this.setLayout(new BorderLayout(5, 5));
        this.buttonPanelContainer.setBackground(Color.GRAY);
        this.buttonPanelContainer.setOpaque(true);
        this.topPanel.add(new JLabel(POSConstants.ORDER_TYPE));
        this.populateOrderTypes();
        this.cbMultiSelectOrderType.addItemListener(e -> this.orderTypeSelectionChanged(e));
        this.topPanel.add(this.cbMultiSelectOrderType, "w 150!");
        this.btnSave = new JButton(Messages.getString("MenuPageDesigner.26"));
        this.btnSave.setEnabled(false);
        this.btnSave.addActionListener(e -> this.save());
        this.btnCancel = new JButton(Messages.getString("Cancel"));
        this.btnCancel.setEnabled(false);
        this.btnCancel.addActionListener(e -> this.doCancel());
        this.topPanel.add((Component)new JSeparator(1), "gapright 10,grow");
        this.btnDetachedAll = new JButton(Messages.getString("MenuPageDesigner.28"));
        this.btnDetachedAll.addActionListener(e -> this.doDetachAllItems());
        this.topPanel.add((Component)this.btnDetachedAll, "flowx,cell 3 0,alignx right");
        this.topPanel.add((Component)this.btnSave, "alignx right");
        this.topPanel.add((Component)this.btnCancel, "align right");
        this.add((Component)this.topPanel, "North");
        this.add(this.buttonPanelContainer);
    }

    private void orderTypeSelectionChanged(ItemEvent e) {
        if (e.getStateChange() != 1) {
            return;
        }
        if (this.menuPage == null) {
            return;
        }
        this.setEnabledSaveAndCancel(true);
    }

    private void populateOrderTypes() {
        this.cbMultiSelectOrderType.setItems(OrderTypeDAO.getInstance().findAll());
    }

    public MenuPage getMenuPage() {
        return this.menuPage;
    }

    public void setMenuPage(MenuPage paramPage) {
        try {
            if (paramPage == null) {
                this.menuPage = null;
                this.reset();
                return;
            }
            this.menuPage = MenuPageDAO.getInstance().getInitialized(paramPage.getId());
            this.cols = this.menuPage.getCols();
            if (this.cols <= 0) {
                this.cols = 4;
            }
            this.rows = this.menuPage.getRows();
            if (this.rows <= 0) {
                this.rows = 4;
            }
            MigLayout migLayout = new MigLayout("center,wrap " + this.cols);
            if (this.menuPage.isFlixibleButtonSize().booleanValue()) {
                migLayout.setLayoutConstraints((Object)"fill");
                migLayout.setColumnConstraints((Object)"fill,grow");
                migLayout.setRowConstraints((Object)"fill,grow");
            }
            this.buttonPanelContainer.setLayout((LayoutManager)migLayout);
            this.rendererSelectedOrderType();
            this.renderItems();
        }
        catch (Exception e) {
            POSMessageDialog.showError(Application.getPosWindow(), e.getMessage(), e);
        }
    }

    protected void renderItems() {
        try {
            String cellKey;
            this.reset();
            if (this.menuPage == null) {
                return;
            }
            List<MenuPageItem> items = this.getItems();
            HashMap<String, ItemButton> cellItemMap = new HashMap<String, ItemButton>();
            for (int row = 0; row < this.rows; ++row) {
                for (int col = 0; col < this.cols; ++col) {
                    cellKey = String.valueOf(col) + String.valueOf(row);
                    MenuPageItem itemForCell = this.getMenuPageItemForCell(col, row, items);
                    ItemButton itemButton = (ItemButton)this.createItemButton(itemForCell);
                    cellItemMap.put(cellKey, itemButton);
                    String constraint = String.format("cell %s %s", col, row);
                    if (!this.menuPage.isFlixibleButtonSize().booleanValue()) {
                        constraint = constraint + String.format(", w %s!, h %s!", this.menuPage.getButtonWidth(), this.menuPage.getButtonHeight());
                    }
                    this.buttonPanelContainer.add((Component)itemButton, constraint);
                }
            }
            for (MenuPageItem item : items) {
                cellKey = String.valueOf(item.getCol()) + String.valueOf(item.getRow());
                ItemButton itemCellButton = (ItemButton)cellItemMap.get(cellKey);
                if (itemCellButton == null) continue;
                itemCellButton.setMenuItem(item.getMenuItem());
            }
            this.revalidate();
            this.repaint();
        }
        catch (Exception e) {
            POSMessageDialog.showError(this, e.getMessage(), e);
        }
    }

    public void reset() {
        this.buttonPanelContainer.removeAll();
        this.buttonPanelContainer.revalidate();
        this.buttonPanelContainer.repaint();
    }

    public void fillSelectedPageItems(List<MenuPageItem> items) {
        int count = 0;
        for (int i = 0; i < this.buttonPanelContainer.getComponents().length; ++i) {
            ItemButton button = (ItemButton)this.buttonPanelContainer.getComponent(i);
            if (button.isEmptyItem()) {
                MenuPageItem pageItem = items.get(count);
                button.setMenuItem(pageItem.getMenuItem());
                ++count;
            }
            if (count == items.size()) break;
        }
    }

    protected AbstractButton createItemButton(Object item) {
        MenuPageItem menuPageItem = (MenuPageItem)item;
        ItemButton itemButton = new ItemButton(menuPageItem);
        return itemButton;
    }

    public void resetPage() {
        for (int i = 0; i < this.buttonPanelContainer.getComponents().length; ++i) {
            MenuPageItem pageItem;
            ItemButton button = (ItemButton)this.buttonPanelContainer.getComponent(i);
            if (button.isEmptyItem() || (pageItem = button.menuPageItem).getId() != null) continue;
            button.setMenuItem(null);
        }
        this.revalidate();
        this.repaint();
        this.setEnabledSaveAndCancel(false);
    }

    private MenuPageItem getMenuPageItemForCell(int col, int row, List<MenuPageItem> pageItems) {
        for (MenuPageItem menuPageItem : pageItems) {
            if (menuPageItem.getCol() != col || menuPageItem.getRow() != row) continue;
            return menuPageItem;
        }
        MenuPageItem itemForCell = new MenuPageItem(col, row);
        itemForCell.setMenuPage(this.menuPage);
        return itemForCell;
    }

    public void save() {
        try {
            if (this.menuPage == null) {
                return;
            }
            this.removeUnusedPageItems(this.menuPage);
            List<OrderType> selectedItems = this.cbMultiSelectOrderType.getSelectedItems();
            String createStringByField = POSUtil.createStringByField(selectedItems, OrderType.class, "getId", true);
            if (createStringByField.equals(POSConstants.ALL)) {
                this.menuPage.setOrderTypeIds(null);
            } else {
                this.menuPage.setOrderTypeIds(createStringByField);
            }
            this.menuPage.setOrderTypeId("");
            MenuPageDAO.getInstance().saveOrUpdate(this.menuPage);
            this.setEnabledSaveAndCancel(false);
        }
        catch (StaleStateException e) {
            POSMessageDialog.showMessageDialogWithReloadButton(this, this);
        }
        catch (Exception e) {
            POSMessageDialog.showError(POSUtil.getBackOfficeWindow(), e.getMessage(), e);
        }
    }

    public void rendererSelectedOrderType() {
        if (this.menuPage == null) {
            this.cbMultiSelectOrderType.unselectAllItems();
            return;
        }
        this.cbMultiSelectOrderType.unselectAllItems();
        List<OrderType> orderTypes = this.menuPage.getOrderTypes();
        if (orderTypes != null) {
            this.cbMultiSelectOrderType.setSelectedItems(orderTypes);
        }
    }

    private void doCancel() {
        try {
            if (this.menuPage == null) {
                return;
            }
            List<MenuPageItem> pageItems = this.menuPage.getPageItems();
            if (pageItems != null) {
                Iterator<MenuPageItem> iterator = pageItems.iterator();
                while (iterator.hasNext()) {
                    MenuPageItem pageItem = iterator.next();
                    if (pageItem.getId() != null) continue;
                    iterator.remove();
                }
            }
            this.refresh();
            this.setEnabledSaveAndCancel(false);
        }
        catch (Exception e) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), e.getMessage());
        }
    }

    public void setEnabledSaveAndCancel(boolean enabled) {
        this.btnSave.setEnabled(enabled);
        this.btnCancel.setEnabled(enabled);
    }

    public boolean isEnabledSaveButton() {
        return this.btnSave.isEnabled();
    }

    public JButton getDetachAllButton() {
        return this.btnDetachedAll;
    }

    @Override
    public void refresh() {
        if (this.menuPage != null) {
            this.setMenuPage(this.menuPage);
        }
    }

    private void removeUnusedPageItems(MenuPage menuPage) {
        List<MenuPageItem> pageItems = menuPage.getPageItems();
        if (pageItems != null) {
            Iterator<MenuPageItem> iterator = pageItems.iterator();
            while (iterator.hasNext()) {
                MenuPageItem oldMenuPageItem = iterator.next();
                if (oldMenuPageItem.getMenuItemId() != null) continue;
                iterator.remove();
            }
        }
    }

    private List<MenuPageItem> getItems() {
        if (this.menuPage == null) {
            return new ArrayList<MenuPageItem>(0);
        }
        List<MenuPageItem> pageItems = this.menuPage.getPageItems();
        if (pageItems == null) {
            pageItems = new ArrayList<MenuPageItem>();
        }
        return pageItems;
    }

    public void doDetachAllItems() {
        try {
            if (this.menuPage == null || this.menuPage.getPageItems() == null || this.menuPage.getPageItems().size() < 1) {
                POSMessageDialog.showMessage(POSUtil.getBackOfficeWindow(), Messages.getString("MenuPageDesigner.53"));
                return;
            }
            if (POSMessageDialog.showYesNoQuestionDialog(POSUtil.getBackOfficeWindow(), Messages.getString("MenuPageDesigner.54"), Messages.getString("CONFIRM")) != 0) {
                return;
            }
            if (this.menuPage.getPageItems() != null) {
                this.menuPage.getPageItems().clear();
            }
            MenuPageDAO.getInstance().saveOrUpdate(this.menuPage);
            this.setMenuPage(this.menuPage);
        }
        catch (StaleStateException e) {
            POSMessageDialog.showMessageDialogWithReloadButton(this, this);
        }
        catch (Exception e) {
            POSMessageDialog.showError(this, e.getMessage(), e);
        }
    }

    public class ItemButton
    extends PosButton
    implements MouseMotionListener,
    MouseListener,
    Transferable {
        MenuPageItem menuPageItem;
        private DataFlavor dataFlavor = new DataFlavor(MenuPageItem.class, "menuPageItem");
        private final DataFlavor[] flavors = new DataFlavor[]{this.dataFlavor};
        private DragAndDropTransferHandler dragDropTransferHandler;

        ItemButton(MenuPageItem menuPageItem) {
            this.menuPageItem = menuPageItem;
            this.setFocusable(true);
            this.setFocusPainted(true);
            this.setVerticalTextPosition(3);
            this.setHorizontalTextPosition(0);
            this.setIconTextGap(0);
            this.setText(Messages.getString("MenuPageDesignView.10"));
            this.setPreferredSize(MenuPageDesignView.this.buttonSize);
            this.updateView();
            this.dragDropTransferHandler = new DragAndDropTransferHandler(this);
            this.setTransferHandler(this.dragDropTransferHandler);
            this.addMouseMotionListener(this);
            this.addMouseListener(this);
        }

        int getRow() {
            return this.menuPageItem.getRow();
        }

        int getCol() {
            return this.menuPageItem.getCol();
        }

        public void setMenuPageItem(MenuPageItem item) {
            this.menuPageItem = item;
        }

        public void setMenuItem(MenuItem menuItem) {
            this.menuPageItem.setMenuItem(menuItem);
            this.menuPageItem.setMenuPage(MenuPageDesignView.this.menuPage);
            this.updateView();
        }

        public boolean isEmptyItem() {
            return this.menuPageItem.getMenuItem() == null;
        }

        public void updateView() {
            MenuItem menuItem = this.menuPageItem.getMenuItem();
            if (menuItem == null) {
                this.setIcon(null);
                this.setBackground(Color.WHITE);
                this.setForeground(Color.BLACK);
                this.setText("<html><body><center>+</center></body></html>");
                return;
            }
            ImageIcon image = menuItem.getImage();
            String displayName = menuItem.getDisplayName();
            if (!menuItem.isVisible().booleanValue()) {
                displayName = displayName + "<br/><i>(Inactive)</i>";
            }
            if (image != null) {
                if (menuItem.isShowImageOnly().booleanValue()) {
                    this.setText("");
                    this.setIcon(image);
                } else {
                    this.setIcon(image);
                    this.setText("<html><body><center>" + displayName + "</center></body></html>");
                }
            } else {
                this.setIcon(null);
                this.setText("<html><body><center>" + displayName + "</center></body></html>");
            }
            Color buttonColor = menuItem.getButtonColor();
            if (buttonColor != null) {
                this.setBackground(buttonColor);
            } else {
                this.setBackground(Color.WHITE);
            }
            Color textColor = menuItem.getTextColor();
            if (textColor != null) {
                this.setForeground(textColor);
            } else {
                this.setForeground(Color.black);
            }
        }

        private void doSelectMenuItem() {
            try {
                MenuItem menuItem = this.menuPageItem.getMenuItem();
                if (menuItem == null) {
                    menuItem = this.doAddMenuItem();
                    if (menuItem == null) {
                        return;
                    }
                } else {
                    PageItemActionSelectorDialog dialog = new PageItemActionSelectorDialog(this.menuPageItem);
                    dialog.setSize(PosUIManager.getSize(500, 350));
                    dialog.open();
                    if (dialog.isCanceled()) {
                        return;
                    }
                    String actionCommand = dialog.getActionCommand();
                    if (actionCommand.equals("REPLACE")) {
                        menuItem = this.doAddMenuItem();
                        if (menuItem == null) {
                            return;
                        }
                    } else if (actionCommand.equals("EDIT")) {
                        this.doEditMenuPageItem(menuItem);
                    } else if (actionCommand.equals("DETACH")) {
                        menuItem = null;
                    }
                }
                this.menuPageItem.setMenuItem(menuItem);
                this.menuPageItem.setMenuPage(MenuPageDesignView.this.menuPage);
                List<MenuPageItem> pageItems = MenuPageDesignView.this.menuPage.getPageItems();
                if (pageItems != null) {
                    Iterator<MenuPageItem> iterator = pageItems.iterator();
                    while (iterator.hasNext()) {
                        MenuPageItem oldMenuPageItem = iterator.next();
                        if (!this.menuPageItem.isRowColumnEquals(oldMenuPageItem)) continue;
                        iterator.remove();
                    }
                }
                MenuPageDesignView.this.menuPage.addTopageItems(this.menuPageItem);
                this.menuPageItem.setMenuPage(MenuPageDesignView.this.menuPage);
                MenuPageDesignView.this.setEnabledSaveAndCancel(true);
                MenuPageDesignView.this.renderItems();
            }
            catch (Exception e) {
                POSMessageDialog.showError(POSUtil.getBackOfficeWindow(), Messages.getString("MenuPageDesignView.17"), e);
            }
        }

        private MenuItem doAddMenuItem() {
            MenuItemSelectionDialog dialog = MenuItemSelectionDialog.getInstance();
            dialog.setSelectionMode(0);
            dialog.setSize(PosUIManager.getSize(800, 600));
            dialog.open();
            if (dialog.isCanceled()) {
                return null;
            }
            MenuItem selectedMenuItem = dialog.getSelectedRowData();
            if (selectedMenuItem == null) {
                return null;
            }
            MenuItemDAO.getInstance().refresh(selectedMenuItem);
            List<MenuPageItem> pageItems = MenuPageDesignView.this.menuPage.getPageItems();
            if (pageItems != null) {
                for (MenuPageItem menuPageItem : pageItems) {
                    if (!selectedMenuItem.getId().equals(menuPageItem.getMenuItemId())) continue;
                    POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("ItemAlreadyExists"));
                    return null;
                }
            }
            return selectedMenuItem;
        }

        public void doReplaceMenuPageItem(MenuItem menuItem) {
            try {
                menuItem = this.doAddMenuItem();
                if (menuItem == null) {
                    return;
                }
            }
            catch (Exception e) {
                return;
            }
        }

        private void doEditMenuPageItem(MenuItem menuItem) {
            try {
                MenuPageItem pItem2;
                MenuItemDAO.getInstance().initialize(menuItem);
                MenuItemForm editor = new MenuItemForm(menuItem);
                BeanEditorDialog formDialog = new BeanEditorDialog((Frame)POSUtil.getBackOfficeWindow(), (BeanEditor)editor);
                formDialog.openWithScale(1000, 700);
                if (formDialog.isCanceled()) {
                    return;
                }
                this.menuPageItem.setMenuItem(menuItem);
                if (this.menuPageItem.getId() != null && (pItem2 = MenuPageItemDAO.getInstance().get(this.menuPageItem.getId())) != null) {
                    this.menuPageItem.setVersion(pItem2.getVersion());
                }
                this.updateView();
            }
            catch (Exception e) {
                POSMessageDialog.showError(this, e.getMessage(), e);
            }
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            try {
                ItemButton itemButton = (ItemButton)e.getSource();
                TransferHandler transferHandler = itemButton.getTransferHandler();
                transferHandler.exportAsDrag(itemButton, e, 2);
            }
            catch (Exception exp) {
                POSMessageDialog.showError(POSUtil.getFocusedWindow(), exp.getMessage());
            }
        }

        @Override
        public void mouseMoved(MouseEvent e) {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            this.doSelectMenuItem();
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            return this.flavors;
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor flavor) {
            for (int i = 0; i < this.flavors.length; ++i) {
                if (!flavor.equals(this.flavors[i])) continue;
                return true;
            }
            return false;
        }

        @Override
        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
            if (flavor.equals(this.dataFlavor)) {
                return this.menuPageItem;
            }
            throw new UnsupportedFlavorException(flavor);
        }
    }

    public class DragAndDropTransferHandler
    extends TransferHandler {
        private ItemButton itemButton = null;

        public DragAndDropTransferHandler(ItemButton itemButton) {
            this.itemButton = itemButton;
        }

        @Override
        public int getSourceActions(JComponent c) {
            return 2;
        }

        @Override
        protected Transferable createTransferable(JComponent c) {
            return this.itemButton;
        }

        @Override
        public boolean canImport(TransferHandler.TransferSupport support) {
            return support.isDataFlavorSupported(this.itemButton.dataFlavor);
        }

        @Override
        protected void exportDone(JComponent source, Transferable data, int action) {
            super.exportDone(source, data, action);
            try {
                if (source instanceof ItemButton && MenuPageDesignView.this.dropItem != null) {
                    this.itemButton.setMenuPageItem(MenuPageDesignView.this.dropItem);
                    MenuPage menuPage = MenuPageDesignView.this.getMenuPage();
                    List<MenuPageItem> pageItems = menuPage.getPageItems();
                    if (pageItems != null) {
                        for (MenuPageItem menuPageItem : pageItems) {
                            if (menuPageItem == null || !menuPageItem.getRandomId().equals(MenuPageDesignView.this.dropItem.getRandomId())) continue;
                            menuPageItem.setRow(this.itemButton.getRow());
                            menuPageItem.setCol(this.itemButton.getCol());
                            break;
                        }
                    }
                    MenuPageDesignView.this.dropItem = null;
                    this.itemButton.updateView();
                    this.itemButton.getModel().setPressed(false);
                }
            }
            catch (Exception e) {
                POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("DragDropError"), e);
            }
        }

        @Override
        public boolean importData(TransferHandler.TransferSupport support) {
            boolean accept = false;
            if (!this.canImport(support)) {
                return false;
            }
            try {
                Transferable importTransferable = support.getTransferable();
                MenuPageItem transferData = (MenuPageItem)importTransferable.getTransferData(this.itemButton.dataFlavor);
                MenuPageDesignView.this.dropItem = this.itemButton.menuPageItem;
                MenuPageDesignView.this.dropItem.setImage(this.itemButton.menuPageItem.getImage());
                MenuPageDesignView.this.dropItem.setImageId(this.itemButton.menuPageItem.getImageId());
                if (transferData != null) {
                    int sourceRow = transferData.getRow();
                    int sourceCol = transferData.getCol();
                    Color buttonColor = transferData.getButtonColor();
                    transferData.setButtonColor(this.itemButton.getBackground());
                    transferData.setRow(this.itemButton.getRow());
                    transferData.setCol(this.itemButton.getCol());
                    this.itemButton.setMenuPageItem(transferData);
                    MenuPage menuPage = MenuPageDesignView.this.getMenuPage();
                    List<MenuPageItem> pageItems = menuPage.getPageItems();
                    for (MenuPageItem menuPageItem : pageItems) {
                        if (menuPageItem == null || !menuPageItem.getRandomId().equals(transferData.getRandomId())) continue;
                        menuPageItem.setRow(this.itemButton.getRow());
                        menuPageItem.setCol(this.itemButton.getCol());
                        break;
                    }
                    MenuPageDesignView.this.dropItem.setButtonColor(buttonColor);
                    MenuPageDesignView.this.dropItem.setRow(sourceRow);
                    MenuPageDesignView.this.dropItem.setCol(sourceCol);
                }
                this.itemButton.updateView();
                MenuPageDesignView.this.setEnabledSaveAndCancel(true);
                accept = true;
            }
            catch (Exception exp) {
                POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("DragDropError"));
            }
            return accept;
        }
    }
}

