/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.bo.ui.modifierdesigner;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.bo.ui.BOMessageDialog;
import com.floreantpos.bo.ui.explorer.PageSelectionListener;
import com.floreantpos.bo.ui.modifierdesigner.ModifierPageDesignView;
import com.floreantpos.bo.ui.modifierdesigner.ModifierPageForm;
import com.floreantpos.model.MenuItemModifierPage;
import com.floreantpos.model.MenuItemModifierPageItem;
import com.floreantpos.model.MenuModifier;
import com.floreantpos.model.ModifierGroup;
import com.floreantpos.swing.PaginatedListModel;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.TransparentPanel;
import com.floreantpos.ui.dialog.BeanEditorDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import jiconfont.IconCode;
import jiconfont.icons.FontAwesome;
import jiconfont.swing.IconFontSwing;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang.StringUtils;

public class ModifierGroupPageDesigner
extends TransparentPanel
implements PageSelectionListener {
    private ModifierPageDesignView itemView;
    private ModifierGroup selectedGroup;
    private MenuItemModifierPage menuItemModifierPage;
    private JButton btnEditPage;
    private PosButton btnNext;
    private PosButton btnPrev;
    private PaginatedListModel dataModel = new PaginatedListModel(1);
    private PosButton btnPageNum;
    private JLabel lblNumberOfItem;
    private JButton btnAddNewPage;
    private JButton btnDeletePage;
    private List<MenuItemModifierPage> allMenuItemModifierPages;

    public ModifierGroupPageDesigner(ModifierGroup modifierGroup) {
        this.selectedGroup = modifierGroup;
        this.allMenuItemModifierPages = modifierGroup.getModifierGroupPages();
        this.initComponents();
        this.dataModel.setCurrentRowIndex(0);
        this.initDataModel();
        this.setDataModel(this.dataModel);
    }

    private void initComponents() {
        this.setLayout(new BorderLayout(5, 0));
        JPanel contentPanel = new JPanel(new BorderLayout());
        contentPanel.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.itemView = new ModifierPageDesignView();
        this.itemView.setPageListener(this);
        JPanel southItemActionPanel = new JPanel((LayoutManager)new MigLayout("center,fillx, ins 5 5 0 0", "[33%][33%][33%]", ""));
        JButton btnDetachedAll = new JButton(Messages.getString("ModifierPageDesigner.4"));
        JButton btnAutoBuild = new JButton(Messages.getString("ModifierPageDesigner.5"));
        this.btnEditPage = new JButton(Messages.getString("ModifierPageDesigner.6"));
        btnDetachedAll.addActionListener(e -> this.doDetachAllItems());
        btnAutoBuild.addActionListener(e -> this.doGenenateMenuItemModifierPageItems());
        this.btnEditPage.addActionListener(e -> this.editPage());
        southItemActionPanel.add((Component)new JLabel(""), "grow");
        southItemActionPanel.add((Component)this.btnEditPage, "split 5");
        southItemActionPanel.add(btnAutoBuild);
        southItemActionPanel.add(btnDetachedAll);
        JPanel paginationButtonPanel = new JPanel((LayoutManager)new MigLayout("ins 0,hidemode 3", "", ""));
        int btnSize = PosUIManager.getSize(16);
        this.lblNumberOfItem = new JLabel();
        paginationButtonPanel.add(this.lblNumberOfItem);
        this.btnPrev = new PosButton();
        this.btnPrev.setToolTipText(POSConstants.CAPITAL_PREV);
        this.btnPrev.setIcon(IconFontSwing.buildIcon((IconCode)FontAwesome.ANGLE_LEFT, (float)btnSize));
        paginationButtonPanel.add((Component)this.btnPrev, "split 5,w 30!, h 24!");
        this.btnPageNum = new PosButton();
        this.btnPageNum.setToolTipText(Messages.getString("EditPage"));
        this.btnPageNum.setBorder(null);
        this.btnPageNum.setOpaque(false);
        this.btnPageNum.setContentAreaFilled(false);
        this.btnPageNum.addActionListener(e -> this.editPage());
        paginationButtonPanel.add((Component)this.btnPageNum, "h 35!");
        this.btnPageNum.setVisible(false);
        this.btnNext = new PosButton();
        this.btnNext.setToolTipText(POSConstants.CAPITAL_NEXT);
        this.btnNext.setIcon(IconFontSwing.buildIcon((IconCode)FontAwesome.ANGLE_RIGHT, (float)btnSize));
        paginationButtonPanel.add((Component)this.btnNext, "w 30!,h 24!");
        this.btnAddNewPage = new JButton(IconFontSwing.buildIcon((IconCode)FontAwesome.PLUS_CIRCLE, (float)btnSize));
        this.btnAddNewPage.setToolTipText(Messages.getString("AddNewPage"));
        paginationButtonPanel.add((Component)this.btnAddNewPage, "w 30!,h 24!");
        this.btnDeletePage = new JButton(IconFontSwing.buildIcon((IconCode)FontAwesome.TRASH, (float)btnSize));
        this.btnDeletePage.setToolTipText(Messages.getString("DeletePage"));
        paginationButtonPanel.add((Component)this.btnDeletePage, "w 30!,h 24!");
        JPanel southButtonPanel = new JPanel((LayoutManager)new MigLayout("fillx, ins 0 0 3 3"));
        southButtonPanel.add((Component)southItemActionPanel, "center, wrap");
        southButtonPanel.add((Component)paginationButtonPanel, "center");
        this.add((Component)southButtonPanel, "South");
        ActionListener action = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    Object source = e.getSource();
                    ModifierGroupPageDesigner.this.updateModel();
                    if (source == ModifierGroupPageDesigner.this.btnPrev) {
                        ModifierGroupPageDesigner.this.scrollUp();
                    } else if (source == ModifierGroupPageDesigner.this.btnNext) {
                        ModifierGroupPageDesigner.this.scrollDown();
                    } else if (source == ModifierGroupPageDesigner.this.btnAddNewPage) {
                        ModifierGroupPageDesigner.this.createNewPage();
                    } else if (source == ModifierGroupPageDesigner.this.btnDeletePage) {
                        ModifierGroupPageDesigner.this.deletePage();
                    }
                }
                catch (Exception e2) {
                    POSMessageDialog.showError(POSUtil.getBackOfficeWindow(), e2.getMessage(), e2);
                }
            }
        };
        this.btnPrev.addActionListener(action);
        this.btnNext.addActionListener(action);
        this.btnAddNewPage.addActionListener(action);
        this.btnDeletePage.addActionListener(action);
        this.btnNext.setEnabled(false);
        this.btnPrev.setEnabled(false);
        this.btnAddNewPage.setEnabled(false);
        this.btnDeletePage.setEnabled(false);
        TitledBorder border = new TitledBorder(POSConstants.MODIFIERS);
        border.setTitleJustification(2);
        this.itemView.setBorder(new CompoundBorder(border, null));
        contentPanel.add(this.itemView);
        this.add(contentPanel);
    }

    private void rendererSelectedGroup() {
        if (this.selectedGroup != null) {
            this.itemView.setMenuItemModifierPage(this.menuItemModifierPage);
        }
        this.btnPageNum.setText(this.menuItemModifierPage.getName());
    }

    private void doDetachAllItems() {
        if (this.menuItemModifierPage == null || this.menuItemModifierPage.getPageItems() == null) {
            POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("ModifierPageDesigner.18"));
            return;
        }
        if (POSMessageDialog.showYesNoQuestionDialog(POSUtil.getFocusedWindow(), Messages.getString("ModifierPageDesigner.19"), Messages.getString("CONFIRM")) != 0) {
            return;
        }
        if (this.menuItemModifierPage.getPageItems() != null) {
            this.menuItemModifierPage.getPageItems().clear();
        }
        this.itemView.setMenuItemModifierPage(this.menuItemModifierPage);
    }

    public void doGenenateMenuItemModifierPageItems() {
        if (this.selectedGroup == null) {
            return;
        }
        List<MenuModifier> items = this.selectedGroup.getModifiers();
        if (items == null || items.isEmpty()) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("ModifierGroupPageDesigner.0"));
            return;
        }
        try {
            if (this.menuItemModifierPage == null) {
                this.doCreateNewPage();
            }
            int pageItemCount = this.menuItemModifierPage.getRows() * this.menuItemModifierPage.getCols();
            int itemSize = items.size();
            ArrayList<MenuItemModifierPageItem> pageItems = new ArrayList<MenuItemModifierPageItem>();
            if (items.size() > 0) {
                Collections.sort(items, (O1, O2) -> O1.getSortOrder().compareTo(O2.getSortOrder()));
                int count = 1;
                for (MenuModifier modifier : items) {
                    MenuItemModifierPageItem pageItem = new MenuItemModifierPageItem();
                    pageItem.setMenuModifier(modifier);
                    pageItem.setParentPage(this.menuItemModifierPage);
                    pageItems.add(pageItem);
                    if (count == pageItemCount || itemSize == count) {
                        this.setDataModel(this.dataModel);
                        this.itemView.fillSelectedPageItems(pageItems);
                        if (itemSize == count) break;
                        this.doCreateNewPage();
                        pageItems = new ArrayList();
                        itemSize -= count;
                        count = 1;
                        this.dataModel.setCurrentRowIndex(this.dataModel.getNextRowIndex());
                        continue;
                    }
                    ++count;
                }
                this.setDataModel(this.dataModel);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            BOMessageDialog.showError(ex.getMessage());
        }
    }

    private void doCreateNewPage() {
        if (this.menuItemModifierPage == null) {
            this.menuItemModifierPage = new MenuItemModifierPage();
        }
        int size = this.allMenuItemModifierPages.size();
        this.menuItemModifierPage.setName(Messages.getString("ModifierPageDesigner.21") + (size + 1));
        this.menuItemModifierPage.setButtonHeight(100);
        this.menuItemModifierPage.setButtonWidth(100);
        this.menuItemModifierPage.setRows(4);
        this.menuItemModifierPage.setCols(4);
        this.menuItemModifierPage.setVisible(true);
        this.menuItemModifierPage.setSortOrder(size + 1);
        this.menuItemModifierPage.setFlixibleButtonSize(false);
        this.allMenuItemModifierPages.add(this.menuItemModifierPage);
        this.dataModel.getDataList().add(this.menuItemModifierPage);
        this.dataModel.setNumRows(this.allMenuItemModifierPages.size());
    }

    private void setDataModel(PaginatedListModel dataModel) {
        this.rendererSelectedGroup();
        String pageName = this.menuItemModifierPage.getName();
        if (StringUtils.isBlank((String)pageName)) {
            pageName = Messages.getString("ModifierPageDesigner.21") + (dataModel.getCurrentRowIndex() + 1);
        }
        this.menuItemModifierPage.setName(pageName);
        this.btnPageNum.setText(pageName);
        this.btnAddNewPage.setEnabled(true);
        this.btnDeletePage.setEnabled(true);
        this.btnPageNum.setVisible(StringUtils.isNotEmpty((String)this.menuItemModifierPage.getName()));
        int startNumber = dataModel.getCurrentRowIndex() + 1;
        int endNumber = dataModel.getNextRowIndex();
        int totalNumber = dataModel.getNumRows();
        if (endNumber > totalNumber) {
            endNumber = totalNumber;
        }
        this.lblNumberOfItem.setText(String.format(Messages.getString("MenuItemExplorer.40"), startNumber, endNumber, totalNumber));
        this.btnPrev.setEnabled(dataModel.hasPrevious());
        this.btnNext.setEnabled(dataModel.hasNext());
    }

    private void initDataModel() {
        HashSet<MenuItemModifierPage> modifierPages = new HashSet<MenuItemModifierPage>(this.allMenuItemModifierPages);
        ArrayList<MenuItemModifierPage> pages = new ArrayList<MenuItemModifierPage>();
        for (MenuItemModifierPage page : modifierPages) {
            pages.add(page);
        }
        Collections.sort(pages, new Comparator<MenuItemModifierPage>(){

            @Override
            public int compare(MenuItemModifierPage o1, MenuItemModifierPage o2) {
                return o1.getSortOrder() - o2.getSortOrder();
            }
        });
        this.dataModel.setNumRows(pages.size());
        this.dataModel.setData(pages);
        if (this.dataModel.getSize() > 0) {
            this.menuItemModifierPage = (MenuItemModifierPage)this.dataModel.getElementAt(this.dataModel.getCurrentRowIndex());
        } else {
            this.doCreateNewPage();
        }
    }

    private void createNewPage() {
        if (POSMessageDialog.showYesNoQuestionDialog(POSUtil.getFocusedWindow(), Messages.getString("ModifierPageDesigner.22"), Messages.getString("CONFIRM")) != 0) {
            return;
        }
        this.menuItemModifierPage = new MenuItemModifierPage();
        this.doCreateNewPage();
        this.itemSelected(this.menuItemModifierPage);
        this.dataModel.setCurrentRowIndex(this.dataModel.getNextRowIndex());
        this.setDataModel(this.dataModel);
    }

    private void scrollDown() {
        this.dataModel.setCurrentRowIndex(this.dataModel.getNextRowIndex());
        this.menuItemModifierPage = (MenuItemModifierPage)this.dataModel.getElementAt(this.dataModel.getCurrentRowIndex());
        this.setDataModel(this.dataModel);
    }

    private void scrollUp() {
        this.dataModel.setCurrentRowIndex(this.dataModel.getPreviousRowIndex());
        this.menuItemModifierPage = (MenuItemModifierPage)this.dataModel.getElementAt(this.dataModel.getCurrentRowIndex());
        this.setDataModel(this.dataModel);
    }

    private void deletePage() {
        if (this.dataModel.getSize() <= 1) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("ModifierPageDesigner.100"));
            return;
        }
        if (POSMessageDialog.showYesNoQuestionDialog(POSUtil.getFocusedWindow(), Messages.getString("ModifierPageDesigner.99"), Messages.getString("CONFIRM")) != 0) {
            return;
        }
        int nextFocusIndex = this.dataModel.getCurrentRowIndex();
        if (this.dataModel.hasPrevious()) {
            nextFocusIndex = this.dataModel.getPreviousRowIndex();
        } else if (this.dataModel.hasNext()) {
            nextFocusIndex = this.dataModel.getNextRowIndex() - 1;
        }
        this.allMenuItemModifierPages.remove(this.menuItemModifierPage);
        this.dataModel.getDataList().remove(this.menuItemModifierPage);
        int rows = this.allMenuItemModifierPages.size();
        this.dataModel.setNumRows(rows);
        this.dataModel.setCurrentRowIndex(nextFocusIndex);
        if (rows >= 1) {
            this.menuItemModifierPage = (MenuItemModifierPage)this.dataModel.getElementAt(this.dataModel.getCurrentRowIndex());
            this.setDataModel(this.dataModel);
        }
    }

    public void reset() {
        this.itemView.reset();
        this.itemView.revalidate();
        this.itemView.repaint();
    }

    public void editPage() {
        if (this.menuItemModifierPage == null) {
            POSMessageDialog.showMessage(this, Messages.getString("ModifierPageDesigner.24"));
            return;
        }
        ModifierPageForm form = new ModifierPageForm(this.menuItemModifierPage);
        BeanEditorDialog dialog = new BeanEditorDialog(form);
        dialog.open();
        if (dialog.isCanceled()) {
            return;
        }
        this.rendererSelectedGroup();
    }

    @Override
    public void itemSelected(Object item) {
    }

    @Override
    public void uiUpdate() {
    }

    public void updateModel() {
        List<MenuItemModifierPage> allGroupModifierPages = this.getAllGroupModifierPages();
        for (MenuItemModifierPage menuItemModifierPage : allGroupModifierPages) {
            if (!menuItemModifierPage.equals(this.menuItemModifierPage)) continue;
            menuItemModifierPage.setPageItems(this.menuItemModifierPage.getPageItems());
        }
    }

    public List<MenuItemModifierPage> getAllGroupModifierPages() {
        return this.allMenuItemModifierPages;
    }

    public void setSelectedGroup(ModifierGroup selectedGroup) {
        this.selectedGroup = selectedGroup;
    }
}

