/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.config.ui;

import com.floreantpos.Messages;
import com.floreantpos.PosException;
import com.floreantpos.config.ui.PrintServiceComboRenderer;
import com.floreantpos.config.ui.VirtualPrinterConfigDialog;
import com.floreantpos.model.PosPrinters;
import com.floreantpos.model.Printer;
import com.floreantpos.model.TerminalPrinters;
import com.floreantpos.model.VirtualPrinter;
import com.floreantpos.model.dao.VirtualPrinterDAO;
import com.floreantpos.print.PrinterType;
import com.floreantpos.report.ReceiptPrintService;
import com.floreantpos.swing.ComboBoxModel;
import com.floreantpos.swing.FixedLengthTextField;
import com.floreantpos.swing.IntegerTextField;
import com.floreantpos.ui.TitlePanel;
import com.floreantpos.ui.dialog.POSDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.List;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang.StringUtils;

public class AddPrinterDialog
extends POSDialog {
    private static final String EMPTY_SPACE_STRING = " ";
    private static final String DO_NOT_PRINT = Messages.getString("AddPrinterDialog.1");
    private Printer printer;
    private VirtualPrinter virtualPrinter;
    private FixedLengthTextField tfName;
    private JComboBox cbVirtualPrinter;
    private JComboBox cbDevice;
    private JCheckBox chckbxDefault;
    public TitlePanel titlePanel;
    private JRadioButton rbLocal;
    private JRadioButton rbNetwork;
    private JRadioButton rbSerial;
    private JLabel lblDevice;
    private JLabel lblIpAddress;
    private JLabel lblIpPort;
    private JLabel lblSerialPort;
    private FixedLengthTextField tfIpAddress;
    private FixedLengthTextField tfIpPort;
    private FixedLengthTextField tfSerialPort;
    private TerminalPrinters terminalPrinter;
    private IntegerTextField tfCharacterLength;
    private JComboBox cbPrintType;
    private JButton btnTest;
    private JLabel lblCharacterLength;
    private JButton btnCharacterLengthTest;

    public AddPrinterDialog() throws HeadlessException {
        super((Frame)POSUtil.getBackOfficeWindow(), true);
        this.setTitle(Messages.getString("AddPrinterDialog.0"));
        this.setMinimumSize(new Dimension(500, 200));
        this.setDefaultCloseOperation(2);
        this.pack();
    }

    @Override
    public void initUI() {
        this.setLayout(new BorderLayout(5, 5));
        JPanel centerPanel = new JPanel();
        centerPanel.setLayout((LayoutManager)new MigLayout("wrap 2,hidemode 3", "[][grow]", ""));
        this.titlePanel = new TitlePanel();
        this.titlePanel.setTitle(Messages.getString("AddPrinterDialog.3"));
        this.add((Component)this.titlePanel, "North");
        this.tfCharacterLength = new IntegerTextField(5);
        this.btnTest = new JButton(Messages.getString("MultiPrinterPane.5"));
        this.btnTest.addActionListener(e -> this.doTestPrint(false));
        JLabel lblName = new JLabel(Messages.getString("AddPrinterDialog.4"));
        centerPanel.add((Component)lblName, "alignx trailing");
        this.lblIpAddress = new JLabel(Messages.getString("AddPrinterDialog.5"));
        this.lblIpPort = new JLabel(Messages.getString("AddPrinterDialog.6"));
        this.tfIpAddress = new FixedLengthTextField();
        this.tfIpPort = new FixedLengthTextField();
        this.lblSerialPort = new JLabel(Messages.getString("AddPrinterDialog.7"));
        this.tfSerialPort = new FixedLengthTextField();
        this.tfName = new FixedLengthTextField(20);
        this.rbLocal = new JRadioButton(PrinterType.LOCAL.getName());
        this.rbNetwork = new JRadioButton(PrinterType.NETWORK.getName());
        this.rbSerial = new JRadioButton(PrinterType.SERIAL.getName());
        ActionListener printerTypeSelectionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AddPrinterDialog.this.updatePrinterTypeFieldsVisibility();
            }
        };
        this.rbLocal.addActionListener(printerTypeSelectionListener);
        this.rbNetwork.addActionListener(printerTypeSelectionListener);
        this.rbSerial.addActionListener(printerTypeSelectionListener);
        ButtonGroup group = new ButtonGroup();
        group.add(this.rbLocal);
        group.add(this.rbNetwork);
        group.add(this.rbSerial);
        this.cbVirtualPrinter = new JComboBox();
        this.cbVirtualPrinter.setEnabled(false);
        List<VirtualPrinter> virtualPrinters = VirtualPrinterDAO.getInstance().findAll();
        this.cbVirtualPrinter.setModel(new DefaultComboBoxModel<VirtualPrinter>(virtualPrinters.toArray(new VirtualPrinter[0])));
        centerPanel.add((Component)this.tfName, "growx");
        JButton btnNew = new JButton(Messages.getString("NEW"));
        btnNew.addActionListener(e -> this.doAddNewVirtualPrinter());
        this.cbPrintType = new JComboBox();
        this.cbPrintType.addItem("Standard");
        this.cbPrintType.addItem("EscPOS");
        this.cbPrintType.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 2) {
                    return;
                }
                AddPrinterDialog.this.updatePrinterSystemFieldsVisibility();
            }
        });
        centerPanel.add((Component)new JLabel(Messages.getString("AddPrinterDialog.8")), "alignx trailing");
        centerPanel.add((Component)this.cbPrintType, "growx,split 4");
        centerPanel.add((Component)this.rbLocal, "right");
        centerPanel.add(this.rbNetwork);
        centerPanel.add(this.rbSerial);
        this.lblDevice = new JLabel(Messages.getString("AddPrinterDialog.9") + ":");
        this.cbDevice = new JComboBox();
        ArrayList<Object> printerServices = new ArrayList<Object>();
        printerServices.add(DO_NOT_PRINT);
        printerServices.add(ReceiptPrintService.OROPOS_PDF_PRINTER);
        PrintService[] lookupPrintServices = PrintServiceLookup.lookupPrintServices(null, null);
        this.cbDevice.addItem(null);
        for (int i = 0; i < lookupPrintServices.length; ++i) {
            printerServices.add(lookupPrintServices[i]);
        }
        this.cbDevice.setModel(new ComboBoxModel(printerServices));
        this.cbDevice.setRenderer(new PrintServiceComboRenderer());
        centerPanel.add((Component)this.lblDevice, "newline,alignx trailing");
        centerPanel.add((Component)this.cbDevice, "growx,split 2");
        centerPanel.add((Component)this.lblIpAddress, "newline,alignx trailing");
        centerPanel.add((Component)this.tfIpAddress, "growx,split 4");
        centerPanel.add(this.lblIpPort);
        centerPanel.add((Component)this.tfIpPort, "w 70!,split 2");
        centerPanel.add((Component)this.lblSerialPort, "newline,alignx trailing");
        centerPanel.add((Component)this.tfSerialPort, "growx,split 2");
        centerPanel.add((Component)this.btnTest, "right");
        this.lblCharacterLength = new JLabel(Messages.getString("AddPrinterDialog.13"));
        centerPanel.add((Component)this.lblCharacterLength, "newline,alignx trailing");
        centerPanel.add((Component)this.tfCharacterLength, "growx,split 2");
        this.btnCharacterLengthTest = new JButton(Messages.getString("MultiPrinterPane.5"));
        this.btnCharacterLengthTest.addActionListener(e -> this.doTestPrint(true));
        centerPanel.add((Component)this.btnCharacterLengthTest, "right");
        this.chckbxDefault = new JCheckBox(Messages.getString("AddPrinterDialog.12"));
        JSeparator separator = new JSeparator();
        centerPanel.add((Component)separator, "spanx,growx,gapy 50px");
        this.add((Component)centerPanel, "Center");
        JPanel panel = new JPanel();
        JButton btnOk = new JButton(Messages.getString("OK"));
        btnOk.addActionListener(e -> this.doOk());
        panel.add(btnOk);
        JButton btnCancel = new JButton(Messages.getString("CANCEL"));
        btnCancel.addActionListener(e -> this.doCancel());
        panel.add(btnCancel);
        this.add((Component)panel, "South");
        this.rbLocal.setSelected(true);
        this.updatePrinterSystemFieldsVisibility();
    }

    private void doCancel() {
        this.setCanceled(true);
        this.dispose();
    }

    private void updatePrinterSystemFieldsVisibility() {
        boolean standardPrintSystem;
        String selectedPrintSystem = (String)this.cbPrintType.getSelectedItem();
        boolean bl = standardPrintSystem = selectedPrintSystem == null || selectedPrintSystem.equals("Standard");
        if (standardPrintSystem) {
            this.rbLocal.setSelected(standardPrintSystem);
        }
        this.rbNetwork.setVisible(!standardPrintSystem);
        this.rbSerial.setVisible(!standardPrintSystem);
        this.lblCharacterLength.setVisible(!standardPrintSystem);
        this.tfCharacterLength.setVisible(!standardPrintSystem);
        this.btnCharacterLengthTest.setVisible(!standardPrintSystem);
        this.updatePrinterTypeFieldsVisibility();
    }

    private void doTestPrint(boolean testPrintColLength) {
        try {
            if (!this.updateModel(true)) {
                return;
            }
            String deviceName = this.terminalPrinter.getPrinterName();
            if (deviceName == null) {
                return;
            }
            String testData = testPrintColLength ? this.getColLengthTestData() : ReceiptPrintService.getSystemInfo(this.terminalPrinter.getPrinterName(), this.virtualPrinter.getName());
            ReceiptPrintService.testPrinter(PosPrinters.createPrinter(this.terminalPrinter), testPrintColLength ? "" : "System Information", testData);
        }
        catch (PosException e) {
            POSMessageDialog.showError(e.getMessage());
        }
        catch (SocketException e) {
            POSMessageDialog.showError(Messages.getString("AddPrinterDialog.10"));
        }
        catch (Exception e) {
            POSMessageDialog.showError("Could not perform test. Please fillup all fields correctly.");
        }
    }

    private String getColLengthTestData() {
        if (this.tfCharacterLength.getInteger() <= 0) {
            throw new PosException(Messages.getString("AddPrinterDialog.17"));
        }
        String printText = "";
        for (int i = 0; i < this.tfCharacterLength.getInteger(); ++i) {
            printText = printText + "W";
        }
        return printText;
    }

    private void updatePrinterTypeFieldsVisibility() {
        this.lblIpAddress.setVisible(this.rbNetwork.isSelected());
        this.tfIpAddress.setVisible(this.rbNetwork.isSelected());
        this.lblIpPort.setVisible(this.rbNetwork.isSelected());
        this.tfIpPort.setVisible(this.rbNetwork.isSelected());
        this.lblSerialPort.setVisible(this.rbSerial.isSelected());
        this.tfSerialPort.setVisible(this.rbSerial.isSelected());
        this.lblDevice.setVisible(this.rbLocal.isSelected());
        this.cbDevice.setVisible(this.rbLocal.isSelected());
    }

    protected void doAddNewVirtualPrinter() {
        try {
            VirtualPrinterConfigDialog dialog = new VirtualPrinterConfigDialog();
            dialog.open();
            if (dialog.isCanceled()) {
                return;
            }
            VirtualPrinter virtualPrinter = dialog.getPrinter();
            DefaultComboBoxModel model = (DefaultComboBoxModel)this.cbVirtualPrinter.getModel();
            model.addElement(virtualPrinter);
            this.cbVirtualPrinter.setSelectedItem(virtualPrinter);
        }
        catch (Exception e) {
            POSMessageDialog.showError(e.getMessage(), e);
        }
    }

    protected void doOk() {
        try {
            if (!this.updateModel(false)) {
                return;
            }
            this.setCanceled(false);
            this.dispose();
        }
        catch (Exception e) {
            POSMessageDialog.showError(e.getMessage(), e);
        }
    }

    private boolean updateModel(boolean testPrint) {
        String name = this.tfName.getText().trim();
        if (StringUtils.isEmpty((String)name)) {
            POSMessageDialog.showMessage(this, Messages.getString("VirtualPrinterConfigDialog.11"));
            return false;
        }
        VirtualPrinter virtualPrinter = VirtualPrinterDAO.getInstance().findPrinterByName(name);
        if (this.virtualPrinter == null && virtualPrinter != null && !virtualPrinter.isDeleted().booleanValue()) {
            String message = name + EMPTY_SPACE_STRING + Messages.getString("AddPrinterDialog.11");
            throw new PosException(message);
        }
        if (this.virtualPrinter == null && virtualPrinter != null && virtualPrinter.isDeleted().booleanValue()) {
            this.virtualPrinter = virtualPrinter;
        }
        if (this.virtualPrinter == null) {
            this.virtualPrinter = new VirtualPrinter();
        } else {
            this.virtualPrinter.setDeleted(Boolean.FALSE);
        }
        this.virtualPrinter.setName(name);
        PrintService printService = null;
        Object selectedObject = this.cbDevice.getSelectedItem();
        if (selectedObject instanceof PrintService) {
            printService = (PrintService)selectedObject;
        }
        boolean defaultPrinter = this.chckbxDefault.isSelected();
        if (this.printer == null) {
            this.printer = new Printer();
        }
        String deviceName = this.printer.getDeviceName();
        this.printer.setVirtualPrinter(this.virtualPrinter);
        deviceName = printService != null && printService.getName() != null ? printService.getName() : (selectedObject != null && selectedObject.equals(ReceiptPrintService.OROPOS_PDF_PRINTER) ? ReceiptPrintService.OROPOS_PDF_PRINTER : null);
        this.printer.setDefaultPrinter(defaultPrinter);
        if (this.terminalPrinter == null) {
            this.terminalPrinter = new TerminalPrinters();
        }
        PrinterType printerType = this.getPrinterType();
        this.terminalPrinter.addProperty("receipt.printer_type", String.valueOf(this.cbPrintType.getSelectedItem()));
        this.terminalPrinter.addProperty("printerType", printerType.getName());
        this.terminalPrinter.addProperty("textLength", String.valueOf(this.tfCharacterLength.getInteger()));
        if (printerType == PrinterType.NETWORK) {
            String ipAddress = this.getIPAddress();
            String ipPort = this.getIPPort();
            if (StringUtils.isBlank((String)ipAddress)) {
                throw new PosException("Please provide printer IP address");
            }
            if (StringUtils.isBlank((String)ipPort)) {
                throw new PosException("Please provide printer port");
            }
            this.terminalPrinter.addProperty("ipAddress", ipAddress);
            this.terminalPrinter.addProperty("ipPort", ipPort);
            deviceName = ipAddress + (StringUtils.isNotBlank((String)ipPort) ? ":" + ipPort : "");
        } else if (printerType == PrinterType.SERIAL) {
            this.terminalPrinter.addProperty("serialPort", this.getSerialPort());
            deviceName = this.getSerialPort();
        } else {
            this.terminalPrinter.removeProperty("ipAddress");
            this.terminalPrinter.removeProperty("ipPort");
            this.terminalPrinter.removeProperty("serialPort");
        }
        if (!testPrint) {
            this.printer.setDeviceName(deviceName);
        }
        this.terminalPrinter.setPrinterName(deviceName);
        return true;
    }

    public TerminalPrinters getTerminalPrinter() {
        return this.terminalPrinter;
    }

    public PrinterType getPrinterType() {
        if (this.rbNetwork.isSelected()) {
            return PrinterType.NETWORK;
        }
        if (this.rbSerial.isSelected()) {
            return PrinterType.SERIAL;
        }
        return PrinterType.LOCAL;
    }

    public String getIPAddress() {
        return this.tfIpAddress.getText();
    }

    public String getIPPort() {
        return this.tfIpPort.getText();
    }

    public String getSerialPort() {
        return this.tfSerialPort.getText();
    }

    public Printer getPrinter() {
        return this.printer;
    }

    public void setPrinter(Printer printer, TerminalPrinters terminalPrinter) {
        this.printer = printer;
        this.terminalPrinter = terminalPrinter;
        this.virtualPrinter = printer.getVirtualPrinter();
        this.tfName.setText(printer.getVirtualPrinter().getName());
        this.chckbxDefault.setSelected(printer.isDefaultPrinter());
        if (printer != null && StringUtils.isNotEmpty((String)printer.getDeviceName())) {
            this.cbVirtualPrinter.setSelectedItem(printer.getVirtualPrinter());
            if (printer.getDeviceName().equals(ReceiptPrintService.OROPOS_PDF_PRINTER)) {
                this.cbDevice.setSelectedItem(ReceiptPrintService.OROPOS_PDF_PRINTER);
                return;
            }
            if (printer.getDeviceName().equals(Messages.getString("AddPrinterDialog.2"))) {
                this.cbDevice.setSelectedItem(DO_NOT_PRINT);
                return;
            }
            ComboBoxModel deviceModel = (ComboBoxModel)this.cbDevice.getModel();
            for (int i = 0; i < deviceModel.getSize(); ++i) {
                PrintService printService;
                Object selectedObject = deviceModel.getElementAt(i);
                if (!(selectedObject instanceof PrintService) || (printService = (PrintService)selectedObject) == null || !printService.getName().equals(printer.getDeviceName())) continue;
                this.cbDevice.setSelectedIndex(i);
                break;
            }
        }
        if (terminalPrinter != null) {
            PrinterType printerType = PrinterType.fromString(terminalPrinter.getProperty("printerType", PrinterType.LOCAL.getName()));
            if (printerType == PrinterType.NETWORK) {
                this.rbNetwork.setSelected(true);
            } else if (printerType == PrinterType.SERIAL) {
                this.rbSerial.setSelected(true);
            } else {
                this.rbLocal.setSelected(true);
            }
            this.cbPrintType.setSelectedItem(terminalPrinter.getProperty("receipt.printer_type", "Standard"));
            this.tfIpAddress.setText(terminalPrinter.getProperty("ipAddress", "192.168.0.1"));
            this.tfIpPort.setText(terminalPrinter.getProperty("ipPort", ""));
            this.tfSerialPort.setText(terminalPrinter.getProperty("serialPort", ""));
            this.tfCharacterLength.setText(terminalPrinter.getProperty("textLength", "42"));
        } else {
            this.tfCharacterLength.setText("42");
            this.rbLocal.setSelected(true);
        }
        this.updatePrinterTypeFieldsVisibility();
    }
}

