/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.config.ui;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosException;
import com.floreantpos.bo.ui.BOMessageDialog;
import com.floreantpos.config.AppConfig;
import com.floreantpos.config.ui.ConfigurationView;
import com.floreantpos.main.Application;
import com.floreantpos.model.Gratuity;
import com.floreantpos.model.PaymentType;
import com.floreantpos.model.PosTransaction;
import com.floreantpos.model.RefundTransaction;
import com.floreantpos.model.Store;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.TicketItem;
import com.floreantpos.model.YellowDogStore;
import com.floreantpos.model.dao.SFSyncDAO;
import com.floreantpos.model.dao.StoreDAO;
import com.floreantpos.model.dao.TicketItemDAO;
import com.floreantpos.model.dao.YellowDogStoreDAO;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.model.util.DateUtil;
import com.floreantpos.services.PosTransactionService;
import com.floreantpos.swing.ButtonColumn;
import com.floreantpos.swing.ListTableModel;
import com.floreantpos.swing.POSTextField;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.ui.PosTableRenderer;
import com.floreantpos.ui.dialog.DateSelectionDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.dialog.UploadSfTicketsDialog;
import com.floreantpos.util.AESencrp;
import com.floreantpos.util.POSUtil;
import com.floreantpos.versioning.VersionInfo;
import com.foretees.salesforce.sync.EmployeeSyncable;
import com.foretees.salesforce.sync.ItemSyncable;
import com.foretees.salesforce.sync.MemberSyncable;
import com.foretees.salesforce.sync.SFAuth;
import com.foretees.salesforce.sync.SFDateUtil;
import com.foretees.salesforce.sync.SalesAreaSyncable;
import com.foretees.salesforce.sync.SyncDialog;
import com.foretees.salesforce.sync.UpdateItemCostSync;
import com.foretees.salesforce.sync.UpdateItemCountSync;
import com.foretees.salesforce.sync.YellowDogSyncable;
import com.foretees.yellowDog.YellowDogUtil;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileInputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.prefs.Preferences;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.CompoundBorder;
import javax.swing.border.MatteBorder;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.table.TableColumnModel;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpResponse;
import org.hibernate.StaleStateException;

public class CloudSyncConfigurationView
extends ConfigurationView {
    public static final String CONFIG_TAB_CLOUD_SYNC = "Cloud Sync";
    private POSTextField tfUsername;
    private JTable tableCloudProcess;
    private CloudProcessDataModel tableModel;
    private JPasswordField tfPassword;
    private JPasswordField tfSecurityToken;
    private POSTextField tfLoginUrl;
    private POSTextField tfClientId;
    private JPasswordField tfClientSecret;
    private JPanel topConfigPanel;
    private String memberSyncTime;
    private String itemSyncTime;
    private String paymentSyncTime;
    private String employeeSyncTime;
    private String salesAreaSyncTime;
    private String updateItemSyncTime;
    private String updateItemCountSyncTime;
    private String LAST_USED_FOLDER = "";
    private JCheckBox cbDebug;
    private POSTextField tfOrgName;
    private JTextField tfYellowDogClientId;
    private JTextField tfYellowDogUsername;
    private JPasswordField tfYellowDogPassword;
    private JTextField tfYellowDogsTokenUrl;
    private JTextField tfYellowDogsFetchUrl;

    public CloudSyncConfigurationView() {
        this.setLayout((LayoutManager)new MigLayout("fill, hidemode 3,ins 0", "[grow]", "[][]"));
        this.initComponents();
    }

    private void initComponents() {
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout((LayoutManager)new MigLayout("fill, hidemode 3", "[grow]", "[][]"));
        JScrollPane mainScrollPane = new JScrollPane(mainPanel, 20, 31);
        mainScrollPane.getVerticalScrollBar().setUnitIncrement(16);
        mainScrollPane.setBorder(null);
        this.add((Component)mainScrollPane, "grow");
        JLabel lblOrg = new JLabel(Messages.getString("CloudSyncConfigurationView.1"));
        this.tfOrgName = new POSTextField();
        JLabel lblUsername = new JLabel(Messages.getString("CloudSyncConfigurationView.5"));
        this.tfUsername = new POSTextField();
        JLabel lblPassword = new JLabel(Messages.getString("CloudSyncConfigurationView.6"));
        this.tfPassword = new JPasswordField();
        JLabel lblSecurityToken = new JLabel(Messages.getString("CloudSyncConfigurationView.7"));
        this.tfSecurityToken = new JPasswordField();
        JLabel lblLoginUrl = new JLabel(Messages.getString("CloudSyncConfigurationView.8"));
        this.tfLoginUrl = new POSTextField();
        JLabel lblClientId = new JLabel(Messages.getString("CloudSyncConfigurationView.9"));
        this.tfClientId = new POSTextField(10);
        JLabel lblClientSecret = new JLabel(Messages.getString("CloudSyncConfigurationView.10"));
        this.tfClientSecret = new JPasswordField(10);
        JButton btnTest = new JButton(Messages.getString("CloudSyncConfigurationView.11"));
        btnTest.addActionListener(ev -> this.doCheckSFConfigConnection());
        JButton btnRefresh = new JButton(Messages.getString("CloudSyncConfigurationView.12"));
        btnRefresh.addActionListener(ev -> {
            try {
                this.initSalesForceConfigData();
            }
            catch (Exception e) {
                POSMessageDialog.showError(POSUtil.getFocusedWindow(), e.getMessage(), e);
            }
        });
        JButton btnSave = new JButton(Messages.getString("CloudSyncConfigurationView.13"));
        btnSave.addActionListener(e -> this.doSaveSyncConfig());
        JButton btnImport = new JButton(Messages.getString("CloudSyncConfigurationView.14"));
        btnImport.addActionListener(ev -> {
            try {
                this.doImportConfigInfo();
            }
            catch (Exception e) {
                POSMessageDialog.showError(POSUtil.getFocusedWindow(), e.getMessage(), e);
            }
        });
        this.topConfigPanel = new JPanel((LayoutManager)new MigLayout("ins 0,fillx, hidemode 3", "[][grow]", ""));
        JPanel topSFConfigPanel = new JPanel((LayoutManager)new MigLayout("ins 0,fillx, hidemode 3", "[][grow]", ""));
        topSFConfigPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("CloudSyncConfigurationView.4")));
        topSFConfigPanel.add((Component)lblOrg, "trailing");
        topSFConfigPanel.add((Component)this.tfOrgName, "grow,span, wrap");
        topSFConfigPanel.add((Component)lblUsername, "trailing");
        topSFConfigPanel.add((Component)this.tfUsername, "grow,span, wrap");
        topSFConfigPanel.add((Component)lblPassword, "trailing");
        topSFConfigPanel.add((Component)this.tfPassword, "grow,span, wrap");
        topSFConfigPanel.add((Component)lblSecurityToken, "trailing");
        topSFConfigPanel.add((Component)this.tfSecurityToken, "grow,span, wrap");
        topSFConfigPanel.add((Component)lblLoginUrl, "trailing");
        topSFConfigPanel.add((Component)this.tfLoginUrl, "grow,span, wrap");
        topSFConfigPanel.add((Component)lblClientId, "trailing");
        topSFConfigPanel.add((Component)this.tfClientId, "grow,span, wrap");
        topSFConfigPanel.add((Component)lblClientSecret, "trailing");
        topSFConfigPanel.add((Component)this.tfClientSecret, "grow,span, wrap");
        topSFConfigPanel.add((Component)btnImport, "skip 1,w 100!, align right, split 4");
        topSFConfigPanel.add((Component)btnTest, "w 100!");
        topSFConfigPanel.add((Component)btnRefresh, "w 100!");
        topSFConfigPanel.add((Component)btnSave, "w 100!");
        JLabel lblYellowDogClientId = new JLabel(Messages.getString("YellowDogConfigurationView.0"));
        this.tfYellowDogClientId = new JTextField();
        JLabel lblYellowDogUsername = new JLabel(Messages.getString("YellowDogConfigurationView.1"));
        this.tfYellowDogUsername = new JTextField();
        JLabel lblYellowDogClientSecret = new JLabel(Messages.getString("YellowDogConfigurationView.2"));
        this.tfYellowDogPassword = new JPasswordField();
        JLabel lblYellowDogsTokenUrl = new JLabel(Messages.getString("YellowDogConfigurationView.3"));
        this.tfYellowDogsTokenUrl = new JTextField();
        JLabel lblYellowDogsFetchUrl = new JLabel(Messages.getString("YellowDogConfigurationView.4"));
        this.tfYellowDogsFetchUrl = new JTextField();
        JButton btnYellowDogConfSave = new JButton(Messages.getString("CloudSyncConfigurationView.13"));
        JPanel topYDConfigPanel = new JPanel((LayoutManager)new MigLayout("ins 0,fillx, hidemode 3", "[][grow]", ""));
        topYDConfigPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("CloudSyncConfigurationView.16")));
        topYDConfigPanel.add((Component)lblYellowDogClientId, "newline, alignx trailing");
        topYDConfigPanel.add((Component)this.tfYellowDogClientId, "growx, wrap");
        topYDConfigPanel.add((Component)lblYellowDogUsername, "alignx trailing");
        topYDConfigPanel.add((Component)this.tfYellowDogUsername, "growx, wrap");
        topYDConfigPanel.add((Component)lblYellowDogClientSecret, "alignx trailing");
        topYDConfigPanel.add((Component)this.tfYellowDogPassword, "growx, wrap");
        topYDConfigPanel.add((Component)lblYellowDogsTokenUrl, "alignx trailing");
        topYDConfigPanel.add((Component)this.tfYellowDogsTokenUrl, "growx, wrap");
        topYDConfigPanel.add((Component)lblYellowDogsFetchUrl, "alignx trailing");
        topYDConfigPanel.add((Component)this.tfYellowDogsFetchUrl, "growx, wrap");
        topYDConfigPanel.add((Component)btnYellowDogConfSave, "skip 1,w 100!, align right, split");
        this.topConfigPanel.add((Component)topSFConfigPanel, "growx,wrap,span 2");
        this.topConfigPanel.add((Component)topYDConfigPanel, "growx,span 2");
        mainPanel.add((Component)this.topConfigPanel, "gap bottom 10,grow, wrap");
        JPanel drawerConfigPanel = new JPanel((LayoutManager)new MigLayout("ins 0,fill", "", ""));
        this.tableCloudProcess = new JTable();
        this.tableCloudProcess.setDefaultRenderer(Object.class, new PosTableRenderer());
        this.tableCloudProcess.setSelectionMode(0);
        this.tableModel = new CloudProcessDataModel();
        this.tableCloudProcess.setModel(this.tableModel);
        btnYellowDogConfSave.addActionListener(e -> this.doSaveYellowDogStore());
        AbstractAction actionSyncBtn = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CloudSyncConfigurationView.this.doPerformBtnAction(e);
            }
        };
        ButtonColumn buttonColumn = new ButtonColumn(this.tableCloudProcess, actionSyncBtn, 3){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                CloudProcess process = (CloudProcess)CloudSyncConfigurationView.this.tableModel.getRowData(row);
                if (process.getShowSyncBtn().booleanValue()) {
                    return super.getTableCellRendererComponent(table, value, false, hasFocus, row, column);
                }
                return null;
            }
        };
        JButton syncButton = new JButton();
        MatteBorder selectedBorder = BorderFactory.createMatteBorder(2, 10, 2, 10, this.tableCloudProcess.getBackground());
        MatteBorder unselectedBorder = BorderFactory.createMatteBorder(2, 10, 2, 10, this.tableCloudProcess.getBackground());
        CompoundBorder border1 = new CompoundBorder(selectedBorder, syncButton.getBorder());
        CompoundBorder border2 = new CompoundBorder(unselectedBorder, syncButton.getBorder());
        buttonColumn.setUnselectedBorder(border1);
        buttonColumn.setFocusBorder(border2);
        AbstractAction actionSetDateBtn = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CloudSyncConfigurationView.this.doSetSyncDate();
            }
        };
        ButtonColumn btnSetDateCol = new ButtonColumn(this.tableCloudProcess, actionSetDateBtn, 2){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                CloudProcess process = (CloudProcess)CloudSyncConfigurationView.this.tableModel.getRowData(row);
                if (process.getShowTimeSetBtn()) {
                    return super.getTableCellRendererComponent(table, value, false, hasFocus, row, column);
                }
                return null;
            }
        };
        btnSetDateCol.setUnselectedBorder(border1);
        btnSetDateCol.setFocusBorder(border2);
        this.tableCloudProcess.setRowHeight(PosUIManager.getSize(30));
        this.resizeColumnWidth(this.tableCloudProcess);
        JScrollPane scrollPane = new JScrollPane(this.tableCloudProcess);
        scrollPane.setPreferredSize(PosUIManager.getSize(0, 300));
        drawerConfigPanel.add((Component)scrollPane, "gaptop 5,grow,wrap");
        this.cbDebug = new JCheckBox(Messages.getString("CloudSyncConfigurationView.33"));
        this.cbDebug.addItemListener(e -> this.doEnabledDebug());
        drawerConfigPanel.add(this.cbDebug);
        mainPanel.add((Component)drawerConfigPanel, "grow, wrap");
    }

    protected void doFatchYellowDogStore() {
        List<YellowDogStore> yellowDogStores = YellowDogUtil.getYellowDogStore();
        YellowDogStoreDAO instance = YellowDogStoreDAO.getInstance();
        if (yellowDogStores != null) {
            for (YellowDogStore yellowDogStore : yellowDogStores) {
                YellowDogStore dogStore = instance.get(yellowDogStore.getId());
                if (dogStore == null) {
                    instance.save(yellowDogStore);
                    continue;
                }
                dogStore.setName(yellowDogStore.getName());
                dogStore.setCode(yellowDogStore.getCode());
                dogStore.setNoOnHand(yellowDogStore.isNoOnHand());
                dogStore.setRevenueCenter(yellowDogStore.getRevenueCenter());
                dogStore.setNotes(yellowDogStore.getNotes());
                dogStore.setCreated(yellowDogStore.getCreated());
                instance.update(dogStore);
            }
        }
        POSMessageDialog.showMessage(Messages.getString("YellowDogConfigurationView.9"));
    }

    private void doSaveYellowDogStore() {
        try {
            DataProvider.get().refreshStore();
            Store store = DataProvider.get().getStore();
            store.setClientId(this.tfYellowDogClientId.getText());
            store.setClientPassword(String.valueOf(this.tfYellowDogPassword.getPassword()));
            store.setYellowDogUserName(this.tfYellowDogUsername.getText());
            store.setYellowDogsTokenUrl(this.tfYellowDogsTokenUrl.getText());
            store.setYellowDogsFetchUrl(this.tfYellowDogsFetchUrl.getText());
            StoreDAO.getInstance().saveOrUpdate(store);
            DataProvider.get().refreshStore();
            POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), "Yellowdog configuration successfully updated.");
        }
        catch (Exception e) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), e.getMessage(), e);
        }
    }

    public void resizeColumnWidth(JTable table) {
        TableColumnModel columnModel = table.getColumnModel();
        for (int column = 0; column < table.getColumnCount(); ++column) {
            columnModel.getColumn(column).setPreferredWidth(this.getColumnWidth().get(column));
        }
    }

    private List<Integer> getColumnWidth() {
        ArrayList<Integer> columnWidth = new ArrayList<Integer>();
        columnWidth.add(200);
        columnWidth.add(70);
        columnWidth.add(70);
        columnWidth.add(80);
        return columnWidth;
    }

    @Override
    public void initialize() throws Exception {
        Store store = DataProvider.get().getStore();
        this.initSalesForceConfigData(store);
        this.initYellowDogConfigData(store);
        this.updateProcessTableModel(store);
        this.setInitialized(true);
        this.doSelectedDebug();
    }

    @Override
    public boolean save() throws Exception {
        return true;
    }

    private void doEnabledDebug() {
        AppConfig.put("salesforce.debug.enabled", this.cbDebug.isSelected());
    }

    private void doSelectedDebug() {
        boolean debugEnabled = AppConfig.getBoolean("salesforce.debug.enabled", false);
        if (debugEnabled) {
            this.cbDebug.setSelected(true);
        }
    }

    private void updateProcessTableModel() throws Exception {
        Store store = DataProvider.get().getStore();
        this.updateProcessTableModel(store);
    }

    private void updateProcessTableModel(Store store) throws Exception {
        ArrayList<CloudProcess> cloudProcessList = new ArrayList<CloudProcess>();
        this.memberSyncTime = store.getProperty("salesforce.memberSyncTime");
        this.itemSyncTime = store.getProperty("salesforce.itemSyncTime");
        this.paymentSyncTime = store.getProperty("salesforce.paymentSyncTime");
        this.employeeSyncTime = store.getProperty("salesforce.employeeSyncTime");
        this.salesAreaSyncTime = store.getProperty("salesforce.salesAreaSyncTime");
        this.updateItemSyncTime = store.getProperty("salesforce.updateItemSyncTime");
        this.updateItemCountSyncTime = store.getProperty("salesforce.updateItemCountSyncTime");
        CloudProcess chargeItemsProcess = new CloudProcess(Messages.getString("CloudSyncConfigurationView.34"), this.formatSyncTime(this.itemSyncTime), true, Messages.getString("CloudSyncConfigurationView.35"));
        CloudProcess uploadTicketsProcess = new CloudProcess(Messages.getString("CloudSyncConfigurationView.36"), this.formatSyncTime(this.paymentSyncTime), true, Messages.getString("CloudSyncConfigurationView.37"));
        CloudProcess employeeSyncProcess = new CloudProcess(Messages.getString("CloudSyncConfigurationView.38"), this.formatSyncTime(this.employeeSyncTime), true, Messages.getString("CloudSyncConfigurationView.35"));
        CloudProcess memberSyncProcess = new CloudProcess(Messages.getString("CloudSyncConfigurationView.40"), this.formatSyncTime(this.memberSyncTime), true, Messages.getString("CloudSyncConfigurationView.35"));
        CloudProcess salesAreaSyncProcess = new CloudProcess(Messages.getString("CloudSyncConfigurationView.42"), this.formatSyncTime(this.salesAreaSyncTime), true, Messages.getString("CloudSyncConfigurationView.35"));
        CloudProcess updateItemsProcess = new CloudProcess(Messages.getString("CloudSyncConfigurationView.44"), this.formatSyncTime(this.updateItemSyncTime), true, Messages.getString("CloudSyncConfigurationView.37"));
        CloudProcess updateItemsCountProcess = new CloudProcess(Messages.getString("CloudSyncConfigurationView.18"), this.formatSyncTime(this.updateItemCountSyncTime), true, Messages.getString("CloudSyncConfigurationView.37"));
        CloudProcess yellowDogConfigProcess = new CloudProcess(Messages.getString("CloudSyncConfigurationView.17"), "", true, Messages.getString("CloudSyncConfigurationView.37"), Boolean.FALSE);
        CloudProcess yellowDogFetchStoreProcess = new CloudProcess(Messages.getString("CloudSyncConfigurationView.15"), "", true, Messages.getString("CloudSyncConfigurationView.35"), Boolean.FALSE);
        cloudProcessList.add(chargeItemsProcess);
        cloudProcessList.add(uploadTicketsProcess);
        cloudProcessList.add(employeeSyncProcess);
        cloudProcessList.add(memberSyncProcess);
        cloudProcessList.add(salesAreaSyncProcess);
        cloudProcessList.add(updateItemsProcess);
        cloudProcessList.add(updateItemsCountProcess);
        cloudProcessList.add(yellowDogConfigProcess);
        cloudProcessList.add(yellowDogFetchStoreProcess);
        this.tableModel.setRows(cloudProcessList);
    }

    private String formatSyncTime(String syncTime) throws Exception {
        if (StringUtils.isNotEmpty((String)syncTime)) {
            syncTime = DateUtil.formatFullDateAndTimeAsString(SFDateUtil.parseBySFDate(syncTime));
        }
        return syncTime;
    }

    public void setConfigPanelVisible(boolean isVisible) {
        this.topConfigPanel.setVisible(isVisible);
    }

    public void initSalesForceConfigData() throws Exception {
        Store store = DataProvider.get().getStore();
        this.initSalesForceConfigData(store);
        this.initYellowDogConfigData(store);
    }

    public void initSalesForceConfigData(Store store) throws Exception {
        String orgName = store.getProperty("salesforce.org.name");
        if (StringUtils.isEmpty((String)orgName)) {
            orgName = (String)AppConfig.getConfig().getProperty("sf.packageName");
        }
        this.tfOrgName.setText(orgName);
        this.tfUsername.setText(store.getProperty("salesforce.username"));
        String password = store.getProperty("salesforce.password");
        String securityToken = store.getProperty("salesforce.securityToken");
        this.tfLoginUrl.setText(store.getProperty("salesforce.loginurl"));
        this.tfClientId.setText(store.getProperty("salesforce.clientId"));
        String clientSecret = store.getProperty("salesforce.clientSecret");
        if (StringUtils.isNotEmpty((String)password)) {
            password = AESencrp.decrypt((String)password);
            this.tfPassword.setText(password);
        }
        if (StringUtils.isNotEmpty((String)securityToken)) {
            securityToken = AESencrp.decrypt((String)securityToken);
            this.tfSecurityToken.setText(securityToken);
        }
        if (StringUtils.isNotEmpty((String)clientSecret)) {
            clientSecret = AESencrp.decrypt((String)clientSecret);
            this.tfClientSecret.setText(clientSecret);
        }
    }

    public void initYellowDogConfigData(Store store) throws Exception {
        this.tfYellowDogClientId.setText(store.getClientId());
        this.tfYellowDogUsername.setText(store.getYellowDogUserName());
        this.tfYellowDogPassword.setText(store.getClientPassword());
        this.tfYellowDogsTokenUrl.setText(store.getYellowDogsTokenUrl());
        this.tfYellowDogsFetchUrl.setText(store.getYellowDogsFetchUrl());
    }

    @Override
    public String getName() {
        return CONFIG_TAB_CLOUD_SYNC;
    }

    private void doSaveSyncConfig() {
        try {
            String orgName = this.tfOrgName.getText();
            String username = this.tfUsername.getText();
            String password = new String(this.tfPassword.getPassword());
            String securityToken = new String(this.tfSecurityToken.getPassword());
            String loginUrl = this.tfLoginUrl.getText();
            String clientId = this.tfClientId.getText();
            String clientSecret = new String(this.tfClientSecret.getPassword());
            if (StringUtils.isEmpty((String)username)) {
                POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("CloudSyncConfigurationView.51"));
                return;
            }
            if (StringUtils.isEmpty((String)password)) {
                POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("CloudSyncConfigurationView.52"));
                return;
            }
            if (StringUtils.isEmpty((String)securityToken)) {
                POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("CloudSyncConfigurationView.53"));
                return;
            }
            if (StringUtils.isEmpty((String)loginUrl)) {
                POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("CloudSyncConfigurationView.54"));
                return;
            }
            if (StringUtils.isEmpty((String)clientId)) {
                POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("CloudSyncConfigurationView.55"));
                return;
            }
            if (StringUtils.isEmpty((String)clientSecret)) {
                POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("CloudSyncConfigurationView.56"));
                return;
            }
            DataProvider.get().refreshStore();
            Store store = DataProvider.get().getStore();
            store.addProperty("salesforce.org.name", orgName);
            store.addProperty("salesforce.username", username);
            store.addProperty("salesforce.loginurl", loginUrl);
            store.addProperty("salesforce.clientId", clientId);
            if (StringUtils.isNotEmpty((String)password)) {
                String encryptedPassword = AESencrp.encrypt((String)password);
                store.addProperty("salesforce.password", encryptedPassword);
            }
            if (StringUtils.isNotEmpty((String)securityToken)) {
                String encryptedSecurityToken = AESencrp.encrypt((String)securityToken);
                store.addProperty("salesforce.securityToken", encryptedSecurityToken);
            }
            if (StringUtils.isNotEmpty((String)clientSecret)) {
                String encryptedClientSecret = AESencrp.encrypt((String)clientSecret);
                store.addProperty("salesforce.clientSecret", encryptedClientSecret);
            }
            StoreDAO.getInstance().saveOrUpdate(store);
            DataProvider.get().refreshStore();
            POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("CloudSyncConfigurationView.57"));
        }
        catch (Exception e) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), e.getMessage(), e);
        }
    }

    public void doCheckSFConfigConnection() {
        try {
            String username = this.tfUsername.getText();
            String password = this.tfPassword.getText();
            String securityToken = this.tfSecurityToken.getText();
            String loginUrl = this.tfLoginUrl.getText();
            String clientId = this.tfClientId.getText();
            String clientsSecret = this.tfClientSecret.getText();
            if (StringUtils.isEmpty((String)username)) {
                POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("CloudSyncConfigurationView.58"));
                return;
            }
            if (StringUtils.isEmpty((String)password)) {
                POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("CloudSyncConfigurationView.59"));
                return;
            }
            if (StringUtils.isEmpty((String)securityToken)) {
                POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("CloudSyncConfigurationView.60"));
                return;
            }
            if (StringUtils.isEmpty((String)loginUrl)) {
                POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("CloudSyncConfigurationView.61"));
                return;
            }
            if (StringUtils.isEmpty((String)clientId)) {
                POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("CloudSyncConfigurationView.62"));
                return;
            }
            if (StringUtils.isEmpty((String)clientsSecret)) {
                POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("CloudSyncConfigurationView.63"));
                return;
            }
            HttpResponse loginResponse = SFAuth.getLoginResponse(username, password, securityToken, loginUrl, clientId, clientsSecret);
            int statusCode = loginResponse.getStatusLine().getStatusCode();
            if (statusCode != 200) {
                POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("CloudSyncConfigurationView.64"));
                return;
            }
            POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("CloudSyncConfigurationView.65"));
        }
        catch (Exception e) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), e.getMessage(), e);
        }
    }

    private void doPerformBtnAction(ActionEvent e) {
        try {
            int row = Integer.parseInt(e.getActionCommand());
            switch (row) {
                case 0: {
                    ItemSyncable itemSyncable = new ItemSyncable();
                    SyncDialog dialog = new SyncDialog(itemSyncable);
                    itemSyncable.setSyncView(dialog);
                    dialog.pack();
                    dialog.open();
                    break;
                }
                case 1: {
                    this.doOpenTicketUploadDialog();
                    break;
                }
                case 2: {
                    EmployeeSyncable employeeSyncable = new EmployeeSyncable();
                    SyncDialog employeeSyncDialog = new SyncDialog(employeeSyncable);
                    employeeSyncable.setSyncView(employeeSyncDialog);
                    employeeSyncDialog.pack();
                    employeeSyncDialog.open();
                    break;
                }
                case 3: {
                    MemberSyncable memberSyncable = new MemberSyncable();
                    SyncDialog memberSyncDialog = new SyncDialog(memberSyncable);
                    memberSyncable.setSyncView(memberSyncDialog);
                    memberSyncDialog.pack();
                    memberSyncDialog.open();
                    break;
                }
                case 4: {
                    SalesAreaSyncable salesAreaSync = new SalesAreaSyncable();
                    SyncDialog salesAreaSyncDialog = new SyncDialog(salesAreaSync);
                    salesAreaSync.setSyncView(salesAreaSyncDialog);
                    salesAreaSyncDialog.pack();
                    salesAreaSyncDialog.open();
                    break;
                }
                case 5: {
                    this.doUpdateItem();
                    break;
                }
                case 6: {
                    this.doUpdateItemCount();
                    break;
                }
                case 7: {
                    this.doYDSyncTicketItem();
                    break;
                }
                case 8: {
                    this.doFatchYellowDogStore();
                }
            }
            this.updateProcessTableModel();
        }
        catch (Exception x) {
            BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, x);
        }
    }

    protected void doYDSyncTicketItem() {
        List<TicketItem> activeTicketItems = TicketItemDAO.getInstance().findYellowDogActiveTicketItems();
        YellowDogSyncable syncableTicketItem = new YellowDogSyncable(activeTicketItems);
        SyncDialog dialog = new SyncDialog(syncableTicketItem, Messages.getString("YellowDogConfigurationView.8"));
        syncableTicketItem.setSyncView(dialog);
        dialog.pack();
        dialog.open();
        if (dialog.isCanceled()) {
            return;
        }
    }

    private void doOpenTicketUploadDialog() {
        List<TicketItem> unsyncedTicketItems = SFSyncDAO.getInstance().findUnsyncedItems();
        List<Gratuity> unsyncedGratuities = SFSyncDAO.getInstance().findUnsyncedGratuities();
        List<PosTransaction> unsyncedTransactions = SFSyncDAO.getInstance().findUnsyncedTransactions();
        HashSet<String> refundDates = new HashSet<String>();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd");
        for (PosTransaction posTransaction : unsyncedTransactions) {
            if (!(posTransaction instanceof RefundTransaction)) continue;
            refundDates.add(dateFormat.format(posTransaction.getTransactionTime()));
        }
        Iterator<TicketItem> iterator = unsyncedTicketItems.iterator();
        while (iterator.hasNext()) {
            TicketItem ticketItem = iterator.next();
            if (ticketItem.isVoided().booleanValue()) {
                if (!ticketItem.isReturned()) {
                    iterator.remove();
                    try {
                        ticketItem.setCloudSynced(true);
                        TicketItemDAO.getInstance().update(ticketItem);
                    }
                    catch (Exception exception) {}
                    continue;
                }
                if (!this.hasRefundedTransactionForItem(ticketItem, unsyncedTransactions)) continue;
                iterator.remove();
                continue;
            }
            if (!ticketItem.isReturned()) continue;
            iterator.remove();
        }
        ArrayList<Object> unsyncedItems = new ArrayList<Object>();
        unsyncedItems.addAll(unsyncedTicketItems);
        unsyncedItems.addAll(unsyncedGratuities);
        unsyncedItems.addAll(unsyncedTransactions);
        UploadSfTicketsDialog paymentDialog = new UploadSfTicketsDialog(Application.getCurrentUser(), unsyncedItems);
        paymentDialog.openFullScreen();
    }

    public static void createEvenExchangeData(List<TicketItem> unsyncedTicketItems, List<PosTransaction> unsyncedTransactions) {
        Iterator<TicketItem> iterator = unsyncedTicketItems.iterator();
        while (iterator.hasNext()) {
            TicketItem ticketItem = iterator.next();
            if (!ticketItem.isVoided().booleanValue()) continue;
            iterator.remove();
            Ticket ticket = ticketItem.getTicket();
            if (ticket.getDueAmount() != 0.0) continue;
            PosTransaction posTransaction = PaymentType.MEMBER_ACCOUNT.createTransaction();
            posTransaction.setTicket(ticket);
            posTransaction.setTransactionTime(ticketItem.getCreateDate());
            posTransaction.addProperty("even_exchange", "true");
            posTransaction.addProperty("item_id", ticketItem.getId());
            unsyncedTransactions.add(posTransaction);
        }
    }

    private void doUpdateItem() {
        try {
            UpdateItemCostSync updateItems = new UpdateItemCostSync();
            SyncDialog updateItemsSyncDialog = new SyncDialog(updateItems);
            updateItems.setSyncView(updateItemsSyncDialog);
            updateItemsSyncDialog.pack();
            updateItemsSyncDialog.open();
            if (updateItemsSyncDialog.isCanceled()) {
                return;
            }
            if (!updateItems.hasSyncError) {
                POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("CloudSyncConfigurationView.66"));
                return;
            }
            POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("CloudSyncConfigurationView.67"));
            return;
        }
        catch (StaleStateException x) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), x.getMessage());
            return;
        }
        catch (PosException e) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), e.getMessage());
        }
        catch (Exception e) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), POSConstants.ERROR_MESSAGE, e);
        }
    }

    private void doUpdateItemCount() {
        try {
            UpdateItemCountSync updateItemsCount = new UpdateItemCountSync();
            SyncDialog updateItemsSyncDialog = new SyncDialog(updateItemsCount);
            updateItemsCount.setSyncView(updateItemsSyncDialog);
            updateItemsSyncDialog.pack();
            updateItemsSyncDialog.open();
            if (updateItemsSyncDialog.isCanceled()) {
                return;
            }
            if (!updateItemsCount.hasSyncError) {
                POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("CloudSyncConfigurationView.3"));
                return;
            }
            POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("CloudSyncConfigurationView.67"));
            return;
        }
        catch (StaleStateException x) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), x.getMessage());
            return;
        }
        catch (PosException e) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), e.getMessage());
        }
        catch (Exception e) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), POSConstants.ERROR_MESSAGE, e);
        }
    }

    private void doSetSyncDate() {
        try {
            int row = this.tableCloudProcess.getSelectedRow();
            if (row < 0) {
                return;
            }
            switch (row) {
                case 0: {
                    Date sfDate = StringUtils.isNotEmpty((String)this.itemSyncTime) ? SFDateUtil.parseBySFDate(this.itemSyncTime) : null;
                    DateSelectionDialog itemSynTimeSelDialog = new DateSelectionDialog(sfDate);
                    itemSynTimeSelDialog.setClearDateVisible(true);
                    itemSynTimeSelDialog.setTitle(VersionInfo.getAppName());
                    itemSynTimeSelDialog.setCaption(Messages.getString("CloudSyncConfigurationView.68"));
                    itemSynTimeSelDialog.setSize(PosUIManager.getSize(350, 250));
                    itemSynTimeSelDialog.open();
                    if (itemSynTimeSelDialog.isCanceled()) {
                        return;
                    }
                    Date selectedDate = itemSynTimeSelDialog.getSelectedDate();
                    String dateOfSync = "";
                    if (selectedDate != null) {
                        dateOfSync = SFDateUtil.formatDateAsSFFormat(selectedDate);
                    }
                    this.doUpdateSyncTime("salesforce.itemSyncTime", dateOfSync);
                    break;
                }
                case 1: {
                    Date sfDate = StringUtils.isNotEmpty((String)this.paymentSyncTime) ? SFDateUtil.parseBySFDate(this.paymentSyncTime) : null;
                    DateSelectionDialog paymentSyncDialog = new DateSelectionDialog(sfDate);
                    paymentSyncDialog.setClearDateVisible(true);
                    paymentSyncDialog.setTitle(VersionInfo.getAppName());
                    paymentSyncDialog.setCaption(Messages.getString("CloudSyncConfigurationView.68"));
                    paymentSyncDialog.setSize(PosUIManager.getSize(350, 250));
                    paymentSyncDialog.open();
                    if (paymentSyncDialog.isCanceled()) {
                        return;
                    }
                    Date selectedDate = paymentSyncDialog.getSelectedDate();
                    String dateOfSync = "";
                    if (selectedDate != null) {
                        dateOfSync = SFDateUtil.formatDateAsSFFormat(selectedDate);
                    }
                    this.doUpdateSyncTime("salesforce.paymentSyncTime", dateOfSync);
                    break;
                }
                case 2: {
                    Date sfDate = StringUtils.isNotEmpty((String)this.employeeSyncTime) ? SFDateUtil.parseBySFDate(this.employeeSyncTime) : null;
                    DateSelectionDialog employeeSelDialog = new DateSelectionDialog(sfDate);
                    employeeSelDialog.setClearDateVisible(true);
                    employeeSelDialog.setTitle(VersionInfo.getAppName());
                    employeeSelDialog.setCaption(Messages.getString("CloudSyncConfigurationView.68"));
                    employeeSelDialog.setSize(PosUIManager.getSize(350, 250));
                    employeeSelDialog.open();
                    if (employeeSelDialog.isCanceled()) {
                        return;
                    }
                    Date selectedDate = employeeSelDialog.getSelectedDate();
                    String dateOfSync = "";
                    if (selectedDate != null) {
                        dateOfSync = SFDateUtil.formatDateAsSFFormat(selectedDate);
                    }
                    this.doUpdateSyncTime("salesforce.employeeSyncTime", dateOfSync);
                    break;
                }
                case 3: {
                    Date sfDate = StringUtils.isNotEmpty((String)this.memberSyncTime) ? SFDateUtil.parseBySFDate(this.memberSyncTime) : null;
                    DateSelectionDialog memberSelDialog = new DateSelectionDialog();
                    memberSelDialog.setClearDateVisible(true);
                    memberSelDialog.setTitle(VersionInfo.getAppName());
                    memberSelDialog.setCaption(Messages.getString("CloudSyncConfigurationView.68"));
                    memberSelDialog.setSize(PosUIManager.getSize(350, 250));
                    memberSelDialog.open();
                    if (memberSelDialog.isCanceled()) {
                        return;
                    }
                    Date selectedDate = memberSelDialog.getSelectedDate();
                    String dateOfSync = "";
                    if (selectedDate != null) {
                        dateOfSync = SFDateUtil.formatDateAsSFFormat(selectedDate);
                    }
                    this.doUpdateSyncTime("salesforce.memberSyncTime", dateOfSync);
                    break;
                }
                case 4: {
                    Date sfDate = StringUtils.isNotEmpty((String)this.salesAreaSyncTime) ? SFDateUtil.parseBySFDate(this.salesAreaSyncTime) : null;
                    DateSelectionDialog salesAreaSelDialog = new DateSelectionDialog(sfDate);
                    salesAreaSelDialog.setClearDateVisible(true);
                    salesAreaSelDialog.setTitle(VersionInfo.getAppName());
                    salesAreaSelDialog.setCaption(Messages.getString("CloudSyncConfigurationView.68"));
                    salesAreaSelDialog.setSize(PosUIManager.getSize(350, 250));
                    salesAreaSelDialog.open();
                    if (salesAreaSelDialog.isCanceled()) {
                        return;
                    }
                    Date selectedDate = salesAreaSelDialog.getSelectedDate();
                    String dateOfSync = "";
                    if (selectedDate != null) {
                        dateOfSync = SFDateUtil.formatDateAsSFFormat(selectedDate);
                    }
                    this.doUpdateSyncTime("salesforce.salesAreaSyncTime", dateOfSync);
                    break;
                }
                case 5: {
                    Date sfDate = StringUtils.isNotEmpty((String)this.updateItemSyncTime) ? SFDateUtil.parseBySFDate(this.updateItemSyncTime) : null;
                    DateSelectionDialog updateItemDateSelDialog = new DateSelectionDialog(sfDate);
                    updateItemDateSelDialog.setClearDateVisible(true);
                    updateItemDateSelDialog.setTitle(VersionInfo.getAppName());
                    updateItemDateSelDialog.setCaption(Messages.getString("CloudSyncConfigurationView.68"));
                    updateItemDateSelDialog.setSize(PosUIManager.getSize(350, 250));
                    updateItemDateSelDialog.open();
                    if (updateItemDateSelDialog.isCanceled()) {
                        return;
                    }
                    Date selectedDate = updateItemDateSelDialog.getSelectedDate();
                    String dateOfSync = "";
                    if (selectedDate != null) {
                        dateOfSync = SFDateUtil.formatDateAsSFFormat(selectedDate);
                    }
                    this.doUpdateSyncTime("salesforce.updateItemSyncTime", dateOfSync);
                    break;
                }
                case 6: {
                    Date sfDate = StringUtils.isNotEmpty((String)this.updateItemCountSyncTime) ? SFDateUtil.parseBySFDate(this.updateItemCountSyncTime) : null;
                    DateSelectionDialog updateItemCountDateSelDialog = new DateSelectionDialog(sfDate);
                    updateItemCountDateSelDialog.setClearDateVisible(true);
                    updateItemCountDateSelDialog.setTitle(VersionInfo.getAppName());
                    updateItemCountDateSelDialog.setCaption(Messages.getString("CloudSyncConfigurationView.68"));
                    updateItemCountDateSelDialog.setSize(PosUIManager.getSize(350, 300));
                    updateItemCountDateSelDialog.open();
                    if (updateItemCountDateSelDialog.isCanceled()) {
                        return;
                    }
                    Date selectedDate = updateItemCountDateSelDialog.getSelectedDate();
                    String dateOfSync = "";
                    if (selectedDate != null) {
                        dateOfSync = SFDateUtil.formatDateAsSFFormat(selectedDate);
                    }
                    this.doUpdateSyncTime("salesforce.updateItemCountSyncTime", dateOfSync);
                }
            }
            this.updateProcessTableModel();
        }
        catch (Exception x) {
            BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, x);
        }
    }

    private void doUpdateSyncTime(String salesforceItemSyncTimeConstant, String dateOfSync) {
        try {
            DataProvider.get().refreshStore();
            Store store = DataProvider.get().getStore();
            store.addProperty(salesforceItemSyncTimeConstant, dateOfSync);
            StoreDAO.getInstance().saveOrUpdate(store);
            DataProvider.get().refreshStore();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void doImportConfigInfo() throws Exception {
        try (FileInputStream inputStream = null;){
            Preferences prefs = Preferences.userRoot().node(this.getClass().getName());
            JFileChooser fileChooser = new JFileChooser(prefs.get(this.LAST_USED_FOLDER, new File(".").getAbsolutePath()));
            fileChooser.setFileSelectionMode(0);
            fileChooser.setFileFilter(new FileNameExtensionFilter("*.txt", "txt"));
            int result = fileChooser.showOpenDialog(this);
            if (result == 1) {
                return;
            }
            prefs.put(this.LAST_USED_FOLDER, fileChooser.getSelectedFile().getParent());
            File selectedFile = fileChooser.getSelectedFile();
            if (selectedFile == null) {
                return;
            }
            Properties prop = new Properties();
            inputStream = new FileInputStream(selectedFile);
            prop.load(inputStream);
            String orgName = prop.getProperty("org");
            String username = prop.getProperty("username");
            String password = prop.getProperty("password");
            String securityToken = prop.getProperty("securityToken");
            String loginurl = prop.getProperty("loginurl");
            String clientid = prop.getProperty("clientid");
            String clientSecret = prop.getProperty("clientsecret");
            this.tfOrgName.setText(orgName);
            this.tfUsername.setText(username);
            this.tfLoginUrl.setText(loginurl);
            this.tfClientId.setText(clientid);
            this.tfPassword.setText(password);
            this.tfSecurityToken.setText(securityToken);
            this.tfClientSecret.setText(clientSecret);
            POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("CloudSyncConfigurationView.89"));
        }
    }

    private boolean hasRefundedTransactionForItem(TicketItem item, List<PosTransaction> posTransactions) {
        ArrayList<PosTransaction> refundTicketTrans = new ArrayList<PosTransaction>();
        for (PosTransaction posTransaction : posTransactions) {
            if (!(posTransaction instanceof RefundTransaction) || !posTransaction.getTicketId().equals(item.getTicket().getId())) continue;
            refundTicketTrans.add(posTransaction);
        }
        if (refundTicketTrans.isEmpty()) {
            posTransactions.add(CloudSyncConfigurationView.doCreateInMemoryRefundTx(item));
        }
        return true;
    }

    public static RefundTransaction doCreateInMemoryRefundTx(TicketItem ticketItem) {
        RefundTransaction refundTransaction = PosTransactionService.getInstance().createRefundTransaction(ticketItem.getTicket(), null, 0.0, false);
        refundTransaction.setTransactionTime(ticketItem.getCreateDate());
        if (refundTransaction.getPaymentType() == null) {
            refundTransaction.setPaymentType(PaymentType.MEMBER_ACCOUNT);
        }
        return refundTransaction;
    }

    private class CloudProcessDataModel
    extends ListTableModel<CloudProcess> {
        public CloudProcessDataModel() {
            super(new String[]{Messages.getString("CloudSyncConfigurationView.47"), Messages.getString("CloudSyncConfigurationView.48"), Messages.getString("CloudSyncConfigurationView.49"), Messages.getString("CloudSyncConfigurationView.0")});
        }

        @Override
        public int getColumnCount() {
            return 4;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            CloudProcess process = (CloudProcess)this.getRows().get(rowIndex);
            switch (columnIndex) {
                case 0: {
                    return process.getProcessName();
                }
                case 1: {
                    return process.getSyncTime();
                }
                case 2: {
                    return process.getTimeSetBtn();
                }
                case 3: {
                    if (!process.getShowSyncBtn().booleanValue()) break;
                    return process.getBtnText();
                }
            }
            return null;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == 2 || columnIndex == 3;
        }
    }

    private class CloudProcess {
        private String processName;
        private String syncTime;
        private Boolean showSyncBtn;
        private boolean showTimeSetBtn;
        private String btnText;

        public CloudProcess(String processName, String syncTime, Boolean showSyncBtn, String btnText) {
            this(processName, syncTime, showSyncBtn, btnText, Boolean.TRUE);
        }

        public CloudProcess(String processName, String syncTime, Boolean showSyncBtn, String btnText, Boolean showTimeSetBtn) {
            this.processName = processName;
            this.setSyncTime(syncTime);
            this.showSyncBtn = showSyncBtn;
            this.btnText = btnText;
            this.showTimeSetBtn = showTimeSetBtn;
        }

        public String getProcessName() {
            return this.processName;
        }

        public Boolean getShowSyncBtn() {
            return this.showSyncBtn;
        }

        public boolean getShowTimeSetBtn() {
            return this.showTimeSetBtn;
        }

        public String getBtnText() {
            return this.btnText;
        }

        public String getSyncTime() {
            return this.syncTime;
        }

        public void setSyncTime(String syncTime) {
            this.syncTime = syncTime;
        }

        public String getTimeSetBtn() {
            return Messages.getString("CloudSyncConfigurationView.46");
        }
    }
}

