/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.config.ui;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.config.ui.ConfigurationView;
import com.floreantpos.mailservices.MailService;
import com.floreantpos.model.Store;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.validator.routines.EmailValidator;

public class EmailConfigurationView
extends ConfigurationView {
    private Store store;
    private JTextField tfSenderEmail;
    private JTextField tfApiKey;

    public EmailConfigurationView(Store store) {
        this.store = store;
        this.initComponents();
    }

    private void initComponents() {
        this.setLayout(new BorderLayout(5, 5));
        JPanel mainPanel = new JPanel((LayoutManager)new MigLayout("fillx,hidemode 3", "[][grow]", ""));
        JLabel lblSenderEmail = new JLabel(Messages.getString("EmailConfigurationView.5"));
        JLabel lblApiKey = new JLabel(Messages.getString("EmailConfigurationView.11"));
        this.tfSenderEmail = new JTextField();
        this.tfApiKey = new JTextField();
        mainPanel.add((Component)lblSenderEmail, "alignx trailing");
        mainPanel.add((Component)this.tfSenderEmail, "growx, wrap");
        mainPanel.add((Component)lblApiKey, "alignx trailing");
        mainPanel.add((Component)this.tfApiKey, "growx, wrap");
        JButton btnEmailTest = new JButton(Messages.getString("EmailConfigurationView.4"));
        btnEmailTest.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EmailConfigurationView.this.doSendTestEmail();
            }
        });
        mainPanel.add((Component)btnEmailTest, "skip 1");
        JScrollPane scrollPane = new JScrollPane(mainPanel, 20, 31);
        scrollPane.setBorder(null);
        this.add((Component)scrollPane, "Center");
    }

    protected void doSendTestEmail() {
        try {
            String email = this.tfSenderEmail.getText();
            if (StringUtils.isEmpty((String)email)) {
                POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("EmailConfigurationView.1"));
                return;
            }
            boolean valid = EmailValidator.getInstance().isValid(email);
            if (!valid) {
                POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("CustomerForm.9"));
                return;
            }
            String apiKey = this.tfApiKey.getText();
            if (StringUtils.isEmpty((String)apiKey)) {
                POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("EmailConfigurationView.17"));
                return;
            }
            MailService.setApiKey(apiKey);
            MailService.setSenderEmail(email);
            boolean sendMail = MailService.sendMail(email, Messages.getString("EmailConfigurationView.2"), Messages.getString("EmailConfigurationView.3"));
            if (sendMail) {
                POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("EmailConfigurationView.13"));
            } else {
                POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("EmailConfigurationView.12"));
            }
        }
        catch (Exception e) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), e.getMessage(), e);
        }
    }

    @Override
    public boolean save() {
        try {
            if (!this.isInitialized()) {
                return true;
            }
            return this.updateModel();
        }
        catch (Exception e) {
            POSMessageDialog.showError(e.getMessage());
            return false;
        }
    }

    public void updateView() {
        try {
            this.tfSenderEmail.setText(this.store.getSendGridSenderEmail());
            this.tfApiKey.setText(this.store.getSendGridApiKey());
            this.setInitialized(true);
        }
        catch (Exception e) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), e.getMessage(), e);
        }
    }

    public boolean updateModel() {
        try {
            String email = this.tfSenderEmail.getText();
            String apiKey = this.tfApiKey.getText();
            this.store.setSendGridApiKey(apiKey);
            this.store.setSendGridSenderEmail(email);
            MailService.setApiKey(apiKey);
            MailService.setSenderEmail(email);
            return true;
        }
        catch (Exception e) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), e.getMessage(), e);
            return false;
        }
    }

    @Override
    public void initialize() throws Exception {
        this.updateView();
    }

    @Override
    public String getName() {
        return POSConstants.CONFIG_TAB_EMAIL;
    }
}

