/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.config.ui;

import com.floreantpos.Messages;
import com.floreantpos.config.GiftCardConfig;
import com.floreantpos.config.ui.ConfigurationView;
import com.floreantpos.extension.ExtensionManager;
import com.floreantpos.extension.FloreantPlugin;
import com.floreantpos.extension.GiftCardPaymentPlugin;
import com.floreantpos.ui.dialog.POSMessageDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import net.miginfocom.swing.MigLayout;

public class GiftCardConfigurationView
extends ConfigurationView {
    private JComboBox cbPaymentGateway;
    private JPanel pluginConfigPanel = new JPanel(new BorderLayout());

    public GiftCardConfigurationView() {
        this.createUI();
    }

    private void createUI() {
        this.setLayout(new BorderLayout());
        JPanel contentPanel = new JPanel();
        contentPanel.setLayout((LayoutManager)new MigLayout("", "[][grow]", "[][][][][][][][]"));
        JLabel lblMerchantGateway = new JLabel(Messages.getString("CardConfigurationView.2"));
        contentPanel.add((Component)lblMerchantGateway, "cell 0 4,alignx leading");
        this.cbPaymentGateway = new JComboBox();
        this.cbPaymentGateway.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    GiftCardConfigurationView.this.updatePluginConfigUI();
                }
                catch (Exception e1) {
                    POSMessageDialog.showError(GiftCardConfigurationView.this, e1.getMessage(), e1);
                }
            }
        });
        contentPanel.add((Component)this.cbPaymentGateway, "cell 1 4,growx");
        contentPanel.add((Component)this.pluginConfigPanel, "newline,span,wrap,growx");
        JScrollPane scrollPane = new JScrollPane(contentPanel);
        scrollPane.setBorder(null);
        this.add(scrollPane);
    }

    private void initialMerchantGateways() {
        DefaultComboBoxModel<GiftCardPaymentPlugin> model = new DefaultComboBoxModel<GiftCardPaymentPlugin>();
        List plugins = ExtensionManager.getPlugins(GiftCardPaymentPlugin.class);
        for (FloreantPlugin plugin : plugins) {
            if (!(plugin instanceof GiftCardPaymentPlugin)) continue;
            model.addElement((GiftCardPaymentPlugin)plugin);
        }
        this.cbPaymentGateway.setModel(model);
    }

    @Override
    public boolean save() throws Exception {
        GiftCardPaymentPlugin plugin = (GiftCardPaymentPlugin)this.cbPaymentGateway.getSelectedItem();
        if (plugin != null) {
            plugin.getConfigurationPane().save();
            GiftCardConfig.setPaymentGateway(plugin);
        }
        return true;
    }

    @Override
    public void initialize() throws Exception {
        this.initialMerchantGateways();
        this.updatePluginConfigUI();
        this.setInitialized(true);
    }

    private void updatePluginConfigUI() throws Exception {
        GiftCardPaymentPlugin plugin = (GiftCardPaymentPlugin)this.cbPaymentGateway.getSelectedItem();
        this.pluginConfigPanel.removeAll();
        if (plugin == null) {
            return;
        }
        ConfigurationView configurationPane = plugin.getConfigurationPane();
        configurationPane.initialize();
        this.pluginConfigPanel.add(configurationPane);
        this.revalidate();
        this.repaint();
    }

    @Override
    public String getName() {
        return Messages.getString("GiftCard");
    }
}

