/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.config.ui;

import com.floreantpos.Messages;
import com.floreantpos.PosLog;
import com.floreantpos.SystemProperties;
import com.floreantpos.model.PriceTable;
import com.floreantpos.model.Store;
import com.floreantpos.model.dao.PriceTableDAO;
import com.floreantpos.model.dao.StoreDAO;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.TransparentPanel;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.TitledBorder;
import net.miginfocom.swing.MigLayout;

public class LabelConfigurationView
extends TransparentPanel {
    private Store store;
    private JCheckBox chkBarcode;
    private JCheckBox chkMemberPrice;
    private JCheckBox chkRetailPrice;
    private JCheckBox chkPrintTranslatedName;
    private PosButton btnSave;

    public LabelConfigurationView() {
        this.createUI();
        this.initData();
        this.updateView();
        this.initHandler();
    }

    private void initData() {
        ArrayList<PriceTable> priceTableList = new ArrayList<PriceTable>();
        priceTableList.add(null);
        priceTableList.addAll(PriceTableDAO.getInstance().findAll());
    }

    private void initHandler() {
        this.btnSave.addActionListener(e -> this.save());
    }

    private void createUI() {
        this.setLayout(new BorderLayout());
        JPanel itemInfoPanel = new JPanel((LayoutManager)new MigLayout("hidemode 3", "[][grow][]", ""));
        JScrollPane scrollPane = new JScrollPane(itemInfoPanel, 20, 31);
        TitledBorder border = BorderFactory.createTitledBorder(null, Messages.getString("LabelConfigurationView.3"), 2, 0);
        itemInfoPanel.setBorder(border);
        this.chkBarcode = new JCheckBox(Messages.getString("LabelConfigurationView.4"));
        this.chkMemberPrice = new JCheckBox(Messages.getString("LabelConfigurationView.5"));
        this.chkRetailPrice = new JCheckBox(Messages.getString("LabelConfigurationView.6"));
        this.chkPrintTranslatedName = new JCheckBox("Print translated name");
        itemInfoPanel.add((Component)this.chkBarcode, "wrap");
        itemInfoPanel.add((Component)this.chkMemberPrice, "wrap");
        if (SystemProperties.isForeTees()) {
            itemInfoPanel.add((Component)this.chkRetailPrice, "wrap");
        }
        itemInfoPanel.add((Component)this.chkPrintTranslatedName, "wrap");
        scrollPane.setBorder(null);
        JPanel buttonPanel = new JPanel((LayoutManager)new MigLayout("center"));
        this.btnSave = new PosButton(Messages.getString("LabelConfigurationView.14"));
        buttonPanel.add(this.btnSave);
        this.add((Component)scrollPane, "Center");
        this.add((Component)buttonPanel, "South");
    }

    public boolean save() {
        try {
            if (!this.updateModel()) {
                return false;
            }
            StoreDAO.getInstance().saveOrUpdate(this.store);
            POSMessageDialog.showMessage(POSUtil.getBackOfficeWindow(), Messages.getString("LabelConfigurationView.15"));
            return true;
        }
        catch (Exception e) {
            PosLog.error(LabelConfigurationView.class, e.getMessage(), e);
            POSMessageDialog.showError(e.getMessage());
            return false;
        }
    }

    public void updateView() {
        try {
            this.store = DataProvider.get().getStore();
            this.chkBarcode.setSelected(POSUtil.getBoolean(this.store.getProperty("label.barcode")));
            this.chkMemberPrice.setSelected(POSUtil.getBoolean(this.store.getProperty("label.member.price")));
            this.chkRetailPrice.setSelected(POSUtil.getBoolean(this.store.getProperty("label.isPrint.retail.price")));
            this.chkPrintTranslatedName.setSelected(POSUtil.getBoolean(this.store.getProperty("label.print_translated_name")));
        }
        catch (Exception e) {
            PosLog.error(LabelConfigurationView.class, e);
        }
    }

    public boolean updateModel() {
        try {
            this.store.addProperty("label.barcode", String.valueOf(this.chkBarcode.isSelected()));
            this.store.addProperty("label.member.price", String.valueOf(this.chkMemberPrice.isSelected()));
            this.store.addProperty("label.isPrint.retail.price", String.valueOf(this.chkRetailPrice.isSelected()));
            this.store.addProperty("label.print_translated_name", String.valueOf(this.chkPrintTranslatedName.isSelected()));
        }
        catch (Exception e) {
            PosLog.error(LabelConfigurationView.class, e.getMessage(), e);
        }
        return true;
    }

    @Override
    public String getName() {
        return Messages.getString("LabelConfigurationView.16");
    }
}

