/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.config.ui;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosException;
import com.floreantpos.PosLog;
import com.floreantpos.config.ui.AddPrinterDialog;
import com.floreantpos.config.ui.PrinterTypeSelectionDialog;
import com.floreantpos.main.Application;
import com.floreantpos.model.PosPrinters;
import com.floreantpos.model.Printer;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.TerminalPrinters;
import com.floreantpos.model.VirtualPrinter;
import com.floreantpos.model.dao.TerminalPrintersDAO;
import com.floreantpos.model.dao.VirtualPrinterDAO;
import com.floreantpos.report.ReceiptPrintService;
import com.floreantpos.swing.BeanTableModel;
import com.floreantpos.ui.RefreshableView;
import com.floreantpos.ui.dialog.DetailsInfoDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.hibernate.StaleStateException;
import org.jdesktop.swingx.JXTable;

public class MultiPrinterPane
extends JPanel
implements RefreshableView {
    private List<Printer> printers = new ArrayList<Printer>();
    private DefaultListModel<Printer> listModel;
    private JXTable table;
    private BeanTableModel<Printer> tableModel;
    private int selectedPrinterType;
    private Terminal terminal;

    public MultiPrinterPane() {
    }

    public MultiPrinterPane(String title, List<Printer> allPrinters) {
        this(title, allPrinters, Application.getInstance().getTerminal());
    }

    public MultiPrinterPane(String title, List<Printer> allPrinters, Terminal terminal) {
        this.terminal = terminal;
        this.setBorder(BorderFactory.createTitledBorder(title));
        this.setLayout(new BorderLayout(10, 10));
        JPanel panel = new JPanel();
        this.add((Component)panel, "South");
        JButton btnAdd = new JButton(Messages.getString("MultiPrinterPane.0"));
        btnAdd.addActionListener(e -> this.doAddNewPrinter());
        panel.add(btnAdd);
        JButton btnEdit = new JButton(Messages.getString("EDIT"));
        btnEdit.addActionListener(e -> this.doEditPrinter());
        panel.add(btnEdit);
        JButton btnDelete = new JButton(POSConstants.DELETE);
        btnDelete.addActionListener(e -> this.doDeletePrinter());
        panel.add(btnDelete);
        JButton btnTest = new JButton(Messages.getString("MultiPrinterPane.5"));
        btnTest.addActionListener(e -> this.testPrinter());
        panel.add(btnTest);
        this.listModel = new DefaultListModel();
        if (this.printers != null) {
            for (Printer printer : this.printers) {
                this.listModel.addElement(printer);
            }
        }
        this.tableModel = new BeanTableModel(Printer.class);
        this.tableModel.addColumn(Messages.getString("NAME"), "virtualPrinter");
        this.tableModel.addColumn(Messages.getString("MultiPrinterPane.6"), "deviceName");
        this.tableModel.addColumn(Messages.getString("Type"), "type");
        List<VirtualPrinter> virtualPrinters = VirtualPrinterDAO.getInstance().findAll();
        if (virtualPrinters != null && !virtualPrinters.isEmpty()) {
            for (VirtualPrinter virtualPrinter : virtualPrinters) {
                Printer printer = new Printer();
                printer.setVirtualPrinter(virtualPrinter);
                printer.setDeviceName("");
                TerminalPrinters terminalPrinter = TerminalPrintersDAO.getInstance().findPrinters(printer.getVirtualPrinter(), terminal);
                if (terminalPrinter != null && virtualPrinter.getName().equals(terminalPrinter.getVirtualPrinter().getName())) {
                    printer.setDeviceName(terminalPrinter.getPrinterName());
                }
                this.printers.add(printer);
            }
        }
        this.tableModel.addRows(this.printers);
        this.table = new JXTable(this.tableModel);
        this.add((Component)new JScrollPane((Component)this.table), "Center");
    }

    private void doAddNewPrinter() {
        try {
            PrinterTypeSelectionDialog dialog = new PrinterTypeSelectionDialog();
            dialog.open();
            if (dialog.isCanceled()) {
                return;
            }
            this.selectedPrinterType = dialog.getSelectedPrinterType();
            this.doAddPrinter();
        }
        catch (Exception e) {
            this.showError(e);
        }
    }

    protected void doEditPrinter() {
        try {
            int index = this.table.getSelectedRow();
            if (index < 0) {
                String message = Messages.getString("SELECT_A_ROW");
                POSMessageDialog.showError(POSUtil.getFocusedWindow(), message);
                return;
            }
            index = this.table.convertRowIndexToModel(index);
            Printer customPrinter = this.tableModel.getRow(index);
            TerminalPrinters terminalPrinter = null;
            if (customPrinter.getVirtualPrinter() != null) {
                terminalPrinter = TerminalPrintersDAO.getInstance().findPrinters(customPrinter.getVirtualPrinter(), this.terminal);
            }
            AddPrinterDialog dialog = new AddPrinterDialog();
            dialog.setPrinter(customPrinter, terminalPrinter);
            dialog.open();
            if (dialog.isCanceled()) {
                return;
            }
            Printer p = dialog.getPrinter();
            if (p.isDefaultPrinter()) {
                for (Printer printer2 : this.printers) {
                    printer2.setDefaultPrinter(false);
                }
            }
            VirtualPrinter virtualPrinter = p.getVirtualPrinter();
            VirtualPrinterDAO.getInstance().saveOrUpdate(virtualPrinter);
            terminalPrinter = dialog.getTerminalPrinter();
            terminalPrinter.setTerminal(this.terminal);
            terminalPrinter.setPrinterName(p.getDeviceName());
            terminalPrinter.setVirtualPrinter(p.getVirtualPrinter());
            TerminalPrintersDAO.getInstance().saveOrUpdate(terminalPrinter);
            this.table.repaint();
        }
        catch (StaleStateException e) {
            POSMessageDialog.showMessageDialogWithReloadButton(POSUtil.getFocusedWindow(), this);
        }
        catch (Exception e) {
            this.showError(e);
        }
    }

    protected void doDeletePrinter() {
        try {
            int index = this.table.getSelectedRow();
            if (index < 0) {
                String message = Messages.getString("SELECT_A_ROW");
                POSMessageDialog.showError(POSUtil.getFocusedWindow(), message);
                return;
            }
            index = this.table.convertRowIndexToModel(index);
            Printer customPrinter = this.tableModel.getRow(index);
            String title = Messages.getString("MultiPrinterPane.7");
            String message = Messages.getString("MultiPrinterPane.8");
            message = String.format(message, customPrinter);
            int option = POSMessageDialog.showYesNoQuestionDialog(POSUtil.getFocusedWindow(), message, title);
            if (option != 0) {
                return;
            }
            if (customPrinter.getVirtualPrinter() != null) {
                VirtualPrinterDAO.getInstance().delete(customPrinter.getVirtualPrinter());
            }
            this.refresh();
        }
        catch (StaleStateException e) {
            POSMessageDialog.showMessageDialogWithReloadButton(POSUtil.getFocusedWindow(), this);
        }
        catch (PosException e) {
            DetailsInfoDialog detailsInfoDialog = new DetailsInfoDialog(e.getMessage(), e.getDetails());
            detailsInfoDialog.open();
        }
        catch (Exception e) {
            this.showError(e);
        }
    }

    private void showError(Exception e) {
        POSMessageDialog.showError(e.getMessage(), e);
    }

    protected void doAddPrinter() {
        AddPrinterDialog dialog = new AddPrinterDialog();
        dialog.titlePanel.setTitle(VirtualPrinter.PRINTER_TYPE_NAMES[this.selectedPrinterType] + " - Printer");
        dialog.open();
        if (dialog.isCanceled()) {
            return;
        }
        Printer p = dialog.getPrinter();
        if (p.isDefaultPrinter()) {
            for (Printer printer : this.printers) {
                printer.setDefaultPrinter(false);
            }
        }
        VirtualPrinter virtualPrinter = p.getVirtualPrinter();
        for (Printer printer : this.printers) {
            if (!virtualPrinter.equals(printer.getVirtualPrinter())) continue;
            POSMessageDialog.showError(this.getParent(), Messages.getString("MultiPrinterPane.2"));
            return;
        }
        virtualPrinter.setType(this.selectedPrinterType);
        VirtualPrinterDAO.getInstance().saveOrUpdate(virtualPrinter);
        TerminalPrinters terminalPrinters = dialog.getTerminalPrinter();
        terminalPrinters.setTerminal(this.terminal);
        terminalPrinters.setPrinterName(p.getDeviceName());
        terminalPrinters.setVirtualPrinter(p.getVirtualPrinter());
        TerminalPrintersDAO.getInstance().saveOrUpdate(terminalPrinters);
        this.printers.add(p);
        this.listModel.addElement(p);
        this.refresh();
    }

    @Override
    public void refresh() {
        this.printers.clear();
        List<VirtualPrinter> virtualPrinters = VirtualPrinterDAO.getInstance().findAll();
        if (virtualPrinters != null && !virtualPrinters.isEmpty()) {
            for (VirtualPrinter virtualPrinter : virtualPrinters) {
                Printer printer = new Printer();
                printer.setVirtualPrinter(virtualPrinter);
                printer.setDeviceName("");
                TerminalPrinters terminalPrinter = TerminalPrintersDAO.getInstance().findPrinters(printer.getVirtualPrinter(), this.terminal);
                if (terminalPrinter != null && virtualPrinter.getName().equals(terminalPrinter.getVirtualPrinter().getName())) {
                    printer.setDeviceName(terminalPrinter.getPrinterName());
                }
                this.printers.add(printer);
            }
        }
        this.tableModel.removeAll();
        this.tableModel.addRows(this.printers);
        this.table.validate();
        this.table.repaint();
    }

    private void testPrinter() {
        int index = this.table.getSelectedRow();
        if (index < 0) {
            String message = Messages.getString("SELECT_A_ROW");
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), message);
            return;
        }
        Printer printer = this.tableModel.getRow(index = this.table.convertRowIndexToModel(index));
        if (printer.getDeviceName() == null) {
            PosLog.info(this.getClass(), "No print selected for " + printer.getType());
            return;
        }
        TerminalPrinters terminalPrinter = null;
        if (printer.getVirtualPrinter() != null) {
            terminalPrinter = TerminalPrintersDAO.getInstance().findPrinters(printer.getVirtualPrinter(), this.terminal);
        }
        try {
            ReceiptPrintService.testPrinter(terminalPrinter == null ? printer : PosPrinters.createPrinter(terminalPrinter), "System Information", ReceiptPrintService.getSystemInfo(printer.getDeviceName(), printer.getVirtualPrinter().getName()));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

